/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.hippo.R;

public class MaxHeightLayout
extends FrameLayout {
    private static final float DEFAULT_MAX_RATIO = 0.6f;
    private static final float DEFAULT_MAX_HEIGHT = 0.0f;
    private float mMaxRatio = 0.6f;
    private float mMaxHeight = 0.0f;

    public MaxHeightLayout(Context context) {
        super(context);
        this.init();
    }

    public MaxHeightLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
        this.init();
    }

    public MaxHeightLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttrs(context, attrs);
        this.init();
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MaxHeightLayout);
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.MaxHeightLayout_mhl_HeightRatio) {
                this.mMaxRatio = a.getFloat(attr2, 0.6f);
                continue;
            }
            if (attr2 != R.styleable.MaxHeightLayout_mhl_HeightDimen) continue;
            this.mMaxHeight = a.getDimension(attr2, 0.0f);
        }
        a.recycle();
    }

    private void init() {
        this.mMaxHeight = this.mMaxHeight <= 0.0f ? this.mMaxRatio * (float)this.getScreenHeight(this.getContext()) : Math.min(this.mMaxHeight, this.mMaxRatio * (float)this.getScreenHeight(this.getContext()));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (heightMode == 0x40000000) {
            int n = heightSize = (float)heightSize <= this.mMaxHeight ? heightSize : (int)this.mMaxHeight;
        }
        if (heightMode == 0) {
            int n = heightSize = (float)heightSize <= this.mMaxHeight ? heightSize : (int)this.mMaxHeight;
        }
        if (heightMode == Integer.MIN_VALUE) {
            heightSize = (float)heightSize <= this.mMaxHeight ? heightSize : (int)this.mMaxHeight;
        }
        int maxHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
        super.onMeasure(widthMeasureSpec, maxHeightMeasureSpec);
    }

    private int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        return wm.getDefaultDisplay().getHeight();
    }
}

