/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.retrofit;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import com.google.gson.JsonSyntaxException;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.ErrorUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.loadingBox.LoadingBox;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class ResponseResolver<T>
implements Callback<T> {
    private WeakReference<Activity> weakActivity = null;
    private Boolean showLoading = false;
    private Boolean showError = false;
    private final String NO_INTERNET_MESSAGE = "No internet connection. Please try again later.";
    private final String REMOTE_SERVER_FAILED_MESSAGE = "Application server could not respond. Please try later.";
    public static final String UNEXPECTED_ERROR_OCCURRED = "Something went wrong. Please try again later";
    private static final String PARSING_ERROR = "Parsing error";
    private AlertDialog.Builder alertDialogBuilder;
    private AlertDialog alertDialog;

    public ResponseResolver(Activity activity) {
        this.weakActivity = new WeakReference<Activity>(activity);
    }

    public ResponseResolver(Activity activity, Boolean showLoading) {
        this.weakActivity = new WeakReference<Activity>(activity);
        this.showLoading = showLoading;
        if (showLoading.booleanValue()) {
            LoadingBox.showOn(activity);
        }
    }

    public ResponseResolver(Activity activity, Boolean showLoading, Boolean showError) {
        this.weakActivity = new WeakReference<Activity>(activity);
        this.showLoading = showLoading;
        this.showError = showError;
        if (showLoading.booleanValue()) {
            LoadingBox.showOn(activity);
        }
    }

    public ResponseResolver() {
    }

    public abstract void success(T var1);

    public abstract void failure(APIError var1);

    public void onResponse(Call<T> t, Response<T> tResponse) {
        JSONObject jObjError = null;
        int type = 0;
        String message = "";
        try {
            if (tResponse.errorBody() != null) {
                jObjError = new JSONObject(tResponse.errorBody().string());
                message = jObjError.getString("message");
                type = Integer.parseInt(jObjError.getString("type"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LoadingBox.hide();
        if (tResponse.isSuccessful()) {
            this.success(tResponse.body());
        } else if (TextUtils.isEmpty((CharSequence)message)) {
            this.fireError(ErrorUtils.parseError(tResponse, type));
        } else {
            this.fireError(new APIError(900, message, 0));
        }
    }

    public void onFailure(Call<T> t, Throwable throwable) {
        LoadingBox.hide();
        this.fireError(new APIError(900, this.resolveNetworkError(throwable), 0));
    }

    public void fireError(APIError apiError) {
        if (this.showError.booleanValue() && this.weakActivity.get() != null && this.checkAuthorizationError(apiError).booleanValue()) {
            return;
        }
        this.failure(apiError);
    }

    public Boolean checkAuthorizationError(APIError apiError) {
        if (apiError.getStatusCode() == 403) {
            Toast.makeText((Context)((Context)this.weakActivity.get()), (CharSequence)apiError.getMessage(), (int)0).show();
            ((Activity)this.weakActivity.get()).finish();
            return false;
        }
        if (this.showError.booleanValue()) {
            Toast.makeText((Context)((Context)this.weakActivity.get()), (CharSequence)apiError.getMessage(), (int)0).show();
        }
        return true;
    }

    private String resolveNetworkError(Throwable cause) {
        HippoLog.e("resolveNetworkError =", String.valueOf(cause.toString()));
        if (cause instanceof UnknownHostException) {
            return "No internet connection. Please try again later.";
        }
        if (cause instanceof SocketTimeoutException) {
            return "No internet connection. Please try again later.";
        }
        if (cause instanceof ConnectException) {
            return "No internet connection. Please try again later.";
        }
        if (cause instanceof JsonSyntaxException) {
            return PARSING_ERROR;
        }
        return UNEXPECTED_ERROR_OCCURRED;
    }
}

