/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.dialog;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.google.android.material.appbar.AppBarLayout;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.model.AgentInfoResponse;
import com.hippo.model.CustomField;
import com.hippo.model.HippoUserProfileModel;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.RoundedCornersTransformation;
import java.io.Serializable;
import java.util.ArrayList;
import retrofit2.Callback;

public class ProfileFragmentDialog
extends DialogFragment
implements AppBarLayout.OnOffsetChangedListener {
    private HippoUserProfileModel profileModel;
    private ImageView imageView;
    private LinearLayout contentLayout;
    protected AppBarLayout appBarLayout;
    protected Toolbar toolbar;
    View view;

    public static ProfileFragmentDialog newInstance(HippoUserProfileModel profileModel) {
        ProfileFragmentDialog fragment = new ProfileFragmentDialog();
        Bundle bundle = new Bundle();
        bundle.putSerializable("profileModel", (Serializable)profileModel);
        bundle.putBoolean("fullScreen", true);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hippo_profile_fragment, container, false);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
    }

    public void onResume() {
        super.onResume();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.ivBackBtn) {
            // empty if block
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            if (this.getArguments() != null) {
                this.profileModel = (HippoUserProfileModel)this.getArguments().getSerializable("profileModel");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setStyle(0, R.style.FullScreenDialogStyle);
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.imageView = (ImageView)view.findViewById(R.id.image);
        this.contentLayout = (LinearLayout)view.findViewById(R.id.contentLayout);
        this.appBarLayout = (AppBarLayout)view.findViewById(R.id.appbar);
        this.toolbar = (Toolbar)view.findViewById(R.id.toolbar);
        this.appBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this);
        RequestOptions myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.getActivity(), 4, 1)).placeholder(ContextCompat.getDrawable((Context)this.getActivity(), (int)R.drawable.hippo_placeholder))).fitCenter()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.getActivity(), (int)R.drawable.hippo_placeholder));
        Glide.with((FragmentActivity)this.getActivity()).load(this.profileModel.getImageUrl()).apply((BaseRequestOptions)myOptions).into(this.imageView);
        this.getAgentInfo();
    }

    private void getAgentInfo() {
        CommonParams params = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_user_id", this.profileModel.getEnUserId()).add("channel_id", this.profileModel.getChannelID()).build();
        RestClient.getApiInterface().getAgentInfo(params.getMap()).enqueue((Callback)new ResponseResolver<AgentInfoResponse>((Activity)this.getActivity(), Boolean.valueOf(true), Boolean.valueOf(true)){

            @Override
            public void success(AgentInfoResponse commonResponse) {
                ArrayList fields = new ArrayList();
                for (CustomField field : commonResponse.getData().getCustomFields()) {
                    if (!field.getShowToCustomer().booleanValue()) continue;
                    ProfileFragmentDialog.this.contentLayout.addView(ProfileFragmentDialog.this.getViews(field.getDisplayName(), field.getValue()));
                }
            }

            @Override
            public void failure(APIError error) {
            }
        });
    }

    private View getViews(String titleStr, String detailStr) {
        LayoutInflater layoutInflater = (LayoutInflater)this.getActivity().getBaseContext().getSystemService("layout_inflater");
        this.view = layoutInflater.inflate(R.layout.hippo_content_main, null, false);
        TextView title = (TextView)this.view.findViewById(R.id.title);
        TextView detail = (TextView)this.view.findViewById(R.id.detail);
        title.setText((CharSequence)titleStr);
        detail.setText((CharSequence)detailStr);
        return this.view;
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int i) {
    }
}

