/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.adapter;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.media.MediaPlayer;
import android.os.Build;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.downloader.Error;
import com.downloader.OnDownloadListener;
import com.downloader.OnPauseListener;
import com.downloader.OnProgressListener;
import com.downloader.OnStartOrResumeListener;
import com.downloader.PRDownloader;
import com.downloader.Progress;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.ImageDisplayActivity;
import com.hippo.activity.VideoPlayerActivity;
import com.hippo.adapter.CustomActionButtonsAdapter;
import com.hippo.adapter.CustomActionDescriptionAdapter;
import com.hippo.adapter.FuguMessageAdapter;
import com.hippo.adapter.OnRecyclerListener;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.Util.TagContainerLayout;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.model.EventItem;
import com.hippo.agent.model.HeaderItem;
import com.hippo.agent.model.ListItem;
import com.hippo.agent.model.Message;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.CustomAction;
import com.hippo.model.Image;
import com.hippo.utils.CommonMediaPlayer;
import com.hippo.utils.DateUtils;
import com.hippo.utils.GridDividerItemDecoration;
import com.hippo.utils.HippoLog;
import com.hippo.utils.RoundedCornersTransformation;
import com.hippo.utils.Utils;
import com.hippo.utils.fileUpload.FileManager;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.loadingBox.ProgressWheel;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class FuguAgentMessageAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements FuguAppConstant,
OnRecyclerListener {
    private static final String TAG = FuguAgentMessageAdapter.class.getSimpleName();
    private AgentChatActivity context;
    private final int TYPE_HEADER = 0;
    private final int ITEM_TYPE_SELF = 2;
    private final int ITEM_ASSIGNMENT = 3;
    private final int FUGU_VIDEO_CALL_VIEW = 18;
    private final int HIPPO_FILE_SENT_VIEW = 10;
    private final int HIPPO_VIDEO_MESSGAE_SELF = 12;
    private final int HIPPO_UNKNOWN_MESSAGE_SELF = -2;
    private final int HIPPO_UNKNOWN_MESSAGE_OTHER = -1;
    private final int ITEM_TYPE_OTHER = 1;
    private final int FUGU_OTHER_VIDEO_CALL_VIEW = 19;
    private final int HIPPO_FILE_RECEIVED_VIEW = 11;
    private final int HIPPO_VIDEO_MESSGAE_OTHER = 13;
    private final int HIPPO_USER_CONCENT_VIEW = 20;
    private DateUtils dateUtil = DateUtils.getInstance();
    private OnRetryListener mOnRetry;
    private HippoColorConfig hippoColorConfig;
    private Conversation conversation;
    private FuguMessageAdapter.onVideoCall onVideoCall;
    private String customerName;
    private String agentName;
    private boolean isChatAssignToMe = false;
    private boolean isVideoCallEnabled = true;
    private int agentId;
    @NonNull
    private List<ListItem> items = Collections.emptyList();
    private RecyclerView recyclerView;
    int currentProgress = -1;

    public FuguAgentMessageAdapter(AgentChatActivity context, @NonNull List<ListItem> items, RecyclerView recyclerView, Conversation conversation) {
        this.items = items;
        this.recyclerView = recyclerView;
        this.context = context;
        this.hippoColorConfig = CommonData.getColorConfig();
        this.conversation = conversation;
    }

    public void updateList(@NonNull List<ListItem> items) {
        this.items = items;
    }

    public void setCustomeName(String customeName) {
        this.customerName = customeName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public void setIsChatAssignToMe(boolean isChatAssignToMe) {
        this.isChatAssignToMe = isChatAssignToMe;
    }

    public void isVideoCallEnabled(boolean isVideoCallEnabled) {
        this.isVideoCallEnabled = isVideoCallEnabled;
    }

    public void setOnVideoCallListener(FuguMessageAdapter.onVideoCall onVideoCall2) {
        this.onVideoCall = onVideoCall2;
    }

    public void setOnRetryListener(OnRetryListener OnRetryListener2) {
        this.mOnRetry = OnRetryListener2;
    }

    @Override
    public void onItemClick(View viewClicked, View parentView, int position) {
        int positionInList = this.recyclerView.getChildLayoutPosition(parentView);
        if (positionInList != -1) {
            if (!Utils.preventMultipleClicks()) {
                return;
            }
            Message otherVideoMessage = ((EventItem)this.items.get(positionInList)).getEvent();
            String fname = Util.getFileName(otherVideoMessage.getFileName(), otherVideoMessage.getMuid());
            String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(otherVideoMessage.getDocumentType()));
            Intent intent = new Intent((Context)this.context, VideoPlayerActivity.class);
            intent.putExtra("url", localPath);
            intent.putExtra("title", otherVideoMessage.getFileName());
            this.context.startActivity(intent);
        }
    }

    @Override
    public void onItemClick(View parentView, int position) {
    }

    private void removeDefaultMsgTime() {
        for (int i = 0; i < 2 && i <= this.items.size(); ++i) {
            if (this.items.get(i).getType() != 1) continue;
            ((EventItem)this.items.get(i)).getEvent().setSentAtUtc("");
            break;
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_message_date, parent, false);
                return new DateViewHolder(normalView);
            }
            case 1: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_message_left, parent, false);
                return new OtherMessageViewHolder(normalView);
            }
            case 3: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_assignment, parent, false);
                return new AssignmentViewHolder(normalView);
            }
            case 2: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_message_right, parent, false);
                return new SelfMessageViewHolder(normalView);
            }
            case 18: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_video_self_side, parent, false);
                return new SelfVideoViewHolder(normalView);
            }
            case 19: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_video_other_side, parent, false);
                return new VideoViewHolder(normalView);
            }
            case 10: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_file_sent, parent, false);
                return new SentFileViewHolder(normalView);
            }
            case 11: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_file_received, parent, false);
                return new ReceivedFileViewHolder(normalView);
            }
            case 12: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_video_self, parent, false);
                return new SelfVideoMessageViewHolder(normalView);
            }
            case 13: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_video_other, parent, false);
                return new OtherVideoMessageViewHolder(normalView, this);
            }
            case -2: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_message_right, parent, false);
                return new SelfMessageViewHolder(normalView);
            }
            case -1: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_message_left, parent, false);
                return new OtherMessageViewHolder(normalView);
            }
            case 20: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_agent_bot_item, parent, false);
                return new UserConcentViewHolder(normalView);
            }
        }
        return null;
    }

    @TargetApi(value=21)
    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        int itemType = this.getItemViewType(position);
        switch (itemType) {
            case 18: {
                SelfVideoViewHolder videoViewHolder = (SelfVideoViewHolder)holder;
                final Message videoMessage = ((EventItem)this.items.get(position)).getEvent();
                videoViewHolder.tvMsg.setText((CharSequence)this.getMessage(videoMessage, 18));
                if (videoMessage.getSentAtUtc().isEmpty()) {
                    videoViewHolder.tvTime.setVisibility(8);
                } else {
                    videoViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(videoMessage.getSentAtUtc())));
                    videoViewHolder.tvTime.setVisibility(0);
                }
                if (videoMessage.getVideoCallDuration() > 0) {
                    videoViewHolder.ivCallIcon.setVisibility(0);
                    videoViewHolder.tvDuration.setVisibility(0);
                    videoViewHolder.tvDuration.setText((CharSequence)(this.convertSeconds(videoMessage.getVideoCallDuration()) + " at "));
                } else {
                    videoViewHolder.ivCallIcon.setVisibility(8);
                    videoViewHolder.tvDuration.setVisibility(8);
                }
                if (!(this.isChatAssignToMe && AgentCommonData.getUserData().isVideoCallEnabled() && this.isVideoCallEnabled)) {
                    videoViewHolder.callAgain.setVisibility(8);
                }
                videoViewHolder.callAgain.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguAgentMessageAdapter.this.onVideoCall != null) {
                            int callType = 1;
                            if (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                                callType = 2;
                            }
                            FuguAgentMessageAdapter.this.onVideoCall.onVideoCallClicked(callType);
                        }
                    }
                });
                break;
            }
            case 19: {
                VideoViewHolder videoOtherViewHolder = (VideoViewHolder)holder;
                final Message videoOtherMessage = ((EventItem)this.items.get(position)).getEvent();
                videoOtherViewHolder.tvMsg.setText((CharSequence)this.getMessage(videoOtherMessage, 19));
                if (videoOtherMessage.getSentAtUtc().isEmpty()) {
                    videoOtherViewHolder.tvTime.setVisibility(8);
                } else {
                    videoOtherViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(videoOtherMessage.getSentAtUtc())));
                    videoOtherViewHolder.tvTime.setVisibility(0);
                }
                videoOtherViewHolder.userImage.setVisibility(8);
                if (videoOtherMessage.getVideoCallDuration() > 0) {
                    videoOtherViewHolder.ivCallIcon.setVisibility(0);
                    videoOtherViewHolder.tvDuration.setVisibility(0);
                    videoOtherViewHolder.tvDuration.setText((CharSequence)(this.convertSeconds(videoOtherMessage.getVideoCallDuration()) + " at "));
                } else {
                    videoOtherViewHolder.ivCallIcon.setVisibility(8);
                    videoOtherViewHolder.tvDuration.setVisibility(8);
                }
                NinePatchDrawable drawable2 = (NinePatchDrawable)videoOtherViewHolder.llMessage.getBackground();
                drawable2.setColorFilter(this.hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
                videoOtherViewHolder.llRoot.setPadding(this.pxToDp(17), this.pxToDp(1), 0, this.pxToDp(1));
                videoOtherViewHolder.tvMsg.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
                videoOtherViewHolder.callAgain.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguAgentMessageAdapter.this.onVideoCall != null) {
                            int callType = 1;
                            if (!TextUtils.isEmpty((CharSequence)videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                                callType = 2;
                            }
                            FuguAgentMessageAdapter.this.onVideoCall.onVideoCallClicked(callType);
                        }
                    }
                });
                break;
            }
            case 0: {
                DateViewHolder dateViewHolder = (DateViewHolder)holder;
                HeaderItem headerItem = (HeaderItem)this.items.get(position);
                if (headerItem.getDate().isEmpty()) {
                    dateViewHolder.tvDate.setVisibility(8);
                } else {
                    DateUtils.getInstance();
                    String date = DateUtils.getDate(headerItem.getDate());
                    dateViewHolder.tvDate.setText((CharSequence)date);
                    dateViewHolder.tvDate.setVisibility(0);
                }
                GradientDrawable drawable2 = (GradientDrawable)dateViewHolder.tvDate.getBackground();
                drawable2.setStroke((int)this.context.getResources().getDimension(R.dimen.fugu_border_width), this.hippoColorConfig.getHippoBorderColor());
                dateViewHolder.tvDate.setTextColor(this.hippoColorConfig.getHippoChatDateText());
                break;
            }
            case 1: {
                final OtherMessageViewHolder otherMessageViewHolder = (OtherMessageViewHolder)holder;
                final Message currentOrderItem = ((EventItem)this.items.get(position)).getEvent();
                otherMessageViewHolder.tvUserName.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFromName());
                otherMessageViewHolder.tvMsg.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherMessageViewHolder.tvMsg.setLinkTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherMessageViewHolder.tvMsg.setAutoLinkMask(15);
                otherMessageViewHolder.tvTime.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFrom());
                otherMessageViewHolder.userImage.setVisibility(8);
                if (currentOrderItem.getMessage().isEmpty()) {
                    otherMessageViewHolder.tvMsg.setVisibility(4);
                    LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-2, -1);
                    params2.weight = 1.0f;
                    params2.gravity = 0x800005;
                    otherMessageViewHolder.rlMessages.setLayoutParams((ViewGroup.LayoutParams)params2);
                } else {
                    otherMessageViewHolder.tvMsg.setText((CharSequence)currentOrderItem.getMessage());
                    String msg = currentOrderItem.getMessage().replace(" ", "&nbsp;");
                    otherMessageViewHolder.tvMsg.setText((CharSequence)Html.fromHtml((String)msg.replace("\n", "<br /> ")));
                    otherMessageViewHolder.tvMsg.setVisibility(0);
                }
                otherMessageViewHolder.tvUserName.setText((CharSequence)currentOrderItem.getfromName());
                if (currentOrderItem.getSentAtUtc().isEmpty()) {
                    otherMessageViewHolder.tvTime.setVisibility(8);
                } else {
                    otherMessageViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(currentOrderItem.getSentAtUtc())));
                    otherMessageViewHolder.tvTime.setVisibility(0);
                }
                String userNameText = "";
                if (!TextUtils.isEmpty((CharSequence)currentOrderItem.getfromName())) {
                    userNameText = currentOrderItem.getfromName();
                }
                this.setOtherTypeView(position, currentOrderItem, userNameText, otherMessageViewHolder.llChatLeft, otherMessageViewHolder.tvUserName, otherMessageViewHolder.llRoot, otherMessageViewHolder.tvMsg);
                this.setIntegrationSource(otherMessageViewHolder.messageSourceType, otherMessageViewHolder.messageSourceType1, currentOrderItem.getIntegrationSource());
                if (!currentOrderItem.getThumbnailUrl().isEmpty()) {
                    new RequestOptions();
                    RequestOptions myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.context, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder));
                    Glide.with((FragmentActivity)this.context).load(currentOrderItem.getThumbnailUrl()).apply((BaseRequestOptions)myOptions).into(otherMessageViewHolder.ivMsgImage);
                    otherMessageViewHolder.rlImageMessage.setVisibility(0);
                } else {
                    otherMessageViewHolder.rlImageMessage.setVisibility(8);
                }
                otherMessageViewHolder.rlImageMessage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        FuguAgentMessageAdapter.this.showImageDialog((Context)FuguAgentMessageAdapter.this.context, currentOrderItem.getImageUrl(), otherMessageViewHolder.ivMsgImage, currentOrderItem);
                    }
                });
                this.customViewUI(currentOrderItem, (Context)this.context, otherMessageViewHolder.llChatLeft, otherMessageViewHolder.rlCustomAction, otherMessageViewHolder.tvActionTitle, otherMessageViewHolder.tvActionTitleDescription, otherMessageViewHolder.llTextualContent, otherMessageViewHolder.ivActionImage, otherMessageViewHolder.rvActionDescription, otherMessageViewHolder.rvActionButtons, otherMessageViewHolder.vwActionButtonDivider);
                break;
            }
            case 2: {
                final SelfMessageViewHolder selfMessageViewHolder = (SelfMessageViewHolder)holder;
                final Message selfOrderItem = ((EventItem)this.items.get(position)).getEvent();
                selfMessageViewHolder.tvName.setVisibility(0);
                selfMessageViewHolder.tvName.setText((CharSequence)selfOrderItem.getfromName());
                if (selfOrderItem.getMessage().isEmpty()) {
                    selfMessageViewHolder.tvMsg.setVisibility(4);
                    LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-2, -1);
                    params2.weight = 1.0f;
                    params2.gravity = 0x800005;
                    selfMessageViewHolder.rlMessages.setLayoutParams((ViewGroup.LayoutParams)params2);
                } else {
                    selfMessageViewHolder.tvMsg.setText((CharSequence)selfOrderItem.getMessage());
                    String msg = selfOrderItem.getMessage().replace("  ", "&nbsp;");
                    selfMessageViewHolder.tvMsg.setText((CharSequence)Html.fromHtml((String)msg.replace("\n", "<br />")));
                    selfMessageViewHolder.tvMsg.setVisibility(0);
                }
                if (selfOrderItem.getSentAtUtc().isEmpty()) {
                    selfMessageViewHolder.tvTime.setVisibility(8);
                } else {
                    selfMessageViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(selfOrderItem.getSentAtUtc())));
                    selfMessageViewHolder.tvTime.setVisibility(0);
                }
                this.setSelfTypeView(position, selfOrderItem, selfMessageViewHolder.llRoot, selfMessageViewHolder.tvName, selfMessageViewHolder.llChat, selfMessageViewHolder.rlMessages, selfMessageViewHolder.tvMsg, selfMessageViewHolder.tvTime);
                this.setIntegrationSource(selfMessageViewHolder.messageSourceType, selfMessageViewHolder.messageSourceType1, selfOrderItem.getIntegrationSource());
                if (!TextUtils.isEmpty((CharSequence)selfOrderItem.getThumbnailUrl()) || !TextUtils.isEmpty((CharSequence)selfOrderItem.getLocalImagePath())) {
                    RequestOptions myOptions;
                    if (selfOrderItem.getMessageStatus() == 4 || selfOrderItem.getMessageStatus() == 5 || selfOrderItem.getMessageStatus() == 6) {
                        myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.context, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder));
                        Glide.with((FragmentActivity)this.context).load(new File(selfOrderItem.getLocalImagePath())).apply((BaseRequestOptions)myOptions).into(selfMessageViewHolder.ivMsgImage);
                        if (selfOrderItem.getMessageStatus() == 5 || selfOrderItem.getMessageStatus() == 6) {
                            selfMessageViewHolder.pbLoading.setVisibility(8);
                            selfMessageViewHolder.btnRetry.setVisibility(0);
                            selfMessageViewHolder.btnCancel.setVisibility(0);
                        } else {
                            selfMessageViewHolder.pbLoading.setVisibility(0);
                            selfMessageViewHolder.btnRetry.setVisibility(8);
                            selfMessageViewHolder.btnCancel.setVisibility(8);
                        }
                    } else {
                        myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.context, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder));
                        Glide.with((FragmentActivity)this.context).load(selfOrderItem.getThumbnailUrl()).apply((BaseRequestOptions)myOptions).into(selfMessageViewHolder.ivMsgImage);
                        selfMessageViewHolder.pbLoading.setVisibility(8);
                        selfMessageViewHolder.btnRetry.setVisibility(8);
                        selfMessageViewHolder.btnCancel.setVisibility(8);
                    }
                    selfMessageViewHolder.rlImageMessage.setVisibility(0);
                } else {
                    selfMessageViewHolder.rlImageMessage.setVisibility(8);
                }
                selfMessageViewHolder.rlImageMessage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (selfOrderItem.getMessageStatus() == 4 || selfOrderItem.getMessageStatus() == 5) {
                            return;
                        }
                        FuguAgentMessageAdapter.this.showImageDialog((Context)FuguAgentMessageAdapter.this.context, selfOrderItem.getImageUrl(), selfMessageViewHolder.ivMsgImage, selfOrderItem);
                    }
                });
                if (selfOrderItem.getIsMessageExpired() == 1 && selfOrderItem.getMessageType() != 10) {
                    selfMessageViewHolder.llRetry.setVisibility(0);
                    selfMessageViewHolder.tvCancel.setVisibility(0);
                    selfMessageViewHolder.tvTryAgain.setTag((Object)position);
                    selfMessageViewHolder.tvCancel.setTag((Object)position);
                    selfMessageViewHolder.tvTryAgain.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                                String muid = selfOrderItem.getMuid();
                                int pos = selfMessageViewHolder.getAdapterPosition();
                                FuguAgentMessageAdapter.this.mOnRetry.onMessageRetry(muid, pos);
                            }
                        }
                    });
                    selfMessageViewHolder.tvCancel.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            int pos = selfMessageViewHolder.getAdapterPosition();
                            if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                                String muid = selfOrderItem.getMuid();
                                FuguAgentMessageAdapter.this.mOnRetry.onMessageCancel(muid, pos);
                            }
                        }
                    });
                } else {
                    selfMessageViewHolder.llRetry.setVisibility(8);
                    selfMessageViewHolder.tvCancel.setVisibility(8);
                }
                try {
                    switch (selfOrderItem.getMessageStatus()) {
                        case 4: 
                        case 5: 
                        case 6: {
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                            selfMessageViewHolder.ivMessageState.setVisibility(0);
                            selfMessageViewHolder.ivMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                            break;
                        }
                        case 3: {
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_double));
                            selfMessageViewHolder.ivMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoMessageRead(), PorterDuff.Mode.SRC_ATOP);
                            selfMessageViewHolder.ivMessageState.setVisibility(0);
                            break;
                        }
                        case 1: {
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                            selfMessageViewHolder.ivMessageState.setVisibility(0);
                            selfMessageViewHolder.ivMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                            break;
                        }
                        case 2: {
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_double));
                            selfMessageViewHolder.ivMessageState.setVisibility(0);
                            selfMessageViewHolder.ivMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                            break;
                        }
                        default: {
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                            selfMessageViewHolder.ivMessageState.setVisibility(0);
                            selfMessageViewHolder.ivMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                selfMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                            selfMessageViewHolder.pbLoading.setVisibility(0);
                            selfMessageViewHolder.btnRetry.setVisibility(8);
                            String muid = selfOrderItem.getMuid();
                            int pos = selfMessageViewHolder.getAdapterPosition();
                            if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                                FuguAgentMessageAdapter.this.mOnRetry.onFileMessageRetry(muid, pos);
                            }
                        }
                    }
                });
                selfMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                            String muid = selfOrderItem.getMuid();
                            int pos = selfMessageViewHolder.getAdapterPosition();
                            FuguAgentMessageAdapter.this.mOnRetry.onMessageCancel(muid, pos);
                        }
                    }
                });
                this.customViewUI(selfOrderItem, (Context)this.context, selfMessageViewHolder.llChat, selfMessageViewHolder.rlCustomAction, selfMessageViewHolder.tvActionTitle, selfMessageViewHolder.tvActionTitleDescription, selfMessageViewHolder.llTextualContent, selfMessageViewHolder.ivActionImage, selfMessageViewHolder.rvActionDescription, selfMessageViewHolder.rvActionButtons, selfMessageViewHolder.vwActionButtonDivider);
                break;
            }
            case 3: {
                AssignmentViewHolder assignmentViewHolder = (AssignmentViewHolder)holder;
                Message currentAssignemntItem = ((EventItem)this.items.get(position)).getEvent();
                assignmentViewHolder.tvAssignment.setText((CharSequence)Html.fromHtml((String)currentAssignemntItem.getMessage()));
                break;
            }
            case 10: {
                Integer dimage;
                final SentFileViewHolder sentFileViewHolder = (SentFileViewHolder)holder;
                final Message fileSentMessage = ((EventItem)this.items.get(position)).getEvent();
                this.setSelfMessageBackground((View)sentFileViewHolder.llRoot, (View)sentFileViewHolder.llMessage, position);
                NinePatchDrawable drawable4 = (NinePatchDrawable)sentFileViewHolder.llMessage.getBackground();
                drawable4.setColorFilter(this.hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
                sentFileViewHolder.circleProgress.setBarColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                String fileExt = Util.getExtension(fileSentMessage.getFileName());
                if (TextUtils.isEmpty((CharSequence)fileExt)) {
                    fileExt = Util.getExtension(fileSentMessage.getFileUrl());
                }
                if ((dimage = (Integer)IMAGE_MAP.get(fileExt.toLowerCase())) != null) {
                    sentFileViewHolder.ivFileImage.setImageResource(dimage.intValue());
                } else {
                    sentFileViewHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
                }
                sentFileViewHolder.tvFileName.setText((CharSequence)fileSentMessage.getFileName());
                if (fileExt.length() > 4) {
                    fileExt = fileExt.substring(0, 4) + "..";
                }
                sentFileViewHolder.tvFileExtension.setText((CharSequence)fileExt);
                if (!TextUtils.isEmpty((CharSequence)fileSentMessage.getFileSize())) {
                    try {
                        sentFileViewHolder.tvFileSize.setText((CharSequence)fileSentMessage.getFileSize());
                    }
                    catch (Exception e) {
                        sentFileViewHolder.tvFileSize.setText((CharSequence)fileSentMessage.getFileSize());
                    }
                }
                this.setIntegrationSource(sentFileViewHolder.messageSourceType, sentFileViewHolder.messageSourceType1, fileSentMessage.getIntegrationSource());
                this.messageStatusTick((Activity)this.context, sentFileViewHolder.ivMessageState, fileSentMessage);
                this.setFileUploadStatus(sentFileViewHolder.ivFileImage, sentFileViewHolder.ivFilePlay, sentFileViewHolder.circleProgress, sentFileViewHolder.ivFileDownload, sentFileViewHolder.ivFileUpload, fileSentMessage, position);
                this.setDownloadClick(sentFileViewHolder.ivFileDownload, sentFileViewHolder.circleProgress, fileSentMessage, position);
                this.setUploadClick(sentFileViewHolder.ivFileUpload, sentFileViewHolder.circleProgress, fileSentMessage);
                sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                if (!fileSentMessage.isAudioPlaying()) {
                    sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                } else {
                    sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                }
                this.setFileCLickListener(sentFileViewHolder.llMessage, fileSentMessage, sentFileViewHolder.ivFilePlay, position);
                sentFileViewHolder.ivFileUpload.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int pos = sentFileViewHolder.getAdapterPosition();
                        if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                            FuguAgentMessageAdapter.this.mOnRetry.onFileMessageRetry(fileSentMessage.getMuid(), pos);
                        }
                    }
                });
                break;
            }
            case 11: {
                String fileExt1;
                ReceivedFileViewHolder fHolder = (ReceivedFileViewHolder)holder;
                Message fileReceivedMessage = ((EventItem)this.items.get(position)).getEvent();
                fHolder.userImage.setVisibility(8);
                fHolder.progressBar.setBarColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                this.setIntegrationSource(fHolder.messageSourceType, fHolder.messageSourceType1, fileReceivedMessage.getIntegrationSource());
                String fuserNameText = "";
                if (!TextUtils.isEmpty((CharSequence)fileReceivedMessage.getfromName())) {
                    fuserNameText = fileReceivedMessage.getfromName();
                }
                this.setFileMessageOther((View)fHolder.llRoot, (View)fHolder.llMessage, position, fHolder.tvUserName, fuserNameText);
                NinePatchDrawable drawable6 = (NinePatchDrawable)fHolder.llMessage.getBackground();
                drawable6.setColorFilter(this.hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
                String receivedFileExt = Util.getExtension(fileReceivedMessage.getFileUrl());
                Integer dimage1 = (Integer)IMAGE_MAP.get(receivedFileExt.toLowerCase());
                if (dimage1 != null) {
                    fHolder.ivFileImage.setImageResource(dimage1.intValue());
                } else {
                    fHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
                }
                fHolder.tvFileName.setText((CharSequence)fileReceivedMessage.getFileName());
                String string2 = fileExt1 = TextUtils.isEmpty((CharSequence)fileReceivedMessage.getFileExtension()) ? receivedFileExt : fileReceivedMessage.getFileExtension();
                if (fileExt1.length() > 4) {
                    fileExt1 = fileExt1.substring(0, 4) + "..";
                }
                fHolder.tvFileExtension.setText((CharSequence)fileExt1);
                fHolder.tvFileSize.setText((CharSequence)fileReceivedMessage.getFileSize());
                this.setFileDownLoadStatus(fHolder.ivFileImage, fHolder.ivFilePlay, fHolder.progressBar, fHolder.ivFileDownload, fHolder.ivFileUpload, fileReceivedMessage, position);
                this.setDownloadClick(fHolder.ivFileDownload, fHolder.progressBar, fileReceivedMessage, position);
                if (!fileReceivedMessage.isAudioPlaying()) {
                    fHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                } else {
                    fHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                }
                this.setFileCLickListener(fHolder.llMessage, fileReceivedMessage, fHolder.ivFilePlay, position);
                break;
            }
            case 12: {
                final SelfVideoMessageViewHolder selfVideoMessageViewHolder = (SelfVideoMessageViewHolder)holder;
                final Message selfVideoMessage = ((EventItem)this.items.get(position)).getEvent();
                this.setSelfMessageBackground((View)selfVideoMessageViewHolder.llRoot, (View)selfVideoMessageViewHolder.llImageMessage, position);
                NinePatchDrawable drawable5 = (NinePatchDrawable)selfVideoMessageViewHolder.llImageMessage.getBackground();
                drawable5.setColorFilter(this.hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
                selfVideoMessageViewHolder.circle_progress.setBarColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                this.setIntegrationSource(selfVideoMessageViewHolder.messageSourceType, selfVideoMessageViewHolder.messageSourceType1, selfVideoMessage.getIntegrationSource());
                this.setTime(selfVideoMessageViewHolder.tvImageTime, selfVideoMessage.getSentAtUtc());
                this.setMessageStatus(selfVideoMessageViewHolder.ivMessageState, selfVideoMessage.getMessageStatus(), true);
                if (!TextUtils.isEmpty((CharSequence)selfVideoMessage.getThumbnailUrl())) {
                    this.setImage((Activity)this.context, selfVideoMessageViewHolder.ivImageMsg, selfVideoMessage.getThumbnailUrl());
                } else {
                    selfVideoMessageViewHolder.ivImageMsg.setVisibility(8);
                }
                this.setImageHeightAndWidth((ImageView)selfVideoMessageViewHolder.ivImageMsg, selfVideoMessageViewHolder.rlImageMessage, selfVideoMessageViewHolder.llImageMessage, selfVideoMessage, true);
                selfVideoMessageViewHolder.ivPlay.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (!Utils.preventMultipleClicks()) {
                            return;
                        }
                        String fname = Util.getFileName(selfVideoMessage.getFileName(), selfVideoMessage.getMuid());
                        String localPath = FileManager.getInstance().getLocalPath(fname, FuguAppConstant.FOLDER_TYPE.get(selfVideoMessage.getDocumentType()));
                        if (TextUtils.isEmpty((CharSequence)localPath)) {
                            localPath = selfVideoMessage.getFileUrl();
                        }
                        Intent intent = new Intent((Context)FuguAgentMessageAdapter.this.context, VideoPlayerActivity.class);
                        intent.putExtra("url", localPath);
                        intent.putExtra("title", selfVideoMessage.getFileName());
                        FuguAgentMessageAdapter.this.context.startActivity(intent);
                    }
                });
                this.setVideoUiStatus(true, selfVideoMessage, selfVideoMessageViewHolder.llDownload, selfVideoMessageViewHolder.ivPlay, selfVideoMessageViewHolder.btnRetry, selfVideoMessageViewHolder.btnCancel, selfVideoMessageViewHolder.circle_progress);
                selfVideoMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int pos = selfVideoMessageViewHolder.getAdapterPosition();
                        if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                            FuguAgentMessageAdapter.this.mOnRetry.onMessageCancel(selfVideoMessage.getMuid(), pos);
                        }
                    }
                });
                selfVideoMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int pos = selfVideoMessageViewHolder.getAdapterPosition();
                        if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                            FuguAgentMessageAdapter.this.mOnRetry.onFileMessageRetry(selfVideoMessage.getMuid(), pos);
                        }
                    }
                });
                selfVideoMessageViewHolder.llDownload.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        String fullPath;
                        File file;
                        String fileName;
                        selfVideoMessageViewHolder.circle_progress.setVisibility(0);
                        selfVideoMessageViewHolder.llDownload.setVisibility(8);
                        String docType = "video";
                        if (selfVideoMessage.getMessageType() == 11) {
                            docType = selfVideoMessage.getDocumentType();
                        }
                        if (TextUtils.isEmpty((CharSequence)(fileName = selfVideoMessage.getFileName()))) {
                            String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                            fileName = "Hippochat_" + timeStamp + ".jpg";
                        }
                        if (!(file = new File(fullPath = Util.getDirectoryPath(FuguAppConstant.FOLDER_TYPE.get(docType)))).exists()) {
                            file.mkdir();
                        }
                        int downloadId = FuguAgentMessageAdapter.this.downloadFileFromUrl(fullPath, fileName, selfVideoMessage, position);
                        selfVideoMessage.setDownloadId(downloadId);
                    }
                });
                break;
            }
            case 13: {
                final OtherVideoMessageViewHolder otherVideoMessageViewHolder = (OtherVideoMessageViewHolder)holder;
                final Message otherVideoMessage = ((EventItem)this.items.get(position)).getEvent();
                otherVideoMessageViewHolder.userImage.setVisibility(8);
                otherVideoMessageViewHolder.progressBar.setBarColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                this.setTime(otherVideoMessageViewHolder.tvImageTime, otherVideoMessage.getSentAtUtc());
                if (!TextUtils.isEmpty((CharSequence)otherVideoMessage.getThumbnailUrl())) {
                    this.setImage((Activity)this.context, otherVideoMessageViewHolder.ivImageMsg, otherVideoMessage.getThumbnailUrl());
                } else {
                    otherVideoMessageViewHolder.ivImageMsg.setVisibility(8);
                }
                this.setIntegrationSource(otherVideoMessageViewHolder.messageSourceType, otherVideoMessageViewHolder.messageSourceType1, otherVideoMessage.getIntegrationSource());
                this.setImageHeightAndWidth((ImageView)otherVideoMessageViewHolder.ivImageMsg, otherVideoMessageViewHolder.rlImageMessage, otherVideoMessageViewHolder.llImageMessage, otherVideoMessage, true);
                this.setVideoDownloadStatus(otherVideoMessageViewHolder.llDownload, otherVideoMessageViewHolder.ivPlay, otherVideoMessageViewHolder.tvFileSize, otherVideoMessageViewHolder.progressBar, otherVideoMessage, position);
                String vuserNameText = "";
                if (!TextUtils.isEmpty((CharSequence)otherVideoMessage.getfromName())) {
                    vuserNameText = otherVideoMessage.getfromName();
                }
                this.setFileMessageOther((View)otherVideoMessageViewHolder.llRoot, (View)otherVideoMessageViewHolder.llImageMessage, position, otherVideoMessageViewHolder.tvUserName, vuserNameText);
                otherVideoMessageViewHolder.llDownload.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (FuguAgentMessageAdapter.this.context.isNetworkAvailable()) {
                            String fullPath;
                            File file;
                            String fileName;
                            otherVideoMessageViewHolder.progressBar.setVisibility(0);
                            otherVideoMessageViewHolder.llDownload.setVisibility(8);
                            String docType = "video";
                            if (otherVideoMessage.getMessageType() == 11) {
                                docType = otherVideoMessage.getDocumentType();
                            }
                            if (TextUtils.isEmpty((CharSequence)(fileName = otherVideoMessage.getFileName()))) {
                                String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                                fileName = "Hippochat_" + timeStamp + ".jpg";
                            }
                            if (!(file = new File(fullPath = Util.getDirectoryPath(FuguAppConstant.FOLDER_TYPE.get(docType)))).exists()) {
                                file.mkdir();
                            }
                            int downloadId = FuguAgentMessageAdapter.this.downloadFileFromUrl(fullPath, fileName, otherVideoMessage, position);
                            otherVideoMessage.setDownloadId(downloadId);
                        } else {
                            Toast.makeText((Context)FuguAgentMessageAdapter.this.context, (CharSequence)FuguAgentMessageAdapter.this.context.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
                        }
                    }
                });
                break;
            }
            case -1: {
                OtherMessageViewHolder otherUnknownView = (OtherMessageViewHolder)holder;
                Message unknownItemOther = ((EventItem)this.items.get(position)).getEvent();
                otherUnknownView.userImage.setVisibility(8);
                otherUnknownView.tvUserName.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFromName());
                otherUnknownView.tvMsg.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherUnknownView.tvMsg.setLinkTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherUnknownView.tvMsg.setAutoLinkMask(15);
                otherUnknownView.tvTime.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFrom());
                String message = this.context.getString(R.string.unknown_message);
                if (!TextUtils.isEmpty((CharSequence)AgentCommonData.getUserData().getUnsupportedMessage())) {
                    message = AgentCommonData.getUserData().getUnsupportedMessage();
                }
                otherUnknownView.tvMsg.setText((CharSequence)message);
                otherUnknownView.tvMsg.setVisibility(0);
                otherUnknownView.tvUserName.setText((CharSequence)unknownItemOther.getfromName());
                if (unknownItemOther.getSentAtUtc().isEmpty()) {
                    otherUnknownView.tvTime.setVisibility(8);
                } else {
                    otherUnknownView.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(unknownItemOther.getSentAtUtc())));
                    otherUnknownView.tvTime.setVisibility(0);
                }
                String userNameText1 = "";
                boolean userNameStringCount1 = true;
                if (!TextUtils.isEmpty((CharSequence)unknownItemOther.getfromName())) {
                    userNameText1 = unknownItemOther.getfromName();
                }
                this.setOtherTypeView(position, unknownItemOther, userNameText1, otherUnknownView.llChatLeft, otherUnknownView.tvUserName, otherUnknownView.llRoot, otherUnknownView.tvMsg);
                break;
            }
            case -2: {
                SelfMessageViewHolder selfUnknownView = (SelfMessageViewHolder)holder;
                Message unknownItemSelf = ((EventItem)this.items.get(position)).getEvent();
                selfUnknownView.tvName.setVisibility(0);
                selfUnknownView.tvName.setText((CharSequence)unknownItemSelf.getfromName());
                String selfMsg = this.context.getString(R.string.unknown_message);
                if (!TextUtils.isEmpty((CharSequence)AgentCommonData.getUserData().getUnsupportedMessage())) {
                    selfMsg = AgentCommonData.getUserData().getUnsupportedMessage();
                }
                selfUnknownView.tvMsg.setText((CharSequence)selfMsg);
                selfUnknownView.tvMsg.setVisibility(0);
                if (unknownItemSelf.getSentAtUtc().isEmpty()) {
                    selfUnknownView.tvTime.setVisibility(8);
                } else {
                    selfUnknownView.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(unknownItemSelf.getSentAtUtc())));
                    selfUnknownView.tvTime.setVisibility(0);
                }
                this.setSelfTypeView(position, unknownItemSelf, selfUnknownView.llRoot, selfUnknownView.tvName, selfUnknownView.llChat, selfUnknownView.rlMessages, selfUnknownView.tvMsg, selfUnknownView.tvTime);
                break;
            }
            case 20: {
                UserConcentViewHolder userConcentViewHolder = (UserConcentViewHolder)holder;
                Message userConcentMessage = ((EventItem)this.items.get(position)).getEvent();
                this.setBotSelfView(position, userConcentViewHolder, userConcentMessage);
                String selectedBtnId = "";
                if (!TextUtils.isEmpty((CharSequence)userConcentMessage.getSelectedBtnId())) {
                    selectedBtnId = userConcentMessage.getSelectedBtnId();
                }
                if (TextUtils.isEmpty((CharSequence)selectedBtnId)) {
                    userConcentViewHolder.tagLayout.setVisibility(0);
                    userConcentViewHolder.tvTagsTime.setVisibility(0);
                    userConcentViewHolder.leftrootview.setVisibility(8);
                    ArrayList<String> tagList = new ArrayList<String>();
                    ArrayList<Integer> colorsTag = new ArrayList<Integer>();
                    for (int i = 0; i < userConcentMessage.getContentValue().size(); ++i) {
                        tagList.add(userConcentMessage.getContentValue().get(i).getBtnTitle());
                        colorsTag.add(this.hippoColorConfig.getHippoBgMessageYou());
                    }
                    userConcentViewHolder.tagLayout.setTagBorderColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                    userConcentViewHolder.tagLayout.setTagTextColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                    userConcentViewHolder.tagLayout.setTags(tagList, colorsTag);
                    break;
                }
                userConcentViewHolder.leftrootview.setVisibility(0);
                userConcentViewHolder.tagLayout.setVisibility(8);
                userConcentViewHolder.tvTagsTime.setVisibility(8);
                int selectedPosition = 0;
                for (int i = 0; i < userConcentMessage.getContentValue().size(); ++i) {
                    if (!selectedBtnId.equalsIgnoreCase(userConcentMessage.getContentValue().get(i).getBtnId())) continue;
                    selectedPosition = i;
                    break;
                }
                this.setBotOtherView(position, selectedPosition, userConcentViewHolder, userConcentMessage);
                break;
            }
        }
    }

    private void setBotOtherView(int position, int selectedBtn, UserConcentViewHolder userConcentViewHolder, Message userConcentMessage) {
        userConcentViewHolder.tvMsg.setText((CharSequence)userConcentMessage.getContentValue().get(selectedBtn).getBtnTitle());
        userConcentViewHolder.tvUserName.setText((CharSequence)userConcentMessage.getfromName());
        userConcentViewHolder.tvUserName.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFromName());
        userConcentViewHolder.tvMsg.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
        userConcentViewHolder.tvTime.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFrom());
        if (userConcentMessage.getSentAtUtc().isEmpty()) {
            userConcentViewHolder.tvTime.setVisibility(8);
        } else {
            userConcentViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(userConcentMessage.getSentAtUtc())));
            userConcentViewHolder.tvTime.setVisibility(0);
        }
        String userNameText = userConcentMessage.getRepliedBy();
        if (position != 0 && this.getItemViewType(position - 1) == 1) {
            Message lastOrderItem = ((EventItem)this.items.get(position - 1)).getEvent();
            if (userConcentMessage.getUserId().compareTo(lastOrderItem.getUserId()) != 0) {
                userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
                userConcentViewHolder.tvUserName.setVisibility(0);
                userConcentViewHolder.tvUserName.setText((CharSequence)userNameText);
                userConcentViewHolder.leftrootview.setPadding(this.pxToDp(10), this.pxToDp(8), 0, this.pxToDp(1));
                userConcentViewHolder.tvUserName.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                userConcentViewHolder.tvMsg.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
            } else if (position != 0 && position + 1 != this.items.size() && this.getItemViewType(position + 1) != 1) {
                userConcentViewHolder.tvUserName.setVisibility(8);
                userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                userConcentViewHolder.leftrootview.setPadding(this.pxToDp(17), this.pxToDp(1), this.pxToDp(0), this.pxToDp(2));
                userConcentViewHolder.tvUserName.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                userConcentViewHolder.tvMsg.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
            } else {
                userConcentViewHolder.tvUserName.setVisibility(8);
                userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                userConcentViewHolder.leftrootview.setPadding(this.pxToDp(17), this.pxToDp(1), 0, this.pxToDp(1));
                userConcentViewHolder.tvUserName.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                userConcentViewHolder.tvMsg.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
            }
        } else if (position != 0 && position + 1 != this.items.size() && this.getItemViewType(position + 1) == 1) {
            userConcentViewHolder.tvUserName.setVisibility(0);
            userConcentViewHolder.tvUserName.setText((CharSequence)userNameText);
            userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            userConcentViewHolder.leftrootview.setPadding(this.pxToDp(10), this.pxToDp(4), this.pxToDp(0), this.pxToDp(1));
            userConcentViewHolder.tvUserName.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
            userConcentViewHolder.tvMsg.setPadding(this.pxToDp(15), this.pxToDp(0), this.pxToDp(2), this.pxToDp(7));
        } else {
            userConcentViewHolder.tvUserName.setVisibility(0);
            userConcentViewHolder.tvUserName.setText((CharSequence)userNameText);
            userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            userConcentViewHolder.leftrootview.setPadding(this.pxToDp(10), this.pxToDp(4), 0, this.pxToDp(2));
            userConcentViewHolder.tvUserName.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
            userConcentViewHolder.tvMsg.setPadding(this.pxToDp(15), this.pxToDp(0), this.pxToDp(2), this.pxToDp(7));
        }
        NinePatchDrawable drawable2 = (NinePatchDrawable)userConcentViewHolder.llChatLeft.getBackground();
        drawable2.setColorFilter(this.hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
    }

    private void setBotSelfView(int position, UserConcentViewHolder userConcentViewHolder, Message userConcentMessage) {
        userConcentViewHolder.tvNameRight.setText((CharSequence)userConcentMessage.getfromName());
        userConcentViewHolder.tvMsgRight.setText((CharSequence)userConcentMessage.getMessage());
        userConcentViewHolder.tvNameRight.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFromName());
        userConcentViewHolder.tvMsgRight.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgYou());
        userConcentViewHolder.tvTimeRight.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgYou());
        if (userConcentMessage.getSentAtUtc().isEmpty()) {
            userConcentViewHolder.tvTimeRight.setVisibility(8);
        } else {
            userConcentViewHolder.tvTimeRight.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(userConcentMessage.getSentAtUtc())));
            userConcentViewHolder.tvTimeRight.setVisibility(0);
        }
        if (position != 0 && this.getItemViewType(position - 1) == 2 && position + 1 != this.items.size() && this.getItemViewType(position + 1) == 2) {
            userConcentViewHolder.llRootRight.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(1));
        } else if (position != 0 && this.getItemViewType(position - 1) == 2 && position + 1 != this.items.size() && this.getItemViewType(position + 1) != 2 || position - 1 >= 0 && this.getItemViewType(position - 1) == 2) {
            if (position == this.items.size() - 1) {
                userConcentViewHolder.llRootRight.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(1));
            } else {
                userConcentViewHolder.llRootRight.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(2));
            }
        } else if (position != 0 && position + 1 != this.items.size() && this.getItemViewType(position + 1) == 2) {
            userConcentViewHolder.llRootRight.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(1));
        } else if (position == this.items.size() - 1) {
            userConcentViewHolder.llRootRight.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(1));
        } else {
            userConcentViewHolder.llRootRight.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(2));
        }
        if (position != 0 && this.isNotSelfViewType(position - 1)) {
            userConcentViewHolder.llChatRight.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            userConcentViewHolder.rlMessagesRight.setPadding(this.pxToDp(0), this.pxToDp(0), this.pxToDp(12), this.pxToDp(0));
        } else {
            userConcentViewHolder.llChatRight.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
            userConcentViewHolder.rlMessagesRight.setPadding(this.pxToDp(0), this.pxToDp(0), this.pxToDp(6), this.pxToDp(0));
        }
        NinePatchDrawable drawable3 = (NinePatchDrawable)userConcentViewHolder.llChatRight.getBackground();
        drawable3.setColorFilter(this.hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
    }

    private boolean isNotSelfViewType(int position) {
        int itemType = this.getItemViewType(position);
        return itemType != 2 && itemType != 10 && itemType != 12 && itemType != 18;
    }

    private void customViewUI(Message currentOrderItem2, Context context, LinearLayout llChatLeft, RelativeLayout rlCustomAction, TextView tvActionTitle, TextView tvActionTitleDescription, LinearLayout llTextualContent, ImageView ivActionImage, RecyclerView rvActionDescription, RecyclerView rvActionButtons, View vwActionButtonDivider) {
        if (currentOrderItem2.getMessageType() == 12 || currentOrderItem2.getMessageType() == 19) {
            CustomAction customAction;
            rlCustomAction.setVisibility(0);
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)rlCustomAction.getLayoutParams();
            if (llChatLeft.getBackground().getConstantState() == ContextCompat.getDrawable((Context)context, (int)R.drawable.hippo_chat_bg_left).getConstantState()) {
                layoutParams.setMargins(this.pxToDp(13), this.pxToDp(10), this.pxToDp(10), this.pxToDp(10));
                if (Build.VERSION.SDK_INT >= 17) {
                    layoutParams.setMarginStart(this.pxToDp(13));
                    layoutParams.setMarginEnd(this.pxToDp(10));
                }
            } else {
                layoutParams.setMargins(this.pxToDp(10), this.pxToDp(10), this.pxToDp(10), this.pxToDp(10));
            }
            if ((customAction = currentOrderItem2.getCustomAction()) != null) {
                if (customAction.getTitle() != null && !TextUtils.isEmpty((CharSequence)customAction.getTitle())) {
                    tvActionTitle.setVisibility(0);
                    tvActionTitle.setText((CharSequence)customAction.getTitle());
                } else {
                    tvActionTitle.setVisibility(8);
                }
                if (customAction.getTitleDescription() != null && !TextUtils.isEmpty((CharSequence)customAction.getTitleDescription())) {
                    tvActionTitleDescription.setVisibility(0);
                    tvActionTitleDescription.setText((CharSequence)customAction.getTitleDescription());
                } else {
                    tvActionTitleDescription.setVisibility(8);
                }
                if (customAction.getImageUrl() != null && !TextUtils.isEmpty((CharSequence)customAction.getImageUrl())) {
                    llTextualContent.setBackgroundResource(R.drawable.fugu_white_background_curved_bottom);
                    ivActionImage.setVisibility(0);
                    RequestOptions myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation(context, 7, 2)).placeholder(ContextCompat.getDrawable((Context)context, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)context, (int)R.drawable.hippo_placeholder));
                    Glide.with((Context)context).load(customAction.getImageUrl()).apply((BaseRequestOptions)myOptions).into(ivActionImage);
                } else {
                    ivActionImage.setVisibility(8);
                    llTextualContent.setBackgroundResource(R.drawable.fugu_white_background_curved_all_sides);
                }
                if (customAction.getDescriptionObjects() != null && customAction.getDescriptionObjects().size() != 0) {
                    rvActionDescription.setVisibility(0);
                    rvActionDescription.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
                    rvActionDescription.setNestedScrollingEnabled(false);
                    rvActionDescription.setAdapter((RecyclerView.Adapter)new CustomActionDescriptionAdapter(context, customAction.getDescriptionObjects()));
                } else {
                    rvActionDescription.setVisibility(8);
                }
                if (customAction.getActionButtons() != null && customAction.getActionButtons().size() != 0) {
                    vwActionButtonDivider.setVisibility(0);
                    rvActionButtons.setVisibility(0);
                    rvActionButtons.setNestedScrollingEnabled(false);
                    int span = 2;
                    int size = customAction.getActionButtons().size();
                    span = size == 1 ? 1 : (size % 3 == 0 ? 3 : 2);
                    boolean disAbleClick = false;
                    if (currentOrderItem2.getUserId().intValue() == AgentCommonData.getUserData().getUserId().intValue()) {
                        disAbleClick = true;
                    }
                    rvActionButtons.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, span));
                    rvActionButtons.addItemDecoration((RecyclerView.ItemDecoration)new GridDividerItemDecoration(context));
                    rvActionButtons.setAdapter((RecyclerView.Adapter)new CustomActionButtonsAdapter(context, customAction.getActionButtons(), disAbleClick));
                } else {
                    vwActionButtonDivider.setVisibility(8);
                    rvActionButtons.setVisibility(8);
                }
            }
        } else {
            rlCustomAction.setVisibility(8);
        }
    }

    private void setSelfTypeView(int position, Message currentOrderItem, LinearLayout llRoot, TextView tvName, LinearLayout llChat, RelativeLayout rlMessages, TextView tvMsg, TextView tvTime) {
        if (position != 0 && this.getSelfViewType(position - 1) && position + 1 != this.items.size() && this.getSelfViewType(position + 1)) {
            llRoot.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(1));
            tvName.setVisibility(8);
        } else if (position != 0 && this.getSelfViewType(position - 1) && position + 1 != this.items.size() && this.getSelfViewType(position + 1) || position - 1 >= 0 && this.getSelfViewType(position - 1)) {
            if (position == this.items.size() - 1) {
                llRoot.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(1));
            } else {
                llRoot.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(2));
            }
            tvName.setVisibility(8);
        } else if (position != 0 && position + 1 != this.items.size() && this.getSelfViewType(position + 1)) {
            llRoot.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(1));
        } else if (position == this.items.size() - 1) {
            llRoot.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(1));
        } else {
            llRoot.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(2));
        }
        if (position != 0 && !this.getSelfViewType(position - 1)) {
            llChat.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            rlMessages.setPadding(this.pxToDp(0), this.pxToDp(0), this.pxToDp(12), this.pxToDp(0));
        } else {
            llChat.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
            rlMessages.setPadding(this.pxToDp(0), this.pxToDp(0), this.pxToDp(6), this.pxToDp(0));
        }
        NinePatchDrawable drawable3 = (NinePatchDrawable)llChat.getBackground();
        if (currentOrderItem.getMessageType() == 3) {
            drawable3.setColorFilter(this.hippoColorConfig.getHippoPrivateMsg(), PorterDuff.Mode.MULTIPLY);
        } else {
            drawable3.setColorFilter(this.hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
        }
        tvName.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFromName());
        tvMsg.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgYou());
        tvMsg.setLinkTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgYou());
        tvMsg.setAutoLinkMask(15);
        tvTime.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgYou());
    }

    private boolean getSelfViewType(int position) {
        int type = this.getItemViewType(position);
        return type == 2 || type == 12 || type == 10 || type == 12 || type == -2;
    }

    private void setOtherTypeView(int position, Message currentOrderItem, String userNameText, LinearLayout llChatLeft, TextView tvUserName, LinearLayout llRoot, TextView tvMsg) {
        int previousViewType = this.getItemViewType(position - 1);
        int viewType = this.getItemViewType(position);
        int nextViewType = this.getItemViewType(position);
        if (position + 1 != this.items.size()) {
            nextViewType = this.getItemViewType(position + 1);
        }
        if (position != 0 && (previousViewType == 1 || previousViewType == 20 || previousViewType == -1)) {
            Message lastOrderItem = ((EventItem)this.items.get(position - 1)).getEvent();
            if (currentOrderItem.getUserId().compareTo(lastOrderItem.getUserId()) != 0 && previousViewType != 20) {
                llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
                tvUserName.setVisibility(0);
                tvUserName.setText((CharSequence)userNameText);
                llRoot.setPadding(this.pxToDp(10), this.pxToDp(8), 0, this.pxToDp(1));
                tvUserName.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                tvMsg.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
            } else if (position != 0 && position + 1 != this.items.size() && (nextViewType != 1 || nextViewType != 20 || nextViewType != -1)) {
                tvUserName.setVisibility(8);
                llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                llRoot.setPadding(this.pxToDp(17), this.pxToDp(1), this.pxToDp(0), this.pxToDp(2));
                tvUserName.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                tvMsg.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
            } else {
                tvUserName.setVisibility(8);
                llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                llRoot.setPadding(this.pxToDp(17), this.pxToDp(1), 0, this.pxToDp(1));
                tvUserName.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                tvMsg.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
            }
        } else if (position != 0 && position + 1 != this.items.size() && (nextViewType == 1 || nextViewType == 20 || nextViewType == -1)) {
            tvUserName.setVisibility(0);
            tvUserName.setText((CharSequence)userNameText);
            llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            llRoot.setPadding(this.pxToDp(10), this.pxToDp(4), this.pxToDp(0), this.pxToDp(1));
            tvUserName.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
            tvMsg.setPadding(this.pxToDp(15), this.pxToDp(0), this.pxToDp(2), this.pxToDp(7));
        } else {
            tvUserName.setVisibility(0);
            tvUserName.setText((CharSequence)userNameText);
            llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            llRoot.setPadding(this.pxToDp(10), this.pxToDp(4), 0, this.pxToDp(2));
            tvUserName.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
            tvMsg.setPadding(this.pxToDp(15), this.pxToDp(0), this.pxToDp(2), this.pxToDp(7));
        }
        NinePatchDrawable drawable2 = (NinePatchDrawable)llChatLeft.getBackground();
        drawable2.setColorFilter(this.hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
    }

    private void setMargins(View view, int left, int top, int right, int bottom) {
        if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            p.setMargins(left, top, right, bottom);
            view.requestLayout();
        }
    }

    private int pxToDp(int dpParam) {
        int dpValue = dpParam;
        float d = this.context.getResources().getDisplayMetrics().density;
        return (int)((float)dpValue * d);
    }

    public int getItemViewType(int position) {
        return this.items.get(position).getType();
    }

    public int getItemCount() {
        return this.items.size();
    }

    private void setIntegrationSource(ImageView source, ImageView messenger, int type) {
        source.setVisibility(8);
        messenger.setVisibility(8);
        int color2 = this.hippoColorConfig.getHippoSourceType();
        switch (type) {
            case 5: {
                source.setImageResource(R.drawable.hippo_ic_email);
                source.setVisibility(0);
                source.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_IN));
                break;
            }
            case 6: {
                messenger.setVisibility(0);
                break;
            }
            case 7: {
                source.setImageResource(R.drawable.hippo_ic_sms);
                source.setVisibility(0);
                source.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_IN));
                break;
            }
            default: {
                source.setVisibility(8);
                messenger.setVisibility(8);
            }
        }
    }

    private void showImageDialog(Context activity, String imgUrl, ImageView imageView, Message message) {
        try {
            if (!Utils.preventMultipleClicks()) {
                return;
            }
            Intent imageIntent = new Intent((Context)this.context, ImageDisplayActivity.class);
            Image image = new Image(message.getImageUrl(), message.getThumbnailUrl(), message.getMuid(), message.getSentAtUtc(), "");
            imageIntent.putExtra("image", (Serializable)image);
            activity.startActivity(imageIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTimeView(TextView tvMsg, RelativeLayout rlMessages, View time, int itemType, Message message, int position) {
        Object vTime = itemType == 1 ? (TextView)time : (LinearLayout)time;
        int lineCount = 0;
        int difference = 0;
        lineCount = tvMsg.getLineCount();
        if (lineCount != 0) {
            difference = tvMsg.getLayout().getLineStart(lineCount) - tvMsg.getLayout().getLineStart(lineCount - 1);
        }
        String completeString = tvMsg.getText().toString();
        boolean lineCountGreater = lineCount > 1;
        String stringInLastLine = lineCountGreater ? completeString.substring(tvMsg.getText().toString().length() - difference, tvMsg.getText().toString().length()) : tvMsg.getText().toString();
        float emptySpaceLeft = (float)rlMessages.getMeasuredWidth() - tvMsg.getPaint().measureText(stringInLastLine);
        RelativeLayout.LayoutParams layout2 = (RelativeLayout.LayoutParams)vTime.getLayoutParams();
        if (emptySpaceLeft > (float)this.context.getResources().getDimensionPixelSize(R.dimen.height_ll_time)) {
            if (lineCountGreater) {
                layout2.addRule(11);
                layout2.addRule(1, -1);
                message.setTimeIndex(2);
            } else {
                layout2.addRule(11, 0);
                layout2.addRule(1, tvMsg.getId());
                message.setTimeIndex(3);
            }
            layout2.addRule(3, -1);
            layout2.addRule(8, tvMsg.getId());
        } else if (!tvMsg.getText().toString().contains("/n")) {
            layout2.addRule(8, -1);
            layout2.addRule(1, -1);
            layout2.addRule(3, tvMsg.getId());
            layout2.addRule(11);
            message.setTimeIndex(1);
        }
        vTime.setLayoutParams((ViewGroup.LayoutParams)layout2);
    }

    private String convertSeconds(int seconds) {
        int h = seconds / 3600;
        int m = seconds % 3600 / 60;
        int s = seconds % 60;
        String sh = h > 0 ? String.valueOf(h) + " h" : "";
        String sm = (m < 10 && m > 0 && h > 0 ? "0" : "") + (m > 0 ? (h > 0 && s == 0 ? String.valueOf(m) : String.valueOf(m) + " min") : "");
        String ss = s == 0 && (h > 0 || m > 0) ? "" : (s < 10 && (h > 0 || m > 0) ? "0" : "") + String.valueOf(s) + " sec";
        return sh + (h > 0 ? " " : "") + sm + (m > 0 ? " " : "") + ss;
    }

    private String getMessage(Message videoMessage, int userType) {
        String message = "The video call ended";
        String agentType = "you";
        if (userType == 18) {
            if (videoMessage.getUserId().intValue() != AgentCommonData.getUserData().getUserId().intValue()) {
                agentType = videoMessage.getfromName();
            }
            message = videoMessage.getMessageState() != null && videoMessage.getMessageState() == 2 ? (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? this.customerName + " missed a voice call with " + agentType : this.customerName + " missed a video call with " + agentType) : (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? "The voice call ended" : "The video call ended");
        } else {
            agentType = "You";
            if (!this.isChatAssignToMe) {
                agentType = this.agentName;
            }
            message = videoMessage.getMessageState() != null && videoMessage.getMessageState() == 2 ? (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? agentType + " missed a voice call with " + videoMessage.getfromName() : agentType + " missed a video call with " + videoMessage.getfromName()) : (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? "The voice call ended" : "The video call ended");
        }
        return message;
    }

    private void setTime(AppCompatTextView tvImageTime, String sentAtUtc) {
        tvImageTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(sentAtUtc)));
    }

    private void showImageView(ImageView imageView, Message message) {
        String fname = Util.getFileName(message.getFileName(), message.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(FuguAppConstant.DocumentType.IMAGE.toString()));
        HippoLog.e("localPath", "localPath = " + localPath);
        RequestOptions myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.context, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder));
        Glide.with((FragmentActivity)this.context).load(TextUtils.isEmpty((CharSequence)localPath) ? message.getThumbnailUrl() : new File(localPath)).apply((BaseRequestOptions)myOptions).into(imageView);
    }

    private void setMessageStatus(AppCompatImageView ivMessageState, int messageStatus, Boolean isImage) {
        if (isImage.booleanValue()) {
            switch (messageStatus) {
                case 1: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single_white));
                    break;
                }
                case 4: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting_white));
                    break;
                }
                case 2: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_double));
                    break;
                }
                case 3: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_double));
                    break;
                }
                case 6: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting_white));
                    break;
                }
                case 5: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting_white));
                    break;
                }
            }
        } else {
            switch (messageStatus) {
                case 1: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                    break;
                }
                case 4: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                    break;
                }
                case 2: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_double));
                    break;
                }
                case 3: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_double));
                    break;
                }
                case 6: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                    break;
                }
                case 5: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                    break;
                }
            }
        }
    }

    private void setImageHeightAndWidth(ImageView imageView, RelativeLayout rlImageMessage, LinearLayoutCompat llImageMessage, Message message, Boolean isSpiked) {
        int imageHeight = message.getImageHeight();
        int imageWidth = message.getImageWidth();
        if (imageHeight != 0 && message.getImageWidth() != 0) {
            float ratio = imageHeight / imageWidth;
            if (ratio < 1.0f) {
                rlImageMessage.getLayoutParams().height = (int)((float)this.pxToDp(250) * ratio);
                rlImageMessage.getLayoutParams().width = this.pxToDp(250);
                llImageMessage.getLayoutParams().width = isSpiked.booleanValue() ? this.pxToDp(255) : this.pxToDp(252);
            } else {
                rlImageMessage.getLayoutParams().height = this.pxToDp(250);
                rlImageMessage.getLayoutParams().width = this.pxToDp(250);
                llImageMessage.getLayoutParams().width = isSpiked.booleanValue() ? this.pxToDp(255) : this.pxToDp(252);
            }
        } else {
            rlImageMessage.getLayoutParams().height = this.pxToDp(250);
            rlImageMessage.getLayoutParams().width = this.pxToDp(250);
            llImageMessage.getLayoutParams().width = isSpiked != false ? this.pxToDp(255) : this.pxToDp(252);
        }
    }

    private void setVideoDownloadStatus(LinearLayout videoDownloadStatus, ImageView playBtn, TextView fileSize, ProgressWheel progressBar, Message message, int position) {
        String fname = Util.getFileName(message.getFileName(), message.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(message.getDocumentType()));
        videoDownloadStatus.setVisibility(8);
        progressBar.setVisibility(8);
        playBtn.setVisibility(8);
        if (!(TextUtils.isEmpty((CharSequence)localPath) || message.getMessageStatus() != 3 && message.getMessageStatus() != 2 && message.getMessageStatus() != 1)) {
            playBtn.setVisibility(0);
        } else {
            switch (message.getDownloadStatus()) {
                case 1: {
                    progressBar.setVisibility(0);
                    break;
                }
                case 3: {
                    playBtn.setVisibility(0);
                    break;
                }
                default: {
                    videoDownloadStatus.setVisibility(0);
                    fileSize.setText((CharSequence)message.getFileSize());
                }
            }
        }
    }

    private void setVideoUiStatus(boolean isSelf, Message message, LinearLayout download, ImageView playBtn, AppCompatButton btnRetry, AppCompatButton btnCancel, ProgressWheel progress) {
        if (isSelf) {
            download.setVisibility(8);
            playBtn.setVisibility(8);
            btnRetry.setVisibility(8);
            btnCancel.setVisibility(8);
            progress.setVisibility(8);
            if (message.getMessageStatus() == 3 || message.getMessageStatus() == 2 || message.getMessageStatus() == 1) {
                String fname = Util.getFileName(message.getFileName(), message.getMuid());
                String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(message.getDocumentType()));
                if (TextUtils.isEmpty((CharSequence)localPath)) {
                    download.setVisibility(0);
                } else {
                    playBtn.setVisibility(0);
                }
            } else if (message.getUploadStatus() == 1) {
                progress.setVisibility(0);
            } else if (message.getIsMessageExpired() == 1) {
                btnRetry.setVisibility(0);
                btnCancel.setVisibility(0);
            }
        }
    }

    private void setVideoUploadStatus(AppCompatTextView tvImageTime, ProgressWheel circleProgress, AppCompatButton fuguBtnRetry, ImageView ivPlay, Message currentOrderItem2, ImageView ivDownload) {
        switch (currentOrderItem2.getUploadStatus()) {
            case 0: {
                if (currentOrderItem2.getMessageStatus() == 3 || currentOrderItem2.getMessageStatus() == 2 || currentOrderItem2.getMessageStatus() == 1) {
                    circleProgress.setVisibility(8);
                    fuguBtnRetry.setVisibility(8);
                    ivPlay.setVisibility(0);
                    break;
                }
                fuguBtnRetry.setVisibility(0);
                circleProgress.setVisibility(8);
                ivPlay.setVisibility(8);
                break;
            }
            case 1: {
                circleProgress.setVisibility(0);
                fuguBtnRetry.setVisibility(8);
                ivPlay.setVisibility(8);
                break;
            }
            case 3: {
                circleProgress.setVisibility(8);
                fuguBtnRetry.setVisibility(8);
                if (currentOrderItem2.getMessageStatus() == 3 || currentOrderItem2.getMessageStatus() == 2 || currentOrderItem2.getMessageStatus() == 1) {
                    ivPlay.setVisibility(0);
                    break;
                }
                ivPlay.setVisibility(8);
                break;
            }
            default: {
                tvImageTime.append((CharSequence)"10");
                circleProgress.setVisibility(8);
                fuguBtnRetry.setVisibility(8);
                if (currentOrderItem2.getMessageStatus() == 3 || currentOrderItem2.getMessageStatus() == 2 || currentOrderItem2.getMessageStatus() == 1) {
                    ivPlay.setVisibility(0);
                    break;
                }
                ivPlay.setVisibility(8);
            }
        }
        if (currentOrderItem2.getIsMessageExpired() == 1) {
            fuguBtnRetry.setVisibility(0);
        } else if (currentOrderItem2.getMessageStatus() == 3 || currentOrderItem2.getMessageStatus() == 2 || currentOrderItem2.getMessageStatus() == 1) {
            circleProgress.setVisibility(8);
            fuguBtnRetry.setVisibility(8);
            ivPlay.setVisibility(0);
            String fname = Util.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
            String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(FuguAppConstant.DocumentType.VIDEO.toString()));
            if (TextUtils.isEmpty((CharSequence)localPath)) {
                ivDownload.setVisibility(0);
                ivPlay.setVisibility(8);
            }
        }
    }

    private void setFileCLickListener(LinearLayoutCompat llFile, final Message message, final AppCompatImageView ivFilePlay, final int position) {
        ivFilePlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FuguAgentMessageAdapter.this.onPlaySound(message, ivFilePlay, position);
            }
        });
        llFile.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                block4: {
                    try {
                        if (message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                            return;
                        }
                        String fname = Util.getFileName(message.getFileName(), message.getMuid());
                        String localPath = FileManager.getInstance().getLocalPath(fname, FuguAppConstant.FOLDER_TYPE.get(message.getDocumentType()));
                        if (!TextUtils.isEmpty((CharSequence)localPath)) {
                            FileManager.getInstance().openFileInDevice((Context)FuguAgentMessageAdapter.this.context, localPath, new FileManager.FileCopyListener(){

                                @Override
                                public void onCopingFile(boolean flag, FileuploadModel fileuploadModel) {
                                }

                                @Override
                                public void largeFileSize() {
                                }

                                @Override
                                public void onError() {
                                    Toast.makeText((Context)FuguAgentMessageAdapter.this.context, (CharSequence)FuguAgentMessageAdapter.this.context.getString(R.string.no_handler), (int)1).show();
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (!HippoConfig.DEBUG) break block4;
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void setFileDownLoadStatus(ImageView fileView, final AppCompatImageView ivFilePlay, ProgressWheel circleProgress, AppCompatImageView ivFileDownload, AppCompatImageView ivFileUpload, final Message currentOrderItem2, final int position) {
        ivFileDownload.setVisibility(8);
        circleProgress.setVisibility(8);
        ivFileUpload.setVisibility(8);
        ivFilePlay.setVisibility(8);
        String fname = Util.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
        HippoLog.v("localPath", "localPath ********* = " + localPath);
        if (!TextUtils.isEmpty((CharSequence)localPath)) {
            if (currentOrderItem2.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                ivFilePlay.setVisibility(0);
            }
        } else {
            switch (currentOrderItem2.getDownloadStatus()) {
                case 1: {
                    circleProgress.setVisibility(0);
                    break;
                }
                case 3: {
                    if (!currentOrderItem2.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) break;
                    ivFilePlay.setVisibility(0);
                    break;
                }
                default: {
                    ivFileDownload.setVisibility(0);
                }
            }
        }
        ivFilePlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FuguAgentMessageAdapter.this.onPlaySound(currentOrderItem2, ivFilePlay, position);
            }
        });
    }

    private void setFileUploadStatus(ImageView fileView, final AppCompatImageView ivFilePlay, ProgressWheel circleProgress, AppCompatImageView ivFileDownload, AppCompatImageView ivFileUpload, final Message currentOrderItem2, final int position) {
        block10: {
            block11: {
                block9: {
                    ivFileDownload.setVisibility(8);
                    circleProgress.setVisibility(8);
                    ivFileUpload.setVisibility(8);
                    ivFilePlay.setVisibility(8);
                    if (currentOrderItem2.getIsMessageExpired() != 1) break block9;
                    ivFileUpload.setVisibility(0);
                    break block10;
                }
                if (currentOrderItem2.getMessageStatus() != 4) break block11;
                switch (currentOrderItem2.getUploadStatus()) {
                    case 0: {
                        ivFileUpload.setVisibility(0);
                        break;
                    }
                    case 1: {
                        circleProgress.setVisibility(0);
                        break;
                    }
                    case 3: {
                        if (currentOrderItem2.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                            ivFilePlay.setVisibility(0);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block10;
            }
            String fname = Util.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
            String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
            HippoLog.v("localPath", "localPath ********* = " + currentOrderItem2.getFileName());
            if (!TextUtils.isEmpty((CharSequence)localPath)) {
                if (currentOrderItem2.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                    ivFilePlay.setVisibility(0);
                }
            } else {
                ivFileDownload.setVisibility(0);
            }
        }
        ivFilePlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FuguAgentMessageAdapter.this.onPlaySound(currentOrderItem2, ivFilePlay, position);
            }
        });
    }

    private void onPlaySound(final Message currentOrderItem2, final AppCompatImageView ivFilePlay, final int position) {
        if (!TextUtils.isEmpty((CharSequence)this.context.audioMuid)) {
            if (this.context.audioMuid.equalsIgnoreCase(currentOrderItem2.getMuid())) {
                this.context.audioMuid = "";
                currentOrderItem2.setAudioPlaying(false);
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                CommonMediaPlayer.getInstance().stopMedia();
                this.notifyItemChanged(position);
                return;
            }
            ListItem listItem = this.items.get(this.context.playingItem);
            ((EventItem)listItem).getEvent().setAudioPlaying(false);
            this.notifyItemChanged(this.context.playingItem);
        }
        String fname = Util.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
        CommonMediaPlayer.getInstance().playMediaPlayer((Context)this.context, localPath, new CommonMediaPlayer.MediaPlayerStatus(){

            @Override
            public void onPlaying() {
                currentOrderItem2.setAudioPlaying(true);
                ((FuguAgentMessageAdapter)FuguAgentMessageAdapter.this).context.audioMuid = currentOrderItem2.getMuid();
                ((FuguAgentMessageAdapter)FuguAgentMessageAdapter.this).context.playingItem = position;
                ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                currentOrderItem2.setAudioPlaying(true);
                FuguAgentMessageAdapter.this.notifyItemChanged(position);
            }

            @Override
            public void onCompletion(MediaPlayer mp) {
                ((FuguAgentMessageAdapter)FuguAgentMessageAdapter.this).context.audioMuid = "";
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                currentOrderItem2.setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
                FuguAgentMessageAdapter.this.notifyItemChanged(position);
            }

            @Override
            public void onError(MediaPlayer mp, int what, int extra) {
                ((FuguAgentMessageAdapter)FuguAgentMessageAdapter.this).context.audioMuid = "";
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                currentOrderItem2.setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
                FuguAgentMessageAdapter.this.notifyItemChanged(position);
            }
        });
    }

    private void setDownloadClick(final AppCompatImageView ivFileDownload, final ProgressWheel circleProgress, final Message message, final int position) {
        if (!this.context.isNetworkAvailable()) {
            return;
        }
        ivFileDownload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String fileName;
                if (!FuguAgentMessageAdapter.this.context.checkPermission()) {
                    FuguAgentMessageAdapter.this.context.readExternalStorage();
                    return;
                }
                circleProgress.setVisibility(0);
                ivFileDownload.setVisibility(8);
                String docType = "image";
                if (message.getMessageType() == 11) {
                    docType = message.getDocumentType();
                }
                if (TextUtils.isEmpty((CharSequence)(fileName = message.getFileName()))) {
                    String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                    fileName = "Hippochat_" + timeStamp + ".jpg";
                }
                String fullPath = Util.getOrCreateDirectoryPath(FuguAppConstant.FOLDER_TYPE.get(docType));
                int downloadId = FuguAgentMessageAdapter.this.downloadFileFromUrl(fullPath, fileName, message, position);
                message.setDownloadId(downloadId);
            }
        });
    }

    private int downloadFileFromUrl(String dirPath, String fileName, final Message message, final int position) {
        if (!fileName.contains(message.getMuid())) {
            String muid = message.getMuid();
            String ext = Util.getExtension(fileName);
            String name = Util.extractFileNameWithoutSuffix(fileName);
            fileName = name + "_" + muid + "." + ext;
        }
        this.currentProgress = -1;
        return PRDownloader.download((String)message.getFileUrl(), (String)dirPath, (String)fileName).build().setOnStartOrResumeListener(new OnStartOrResumeListener(){

            public void onStartOrResume() {
                HippoLog.v(TAG, "OnStartOrResumeListener");
            }
        }).setOnPauseListener(new OnPauseListener(){

            public void onPause() {
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_PAUSED.downloadStatus);
            }
        }).setOnProgressListener(new OnProgressListener(){

            public void onProgress(Progress progress) {
                int cProgress = (int)(progress.currentBytes * 100L / progress.totalBytes);
                if (FuguAgentMessageAdapter.this.currentProgress < cProgress) {
                    ++FuguAgentMessageAdapter.this.currentProgress;
                }
                message.setCurrentprogress(cProgress);
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_IN_PROGRESS.downloadStatus);
            }
        }).start(new OnDownloadListener(){

            public void onDownloadComplete() {
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus);
                Intent mIntent = FuguAgentMessageAdapter.this.getIntentExtraData(position, 100, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus);
                LocalBroadcastManager.getInstance((Context)FuguAgentMessageAdapter.this.context).sendBroadcast(mIntent);
            }

            public void onError(Error error) {
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_FAILED.downloadStatus);
                Intent mIntent = FuguAgentMessageAdapter.this.getIntentExtraData(position, 0, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_FAILED.downloadStatus);
                LocalBroadcastManager.getInstance((Context)FuguAgentMessageAdapter.this.context).sendBroadcast(mIntent);
            }
        });
    }

    private Intent getIntentExtraData(int position, int progress, String muid, int status) {
        Intent mIntent = new Intent("hippo_progress_intent");
        mIntent.putExtra("hippo_position", position);
        mIntent.putExtra("hippo_progress", progress);
        mIntent.putExtra("muid", muid);
        mIntent.putExtra("hippo_statusUpload", status);
        return mIntent;
    }

    private void messageStatusTick(Activity activity, ImageView fuguIvMessageState, Message currentOrderItem2) {
        switch (currentOrderItem2.getMessageStatus()) {
            case 4: 
            case 5: 
            case 6: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.fugu_ic_waiting));
                fuguIvMessageState.setVisibility(0);
                fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            }
            case 3: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.fugu_tick_double));
                fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoMessageRead(), PorterDuff.Mode.SRC_ATOP);
                fuguIvMessageState.setVisibility(0);
                break;
            }
            case 1: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.fugu_tick_single));
                fuguIvMessageState.setVisibility(0);
                fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            }
            case 2: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.fugu_tick_double));
                if (Build.VERSION.SDK_INT >= 21) {
                    fuguIvMessageState.getDrawable().setTint(ContextCompat.getColor((Context)activity, (int)R.color.fugu_drawable_color));
                }
                fuguIvMessageState.setVisibility(0);
                fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            }
            default: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.fugu_tick_single));
                fuguIvMessageState.setVisibility(0);
                fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
            }
        }
    }

    private void setUploadClick(AppCompatImageView ivFileUpload, ProgressWheel circleProgress, Message message) {
        ivFileUpload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!FuguAgentMessageAdapter.this.context.isNetworkAvailable() || FuguAgentMessageAdapter.this.mOnRetry != null) {
                    // empty if block
                }
            }
        });
    }

    private boolean setOtherMessageBackground(View viewMessage, View viewBg, int position, TextView viewUsername) {
        int oneDp = this.pxToDp(1);
        int sixDp = this.pxToDp(6);
        int sevenDp = this.pxToDp(7);
        int eight = this.pxToDp(8);
        if (this.items.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            viewMessage.setPadding(eight, sevenDp, 0, oneDp);
            viewBg.setPadding(this.pxToDp(13), sixDp, sixDp, sixDp);
            return true;
        }
        if (position == 0) {
            viewMessage.setPadding(eight, sevenDp, 0, oneDp);
            viewBg.setPadding(this.pxToDp(13), sixDp, sixDp, sixDp);
            if (viewUsername != null) {
                viewUsername.setPadding(eight, 0, 0, 0);
            }
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            return true;
        }
        if (this.getItemViewType(position - 1) == 1 || this.getItemViewType(position - 1) == 19 || this.getItemViewType(position - 1) == 13) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
            if (viewUsername != null) {
                viewUsername.setVisibility(8);
            }
            viewMessage.setPadding(this.pxToDp(15), oneDp, 0, oneDp);
            viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
            return false;
        }
        viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
        viewMessage.setPadding(eight, sevenDp, 0, oneDp);
        viewBg.setPadding(this.pxToDp(13), sixDp, sixDp, sixDp);
        return true;
    }

    private boolean setSelfMessageBackground(View viewMessage, View viewBg, int position) {
        int oneDp = this.pxToDp(1);
        int sixDp = this.pxToDp(6);
        int sevenDp = this.pxToDp(7);
        if (this.items.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            viewMessage.setPadding(0, sixDp, sevenDp, oneDp);
            viewBg.setPadding(sixDp, sixDp, this.pxToDp(17), sixDp);
            return true;
        }
        if (position == 0) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            viewMessage.setPadding(0, sixDp, this.pxToDp(7), sevenDp);
            viewBg.setPadding(sixDp, sixDp, this.pxToDp(17), sixDp);
            return true;
        }
        if (this.getItemViewType(position - 1) == 2 || this.getItemViewType(position - 1) == 18 || this.getItemViewType(position - 1) == 10 || this.getItemViewType(position - 1) == 12) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
            viewMessage.setPadding(0, oneDp, this.pxToDp(15), oneDp);
            viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
            return false;
        }
        viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right);
        viewMessage.setPadding(0, sixDp, sevenDp, oneDp);
        viewBg.setPadding(sixDp, sixDp, this.pxToDp(17), sixDp);
        return true;
    }

    private boolean setFileMessageOther(View viewMessage, View viewBg, int position, TextView userName, String name) {
        int oneDp = this.pxToDp(1);
        int sixDp = this.pxToDp(6);
        int sevenDp = this.pxToDp(7);
        int eightDp = this.pxToDp(8);
        if (this.items.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
            viewBg.setPadding(this.pxToDp(13), sixDp, sixDp, sixDp);
            if (userName != null) {
                userName.setVisibility(0);
                userName.setText((CharSequence)name);
            } else if (TextUtils.isEmpty((CharSequence)name)) {
                userName.setVisibility(8);
            }
            return true;
        }
        if (position == 0) {
            viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
            viewBg.setPadding(this.pxToDp(13), sixDp, sixDp, sixDp);
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            if (userName != null) {
                userName.setVisibility(0);
                userName.setText((CharSequence)name);
            } else if (TextUtils.isEmpty((CharSequence)name)) {
                userName.setVisibility(8);
            }
            return true;
        }
        if (this.getItemViewType(position - 1) == 1 || this.getItemViewType(position - 1) == 19 || this.getItemViewType(position - 1) == 13 || this.getItemViewType(position - 1) == 11) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
            viewMessage.setPadding(this.pxToDp(15), oneDp, 0, oneDp);
            viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
            if (userName != null) {
                userName.setVisibility(8);
            }
            return true;
        }
        viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
        viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
        viewBg.setPadding(this.pxToDp(13), sixDp, sixDp, sixDp);
        if (userName != null) {
            userName.setVisibility(0);
            userName.setText((CharSequence)name);
        } else if (TextUtils.isEmpty((CharSequence)name)) {
            userName.setVisibility(8);
        }
        return true;
    }

    private void setImage(Activity activity, AppCompatImageView ivImageMessage, String thumbnailUrl) {
        try {
            HippoLog.e(TAG, "thumbnailUrl = " + thumbnailUrl);
            RequestOptions myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)activity, 7, 2)).placeholder(ContextCompat.getDrawable((Context)activity, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)activity, (int)R.drawable.hippo_placeholder));
            Glide.with((Activity)activity).load(thumbnailUrl).apply((BaseRequestOptions)myOptions).into((ImageView)ivImageMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class DateViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvDate;

        public DateViewHolder(View itemView) {
            super(itemView);
            this.tvDate = (TextView)itemView.findViewById(R.id.tvDate);
        }
    }

    class AssignmentViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvAssignment;

        public AssignmentViewHolder(View itemView) {
            super(itemView);
            this.tvAssignment = (TextView)itemView.findViewById(R.id.tvAssignment);
        }
    }

    class OtherVideoMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llImageMessage;
        private LinearLayout llDownload;
        private TextView tvUserName;
        private TextView tvFileSize;
        private RelativeLayout rlImageMessage;
        private AppCompatImageView ivImageMsg;
        private AppCompatTextView tvImageTime;
        private AppCompatTextView tvImgWithText;
        private ImageView ivPlay;
        private ImageView ivDownload;
        private ProgressWheel progressBar;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;
        private ImageView userImage;

        public OtherVideoMessageViewHolder(final View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            this.llRoot = (LinearLayoutCompat)itemView.findViewById(R.id.llRoot);
            this.llImageMessage = (LinearLayoutCompat)itemView.findViewById(R.id.llImageMessage);
            this.llDownload = (LinearLayout)itemView.findViewById(R.id.llDownload);
            this.rlImageMessage = (RelativeLayout)itemView.findViewById(R.id.rlImageMessage);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.ivImageMsg = (AppCompatImageView)itemView.findViewById(R.id.ivImageMsg);
            this.tvImageTime = (AppCompatTextView)itemView.findViewById(R.id.tvImageTime);
            this.tvImgWithText = (AppCompatTextView)itemView.findViewById(R.id.tvImgWithText);
            this.ivPlay = (ImageView)itemView.findViewById(R.id.ivPlay);
            this.ivDownload = (ImageView)itemView.findViewById(R.id.ivDownload);
            this.progressBar = (ProgressWheel)itemView.findViewById(R.id.circle_progress);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
            this.ivPlay.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    itemClickListener.onItemClick((View)OtherVideoMessageViewHolder.this.llRoot, itemView, OtherVideoMessageViewHolder.this.getAdapterPosition());
                }
            });
        }
    }

    class SelfVideoMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout llDownload;
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llImageMessage;
        private RelativeLayout rlImageMessage;
        private AppCompatImageView ivImageMsg;
        private AppCompatImageView ivMessageState;
        private ImageView ivPlay;
        private ImageView ivDownload;
        private AppCompatTextView tvImageTime;
        private TextView tvFileSize;
        private TextView tvImgWithText;
        private AppCompatButton btnRetry;
        private AppCompatButton btnCancel;
        private ProgressWheel circle_progress;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;

        public SelfVideoMessageViewHolder(View itemView) {
            super(itemView);
            this.llRoot = (LinearLayoutCompat)itemView.findViewById(R.id.llRoot);
            this.llImageMessage = (LinearLayoutCompat)itemView.findViewById(R.id.llImageMessage);
            this.llDownload = (LinearLayout)itemView.findViewById(R.id.llDownload);
            this.rlImageMessage = (RelativeLayout)itemView.findViewById(R.id.rlImageMessage);
            this.ivImageMsg = (AppCompatImageView)itemView.findViewById(R.id.ivImageMsg);
            this.ivPlay = (ImageView)itemView.findViewById(R.id.ivPlay);
            this.ivDownload = (ImageView)itemView.findViewById(R.id.ivDownload);
            this.ivMessageState = (AppCompatImageView)itemView.findViewById(R.id.ivMessageState);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.tvImageTime = (AppCompatTextView)itemView.findViewById(R.id.tvImageTime);
            this.tvImgWithText = (TextView)itemView.findViewById(R.id.tvImgWithText);
            this.circle_progress = (ProgressWheel)itemView.findViewById(R.id.circle_progress);
            this.btnRetry = (AppCompatButton)itemView.findViewById(R.id.btnRetry);
            this.btnCancel = (AppCompatButton)itemView.findViewById(R.id.btnCancel);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
        }
    }

    class SentFileViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llMessage;
        private LinearLayoutCompat llImages;
        private TextView tvFileName;
        private TextView tvFileSize;
        private TextView tvFileExtension;
        private TextView tvFileTime;
        private AppCompatImageView ivFilePlay;
        private AppCompatImageView ivFileDownload;
        private AppCompatImageView ivFileUpload;
        private ImageView ivFileImage;
        private ImageView ivMessageState;
        private ProgressWheel circleProgress;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;

        public SentFileViewHolder(View itemView) {
            super(itemView);
            this.llRoot = (LinearLayoutCompat)itemView.findViewById(R.id.llRoot);
            this.llMessage = (LinearLayoutCompat)itemView.findViewById(R.id.llMessage);
            this.llImages = (LinearLayoutCompat)itemView.findViewById(R.id.llImages);
            this.tvFileName = (TextView)itemView.findViewById(R.id.tvFileName);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.tvFileExtension = (TextView)itemView.findViewById(R.id.tvFileExtension);
            this.tvFileTime = (TextView)itemView.findViewById(R.id.tvFileTime);
            this.ivFileImage = (ImageView)itemView.findViewById(R.id.ivFileImage);
            this.ivFilePlay = (AppCompatImageView)itemView.findViewById(R.id.ivFilePlay);
            this.ivFileDownload = (AppCompatImageView)itemView.findViewById(R.id.ivFileDownload);
            this.ivFileUpload = (AppCompatImageView)itemView.findViewById(R.id.ivFileUpload);
            this.ivMessageState = (ImageView)itemView.findViewById(R.id.ivMessageState);
            this.circleProgress = (ProgressWheel)itemView.findViewById(R.id.circle_progress);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
        }
    }

    class ReceivedFileViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llMessage;
        private LinearLayoutCompat llFile;
        private LinearLayoutCompat llImages;
        private TextView tvUserName;
        private TextView tvFileName;
        private TextView tvFileSize;
        private TextView tvFileExtension;
        private TextView tvFileTime;
        private ImageView ivFileImage;
        private AppCompatImageView ivFileDownload;
        private AppCompatImageView ivFilePlay;
        private AppCompatImageView ivFileUpload;
        private ProgressWheel progressBar;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;
        private ImageView userImage;

        public ReceivedFileViewHolder(View itemView) {
            super(itemView);
            this.llRoot = (LinearLayoutCompat)itemView.findViewById(R.id.llRoot);
            this.llMessage = (LinearLayoutCompat)itemView.findViewById(R.id.llMessage);
            this.llFile = (LinearLayoutCompat)itemView.findViewById(R.id.llFile);
            this.llImages = (LinearLayoutCompat)itemView.findViewById(R.id.llImages);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.tvFileName = (TextView)itemView.findViewById(R.id.tvFileName);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.tvFileExtension = (TextView)itemView.findViewById(R.id.tvFileExtension);
            this.tvFileTime = (TextView)itemView.findViewById(R.id.tvFileTime);
            this.ivFileImage = (ImageView)itemView.findViewById(R.id.ivFileImage);
            this.ivFilePlay = (AppCompatImageView)itemView.findViewById(R.id.ivFilePlay);
            this.ivFileDownload = (AppCompatImageView)itemView.findViewById(R.id.ivFileDownload);
            this.ivFileUpload = (AppCompatImageView)itemView.findViewById(R.id.ivFileUpload);
            this.progressBar = (ProgressWheel)itemView.findViewById(R.id.circle_progress);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
        }
    }

    class VideoViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvMsg;
        private TextView tvTime;
        private TextView callAgain;
        private TextView tvDuration;
        private ImageView ivCallIcon;
        private ImageView userImage;
        private LinearLayout llMessage;
        private LinearLayout llRoot;

        public VideoViewHolder(View itemView) {
            super(itemView);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.callAgain = (TextView)itemView.findViewById(R.id.callAgain);
            this.tvDuration = (TextView)itemView.findViewById(R.id.tvDuration);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
            this.ivCallIcon = (ImageView)itemView.findViewById(R.id.ivCallIcon);
            this.llMessage = (LinearLayout)itemView.findViewById(R.id.llMessage);
            this.llRoot = (LinearLayout)itemView.findViewById(R.id.llMessage);
        }
    }

    class SelfVideoViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvMsg;
        private TextView tvTime;
        private TextView callAgain;
        private TextView tvDuration;
        private ImageView ivCallIcon;

        public SelfVideoViewHolder(View itemView) {
            super(itemView);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.callAgain = (TextView)itemView.findViewById(R.id.callAgain);
            this.tvDuration = (TextView)itemView.findViewById(R.id.tvDuration);
            this.ivCallIcon = (ImageView)itemView.findViewById(R.id.ivCallIcon);
        }
    }

    class UserConcentViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout main_root;
        private LinearLayout llRootRight;
        private LinearLayout llChatRight;
        private LinearLayout llTimeRight;
        private RelativeLayout rlMessagesRight;
        private TextView tvNameRight;
        private TextView tvMsgRight;
        private TextView tvTimeRight;
        private ImageView ivMessageStateRight;
        private TagContainerLayout tagLayout;
        private TextView tvTagsTime;
        private LinearLayout llChatLeft;
        private LinearLayout llTime;
        private TextView tvUserName;
        private TextView tvMsg;
        private TextView tvTime;
        private LinearLayout leftrootview;

        public UserConcentViewHolder(View itemView) {
            super(itemView);
            this.main_root = (LinearLayout)itemView.findViewById(R.id.main_root);
            this.llRootRight = (LinearLayout)itemView.findViewById(R.id.llRootRight);
            this.llChatRight = (LinearLayout)itemView.findViewById(R.id.llChatRight);
            this.llTimeRight = (LinearLayout)itemView.findViewById(R.id.llTimeRight);
            this.rlMessagesRight = (RelativeLayout)itemView.findViewById(R.id.rlMessagesRight);
            this.tvNameRight = (TextView)itemView.findViewById(R.id.tvNameRight);
            this.tvMsgRight = (TextView)itemView.findViewById(R.id.tvMsgRight);
            this.tvTimeRight = (TextView)itemView.findViewById(R.id.tvTimeRight);
            this.ivMessageStateRight = (ImageView)itemView.findViewById(R.id.ivMessageStateRight);
            this.tagLayout = (TagContainerLayout)itemView.findViewById(R.id.tagLayout);
            this.tvTagsTime = (TextView)itemView.findViewById(R.id.tvTagsTime);
            this.llChatLeft = (LinearLayout)itemView.findViewById(R.id.llChatLeft);
            this.llTime = (LinearLayout)itemView.findViewById(R.id.llTime);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.leftrootview = (LinearLayout)itemView.findViewById(R.id.leftrootview);
        }
    }

    class SelfMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout llRoot;
        private LinearLayout llTime;
        private TextView tvMsg;
        private TextView tvTime;
        private TextView tvName;
        private RelativeLayout rlImageMessage;
        private RelativeLayout rlMessages;
        private LinearLayout llChat;
        private ImageView ivMessageState;
        private ImageView ivMsgImage;
        private ProgressBar pbLoading;
        private Button btnRetry;
        private Button btnCancel;
        private TextView tvTryAgain;
        private TextView tvCancel;
        private LinearLayout llRetry;
        private RelativeLayout rlCustomAction;
        private ImageView ivActionImage;
        private TextView tvActionTitle;
        private TextView tvActionTitleDescription;
        private RecyclerView rvActionDescription;
        private RecyclerView rvActionButtons;
        private View vwActionButtonDivider;
        private LinearLayout llTextualContent;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;

        public SelfMessageViewHolder(View itemView) {
            super(itemView);
            this.llRoot = (LinearLayout)itemView.findViewById(R.id.llRoot);
            this.llTime = (LinearLayout)itemView.findViewById(R.id.llTime);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvName = (TextView)itemView.findViewById(R.id.tvName);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.llChat = (LinearLayout)itemView.findViewById(R.id.llMessageBg);
            this.rlImageMessage = (RelativeLayout)itemView.findViewById(R.id.rlImageMessage);
            this.rlMessages = (RelativeLayout)itemView.findViewById(R.id.rlMessages);
            this.ivMessageState = (ImageView)itemView.findViewById(R.id.ivMessageState);
            this.ivMsgImage = (ImageView)itemView.findViewById(R.id.ivMsgImage);
            this.pbLoading = (ProgressBar)itemView.findViewById(R.id.pbLoading);
            this.btnRetry = (Button)itemView.findViewById(R.id.btnRetry);
            this.btnCancel = (Button)itemView.findViewById(R.id.btnCancel);
            this.tvTryAgain = (TextView)itemView.findViewById(R.id.tvTryAgain);
            this.tvCancel = (TextView)itemView.findViewById(R.id.tvCancel);
            this.llRetry = (LinearLayout)itemView.findViewById(R.id.llRetry);
            this.rlCustomAction = (RelativeLayout)itemView.findViewById(R.id.layoutCustomAction);
            this.tvActionTitle = (TextView)itemView.findViewById(R.id.tvActionTitle);
            this.rvActionDescription = (RecyclerView)itemView.findViewById(R.id.rvActionDescription);
            this.rvActionButtons = (RecyclerView)itemView.findViewById(R.id.rvActionButtons);
            this.ivActionImage = (ImageView)itemView.findViewById(R.id.ivActionImage);
            this.vwActionButtonDivider = itemView.findViewById(R.id.vwActionButtonDivider);
            this.tvActionTitleDescription = (TextView)itemView.findViewById(R.id.tvActionDescription);
            this.llTextualContent = (LinearLayout)itemView.findViewById(R.id.llTextualContent);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
        }
    }

    class OtherMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout llRoot;
        private LinearLayout llChatLeft;
        private TextView tvUserName;
        private TextView tvMsg;
        private TextView tvTime;
        private RelativeLayout rlImageMessage;
        private RelativeLayout rlMessages;
        private ImageView ivMsgImage;
        private RelativeLayout rlCustomAction;
        private ImageView ivActionImage;
        private TextView tvActionTitle;
        private TextView tvActionTitleDescription;
        private RecyclerView rvActionDescription;
        private RecyclerView rvActionButtons;
        private View vwActionButtonDivider;
        private LinearLayout llTextualContent;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;
        private ImageView userImage;

        public OtherMessageViewHolder(View itemView) {
            super(itemView);
            this.llRoot = (LinearLayout)itemView.findViewById(R.id.llRoot);
            this.llChatLeft = (LinearLayout)itemView.findViewById(R.id.llMessageBg);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.rlImageMessage = (RelativeLayout)itemView.findViewById(R.id.rlImageMessage);
            this.rlMessages = (RelativeLayout)itemView.findViewById(R.id.rlMessages);
            this.ivMsgImage = (ImageView)itemView.findViewById(R.id.ivMsgImage);
            this.rlCustomAction = (RelativeLayout)itemView.findViewById(R.id.layoutCustomAction);
            this.tvActionTitle = (TextView)itemView.findViewById(R.id.tvActionTitle);
            this.rvActionDescription = (RecyclerView)itemView.findViewById(R.id.rvActionDescription);
            this.rvActionButtons = (RecyclerView)itemView.findViewById(R.id.rvActionButtons);
            this.ivActionImage = (ImageView)itemView.findViewById(R.id.ivActionImage);
            this.vwActionButtonDivider = itemView.findViewById(R.id.vwActionButtonDivider);
            this.tvActionTitleDescription = (TextView)itemView.findViewById(R.id.tvActionDescription);
            this.llTextualContent = (LinearLayout)itemView.findViewById(R.id.llTextualContent);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
        }
    }

    public static interface OnRetryListener {
        public void onRetry(String var1, String var2, int var3, String var4);

        public void onMessageRetry(String var1, int var2);

        public void onMessageCancel(String var1, int var2);

        public void onFileMessageRetry(String var1, int var2);
    }
}

