package com.hippo.activity;

import android.os.Bundle;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.appcompat.widget.Toolbar;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.adapter.CustomerInitalAdapter;
import com.hippo.apis.ApiPutUserDetails;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.interfaces.CustomerInitalListener;
import com.hippo.model.Field;
import com.hippo.utils.HippoLog;
import com.hippo.utils.fileUpload.Prefs;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by gurmail on 14/02/19.
 *
 * @author gurmail
 */
public class CustomerInitalActivity extends FuguBaseActivity implements FuguAppConstant, CustomerInitalListener {

    private static final String TAG = CustomerInitalActivity.class.getSimpleName();
    private RecyclerView recyclerView;
    private CustomerInitalAdapter initalAdapter;
    private Toolbar myToolbar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.hippo_activity_customer_inital);

        myToolbar = findViewById(R.id.my_toolbar);
        setSupportActionBar(myToolbar);

        String title = "";
        try {
            title = CommonData.getUserDetails().getData().getCustomerInitialFormInfo().getPageTitle();
        } catch (Exception e) {

        }
        title = TextUtils.isEmpty(title) ? CommonData.getChatTitle() : title;
        setToolbar(myToolbar, title);

        recyclerView = findViewById(R.id.recyclerView);
        LinearLayoutManager layoutManager = new LinearLayoutManager(CustomerInitalActivity.this);
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);

        recyclerView.setLayoutManager(layoutManager);

        ArrayList<Object> objects = new ArrayList<>();

        objects.addAll(CommonData.getUserDetails().getData().getCustomerInitialFormInfo().getFields());
        objects.add(CommonData.getUserDetails().getData().getCustomerInitialFormInfo().getButton());

        initalAdapter = new CustomerInitalAdapter(objects, getSupportFragmentManager(), this);
        recyclerView.setAdapter(initalAdapter);
    }

    @Override
    public void onButtonClicked(ArrayList<Object> objects) {
        HippoLog.v(TAG, "objects >>>>>> "+new Gson().toJson(objects));

        HashMap<String, Object> objectHashMap = CommonData.getPutUserParams();
        for(Object object : objects) {
            if(object instanceof Field) {
                Field field = (Field) object;
                if(field.getType().toLowerCase().equalsIgnoreCase("LABEL")) {
                    //do nothing here.
                } else if(field.getType().toLowerCase().equalsIgnoreCase("contact_number")) {
                    objectHashMap.put(field.getKey(), field.getCountryCode()+field.getTextValue().trim());
                } else {
                    objectHashMap.put(field.getKey(), field.getTextValue().trim());
                    if(field.getKey().equalsIgnoreCase("full_name")) {
                        Prefs.with(this).save("form_full_name", field.getTextValue().trim());
                    }
                }
            }
        }

        String phnNumber = Prefs.with(this).getString("PHONE_NUMBER", "");
        if(!TextUtils.isEmpty(phnNumber)) {
            objectHashMap.put(PHONE_NUMBER, phnNumber);
            Prefs.with(this).save("PHONE_NUMBER", "");
        }

//        String name = (String) objectHashMap.get("full_name");
//        Prefs.with(this).save("form_full_name", name);

        new ApiPutUserDetails(CustomerInitalActivity.this, new ApiPutUserDetails.Callback() {
            @Override
            public void onSuccess() {

                openConversation();
            }

            @Override
            public void onFailure() {

            }
        }).updateUserData(objectHashMap);

    }

    @Override
    public void onNotifyAdapter(ArrayList<Object> objects) {
        HippoLog.v(TAG, "arrayList ******** "+new Gson().toJson(objects));

        if(initalAdapter != null) {
            initalAdapter = null;
            initalAdapter = new CustomerInitalAdapter(objects, getSupportFragmentManager(), this);
            recyclerView.setAdapter(initalAdapter);
        }
    }

    private void openConversation() {
        HippoConfig.getInstance().showConversations(CustomerInitalActivity.this, CommonData.getChatTitle());
        finish();
    }
}
