/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.payment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.RelativeLayout;
import androidx.appcompat.app.AlertDialog;
import com.hippo.R;
import com.hippo.payment.PaymentConstants;
import com.hippo.utils.HippoLog;
import com.hippo.utils.filepicker.activity.BaseActivity;

public class ProcessingPaymentWebViewActivity
extends BaseActivity
implements View.OnClickListener,
PaymentConstants {
    private WebView wvWebView;
    private String url = "";
    private long paymentMethod = 0L;
    private long paymentFor = 0L;

    @Override
    protected void permissionGranted() {
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hippo_web_view_activity);
        if (this.getIntent() != null) {
            this.url = this.getIntent().getStringExtra("url_webview");
            this.paymentMethod = this.getIntent().getLongExtra("VALUE_PAYMENT", 0L);
            this.paymentFor = this.getIntent().getLongExtra("paymentForFlow", 0L);
        }
        this.initViews();
        if (this.url != null) {
            HippoLog.e("URL", this.url + "");
            this.wvWebView.loadUrl(this.url);
        }
    }

    private void initViews() {
        this.wvWebView = (WebView)this.findViewById(R.id.wvWebsite);
        this.setWebViewProperties(this.wvWebView);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean ret = super.dispatchTouchEvent(event);
        View view = this.getCurrentFocus();
        try {
            if (view != null && view instanceof EditText) {
                View w = this.getCurrentFocus();
                int[] scrcoords = new int[2];
                assert (w != null);
                w.getLocationOnScreen(scrcoords);
                float x = event.getRawX() + (float)w.getLeft() - (float)scrcoords[0];
                float y = event.getRawY() + (float)w.getTop() - (float)scrcoords[1];
                if (event.getAction() == 1 && (x < (float)w.getLeft() || x >= (float)w.getRight() || y < (float)w.getTop() || y > (float)w.getBottom())) {
                    InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void setWebViewProperties(final WebView webView) {
        webView.setWebViewClient((WebViewClient)new MyWebViewClient());
        webView.setWebChromeClient(new WebChromeClient());
        webView.getSettings().setLoadsImagesAutomatically(true);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setScrollBarStyle(0);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportMultipleWindows(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webView.getSettings().setMixedContentMode(0);
        }
        webView.getSettings().setAllowFileAccessFromFileURLs(true);
        webView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        webView.getSettings().setAllowFileAccess(true);
        webView.getSettings().setAllowContentAccess(true);
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onCreateWindow(WebView view, boolean dialog, boolean userGesture, Message resultMsg) {
                WebView newView = new WebView((Context)ProcessingPaymentWebViewActivity.this);
                newView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
                if (ProcessingPaymentWebViewActivity.this.paymentMethod == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
                    webView.addView((View)newView);
                }
                if (ProcessingPaymentWebViewActivity.this.paymentMethod == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
                    ProcessingPaymentWebViewActivity.this.setWebViewProperties(newView);
                } else {
                    ProcessingPaymentWebViewActivity.this.setWebViewProperties(ProcessingPaymentWebViewActivity.this.wvWebView);
                }
                WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
                transport.setWebView(newView);
                resultMsg.sendToTarget();
                return true;
            }

            public void onCloseWindow(WebView window) {
                HippoLog.e("onCloseWindow", window + "");
                webView.removeView((View)window);
                super.onCloseWindow(window);
            }

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                HippoLog.e("URL onJsAlert", url + "");
                return super.onJsAlert(view, url, message, result);
            }
        });
    }

    public void onClick(View v) {
        v.getId();
    }

    public void onBackPressed() {
        Intent intent = new Intent();
        intent.putExtras(new Bundle());
        this.setResult(0, intent);
        this.finish();
    }

    private boolean onOverrideUrlLoading(WebView view, String url) {
        HippoLog.e("URL", url + "");
        UrlQuerySanitizer sanitizer = new UrlQuerySanitizer(url);
        String transactionId = "";
        String jobPaymentDetailId = "";
        if (this.paymentMethod == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
            transactionId = sanitizer.getValue("rzp_payment_id");
        } else if (this.paymentMethod == PaymentConstants.PaymentValue.BILLPLZ.intValue) {
            transactionId = sanitizer.getValue("billplz[id]");
            if (transactionId != null) {
                if (this.paymentFor != PaymentConstants.PaymentForFlow.ORDER_PAYMENT.intValue && this.paymentFor != PaymentConstants.PaymentForFlow.REPAY_FROM_TASK_DETAILS.intValue) {
                    Bundle extras = new Bundle();
                    extras.putString("tr_id", transactionId);
                    Intent intent = new Intent();
                    intent.putExtras(extras);
                    this.setResult(-1, intent);
                    this.finish();
                }
                return true;
            }
        } else if (this.paymentMethod == PaymentConstants.PaymentValue.PAYFORT.intValue) {
            transactionId = sanitizer.getValue("transactionId");
            jobPaymentDetailId = sanitizer.getValue("job_payment_detail_id");
        } else {
            transactionId = sanitizer.getValue("transactionId") != null ? sanitizer.getValue("transactionId") : sanitizer.getValue("transaction_id");
        }
        if (url.startsWith("http:") || url.startsWith("https:")) {
            view.loadUrl(url);
            if ((this.paymentMethod == PaymentConstants.PaymentValue.PAYMOB.intValue ? url.contains("success.html") || url.contains("Success.html") : url.contains("success") || url.contains("Success")) && transactionId != null && !transactionId.isEmpty()) {
                Bundle extras = new Bundle();
                extras.putString("tr_id", transactionId);
                Intent intent = new Intent();
                intent.putExtras(extras);
                this.setResult(-1, intent);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ProcessingPaymentWebViewActivity.this.finish();
                    }
                }, 1500L);
            } else if (this.paymentMethod == PaymentConstants.PaymentValue.PAYMOB.intValue ? url.contains("error.html") : url.contains("error")) {
                Bundle extras = new Bundle();
                if (transactionId != null && !transactionId.isEmpty()) {
                    extras.putString("tr_id", transactionId);
                }
                Intent intent = new Intent();
                intent.putExtras(extras);
                this.setResult(200, intent);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ProcessingPaymentWebViewActivity.this.finish();
                    }
                }, 1500L);
            }
        }
        return true;
    }

    private void showErrorDialog(String errorMessage) {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)errorMessage).setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
            }
        });
    }

    private class MyWebViewClient
    extends WebViewClient {
        private MyWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return ProcessingPaymentWebViewActivity.this.onOverrideUrlLoading(view, request.getUrl().toString());
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return ProcessingPaymentWebViewActivity.this.onOverrideUrlLoading(view, url);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
        }
    }
}

