/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.linkPreview;

import android.os.AsyncTask;
import com.hippo.utils.linkPreview.LinkPreviewCallback;
import com.hippo.utils.linkPreview.Regex;
import com.hippo.utils.linkPreview.SearchUrls;
import com.hippo.utils.linkPreview.SourceContent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class TextCrawler {
    public static final int ALL = -1;
    public static final int NONE = -2;
    private final String HTTP_PROTOCOL = "http://";
    private final String HTTPS_PROTOCOL = "https://";
    private LinkPreviewCallback callback;
    private AsyncTask getCodeTask;

    public void makePreview(LinkPreviewCallback callback, String url) {
        this.makePreview(callback, url, -1);
    }

    public void makePreview(LinkPreviewCallback callback, String url, int imageQuantity) {
        this.callback = callback;
        this.cancel();
        this.getCodeTask = new GetCode(imageQuantity).execute(new String[]{url});
    }

    public void cancel() {
        if (this.getCodeTask != null) {
            this.getCodeTask.cancel(true);
        }
    }

    private String getTagContent(String tag, String content) {
        String pattern = "<" + tag + "(.*?)>(.*?)</" + tag + ">";
        String result = "";
        String currentMatch = "";
        List<String> matches = Regex.pregMatchAll(content, pattern, 2);
        int matchesSize = matches.size();
        for (int i = 0; i < matchesSize && !this.getCodeTask.isCancelled(); ++i) {
            currentMatch = this.stripTags(matches.get(i));
            if (currentMatch.length() < 120) continue;
            result = TextCrawler.extendedTrim(currentMatch);
            break;
        }
        if (result.equals("")) {
            String matchFinal = Regex.pregMatch(content, pattern, 2);
            result = TextCrawler.extendedTrim(matchFinal);
        }
        result = result.replaceAll("&nbsp;", "");
        return this.htmlDecode(result);
    }

    public List<String> getImages(Document document, int imageQuantity) {
        List<String> matches = new ArrayList<String>();
        Elements media = document.select("[src]");
        for (Element srcElement : media) {
            if (this.getCodeTask.isCancelled()) break;
            if (!srcElement.tagName().equals("img")) continue;
            matches.add(srcElement.attr("abs:src"));
        }
        if (imageQuantity != -1) {
            matches = matches.subList(0, imageQuantity);
        }
        return matches;
    }

    private String htmlDecode(String content) {
        return Jsoup.parse((String)content).text();
    }

    private String crawlCode(String content) {
        String result = "";
        String resultSpan = "";
        String resultParagraph = "";
        String resultDiv = "";
        resultSpan = this.getTagContent("span", content);
        resultParagraph = this.getTagContent("p", content);
        resultDiv = this.getTagContent("div", content);
        result = resultSpan;
        result = resultParagraph.length() > resultSpan.length() && resultParagraph.length() >= resultDiv.length() ? resultParagraph : (resultParagraph.length() > resultSpan.length() && resultParagraph.length() < resultDiv.length() ? resultDiv : resultParagraph);
        return this.htmlDecode(result);
    }

    private String cannonicalPage(String url) {
        String cannonical = "";
        if (url.startsWith("http://")) {
            url = url.substring("http://".length());
        } else if (url.startsWith("https://")) {
            url = url.substring("https://".length());
        }
        int urlLength = url.length();
        for (int i = 0; i < urlLength && !this.getCodeTask.isCancelled() && url.charAt(i) != '/'; ++i) {
            cannonical = cannonical + url.charAt(i);
        }
        return cannonical;
    }

    private String stripTags(String content) {
        return Jsoup.parse((String)content).text();
    }

    private boolean isImage(String url) {
        return url.matches("(.+?)\\.(jpg|png|gif|bmp)$");
    }

    private HashMap<String, String> getMetaTags(String content) {
        HashMap<String, String> metaTags = new HashMap<String, String>();
        metaTags.put("url", "");
        metaTags.put("title", "");
        metaTags.put("description", "");
        metaTags.put("image", "");
        List<String> matches = Regex.pregMatchAll(content, "<meta(.*?)>", 1);
        for (String match : matches) {
            if (this.getCodeTask.isCancelled()) break;
            String lowerCase = match.toLowerCase();
            if (lowerCase.contains("property=\"og:url\"") || lowerCase.contains("property='og:url'") || lowerCase.contains("name=\"url\"") || lowerCase.contains("name='url'")) {
                this.updateMetaTag(metaTags, "url", this.separeMetaTagsContent(match));
                continue;
            }
            if (lowerCase.contains("property=\"og:title\"") || lowerCase.contains("property='og:title'") || lowerCase.contains("name=\"title\"") || lowerCase.contains("name='title'")) {
                this.updateMetaTag(metaTags, "title", this.separeMetaTagsContent(match));
                continue;
            }
            if (lowerCase.contains("property=\"og:description\"") || lowerCase.contains("property='og:description'") || lowerCase.contains("name=\"description\"") || lowerCase.contains("name='description'")) {
                this.updateMetaTag(metaTags, "description", this.separeMetaTagsContent(match));
                continue;
            }
            if (!lowerCase.contains("property=\"og:image\"") && !lowerCase.contains("property='og:image'") && !lowerCase.contains("name=\"image\"") && !lowerCase.contains("name='image'")) continue;
            this.updateMetaTag(metaTags, "image", this.separeMetaTagsContent(match));
        }
        return metaTags;
    }

    private void updateMetaTag(HashMap<String, String> metaTags, String url, String value) {
        if (value != null && value.length() > 0) {
            metaTags.put(url, value);
        }
    }

    private String separeMetaTagsContent(String content) {
        String result = Regex.pregMatch(content, "content=\"(.*?)\"", 1);
        return this.htmlDecode(result);
    }

    private String unshortenUrl(String shortURL) {
        if (!shortURL.startsWith("http://") && !shortURL.startsWith("https://")) {
            return "";
        }
        URLConnection urlConn = this.connectURL(shortURL);
        urlConn.getHeaderFields();
        String finalResult = urlConn.getURL().toString();
        urlConn = this.connectURL(finalResult);
        urlConn.getHeaderFields();
        shortURL = urlConn.getURL().toString();
        while (!shortURL.equals(finalResult)) {
            finalResult = this.unshortenUrl(finalResult);
        }
        return finalResult;
    }

    private URLConnection connectURL(String strURL) {
        URLConnection conn = null;
        try {
            URL inputURL = new URL(strURL);
            conn = inputURL.openConnection();
        }
        catch (MalformedURLException e) {
            System.out.println("Please input a valid URL");
        }
        catch (IOException ioe) {
            System.out.println("Can not connect to the URL");
        }
        return conn;
    }

    public static String extendedTrim(String content) {
        return content.replaceAll("\\s+", " ").replace("\n", " ").replace("\r", " ").trim();
    }

    public class GetCode
    extends AsyncTask<String, Void, Void> {
        private SourceContent sourceContent = new SourceContent();
        private int imageQuantity;
        private ArrayList<String> urls;

        public GetCode(int imageQuantity) {
            this.imageQuantity = imageQuantity;
        }

        protected void onPreExecute() {
            if (TextCrawler.this.callback != null) {
                TextCrawler.this.callback.onPre();
            }
            super.onPreExecute();
        }

        protected void onPostExecute(Void result) {
            if (TextCrawler.this.callback != null) {
                TextCrawler.this.callback.onPos(this.sourceContent, this.isNull());
            }
            super.onPostExecute((Object)result);
        }

        protected void onCancelled() {
            super.onCancelled();
        }

        protected Void doInBackground(String ... params) {
            this.urls = SearchUrls.matches(params[0]);
            if (this.urls.size() > 0) {
                this.sourceContent.setFinalUrl(TextCrawler.this.unshortenUrl(TextCrawler.extendedTrim(this.urls.get(0))));
            } else {
                this.sourceContent.setFinalUrl("");
            }
            if (!this.sourceContent.getFinalUrl().equals("")) {
                if (TextCrawler.this.isImage(this.sourceContent.getFinalUrl()) && !this.sourceContent.getFinalUrl().contains("dropbox")) {
                    this.sourceContent.setSuccess(true);
                    this.sourceContent.getImages().add(this.sourceContent.getFinalUrl());
                    this.sourceContent.setTitle("");
                    this.sourceContent.setDescription("");
                } else {
                    try {
                        String matchTitle;
                        Document doc = Jsoup.connect((String)this.sourceContent.getFinalUrl()).userAgent("Mozilla").get();
                        this.sourceContent.setHtmlCode(TextCrawler.extendedTrim(doc.toString()));
                        HashMap metaTags = TextCrawler.this.getMetaTags(this.sourceContent.getHtmlCode());
                        this.sourceContent.setMetaTags(metaTags);
                        this.sourceContent.setTitle((String)metaTags.get("title"));
                        this.sourceContent.setDescription((String)metaTags.get("description"));
                        if (this.sourceContent.getTitle().equals("") && !(matchTitle = Regex.pregMatch(this.sourceContent.getHtmlCode(), "<title(.*?)>(.*?)</title>", 2)).equals("")) {
                            this.sourceContent.setTitle(TextCrawler.this.htmlDecode(matchTitle));
                        }
                        if (this.sourceContent.getDescription().equals("")) {
                            this.sourceContent.setDescription(TextCrawler.this.crawlCode(this.sourceContent.getHtmlCode()));
                        }
                        this.sourceContent.setDescription(this.sourceContent.getDescription().replaceAll("<script(.*?)>(.*?)</script>", ""));
                        if (this.imageQuantity != -2) {
                            if (!((String)metaTags.get("image")).equals("")) {
                                this.sourceContent.getImages().add((String)metaTags.get("image"));
                            } else {
                                this.sourceContent.setImages(TextCrawler.this.getImages(doc, this.imageQuantity));
                            }
                        }
                        this.sourceContent.setSuccess(true);
                    }
                    catch (Exception e) {
                        this.sourceContent.setSuccess(false);
                    }
                }
            }
            String[] finalLinkSet = this.sourceContent.getFinalUrl().split("&");
            this.sourceContent.setUrl(finalLinkSet[0]);
            this.sourceContent.setCannonicalUrl(TextCrawler.this.cannonicalPage(this.sourceContent.getFinalUrl()));
            this.sourceContent.setDescription(TextCrawler.this.stripTags(this.sourceContent.getDescription()));
            return null;
        }

        public boolean isNull() {
            return !this.sourceContent.isSuccess() && TextCrawler.extendedTrim(this.sourceContent.getHtmlCode()).equals("") && !TextCrawler.this.isImage(this.sourceContent.getFinalUrl());
        }
    }
}

