package com.hippo.agent.helper;

import android.app.*;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import androidx.core.app.NotificationCompat;
import android.webkit.MimeTypeMap;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippo.BuildConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.model.EventItem;
import com.hippo.agent.model.HeaderItem;
import com.hippo.agent.model.ListItem;
import com.hippo.agent.model.Message;
import com.hippo.constant.FuguAppConstant;
import com.hippo.interfaces.fayeClient;
import com.hippo.model.FuguUploadImageResponse;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.MultipartParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.fileUpload.Prefs;
import com.hippo.utils.fileUpload.ProgressRequestBody;

import faye.ConnectionManager;
import faye.FayeClient;
import faye.FayeServiceListener;
import okhttp3.MultipartBody;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * Created by gurmail on 04/02/19.
 *
 * @author gurmail
 */
public class UploadingService extends Service implements FayeServiceListener, FuguAppConstant, ProgressRequestBody.UploadCallbacks {

    private static final String TAG = UploadingService.class.getSimpleName();

    private static final int NOTIFICATION_ID = 5101;
    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";

    private Handler h;
    private Runnable r;
    FayeClient mClient = null;

    int counter = 0;
    private Type fileuploadType = new TypeToken<List<FileuploadModel>>() {
    }.getType();
    NotificationManager manager;
    NotificationCompat.Builder builder;

    FileuploadModel fileuploadModel;
    ArrayList<FileuploadModel> fileuploadModels = new ArrayList<>();
    boolean apiInProgress;


    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    private Notification updateNotification() {
        counter++;
        Context context = getApplicationContext();
        manager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
            String CHANNEL_ID = "hippo_file_uploading";
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, getString(R.string.app_name),
                    NotificationManager.IMPORTANCE_DEFAULT);
            channel.setDescription("File uploading");
            manager.createNotificationChannel(channel);
            builder = new NotificationCompat.Builder(this, CHANNEL_ID);
        } else {
            builder = new NotificationCompat.Builder(context);
        }

        builder.setProgress(100, counter, false);
        return builder.setContentTitle(getString(R.string.uploading))
                .setTicker("")
                .setOnlyAlertOnce(true)
                .setContentText(getString(R.string.uploading_in_progress))
                .setSmallIcon(R.drawable.hippo_default_notif_icon)
                .setOngoing(true).build();
    }

    /*@Override
    public void onTaskRemoved(Intent rootIntent) {
//        super.onTaskRemoved(rootIntent);
        HippoLog.v(TAG, "uploadFileServerCall task removed:");
        Intent intent = new Intent(getApplicationContext(), UploadingService.class);
        PendingIntent pendingIntent = PendingIntent.getService(this, 1, intent, PendingIntent.FLAG_ONE_SHOT);
        AlarmManager alarmManager = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
        alarmManager.set(AlarmManager.RTC_WAKEUP, SystemClock.elapsedRealtime() + 5000, pendingIntent);
        super.onTaskRemoved(rootIntent);
    }

    @Override
    public void onDestroy() {
        HippoLog.v(TAG, "uploadFileServerCall task removed: 1");
        super.onDestroy();
    }*/

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent.getAction().contains("start")) {
            startForeground(NOTIFICATION_ID, updateNotification());
            uploadFileServerCall();
        } else {
            stopFayeClient();
            stopForeground(true);
            stopSelf();
        }

        return Service.START_STICKY;
    }

    public void stopFayeClient() {
        if(mClient == null)
            return;
        try {
            HandlerThread thread = new HandlerThread("TerminateThread");
            thread.start();
            new Handler(thread.getLooper()).post(new Runnable() {
                @Override
                public void run() {
                    mClient.setServiceListener(null);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateProgress(int uploaded, int total) {
        HippoLog.e(TAG, "uploaded progress = "+uploaded);
        if(builder != null && manager != null) {
            builder.setProgress(total, uploaded, false);
            // Issues the notification
            manager.notify(NOTIFICATION_ID, builder.build());
        } else {
            startForeground(NOTIFICATION_ID, updateNotification());
        }
    }

    /**
     * Check Network Connection
     *
     * @return boolean
     */
    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }


    private void uploadFileServerCall() {
        try {
            if(apiInProgress) {
                HippoLog.e(TAG, "***************ApiInProgress*************");
                return;
            }
            if (isNetworkAvailable()) {
                String data = Prefs.with(this).getString(KEY, "");
                HippoLog.v(TAG, "uploadFileServerCall 1: "+data);
                fileuploadModels = new Gson().fromJson(data, fileuploadType);

                if(fileuploadModels == null || fileuploadModels.size()==0) {
                    Prefs.with(this).remove(KEY);
                    stopFayeClient();
                    stopForeground(true);
                    stopSelf();
                    return;
                }

                fileuploadModel = fileuploadModels.get(0);

                LinkedHashMap<String, JSONObject> unsentMessageMapNew = AgentCommonData.getUnsentMessageMapByChannel(fileuploadModel.getChannelId());
                if(unsentMessageMapNew == null || unsentMessageMapNew.size() == 0) {
                    HippoLog.e(TAG, "File item not found "+fileuploadModel.getMuid());
                    updatePref();
                    return;
                }
                if(!unsentMessageMapNew.containsKey(fileuploadModel.getMuid())) {
                    HippoLog.e(TAG, "File item not found "+fileuploadModel.getMuid());
                    updatePref();
                    return;
                }

//                try {
//                    JSONObject messageJson = unsentMessageMapNew.get(fileuploadModel.getMuid());
//                    if(DateUtils.getTimeDiff(messageJson.optString("is_message_expired", "0"))) {
//                        messageJson.put("is_message_expired", 1);
//                        unsentMessageMapNew.put(fileuploadModel.getMuid(), messageJson);
//
//                        updatePref();
//                        return;
//                    }
//                } catch (Exception e) {
//
//                }

                isFirstTime = true;
                ProgressRequestBody fileBody = new ProgressRequestBody(new File(fileuploadModel.getFilePath()),  this,
                        getMimeType(fileuploadModel.getFilePath()), fileuploadModel.getFilePath(), fileuploadModel.getMessageIndex(),
                        fileuploadModel.getMuid());
                MultipartBody.Part filePart =
                        MultipartBody.Part.createFormData("file", fileuploadModel.getFileName(), fileBody);

                MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
                MultipartParams multipartParams = multipartBuilder
                        .add(FuguAppConstant.ACCESS_TOKEN, AgentCommonData.getUserData().getAccessToken())
                        .add(APP_VERSION, BuildConfig.VERSION_NAME)
                        .add(DEVICE_TYPE, 1)
                        .add("allow_all_mime_type", true)
                        .add("file_name", fileuploadModel.getFileName())
                        .build(2);

                apiInProgress = true;
                HippoLog.v("map = ", multipartParams.getMap().toString());
                RestClient.getAgentApiInterface()
                        .uploadFile(AgentCommonData.getUserData().getAccessToken(), 1,
                                BuildConfig.VERSION_CODE, filePart, multipartParams.getMap())
                        .enqueue(new ResponseResolver<FuguUploadImageResponse>() {

                            @Override
                            public void success(FuguUploadImageResponse fuguUploadImageResponse) {

                                String image_url = fuguUploadImageResponse.getData().getUrl();
                                String thumbnail_url = fuguUploadImageResponse.getData().getThumbnailUrl();

                                String data = Prefs.with(UploadingService.this).getString(KEY, "");
                                HippoLog.v(TAG, "In response: " + data);
                                fileuploadModels = new Gson().fromJson(data, fileuploadType);


                                JSONObject jsonObject = fileuploadModels.get(0).getMessageObject();
                                try {
                                    jsonObject.put(IMAGE_URL, image_url);
                                    jsonObject.put(THUMBNAIL_URL, thumbnail_url);
                                    jsonObject.put("url", image_url);
                                    jsonObject.remove("local_url");
                                } catch (JSONException e) {
                                    if(HippoConfig.DEBUG)
                                        e.printStackTrace();
                                }
                                fileuploadModels.get(0).setFileUploaded(true);
                                fileuploadModels.get(0).setMessageObject(jsonObject);

                                if(fileuploadModels.get(0).getChannelId() < 1) {

                                    Intent mIntent = new Intent(FuguAppConstant.HIPPO_FILE_UPLOAD);
                                    mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.CREATE_CHANNEL);
                                    mIntent.putExtra("fileuploadModel", new Gson().toJson(fileuploadModels.get(0)));
                                    LocalBroadcastManager.getInstance(HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);

                                    updatePref();

                                } else {
                                    data = new Gson().toJson(fileuploadModels, fileuploadType);
                                    HippoLog.e(TAG, "In response else case "+data);
                                    Prefs.with(UploadingService.this).save(KEY, data);

                                    fileuploadModel = fileuploadModels.get(0);

                                    if(isOpenedChatActivityMsg(fileuploadModel.getChannelId())) {
                                        Intent mIntent = new Intent(FuguAppConstant.HIPPO_FILE_UPLOAD);
                                        mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.UPLOADED_SUCESSFULLY);
                                        mIntent.putExtra("channelId", fileuploadModel.getChannelId());
                                        mIntent.putExtra("muid", fileuploadModel.getMuid());
                                        mIntent.putExtra("messageIndex", fileuploadModel.getMessageIndex());
                                        mIntent.putExtra("image_url", image_url);
                                        mIntent.putExtra("thumbnail_url", thumbnail_url);
                                        mIntent.putExtra("fileuploadModel", new Gson().toJson(fileuploadModel));
                                        LocalBroadcastManager.getInstance(HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
                                        //getClient(fileuploadModel.getChannelId(), jsonObject);
                                        updatePref();

                                    } else {
                                        updateLocalAgentMessageObj(fileuploadModel.getChannelId(), false, image_url, thumbnail_url, jsonObject,
                                                new UpdateLocalMsgListener() {
                                            @Override
                                            public void onUpdation(JSONObject jsonObject) {
                                                apiInProgress = false;
                                                getClient(fileuploadModel.getChannelId(), jsonObject);
                                            }
                                        });
                                    }
                                }
                            }

                            @Override
                            public void failure(APIError error) {
                                HippoLog.e(TAG, "In uploading failure");
                                handleException();
                            }
                        });
            } else {
                HippoLog.e(TAG, "In uploading else");
                handleException();
            }
        } catch (Exception e) {
            e.printStackTrace();
            HippoLog.e(TAG, "In uploading else 2");
            handleException();
        }
    }


    private void handleException() {
        HippoLog.e(TAG, "In handleException failure");
        try {
            String data = Prefs.with(this).getString(KEY, "");
            HippoLog.e(TAG, "In response else case "+data);
            fileuploadModels = new Gson().fromJson(data, fileuploadType);
            if(fileuploadModels == null || fileuploadModels.size() == 0) {
                Prefs.with(this).remove(KEY);
                stopFayeClient();
                stopForeground(true);
                stopSelf();
                return;
            }
            fileuploadModel = fileuploadModels.get(0);
            apiInProgress = false;
            if(isOpenedChatActivityMsg(fileuploadModel.getChannelId())) {
                //String fileuploadModeldata = new Gson().toJson(fileuploadModel);
                setMessageExpired();
                Intent mIntent = new Intent(HIPPO_FILE_UPLOAD);
                mIntent.putExtra("channelId", fileuploadModel.getChannelId());
                mIntent.putExtra("muid", fileuploadModel.getMuid());
                mIntent.putExtra("messageIndex", fileuploadModel.getMessageIndex());
                mIntent.putExtra("fileuploadModel", new Gson().toJson(fileuploadModel));
                mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.UPLOADING_FAILED);
                LocalBroadcastManager.getInstance(HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
            } else {
                uploadingFailed(fileuploadModel.getChannelId());
                setMessageExpired();
            }
        } catch (Exception e) {
            e.printStackTrace();
            Prefs.with(this).remove(KEY);
            stopFayeClient();
            stopForeground(true);
            stopSelf();
        }
    }

    /**
     * get mime type of selected file/image on basis of extension
     */
    public String getMimeType(String url) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl(url);
        if (extension != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return type;
    }


    private void updatePref() {
        HippoLog.e(TAG, "updatePref: "+Prefs.with(this).getString(KEY, ""));
        fileuploadModels = new Gson().fromJson(Prefs.with(this).getString(KEY, ""), fileuploadType);
        if(fileuploadModels == null || fileuploadModels.size() == 0) {
            Prefs.with(this).remove(KEY);
            stopFayeClient();
            stopForeground(true);
            stopSelf();
        } else {
            fileuploadModels.remove(0);
            String data = new Gson().toJson(fileuploadModels, fileuploadType);
            Prefs.with(this).save(KEY, data);

            HippoLog.e(TAG, "int updatePref set data : "+data);
            if(fileuploadModels.size() == 0) {
                Prefs.with(this).remove(KEY);
                stopFayeClient();
                stopForeground(true);
                stopSelf();
            } else {
                apiInProgress = false;
                uploadFileServerCall();
            }
        }
    }

    boolean isFirstTime;
    @Override
    public void onProgressUpdate(int percentage, int mMessageIndex, String muid) {
        if(isFirstTime && percentage == 10) {
            isFirstTime = false;
            return;
        }
        if(!isFirstTime && percentage == 10)
            isFirstTime = true;

        if(isFirstTime)
            updateProgress(percentage, 100);
    }

    @Override
    public void onError(int percentage, int mMessageIndex, String muid) {
        HippoLog.e(TAG, "In onError else 2");
    }

    @Override
    public void onFinish(int percentage, int mMessageIndex, String muid) {
        HippoLog.e(TAG, "In onFinish else 2");
    }

    private void getClient(final Long channelId, final JSONObject messageJson) {
        ConnectionManager.INSTANCE.initFayeConnection();
        afterSetUpFayeConnection(channelId, messageJson);

        /*HippoConfig.getClient(new fayeClient() {
            @Override
            public void Listener(FayeClient client) {
                mClient = client;
                afterSetUpFayeConnection(channelId, messageJson);
            }
        });*/
    }

    private void afterSetUpFayeConnection(Long channelId, JSONObject messageJson) {
        mClient.setServiceListener(this);
        if (!mClient.isConnectedServer() && isNetworkAvailable()) {
            mClient.connectServer();
        } else if (mClient.isConnectedServer()) {
            HippoLog.e(TAG, "************publish*********");
            mClient.publish("/" + String.valueOf(channelId), messageJson);
            updatePref();
        } else if(!isNetworkAvailable()) {
            Intent mIntent = new Intent(FuguAppConstant.HIPPO_FILE_UPLOAD);
            mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.UPLOADED_SUCESSFULLY);
            LocalBroadcastManager.getInstance(HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
            updatePref();
        }
    }

    @Override
    public void onConnectedServer(FayeClient fc) {
        HippoLog.e(TAG, "************onConnectedServer*********");

        ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(UploadingService.this).getString(KEY, ""), fileuploadType);
        for(FileuploadModel fileuploadModel : fileuploadModels) {
            if(fileuploadModel.isFileUploaded()) {
                if(mClient.hasSubscribed("/" + String.valueOf(fileuploadModel.getChannelId()))) {
                    mClient.subscribeChannel("/" + String.valueOf(fileuploadModel.getChannelId()));
                }
                mClient.publish("/" + String.valueOf(fileuploadModel.getChannelId()), fileuploadModel.getMessageObject());
                break;
            }
        }
    }

    @Override
    public void onDisconnectedServer(FayeClient fc) {

    }

    @Override
    public void onReceivedMessage(FayeClient fc, String msg, String channel) {
        try {
            JSONObject messageJson = new JSONObject(msg);
            if(messageJson.optInt(MESSAGE_TYPE, 0) == IMAGE_MESSAGE ||
                    messageJson.optInt(MESSAGE_TYPE, 0) == FILE_MESSAGE) {
                long value = messageJson.optLong("channel_id");
                if (!isOpenedChatActivityMsg(value)) {
                    updateLocalAgentMessageObj(value, true, "", "", null, null);
                }
                updatePref();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    public void onWebSocketError() {

    }

    @Override
    public void onErrorReceived(FayeClient fc, String msg, String channel) {

    }


    private boolean isOpenedChatActivityMsg(Long channelId) {
        ActivityManager mngr = (ActivityManager) getSystemService(ACTIVITY_SERVICE);
        List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);
        if (taskList.get(0).topActivity.getClassName().equals("com.hippo.agent.AgentChatActivity")
                && AgentChatActivity.currentChannelId.compareTo(channelId) == 0) {
            return true;
        }
        return false;
    }

    private void uploadingFailed(Long channelId) {
        String data = Prefs.with(UploadingService.this).getString(KEY, "empty");
        if(data.equals("empty")) {
            apiInProgress = false;
            HippoLog.v(TAG, "data = "+data);
            return;
        }
        ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(data, fileuploadType);
        int index = fileuploadModels.indexOf(new FileuploadModel(channelId));
        if(index == -1)
            return;
        FileuploadModel fileuploadModel = fileuploadModels.get(index);

        LinkedHashMap<String, ListItem> unsentMessages = AgentCommonData.getUnsentMessageByChannel(channelId);
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = AgentCommonData.getUnsentMessageMapByChannel(channelId);

        ListItem listItem = unsentMessages.get(fileuploadModel.getMuid());
        if (listItem == null)
            return;

        Message message = ((EventItem) listItem).getEvent();
        message.setUploadStatus(UPLOAD_FAILED);
        message.setIsMessageExpired(1);
        unsentMessages.put(fileuploadModel.getMuid(), new EventItem(message));
        AgentCommonData.setUnsentMessageByChannel(channelId, unsentMessages);
    }

    private void updateLocalAgentMessageObj(Long channelId, boolean isPublished, String url, String thumbnailUrl,
                                            JSONObject jsonObject, UpdateLocalMsgListener msgListener) {
        String data = Prefs.with(UploadingService.this).getString(KEY, "empty");
        if(data.equals("empty")) {
            apiInProgress = false;
            HippoLog.v(TAG, "data = "+data);
            return;
        }
        ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(data, fileuploadType);
        int index = fileuploadModels.indexOf(new FileuploadModel(channelId));
        if(index == -1)
            return;
        FileuploadModel fileuploadModel = fileuploadModels.get(index);

        LinkedHashMap<String, ListItem> sentMessages = AgentCommonData.getSentMessageByChannel(channelId);
        LinkedHashMap<String, ListItem> unsentMessages = AgentCommonData.getUnsentMessageByChannel(channelId);
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = AgentCommonData.getUnsentMessageMapByChannel(channelId);

        ListItem listItem = unsentMessages.get(fileuploadModel.getMuid());
        if (listItem == null)
            return;

        if(isPublished) {
            ((EventItem) listItem).getEvent().setMessageStatus(MESSAGE_SENT);
            List<String> reverseOrderedKeys = new ArrayList<>(sentMessages.keySet());
            Collections.reverse(reverseOrderedKeys);
            String tempSentAtUTC = "";
            for (String key : reverseOrderedKeys) {
                if (sentMessages.get(key) instanceof HeaderItem) {
                    tempSentAtUTC = key;
                    break;
                }
            }
            String time = ((EventItem) listItem).getEvent().getSentAtUtc();
            String localDate = DateUtils.getInstance().convertToLocal(time, inputFormat, outputFormat);
            if (!tempSentAtUTC.equalsIgnoreCase(localDate)) {
                sentMessages.put(localDate, new HeaderItem(localDate));
            }
            sentMessages.put(fileuploadModel.getMuid(), listItem);

            unsentMessages.remove(fileuploadModel.getMuid());
            unsentMessageMapNew.remove(fileuploadModel.getMuid());

            AgentCommonData.setSentMessageByChannel(channelId, sentMessages);

        } else {
            Message message = ((EventItem) listItem).getEvent();
            message.setFileUrl(url);
            message.setImageUrl(url);
            message.setThumbnailUrl(thumbnailUrl);
            message.setUploadStatus(UPLOAD_COMPLETED);

            unsentMessages.put(fileuploadModel.getMuid(), new EventItem(message));

            JSONObject object = null;
            try {
                object = unsentMessageMapNew.get(fileuploadModel.getMuid());
                object.put(IMAGE_URL, url);
                object.put(THUMBNAIL_URL, thumbnailUrl);
                object.put("url", url);
                unsentMessageMapNew.put(fileuploadModel.getMuid(), object);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        AgentCommonData.setUnsentMessageByChannel(channelId, unsentMessages);
        AgentCommonData.setUnsentMessageMapByChannel(channelId, unsentMessageMapNew);

        if(msgListener != null)
            msgListener.onUpdation(jsonObject);

    }

    private void setAllMessageExpired() {
        fileuploadModels = new Gson().fromJson(Prefs.with(this).getString(KEY, ""), fileuploadType);
        if(fileuploadModels == null || fileuploadModels.size()==0) {
            Prefs.with(this).remove(KEY);
            stopFayeClient();
            stopForeground(true);
            stopSelf();
            return;
        } else {
            for(FileuploadModel fileuploadModel : fileuploadModels) {
                if (isOpenedChatActivityMsg(fileuploadModel.getChannelId())) {
                    sendLocalBroadcast(fileuploadModel);
                } else {
                    updateAgentLocalMessage(fileuploadModels.get(0));
                }
            }
            fileuploadModels.clear();
            Prefs.with(this).remove(KEY);
            stopFayeClient();
            stopForeground(true);
            stopSelf();

        }
    }

    private void setMessageExpired() {
        String data = Prefs.with(this).getString(KEY, "");
        HippoLog.e(TAG, "In setMessageExpired: "+data);
        fileuploadModels = new Gson().fromJson(data, fileuploadType);
        if(fileuploadModels == null || fileuploadModels.size()==0) {
            Prefs.with(this).remove(KEY);
            stopFayeClient();
            stopForeground(true);
            stopSelf();
        } else {
            //FileuploadModel fileuploadModel = fileuploadModels.get(0);
            if (isOpenedChatActivityMsg(fileuploadModels.get(0).getChannelId())) {
                sendLocalBroadcast(fileuploadModels.get(0));
            } else {
                updateAgentLocalMessage(fileuploadModels.get(0));
            }
            fileuploadModels.remove(0);
            data = new Gson().toJson(fileuploadModels, fileuploadType);
            HippoLog.e(TAG, "In setMessageExpired after update: "+data);
            Prefs.with(this).save(KEY, data);
            if(fileuploadModels != null && fileuploadModels.size()>0) {
                uploadFileServerCall();
            } else {
                Prefs.with(this).remove(KEY);
                stopFayeClient();
                stopForeground(true);
                stopSelf();
            }
        }
    }

    private void sendLocalBroadcast(FileuploadModel fileuploadModel) {
        Intent mIntent = new Intent(HIPPO_FILE_UPLOAD);
        mIntent.putExtra("muid", fileuploadModel.getMuid());
        mIntent.putExtra("messageIndex", fileuploadModel.getMessageIndex());
        mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.MESSAGE_EXPIRED);
        LocalBroadcastManager.getInstance(HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
    }

    private void updateAgentLocalMessage(FileuploadModel fileuploadModel) {
        String muid = fileuploadModel.getMuid();
        LinkedHashMap<String, ListItem> unsentMessages = AgentCommonData.getUnsentMessageByChannel(fileuploadModel.getChannelId());
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = AgentCommonData.getUnsentMessageMapByChannel(fileuploadModel.getChannelId());

        if (unsentMessages == null)
            unsentMessages = new LinkedHashMap<>();

        ListItem listItem = unsentMessages.get(muid);
        ((EventItem) listItem).getEvent().setIsMessageExpired(1);
        try {
            JSONObject messageJson = unsentMessageMapNew.get(muid);
            messageJson.put("is_message_expired", 1);
            unsentMessageMapNew.put(muid, messageJson);
        } catch (Exception e) {
            //e.printStackTrace();
        }

        AgentCommonData.setUnsentMessageByChannel(fileuploadModel.getChannelId(), unsentMessages);
        AgentCommonData.setUnsentMessageMapByChannel(fileuploadModel.getChannelId(), unsentMessageMapNew);
    }

    public interface UpdateLocalMsgListener {
        void onUpdation(JSONObject jsonObject);
    }
}