package com.hippo.activity;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.fragment.app.DialogFragment;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.hippo.BuildConfig;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.model.FuguDeviceDetails;
import com.hippo.model.MakePayment;
import com.hippo.model.PaymentResponse;
import com.hippo.model.payment.AddedPaymentGateway;
import com.hippo.payment.PaymentConstants;
import com.hippo.payment.ProcessingPaymentWebViewActivity;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.hippo.utils.loadingBox.ProgressWheel;

import static android.provider.Telephony.BaseMmsColumns.TRANSACTION_ID;
import static android.webkit.WebSettings.MIXED_CONTENT_ALWAYS_ALLOW;
import static com.hippo.constant.FuguAppConstant.ANDROID_USER;
import static com.hippo.constant.FuguAppConstant.Request.RESULT_PAYMENT_ERROR;
import static com.hippo.payment.PaymentConstants.PaymentValue.BILLPLZ;
import static com.hippo.payment.PaymentConstants.PaymentValue.PAYFORT;
import static com.hippo.payment.PaymentConstants.PaymentValue.PAYMOB;
import static com.hippo.payment.PaymentConstants.PaymentValue.RAZORPAY;

/**
 * Created by gurmail on 2019-11-05.
 *
 * @author gurmail
 */
public class PaymentDialogFragment extends DialogFragment {

    private RelativeLayout rootToolbar;
    private ImageView ivBackBtn;
    private TextView tvToolbarName;
    private ImageView userImageIcon;
    private ImageView ivVideoView, ivAudioView, ivHistoryView;
    private RelativeLayout loadingLayout;
    private ProgressWheel progressWheel;
    private TextView textView;

    private MakePayment paymentData;

    private ProgressBar pbWebPageLoader;
    private WebView webView;

    private HippoColorConfig hippoColorConfig;
    private FuguChatActivity chatActivity;

    public interface OnInputListener {
        void closeFragment();
    }

    public OnInputListener onInputListener;
    private AddedPaymentGateway paymentGateway;

    //PaymentDialogFragment fragment;

    static PaymentDialogFragment newInstance(String url, String paymentData, AddedPaymentGateway paymentGateway) {
        PaymentDialogFragment fragment = new PaymentDialogFragment();
        Bundle bundle = new Bundle();
        //bundle.putString("url", url);
        bundle.putString("paymentData", paymentData);
        bundle.putBoolean("fullScreen", true);
        bundle.putString("paymentGateway", new Gson().toJson(paymentGateway));

        fragment.setArguments(bundle);
        return fragment;
    }

    String url = "";
    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.activity_webview, container, false);

    }



    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);


        String title = "Payment";

        rootToolbar = view.findViewById(R.id.my_toolbar);
        userImageIcon = view.findViewById(R.id.user_image);
        tvToolbarName = view.findViewById(R.id.tv_toolbar_name);
        ivBackBtn = view.findViewById(R.id.ivBackBtn);
        ivVideoView = view.findViewById(R.id.ivVideoView);
        ivAudioView = view.findViewById(R.id.ivAudioView);
        ivHistoryView = view.findViewById(R.id.ivHistoryView);
        loadingLayout = view.findViewById(R.id.loadingLayout);
        progressWheel = view.findViewById(R.id.circle_progress);
        textView = view.findViewById(R.id.text);

        hippoColorConfig = CommonData.getColorConfig();
        rootToolbar.setBackgroundColor(hippoColorConfig.getHippoActionBarBg());
        tvToolbarName.setTextColor(hippoColorConfig.getHippoActionBarText());
        tvToolbarName.setText(title);

        pbWebPageLoader = view.findViewById(R.id.pbWebPageLoader);
        webView = view.findViewById(R.id.webView);

        userImageIcon.setVisibility(View.GONE);
        ivVideoView.setVisibility(View.GONE);
        ivAudioView.setVisibility(View.GONE);
        ivHistoryView.setVisibility(View.GONE);


        setWebViewProperties(webView);

        webView.addJavascriptInterface(new MyJavaScriptInterface(),
                "android");

        ivBackBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(onInputListener != null)
                    onInputListener.closeFragment();
                dismiss();
            }
        });

        webView.setWebViewClient(new MyWebViewClient());
        if(!TextUtils.isEmpty(url)) {
            handleLayout(1);
            webView.loadUrl(url);
        } else {
            handleLayout(0);
            createPaymentLink(paymentData);
        }

    }

    private void handleLayout(int value) {
        if(value == 0) {
            loadingLayout.setVisibility(View.VISIBLE);
            webView.setVisibility(View.GONE);
        } else if(value == 2) {
            progressWheel.setVisibility(View.GONE);
            textView.setText("Something went wrong! \n Please try again");
        } else {
            loadingLayout.setVisibility(View.GONE);
            webView.setVisibility(View.VISIBLE);
        }
    }

    private void setWebViewProperties(final WebView webView) {
        webView.setWebViewClient(new MyWebViewClient());
        webView.setWebChromeClient(new WebChromeClient());
        webView.getSettings().setLoadsImagesAutomatically(true);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setScrollBarStyle(View.SCROLLBARS_INSIDE_OVERLAY);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportMultipleWindows(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webView.getSettings().setMixedContentMode(MIXED_CONTENT_ALWAYS_ALLOW);
        }


        webView.getSettings().setAllowFileAccessFromFileURLs(true);
        webView.getSettings().setAllowUniversalAccessFromFileURLs(true);

        webView.getSettings().setAllowFileAccess(true);
        webView.getSettings().setAllowContentAccess(true);


        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public boolean onCreateWindow(WebView view, boolean dialog, boolean userGesture, Message resultMsg) {
                //return true or false after performing the URL request

//                wvWebsite.removeAllViews();
                WebView newView = new WebView(getActivity());
                newView.setLayoutParams(new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

                if (paymentGateway.getGatewayId() == RAZORPAY.intValue)
                    webView.addView(newView);

                if (paymentGateway.getGatewayId() == RAZORPAY.intValue)
                    setWebViewProperties(newView); //Dialog update on same screen
                else setWebViewProperties(webView); //Dialog update on different screen

                WebView.WebViewTransport transport = (WebView.WebViewTransport) resultMsg.obj;
                transport.setWebView(newView);
                resultMsg.sendToTarget();
                return true;
            }

            @Override
            public void onCloseWindow(WebView window) {
                HippoLog.e("onCloseWindow", window + "");
                webView.removeView(window);
                super.onCloseWindow(window);
            }

            @Override
            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                HippoLog.e("URL onJsAlert", url + "");

                return super.onJsAlert(view, url, message, result);
            }
        });

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            onInputListener = (OnInputListener) getActivity();
        } catch (ClassCastException e) {
            HippoLog.e("TAG", "onAttach: " + e.getMessage());
        }
        chatActivity = (FuguChatActivity) getActivity();
    }


    @Override
    public void onResume() {
        super.onResume();

    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        if(onInputListener != null)
            onInputListener.closeFragment();
        super.onDismiss(dialog);
    }

    public void onClick(View v) {
        if(v.getId() == R.id.ivBackBtn) {
            //onBackPressed();
            //dismiss();
        }
    }



    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        url = getArguments().getString("url");
        paymentData = new Gson().fromJson(getArguments().getString("paymentData"), MakePayment.class);
        paymentGateway = new Gson().fromJson(getArguments().getString("paymentGateway"), AddedPaymentGateway.class);
        HippoLog.e("URL", "URL = "+url);
        boolean setFullScreen = true;
        if (getArguments() != null) {
            setFullScreen = getArguments().getBoolean("fullScreen");
        }

        setStyle(DialogFragment.STYLE_NORMAL, R.style.FullScreenDialogStyle);

//        if (setFullScreen)
//            setStyle(DialogFragment.STYLE_NORMAL, android.R.style.Theme_Black_NoTitleBar_Fullscreen);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
    }


    private class MyWebViewClient extends WebViewClient {
        @Override
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return onOverrideUrlLoading(view, request.getUrl().toString());
        }

       /* @Override
        public WebResourceResponse shouldInterceptRequest (final WebView view, String url) {
            HippoLog.e("URL", url + " <<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            return super.shouldInterceptRequest(view, url);

        }*/

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return onOverrideUrlLoading(view, url);
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            //ProgressDialog.show(mActivity);
            super.onPageStarted(view, url, favicon);
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            try {
                if (pbWebPageLoader != null)
                    pbWebPageLoader.setVisibility(View.INVISIBLE);
            } catch (Exception e) {

            }
            super.onPageFinished(view, url);
        }
    }


    private boolean onOverrideUrlLoading(WebView view, String url) {
        HippoLog.e("loaded URL", url + " <<<<<<<<<<<<<<<<<<<<<<<<<<<<");

        UrlQuerySanitizer sanitizer = new UrlQuerySanitizer(url);
        String transactionId = "", jobPaymentDetailId = "";


        if (paymentGateway.getGatewayId() == RAZORPAY.intValue) {
            transactionId = sanitizer.getValue("rzp_payment_id");

        } else if (paymentGateway.getGatewayId() == BILLPLZ.intValue) {
            transactionId = sanitizer.getValue("billplz[id]");
        } else if (paymentGateway.getGatewayId() == PAYFORT.intValue) {
            transactionId = sanitizer.getValue("transactionId");
            jobPaymentDetailId = sanitizer.getValue("job_payment_detail_id");
        } else {
            /* paymentMethod == PAYFAST || FAC || INSTAPAY || PAYPAL || PAYMOB  returns transactionId*/

            if (sanitizer.getValue("transactionId") != null) {
                transactionId = sanitizer.getValue("transactionId");
            } else {
                transactionId = sanitizer.getValue("transaction_id");
            }
        }

        /*if (url.startsWith("http:") || url.startsWith("https:")) {
            view.loadUrl(url);

        }*/

        if (url.startsWith("http:") || url.startsWith("https:")) {
            view.loadUrl(url);
            if(url.contains("success") || url.contains("Success")) {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        dismiss();
                    }
                }, 1500);
            } else if(url.contains("error.html")) {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        dismiss();
                    }
                }, 1500);
            }
        }

        /*if (url.startsWith("http:") || url.startsWith("https:")) {
            view.loadUrl(url);
            if (((paymentGateway.getGatewayId() == PAYMOB.intValue) ? (url.contains("success.html") || url.contains("Success.html")) : (url.contains("success") || url.contains("Success"))) && transactionId != null && !transactionId.isEmpty()) {
                dismiss();
            } else if ((paymentGateway.getGatewayId() == PAYMOB.intValue) ? url.contains("error.html") : url.contains("error")) {
                dismiss();
            }
        }*/


            /*if (((paymentMethod == PAYMOB.intValue) ? (url.contains("success.html") || url.contains("Success.html")) : (url.contains("success") || url.contains("Success"))) && transactionId != null && !transactionId.isEmpty()) {

                Bundle extras = new Bundle();
                extras.putString(TRANSACTION_ID, transactionId);
                //extras.putString(JOB_PAYMENT_DETAIL_ID, jobPaymentDetailId);
                Intent intent = new Intent();
                intent.putExtras(extras);
                setResult(RESULT_OK, intent);
//                finish();
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        finish();
                    }
                }, 1500);
            } else if ((paymentMethod == PAYMOB.intValue) ? url.contains("error.html") : url.contains("error")) {
                Bundle extras = new Bundle();
                if (transactionId != null && !transactionId.isEmpty()) {
                    extras.putString(TRANSACTION_ID, transactionId);
                }
                Intent intent = new Intent();
                intent.putExtras(extras);
                setResult(RESULT_PAYMENT_ERROR, intent);
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        finish();
                    }
                }, 1500);
            }
        }*/

        return true;
    }

    private void createPaymentLink(MakePayment makePayment) {
        if (chatActivity.isNetworkAvailable()) {

            makePayment.setPayment_gateway_id(paymentGateway.getGatewayId());
            makePayment.setIs_multi_gateway_flow(1);
            makePayment.setDevice_details(CommonData.deviceDetailString(getActivity()));
            makePayment.setApp_version(BuildConfig.VERSION_CODE);
            makePayment.setDevice_id(UniqueIMEIID.getUniqueIMEIId(getActivity()));
            makePayment.setSource_type(1);
            makePayment.setDevice_type(ANDROID_USER);


            RestClient.getApiInterface().createPaymentLink(makePayment)
                    .enqueue(new ResponseResolver<PaymentResponse>(getActivity(), false, true) {
                        @Override
                        public void success(PaymentResponse response) {
                            if(!TextUtils.isEmpty(response.getData().getPaymentUrl())) {
                                handleLayout(1);
                                webView.loadUrl(response.getData().getPaymentUrl());
                            } else {
                                handleLayout(2);
                            }
                        }

                        @Override
                        public void failure(APIError error) {
                            handleLayout(2);
                        }
                    });
        } else {
            Toast.makeText(getActivity(), getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }


    class MyJavaScriptInterface {
        @JavascriptInterface
        public void onUrlChange(String url) {
            Log.d("hydrated", "onUrlChange" + url);
        }
    }


}
