package com.hippo.helper

import android.text.TextUtils
import com.hippo.HippoConfig
import com.hippo.eventbus.BusProvider
import com.hippo.utils.HippoLog
import org.json.JSONObject

/**
 * Created by gurmail on 2020-04-19.
 * @author gurmail
 */
object ParseMessage {

    fun receivedMessage(msg: String?, channel: String?) {
        if(TextUtils.isEmpty(msg))
            return

        try {
            val data = JSONObject(msg)
            when(data.optInt("message_type")) {
                18 -> {
                    if (HippoConfig.getInstance().fayeCallDate != null) {
                        HippoConfig.getInstance().fayeCallDate.callingFlow(data, msg, channel)
                    }
                }
                else -> {
                    BusProvider.getInstance().post(FayeMessage(BusEvents.RECEIVED_MESSAGE.toString(), channel, msg))
                }
            }
        } catch (e: Exception) {
            BusProvider.getInstance().post(FayeMessage(BusEvents.RECEIVED_MESSAGE.toString(), channel, msg))
        }
    }

    /*private fun callingFlow(data: JSONObject, msg: String?, channel: String?) {
        when(data.getString(VIDEO_CALL_TYPE)) {
            FuguAppConstant.JitsiCallType.START_CONFERENCE.toString() -> startConference(data)
            FuguAppConstant.JitsiCallType.OFFER_CONFERENCE.toString() -> offerConference(data)
            FuguAppConstant.JitsiCallType.REJECT_CONFERENCE.toString() -> rejectConference(data)
            FuguAppConstant.JitsiCallType.HUNGUP_CONFERENCE.toString() -> hungupConference(data)
            else -> {
                if(!TextUtils.isEmpty(msg))
                    BusProvider.getInstance().post(com.fuguagent.hippocall.model.FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg))
                Log.e("msg", "~~&~^*&^~*&^~*&^~*^~*~^*~^*~&^~*^~*&^~*&~^*~&^&*~");
            }
        }
    }

    //
    private fun startConference(data: JSONObject) {
        val finalUserId1 = MyApplication.getInstance().userData.userId
        if(finalUserId1 != data.optInt("user_id", -1)
                && !OngoingCallService.NotificationServiceState.isConferenceConnected) {
            emitReadyToConnect(data, finalUserId1)
            return
        }

        if(OngoingCallService.NotificationServiceState.isConferenceConnected) {
            emitUserBusy(data, finalUserId1)
        }
    }

    private fun offerConference(data: JSONObject) {
        val finalUserId1 = MyApplication.getInstance().userData.userId
        if(finalUserId1 != data.optInt("user_id", -1)
                && !OngoingCallService.NotificationServiceState.isConferenceConnected) {
            val turnCredentials = AppContants().turnCredentials
            val myName = MyApplication.getInstance().userData.fullName
            val myImage = MyApplication.getInstance().userData.userImage


            val userId = MyApplication.getInstance().userData.userId
            val fullname = data.optString("full_name")
            val channelId = data.optLong("channel_id")
            val messageUniqueId = data.optString("muid")
            val videoCallType = data.optString("video_call_type", "")

            val callType = data.optString("call_type", "")
            val activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString()
            val userImage = data.optString("user_thumbnail_image")

            val videoCallModel = VideoCallModel(channelId,
                    data.optString("user_thumbnail_image"),
                    data.optString("full_name"),
                    userId,
                    -1,
                    fullname,
                    turnCredentials.getTurnApiKey(),
                    turnCredentials.getUsername(),
                    turnCredentials.getCredentials(),
                    ArrayList(),
                    ArrayList(),
                    activityLaunchState,
                    messageUniqueId,
                    callType.toUpperCase(), "", "",
                    myName, myImage)

            if(OngoingCallService.NotificationServiceState.muid == data.getString(MESSAGE_UNIQUE_ID))
                return
            OngoingCallService.NotificationServiceState.muid = data.getString(MESSAGE_UNIQUE_ID)
            OngoingCallService.NotificationServiceState.inviteLink = data.getString("invite_link")
            val fuguNotificationConfig = PushReceiver().getInstance();
            fuguNotificationConfig.incomingCallNotification(MyApplication.getInstance().applicationContext, data, videoCallModel)
        }
    }

    private fun rejectConference(data: JSONObject) {
        val finalUserId1 = MyApplication.getInstance().userData.userId
        val startIntent = Intent(MyApplication.getInstance().applicationContext, OngoingCallService::class.java)
        MyApplication.getInstance().applicationContext.stopService(startIntent)
    }

    private fun hungupConference(data: JSONObject) {
        if (OngoingCallService.NotificationServiceState.inviteLink == data.optString("invite_link")) {
            val hungupIntent = Intent(MyApplication.getInstance().applicationContext, HungUpBroadcast::class.java)
            hungupIntent.putExtra("action", "rejectCall")
            hungupIntent.putExtra(FuguAppConstant.MESSAGE_UNIQUE_ID, data.getString(FuguAppConstant.MESSAGE_UNIQUE_ID))
            MyApplication.getInstance().applicationContext.sendBroadcast(hungupIntent)
            val mIntent = Intent("CALL_HANGUP")
            LocalBroadcastManager.getInstance(MyApplication.getInstance().applicationContext).sendBroadcast(mIntent)

            val mIntent2 = Intent(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
            mIntent2.putExtra(FuguAppConstant.INVITE_LINK, data.getString(FuguAppConstant.INVITE_LINK))
            LocalBroadcastManager.getInstance(MyApplication.getInstance().applicationContext).sendBroadcast(mIntent2)
        } else if (!ConnectionUtils.isAppRunning(MyApplication.getInstance().applicationContext)) {
            ConnectionManager.onClose()
        } else {
            // do nothing
        }
    }

    private fun emitReadyToConnect(data: JSONObject, userId: Int?) {
        try {
            val startCallJson = JSONObject()
            startCallJson.put(FuguAppConstant.IS_SILENT, true)
            startCallJson.put(FuguAppConstant.VIDEO_CALL_TYPE, FuguAppConstant.JitsiCallType.READY_TO_CONNECT_CONFERENCE)
            startCallJson.put(FuguAppConstant.USER_ID, userId)
            startCallJson.put(FuguAppConstant.CHANNEL_ID, data.getString(FuguAppConstant.CHANNEL_ID))
            startCallJson.put(FuguAppConstant.MESSAGE_TYPE, FuguAppConstant.VIDEO_CALL)
            startCallJson.put(WebRTCCallConstants.CALL_TYPE, "VIDEO")
            try {
                startCallJson.put(WebRTCCallConstants.DEVICE_PAYLOAD, CommonData.deviceDetails(MyApplication.getInstance().applicationContext))
            } catch (e: Exception) {
            }
            startCallJson.put(FuguAppConstant.INVITE_LINK, data.getString(FuguAppConstant.INVITE_LINK))
            startCallJson.put(FuguAppConstant.MESSAGE_UNIQUE_ID, data.getString(FuguAppConstant.MESSAGE_UNIQUE_ID))

            startCallJson.put(WebRTCCallConstants.FULL_NAME, data.optString("full_name", ""))
            startCallJson.put("message", "")
            startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)

            val channelId = "/" + data.optLong(FuguAppConstant.CHANNEL_ID)
            ConnectionManager.publish(channelId, startCallJson)
            Log.e("Video_CONF-->", startCallJson.toString())
        } catch (e: Exception) {

        }
    }

    private fun emitUserBusy(jsonObject: JSONObject, userId: Int?) {
        try {
            val startCallJson = JSONObject()
            startCallJson.put(FuguAppConstant.IS_SILENT, false)
            startCallJson.put(FuguAppConstant.VIDEO_CALL_TYPE, FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE)
            startCallJson.put(FuguAppConstant.USER_ID, userId)
            startCallJson.put(FuguAppConstant.CHANNEL_ID, jsonObject.optString(FuguAppConstant.CHANNEL_ID))
            startCallJson.put(FuguAppConstant.MESSAGE_TYPE, FuguAppConstant.VIDEO_CALL)
            startCallJson.put(WebRTCCallConstants.CALL_TYPE, "VIDEO")
            startCallJson.put(WebRTCCallConstants.DEVICE_PAYLOAD, com.fuguagent.hippocall.CommonData.deviceDetails(MyApplication.getInstance().applicationContext))
            startCallJson.put(FuguAppConstant.INVITE_LINK, jsonObject.optString(FuguAppConstant.INVITE_LINK))
            startCallJson.put(FuguAppConstant.MESSAGE_UNIQUE_ID, jsonObject.optString(FuguAppConstant.MESSAGE_UNIQUE_ID))

            startCallJson.put(WebRTCCallConstants.FULL_NAME, jsonObject.optString("full_name", ""))
            startCallJson.put("message", "")
            startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)
            startCallJson.put("user_type", FuguAppConstant.ANDROID_USER)

            val channelId = "/"+jsonObject.optLong(CHANNEL_ID)
            ConnectionManager.publish(channelId, startCallJson)

        } catch (e: Exception) {
            e.printStackTrace()
        }

    }*/

}