/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.google.android.material.R;
import com.google.android.material.snackbar.Snackbar;
import java.util.ArrayList;
import java.util.HashMap;

public final class PermissionCommon {
    private static final int REQUEST_CODE = 8;
    private static final int REQUEST_CODE_RATIONAL = 9;
    private int requestCodeInitiated;
    private View view;
    private String[] permissionsInitiated;
    private Snackbar snackBarPermissionDenied;
    private Snackbar snackBarRational;
    private String appName;
    private Activity activity;
    private PermissionListener permissionListener;
    private HashMap<String, String> rationalMessageMap;
    private boolean isFragment;
    private Fragment fragment;

    private PermissionCommon() {
    }

    public <Instance extends PermissionListener> PermissionCommon(Instance context) {
        this.permissionListener = context;
        if (context instanceof Activity) {
            this.activity = (Activity)context;
        } else if (context instanceof Fragment) {
            this.activity = ((Fragment)context).getActivity();
            this.isFragment = true;
            this.fragment = (Fragment)context;
        }
        this.view = this.activity.findViewById(0x1020002);
    }

    public <Instance extends PermissionListener> PermissionCommon(Instance context, @NonNull HashMap<String, String> rationalMessageMap) {
        this.permissionListener = context;
        if (context instanceof Activity) {
            this.activity = (Activity)context;
        } else if (context instanceof Fragment) {
            this.activity = ((Fragment)context).getActivity();
            this.isFragment = true;
            this.fragment = (Fragment)context;
        }
        this.view = this.activity.findViewById(0x1020002);
        this.rationalMessageMap = rationalMessageMap;
    }

    public final void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 8: {
                int permissionsGranted = 0;
                for (int result : grantResults) {
                    if (result != 0) continue;
                    ++permissionsGranted;
                }
                if (grantResults.length == permissionsGranted) {
                    this.permissionListener.permissionGranted(this.requestCodeInitiated);
                    break;
                }
                for (String permission2 : permissions) {
                    if (this.isGranted(permission2) || this.shouldShowRationalPermission(permission2)) continue;
                    String messageToShow = "You have disabled the permission to " + this.getPermissionLabel(permission2) + ". Please go to app settings to allow permission";
                    this.showPermissionDenied(messageToShow);
                    this.permissionListener.permissionDenied(this.requestCodeInitiated);
                    return;
                }
                this.permissionListener.permissionDenied(this.requestCodeInitiated);
                break;
            }
            case 9: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.getPermission(this.requestCodeInitiated, false, this.permissionsInitiated);
                    break;
                }
                if (this.shouldShowRationalPermission(permissions[0])) {
                    String string2 = "You have disabled the permission to " + this.getPermissionLabel(permissions[0]) + ".Please go to app settings to allow permission";
                    this.showPermissionDenied(string2);
                    this.permissionListener.permissionDenied(this.requestCodeInitiated);
                    return;
                }
                this.permissionListener.permissionDenied(this.requestCodeInitiated);
                break;
            }
        }
    }

    private String getRationalMessage(String permission2) {
        if (this.rationalMessageMap != null && this.rationalMessageMap.containsKey(permission2)) {
            return this.rationalMessageMap.get(permission2);
        }
        if (this.appName == null) {
            this.appName = this.activity.getString(this.activity.getApplicationInfo().labelRes);
        }
        switch (permission2) {
            case "android.permission.CAMERA": {
                return this.appName + " needs permission to access the camera to save images";
            }
            case "android.permission.ACCESS_COARSE_LOCATION": {
                return this.appName + " needs permission fetch current location address";
            }
            case "android.permission.ACCESS_FINE_LOCATION": {
                return this.appName + " needs permission fetch current location address";
            }
            case "android.permission.WRITE_EXTERNAL_STORAGE": {
                return this.appName + " needs storage permission to share the feedback";
            }
        }
        return this.appName + " needs this permission to proceed.";
    }

    public void getPermission(int requestCode, boolean isLocation, String ... permissionArray) {
        if (!isLocation && Build.VERSION.SDK_INT < 23) {
            this.permissionListener.permissionGranted(requestCode);
            return;
        }
        ArrayList<String> permissionsToAsk = new ArrayList<String>();
        for (String permission2 : permissionArray) {
            if (this.isGranted(permission2)) continue;
            permissionsToAsk.add(permission2);
        }
        if (permissionsToAsk.size() < 1) {
            this.permissionListener.permissionGranted(requestCode);
            return;
        }
        this.permissionsInitiated = permissionArray;
        this.requestCodeInitiated = requestCode;
        for (final String permission3 : permissionsToAsk) {
            if (!this.shouldShowRationalPermission(permission3)) continue;
            this.getRationalSnackBar(this.getRationalMessage(permission3)).setAction((CharSequence)"OK", new View.OnClickListener(){

                public void onClick(View v) {
                    PermissionCommon.this.requestPermissions(new String[]{permission3}, 9);
                }
            }).show();
            return;
        }
        this.requestPermissions(permissionsToAsk.toArray(new String[permissionsToAsk.size()]), 8);
    }

    private void requestPermissions(String[] strings, int requestCode) {
        if (this.isFragment) {
            this.fragment.requestPermissions(strings, requestCode);
        } else {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])strings, (int)requestCode);
        }
    }

    private boolean shouldShowRationalPermission(String permission2) {
        if (this.isFragment) {
            return this.fragment.shouldShowRequestPermissionRationale(permission2);
        }
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)permission2);
    }

    public boolean isGranted(String permission2) {
        return ContextCompat.checkSelfPermission((Context)this.activity, (String)permission2) == 0;
    }

    private CharSequence getPermissionLabel(String permission2) {
        try {
            PermissionInfo permissionInfo = this.activity.getPackageManager().getPermissionInfo(permission2, 0);
            return permissionInfo.loadLabel(this.activity.getPackageManager());
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void showPermissionDenied(String message) {
        if (this.snackBarPermissionDenied == null) {
            this.snackBarPermissionDenied = Snackbar.make((View)this.view, (CharSequence)message, (int)0);
            ((TextView)this.snackBarPermissionDenied.getView().findViewById(R.id.snackbar_text)).setMaxLines(5);
            this.snackBarPermissionDenied.setAction((CharSequence)"Settings", new View.OnClickListener(){

                public void onClick(View v) {
                    PermissionCommon.this.snackBarPermissionDenied.dismiss();
                    Intent intent = new Intent();
                    intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                    Uri uri = Uri.fromParts((String)"package", (String)PermissionCommon.this.activity.getPackageName(), null);
                    intent.setData(uri);
                    PermissionCommon.this.activity.startActivity(intent);
                }
            });
        }
        this.snackBarPermissionDenied.setText((CharSequence)message);
        this.snackBarPermissionDenied.show();
    }

    private Snackbar getRationalSnackBar(String message) {
        if (this.snackBarRational == null) {
            this.snackBarRational = Snackbar.make((View)this.view, (CharSequence)message, (int)0);
            ((TextView)this.snackBarRational.getView().findViewById(R.id.snackbar_text)).setMaxLines(5);
        }
        this.snackBarRational.setText((CharSequence)message);
        return this.snackBarRational;
    }

    public static interface PermissionListener {
        public void permissionGranted(int var1);

        public void permissionDenied(int var1);
    }
}

