/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.customLayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hippo.R;

public class ChatRelativeLayout
extends RelativeLayout {
    private TextView parentTextView;
    private View childView;
    private TypedArray typedArray;
    private RelativeLayout.LayoutParams parentLayoutParams;
    private RelativeLayout.LayoutParams childLayoutParams;
    private int parentWidth;
    private int childWidth;
    private int parentHeight;
    private int childHeight;

    public ChatRelativeLayout(Context context) {
        super(context);
    }

    public ChatRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.typedArray = context.obtainStyledAttributes(attrs, R.styleable.ChatRelativeLayout, 0, 0);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        try {
            this.parentTextView = (TextView)this.findViewById(this.typedArray.getResourceId(R.styleable.ChatRelativeLayout_parent, -1));
            this.childView = this.findViewById(this.typedArray.getResourceId(R.styleable.ChatRelativeLayout_child, -1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.parentTextView == null || this.childView == null || widthSize <= 0) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            int availableWidth = widthSize - this.getPaddingStart() - this.getPaddingEnd();
            this.parentLayoutParams = (RelativeLayout.LayoutParams)this.parentTextView.getLayoutParams();
            this.parentWidth = this.parentTextView.getMeasuredWidth() + this.parentLayoutParams.getMarginStart() + this.parentLayoutParams.getMarginEnd();
            this.parentHeight = this.parentTextView.getMeasuredHeight() + this.parentLayoutParams.topMargin + this.parentLayoutParams.bottomMargin;
            this.childLayoutParams = (RelativeLayout.LayoutParams)this.childView.getLayoutParams();
            this.childWidth = this.childView.getMeasuredWidth() + this.childLayoutParams.getMarginStart() + this.childLayoutParams.getMarginEnd();
            this.childHeight = this.childView.getMeasuredHeight() + this.childLayoutParams.topMargin + this.childLayoutParams.bottomMargin;
            int parentLineCount = this.parentTextView.getLineCount();
            float parentLastLineWitdh = parentLineCount > 0 ? this.parentTextView.getLayout().getLineWidth(parentLineCount - 1) : 0.0f;
            widthSize = this.getPaddingStart() + this.getPaddingEnd();
            int heightSize = this.getPaddingTop() + this.getPaddingBottom();
            if (parentLineCount > 1 && parentLastLineWitdh + (float)this.childWidth < (float)this.parentTextView.getMeasuredWidth()) {
                widthSize += this.parentWidth;
                heightSize += this.parentHeight;
            } else if (parentLineCount == 1 && this.parentWidth + this.childWidth >= availableWidth) {
                widthSize += this.parentTextView.getMeasuredWidth();
                heightSize += this.parentHeight + this.childHeight;
            } else if (parentLineCount > 1 && parentLastLineWitdh + (float)this.childWidth >= (float)availableWidth) {
                widthSize += this.parentWidth;
                heightSize += this.parentHeight + this.childHeight;
            } else {
                widthSize += this.parentWidth + this.childWidth;
                heightSize += this.parentHeight;
            }
            this.setMeasuredDimension(widthSize, heightSize);
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)0x40000000));
        } else {
            int availableWidth = widthSize - this.getPaddingLeft() - this.getPaddingRight();
            this.parentLayoutParams = (RelativeLayout.LayoutParams)this.parentTextView.getLayoutParams();
            this.parentWidth = this.parentTextView.getMeasuredWidth() + this.parentLayoutParams.leftMargin + this.parentLayoutParams.rightMargin;
            this.parentHeight = this.parentTextView.getMeasuredHeight() + this.parentLayoutParams.topMargin + this.parentLayoutParams.bottomMargin;
            this.childLayoutParams = (RelativeLayout.LayoutParams)this.childView.getLayoutParams();
            this.childWidth = this.childView.getMeasuredWidth() + this.childLayoutParams.leftMargin + this.childLayoutParams.rightMargin;
            this.childHeight = this.childView.getMeasuredHeight() + this.childLayoutParams.topMargin + this.childLayoutParams.bottomMargin;
            int parentLineCount = this.parentTextView.getLineCount();
            float parentLastLineWitdh = parentLineCount > 0 ? this.parentTextView.getLayout().getLineWidth(parentLineCount - 1) : 0.0f;
            widthSize = this.getPaddingLeft() + this.getPaddingRight();
            int heightSize = this.getPaddingTop() + this.getPaddingBottom();
            if (parentLineCount > 1 && parentLastLineWitdh + (float)this.childWidth < (float)this.parentTextView.getMeasuredWidth()) {
                widthSize += this.parentWidth;
                heightSize += this.parentHeight;
            } else if (parentLineCount == 1 && this.parentWidth + this.childWidth >= availableWidth) {
                widthSize += this.parentTextView.getMeasuredWidth();
                heightSize += this.parentHeight + this.childHeight;
            } else if (parentLineCount > 1 && parentLastLineWitdh + (float)this.childWidth >= (float)availableWidth) {
                widthSize += this.parentWidth;
                heightSize += this.parentHeight + this.childHeight;
            } else {
                widthSize += this.parentWidth + this.childWidth;
                heightSize += this.parentHeight;
            }
            this.setMeasuredDimension(widthSize, heightSize);
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)0x40000000));
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (Build.VERSION.SDK_INT >= 17) {
            if (this.parentTextView != null && this.childView != null) {
                this.parentTextView.layout(this.getPaddingStart(), this.getPaddingTop(), this.parentTextView.getWidth() + this.getPaddingStart(), this.parentTextView.getHeight() + this.getPaddingTop());
                this.childView.layout(right - left - this.childWidth - this.getPaddingRight(), bottom - top - this.getPaddingBottom() - this.childHeight, right - left - this.getPaddingRight(), bottom - top - this.getPaddingBottom());
            }
        } else if (this.parentTextView != null && this.childView != null) {
            this.parentTextView.layout(this.getPaddingLeft(), this.getPaddingTop(), this.parentTextView.getWidth() + this.getPaddingLeft(), this.parentTextView.getHeight() + this.getPaddingTop());
            this.childView.layout(right - left - this.childWidth - this.getPaddingRight(), bottom - top - this.getPaddingBottom() - this.childHeight, right - left - this.getPaddingRight(), bottom - top - this.getPaddingBottom());
        }
    }
}

