/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.android.material.R;
import com.google.android.material.snackbar.Snackbar;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.AgentListActivity;
import com.hippo.agent.Util.ConversationMode;
import com.hippo.agent.Util.FragmentType;
import com.hippo.agent.Util.MessageMode;
import com.hippo.agent.Util.NotificationType;
import com.hippo.agent.Util.Overlay;
import com.hippo.agent.Util.WrapContentLinearLayoutManager;
import com.hippo.agent.adapter.ChatListAdapter;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.fragment.BaseFragment;
import com.hippo.agent.helper.ConversationListHelper;
import com.hippo.agent.listeners.AgentServerListener;
import com.hippo.agent.listeners.ConversationListerner;
import com.hippo.agent.listeners.OnUserChannelListener;
import com.hippo.agent.model.ApiResponseFlags;
import com.hippo.agent.model.GetConversationResponse;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.agent.recylerviewAnimation.FadeInLeftAnimator;
import com.hippo.retrofit.APIError;
import com.hippo.utils.HippoLog;
import com.hippo.utils.Utils;
import com.hippo.utils.loadingBox.LoadingBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.json.JSONObject;

public class AllChatFragment
extends BaseFragment
implements AgentServerListener,
OnUserChannelListener,
SwipeRefreshLayout.OnRefreshListener,
ChatListAdapter.Callback {
    private static final String TAG = AllChatFragment.class.getSimpleName();
    private SwipeRefreshLayout swipeRefreshLayout;
    private RecyclerView listView;
    private ChatListAdapter chatListAdapter;
    private LinearLayout llNoConversation;
    private WrapContentLinearLayoutManager layoutManager;
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private ConversationListerner listerner;
    private ChatListAdapter.ProgressBarItem progressBarItem;
    private ArrayList<Object> conversationChatList = new ArrayList();
    private TextView title_error;
    private TextView detail_error;
    private boolean isPagingApiInProgress;
    private boolean isLastItemReached;
    private Snackbar snackbar;
    private int newMessageCount = 0;
    private int[] statusIntArray = new int[]{MessageMode.OPEN_CHAT.getOrdinal()};
    private int[] typeIntArray = new int[]{ConversationMode.ALL.getOrdinal()};
    private int[] labelsIntArray = new int[0];
    private UserData userData;
    RecyclerView.OnScrollListener onScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            HippoLog.v("scroll state ", "changed");
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (dy > 0) {
                if (!AllChatFragment.this.isNetworkAvailable()) {
                    return;
                }
                AllChatFragment.this.visibleItemCount = AllChatFragment.this.layoutManager.getChildCount();
                AllChatFragment.this.totalItemCount = AllChatFragment.this.layoutManager.getItemCount();
                AllChatFragment.this.pastVisiblesItems = AllChatFragment.this.layoutManager.findFirstVisibleItemPosition();
                if (!AllChatFragment.this.isPagingApiInProgress && !AllChatFragment.this.isLastItemReached && AllChatFragment.this.visibleItemCount + AllChatFragment.this.pastVisiblesItems >= AllChatFragment.this.totalItemCount) {
                    int pageStart = AllChatFragment.this.conversationChatList.size() + 1;
                    AllChatFragment.this.toggleProgressBarVisibility(true);
                    AllChatFragment.this.getConversationData(pageStart, false);
                }
            } else if (AllChatFragment.this.getSnackbar() != null && AllChatFragment.this.layoutManager.findFirstVisibleItemPosition() == 1) {
                AllChatFragment.this.getSnackbar().dismiss();
            }
        }
    };
    private Handler handler = new Handler();
    private final int OVERLAY_TIME = 1000;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hippo_list_fragment, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.listView = (RecyclerView)view.findViewById(R.id.list_view);
        this.swipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_refresh);
        this.swipeRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.hippo_white});
        this.swipeRefreshLayout.setProgressBackgroundColorSchemeResource(R.color.fugu_theme_color_primary);
        this.swipeRefreshLayout.setSize(1);
        this.llNoConversation = (LinearLayout)view.findViewById(R.id.llNoConversation);
        this.title_error = (TextView)view.findViewById(R.id.title_error);
        this.detail_error = (TextView)view.findViewById(R.id.detail_error);
        this.layoutManager = new WrapContentLinearLayoutManager((Context)this.getActivity(), 1, false);
        this.listView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.listView.setItemAnimator((RecyclerView.ItemAnimator)new FadeInLeftAnimator());
        this.listView.getItemAnimator().setAddDuration(500L);
        this.listView.getItemAnimator().setRemoveDuration(500L);
        this.listView.setHasFixedSize(false);
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        if (this.userData != null && !TextUtils.isEmpty((CharSequence)this.userData.getAccessToken())) {
            this.chatListAdapter = new ChatListAdapter(this.userData.getUserId(), true, FragmentType.ALL_CHAT.getOrdinal(), this.conversationChatList, this, this.listView);
            this.listView.setAdapter((RecyclerView.Adapter)this.chatListAdapter);
            this.listView.addOnScrollListener(this.onScrollListener);
            this.listerner = new ConversationListHelper();
            this.listerner.getOfflineData(FragmentType.ALL_CHAT.getOrdinal());
        } else {
            this.llNoConversation.setVisibility(0);
            this.title_error.setVisibility(8);
            this.detail_error.setText((CharSequence)"Something went wrong. Please try again");
        }
    }

    private void setConnectionManager(boolean loader) {
        this.isLastItemReached = false;
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        this.getConversationData(0, loader);
    }

    private void getConversationData(int pageStart, boolean loader) {
        this.getConversationData(pageStart, loader, -1, false);
    }

    private void getConversationData(int pageStart, boolean loader, int endPage, boolean isRefreshing) {
        if (!this.isNetworkAvailable()) {
            this.swipeRefreshLayout.setRefreshing(false);
            return;
        }
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        String userID = String.valueOf(this.userData.getEnUserId());
        String accessToken = this.userData.getAccessToken();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("en_user_id", userID);
        params.put("access_token", accessToken);
        params.put("status", "[1]");
        params.put("device_type", 1);
        params.put("type", Arrays.toString(this.typeIntArray));
        if (pageStart != 0) {
            params.put("page_start", String.valueOf(pageStart));
        }
        if (endPage > 0) {
            params.put("page_end", String.valueOf(endPage));
        }
        this.getConversationList(params, pageStart > 0, loader, isRefreshing, endPage);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        HippoConfig.getInstance().addUIListener(AgentServerListener.class, this);
        HippoConfig.getInstance().addUIListener(OnUserChannelListener.class, this);
    }

    public void onDetach() {
        super.onDetach();
        HippoConfig.getInstance().removeUIListener(AgentServerListener.class, this);
        HippoConfig.getInstance().removeUIListener(OnUserChannelListener.class, this);
        AgentCommonData.setAgentConversationList(FragmentType.ALL_CHAT.getOrdinal(), this.conversationChatList);
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
    }

    public void onStart() {
        super.onStart();
    }

    public void onStop() {
        super.onStop();
    }

    public void onPause() {
        super.onPause();
    }

    private Snackbar getSnackbar() {
        return this.snackbar;
    }

    private void newConversationSnackBar() {
        ++this.newMessageCount;
        String message = this.newMessageCount > 1 ? this.newMessageCount + " new Chats" : this.newMessageCount + " new Chat";
        this.snackbar = Snackbar.make((View)this.getActivity().getWindow().getDecorView().findViewById(0x1020002), (CharSequence)message, (int)0).setAction((CharSequence)this.getResources().getString(R.string.fugu_tap_to_view), new View.OnClickListener(){

            public void onClick(View view) {
                AllChatFragment.this.newMessageCount = 0;
                AllChatFragment.this.listView.smoothScrollToPosition(0);
            }
        });
        this.snackbar.setActionTextColor(-1);
        View sbView = this.snackbar.getView();
        sbView.setBackgroundColor(ContextCompat.getColor((Context)this.getActivity(), (int)17170453));
        TextView textView = (TextView)sbView.findViewById(R.id.snackbar_text);
        textView.setTextColor(-1);
        Button button = (Button)sbView.findViewById(R.id.snackbar_action);
        this.snackbar.setDuration(-2);
        this.snackbar.show();
    }

    private void getConversationList(HashMap<String, Object> params, boolean isPagination, boolean loader, boolean onRefreshing, int endPage) {
        if (this.listerner != null && !this.isPagingApiInProgress) {
            if (loader) {
                LoadingBox.showOn((Activity)this.getActivity());
            }
            try {
                if (!(this.conversationChatList == null || this.conversationChatList.size() <= 0 || isPagination || loader || onRefreshing || this.getActivity() == null)) {
                    ((AgentListActivity)this.getActivity()).allChatFlag = true;
                    ((AgentListActivity)this.getActivity()).setConnectionMessage(1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isPagingApiInProgress = true;
            this.listerner.getAgentConversation(params, isPagination, FragmentType.ALL_CHAT.getOrdinal(), endPage);
        }
    }

    private void getConversationResponse(GetConversationResponse getConversationResponse, boolean isPagination, int fragmentType, int endPage) {
        if (fragmentType != FragmentType.ALL_CHAT.getOrdinal()) {
            return;
        }
        try {
            this.isPagingApiInProgress = false;
            HippoLog.e("Size of Array", getConversationResponse.getData().getConversation().size() + "");
            if (getConversationResponse != null && ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.getStatusCode().intValue()) {
                this.setConversationChatData((ArrayList)getConversationResponse.getData().getConversation(), isPagination, endPage);
                this.toggleProgressBarVisibility(false);
                if (getConversationResponse.getData().getConversation().size() == 0) {
                    this.isLastItemReached = true;
                }
            }
            if (this.getActivity() != null) {
                ((AgentListActivity)this.getActivity()).hideLoader(2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LoadingBox.hide();
        this.swipeRefreshLayout.setRefreshing(false);
    }

    private void setConversationChatData(ArrayList<Conversation> allChatData, boolean isPagination) {
        this.setConversationChatData(allChatData, isPagination, -1);
    }

    private void setConversationChatData(ArrayList<Conversation> allChatData, final boolean isPagination, final int endPage) {
        if (!isPagination) {
            this.conversationChatList.clear();
        }
        this.conversationChatList.addAll(allChatData);
        if (this.getView() != null && this.chatListAdapter != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AllChatFragment.this.chatListAdapter.notifyDataSetChanged();
                    if (!isPagination && endPage < 1) {
                        AllChatFragment.this.listView.scrollToPosition(0);
                    }
                }
            });
        }
        this.setLlNoConversation(null);
        this.addUnreadCount(allChatData, isPagination);
    }

    private void setLlNoConversation(final String message) {
        if (this.llNoConversation != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (message != null) {
                        if (AllChatFragment.this.conversationChatList == null || AllChatFragment.this.conversationChatList.size() == 0) {
                            AllChatFragment.this.llNoConversation.setVisibility(0);
                            AllChatFragment.this.swipeRefreshLayout.setVisibility(8);
                        } else {
                            AllChatFragment.this.llNoConversation.setVisibility(8);
                        }
                        if (!TextUtils.isEmpty((CharSequence)message)) {
                            AllChatFragment.this.detail_error.setText((CharSequence)message);
                        }
                    } else if (AllChatFragment.this.conversationChatList == null || AllChatFragment.this.conversationChatList.size() == 0) {
                        AllChatFragment.this.llNoConversation.setVisibility(0);
                        AllChatFragment.this.swipeRefreshLayout.setVisibility(8);
                    } else {
                        AllChatFragment.this.llNoConversation.setVisibility(8);
                    }
                }
            });
        }
    }

    private void toggleProgressBarVisibility(boolean isVisible) {
        if (isVisible) {
            if (this.progressBarItem == null) {
                this.progressBarItem = new ChatListAdapter.ProgressBarItem();
            }
            if (!this.conversationChatList.contains(this.progressBarItem)) {
                this.conversationChatList.add(this.progressBarItem);
                this.listView.post(new Runnable(){

                    @Override
                    public void run() {
                        AllChatFragment.this.chatListAdapter.notifyItemInserted(AllChatFragment.this.conversationChatList.size() - 1);
                    }
                });
            }
        } else if (this.progressBarItem != null && this.conversationChatList.contains(this.progressBarItem)) {
            this.conversationChatList.remove(this.progressBarItem);
            this.chatListAdapter.notifyItemRemoved(this.conversationChatList.size() - 1);
        }
    }

    public void onRefresh() {
        if (!this.isNetworkAvailable()) {
            this.swipeRefreshLayout.setRefreshing(false);
            return;
        }
        this.getConversationData(0, false, -1, true);
    }

    @Override
    public void onClick(int position, int fragmentType, Conversation conversation) {
        conversation.setUnreadCount(0);
        this.chatListAdapter.notifyDataSetChanged();
        if (!Utils.preventMultipleClicks()) {
            return;
        }
        Intent chatIntent = new Intent((Context)this.getActivity(), AgentChatActivity.class);
        chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
        chatIntent.putExtra("fragment_type", fragmentType);
        this.startActivityForResult(chatIntent, 100);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        HippoLog.v("onActivityResult", "enter");
        if (requestCode == 100) {
            if (resultCode == MessageMode.OPEN_CHAT.getOrdinal()) {
                Long channelId = Long.parseLong(data.getExtras().getString("channel_id"));
                this.setOverlayTransition(channelId, MessageMode.OPEN_CHAT.getOrdinal(), resultCode);
            } else if (resultCode == MessageMode.CLOSED_CHAT.getOrdinal()) {
                Long channelId = Long.parseLong(data.getExtras().getString("channel_id"));
                this.setOverlayTransition(channelId, MessageMode.CLOSED_CHAT.getOrdinal(), resultCode);
            } else if (resultCode == Overlay.ASSIGNMENT.getOrdinal()) {
                Long channelId = Long.parseLong(data.getExtras().getString("channel_id"));
                this.setOverlayTransition(channelId, MessageMode.OPEN_CHAT.getOrdinal(), resultCode);
            }
        }
    }

    private void setOverlayTransition(Long channelId, int messageMode, int resultCode) {
        boolean success = false;
        Conversation overlayConversation = null;
        for (int i = 0; i < this.conversationChatList.size(); ++i) {
            Conversation conversation1;
            if (!(this.conversationChatList.get(i) instanceof Conversation) || (conversation1 = (Conversation)this.conversationChatList.get(i)).getChannelId().compareTo(channelId) != 0) continue;
            success = true;
            if (resultCode != Overlay.ASSIGNMENT.getOrdinal()) {
                conversation1.setStatus(messageMode);
            }
            conversation1.setOverlay(resultCode);
            break;
        }
        if (success) {
            this.chatListAdapter.notifyDataSetChanged();
            this.removeConversation(channelId);
            if (resultCode != Overlay.ASSIGNMENT.getOrdinal()) {
                this.removeOverlay(overlayConversation);
            } else {
                this.removeConversation(channelId);
            }
        }
    }

    private void removeOverlay(final Conversation conversation) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                AllChatFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (conversation != null) {
                            conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                            AllChatFragment.this.chatListAdapter.notifyDataSetChanged();
                        }
                    }
                });
            }
        }, 1000L);
    }

    private void removeConversation(final Long channelId) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                AllChatFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < AllChatFragment.this.conversationChatList.size(); ++i) {
                            if (!(AllChatFragment.this.conversationChatList.get(i) instanceof Conversation) || channelId != ((Conversation)AllChatFragment.this.conversationChatList.get(i)).getChannelId()) continue;
                            AllChatFragment.this.conversationChatList.remove(i);
                            AllChatFragment.this.chatListAdapter.notifyItemRemoved(i);
                            HashMap<Integer, Integer> unreadCount = AgentCommonData.removeTotalUnreadCount(channelId.intValue());
                            AllChatFragment.this.sendUnreadCount(unreadCount);
                            break;
                        }
                    }
                });
            }
        }, 1000L);
    }

    private void setConversationChatCount(Conversation conversationCount) {
        try {
            for (Object conversation : this.conversationChatList) {
                if (!(conversation instanceof Conversation) || !((Conversation)conversation).getChannelId().equals(conversationCount.getChannelId())) continue;
                ((Conversation)conversation).setUnreadCount(0);
                HashMap<Integer, Integer> unreadCount = AgentCommonData.removeTotalUnreadCount(conversationCount.getChannelId().intValue());
                this.sendUnreadCount(unreadCount);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void conversationList(GetConversationResponse getConversationResponse, boolean isPagination, int fragmentType, int endPage) {
        this.getConversationResponse(getConversationResponse, isPagination, fragmentType, endPage);
    }

    @Override
    public void onError(APIError error, int fragmentType) {
        if (fragmentType != FragmentType.ALL_CHAT.getOrdinal()) {
            return;
        }
        this.setLlNoConversation(error.getMessage() == null ? "" : error.getMessage());
    }

    @Override
    public void offlineConversationList(int fragmentType, ArrayList<Object> arrayList) {
        boolean loader = true;
        if (fragmentType == FragmentType.ALL_CHAT.getOrdinal()) {
            if (fragmentType == FragmentType.ALL_CHAT.getOrdinal() && arrayList != null && arrayList.size() > 0) {
                this.conversationChatList.addAll(arrayList);
                this.chatListAdapter.notifyDataSetChanged();
                loader = false;
            }
            this.setConnectionManager(loader);
        }
    }

    @Override
    public void onAssignChat(JSONObject jsonObject) {
        HippoLog.e(TAG, "onAssignChat jsonObject: " + jsonObject);
        ArrayList<Conversation> allChatData = new ArrayList<Conversation>();
        for (Object obj : this.conversationChatList) {
            if (!(obj instanceof Conversation)) continue;
            Conversation conversation = (Conversation)obj;
            allChatData.add(conversation);
        }
        for (int i = 0; i < allChatData.size(); ++i) {
            if (((Conversation)allChatData.get(i)).getChannelId().compareTo(jsonObject.optLong("channel_id")) != 0) continue;
            Conversation conversation = allChatData.get(i);
            conversation.setMessage(jsonObject.optString("message", ""));
            conversation.setAgentId(jsonObject.optInt("assigned_to", 0));
            conversation.setAgentName(jsonObject.optString("assigned_to_name"));
            conversation.setLabel(jsonObject.optString("label", ""));
            if (jsonObject.optInt("notification_type", 0) == 3) {
                conversation.setLast_sent_by_id(jsonObject.optInt("assigned_by"));
                conversation.setLast_sent_by_full_name(jsonObject.optString("assigned_by_name"));
                conversation.setLast_sent_by_user_type(2);
            } else {
                conversation.setLast_sent_by_id(jsonObject.optInt("last_sent_by_id"));
                conversation.setLast_sent_by_full_name(jsonObject.optString("last_sent_by_full_name"));
                conversation.setLast_sent_by_user_type(jsonObject.optInt("last_sent_by_user_type"));
            }
            conversation.setLastUpdatedAt(jsonObject.optString("date_time", ""));
            conversation.setUnreadCount(0);
            break;
        }
        Collections.sort(allChatData, new Comparator<Conversation>(){

            @Override
            public int compare(Conversation o1, Conversation o2) {
                if (o1.getLastUpdatedAt() == null || o2.getLastUpdatedAt() == null) {
                    return 0;
                }
                return o2.getLastUpdatedAt().compareTo(o1.getLastUpdatedAt());
            }
        });
        this.setConversationChatData(allChatData, false);
    }

    @Override
    public void onControlChannelData(JSONObject jsonObject) {
        this.setControlChannelData(jsonObject);
    }

    @Override
    public void onRefreshData() {
        if (!this.isNetworkAvailable()) {
            this.swipeRefreshLayout.setRefreshing(false);
            return;
        }
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        this.getConversationData(0, false, this.conversationChatList.size(), false);
    }

    @Override
    public void onReadAll(JSONObject jsonObject) {
        if (jsonObject != null) {
            if (this.userData == null) {
                this.userData = AgentCommonData.getUserData();
            }
            if (jsonObject.optInt("user_id", 0) == this.userData.getUserId().intValue()) {
                for (Object obj : this.conversationChatList) {
                    Conversation conversation;
                    if (!(obj instanceof Conversation) || (conversation = (Conversation)obj).getChannelId().compareTo(jsonObject.optLong("channel_id")) != 0) continue;
                    conversation.setUnreadCount(0);
                    HashMap<Integer, Integer> unreadCount = AgentCommonData.removeTotalUnreadCount(conversation.getChannelId().intValue());
                    this.sendUnreadCount(unreadCount);
                    this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AllChatFragment.this.chatListAdapter.notifyDataSetChanged();
                        }
                    });
                    break;
                }
            }
        }
    }

    @Override
    public void updateCount(Long channelId) {
        try {
            for (Object obj : this.conversationChatList) {
                Conversation conversation;
                if (!(obj instanceof Conversation) || (conversation = (Conversation)obj).getChannelId().compareTo(channelId) != 0) continue;
                conversation.setUnreadCount(0);
                HashMap<Integer, Integer> unreadCount = AgentCommonData.addTotalUnreadCount(conversation.getChannelId().intValue(), conversation.getUnreadCount());
                this.sendUnreadCount(unreadCount);
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AllChatFragment.this.chatListAdapter.notifyDataSetChanged();
                    }
                });
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setControlChannelData(JSONObject jsonObject) {
        try {
            boolean newConversation = true;
            for (Object obj : this.conversationChatList) {
                Conversation conversation;
                if (!(obj instanceof Conversation) || (conversation = (Conversation)obj).getChannelId().compareTo(jsonObject.optLong("channel_id")) != 0) continue;
                newConversation = false;
                conversation.setMessage(jsonObject.optString("message", ""));
                conversation.setAgentId(jsonObject.optInt("agent_id", 0));
                conversation.setLast_sent_by_id(jsonObject.optInt("last_sent_by_id"));
                conversation.setLast_sent_by_full_name(jsonObject.optString("last_sent_by_full_name"));
                conversation.setLast_sent_by_user_type(jsonObject.optInt("last_sent_by_user_type"));
                conversation.setLastUpdatedAt(jsonObject.optString("date_time", ""));
                if (jsonObject.optInt("last_sent_by_id", -1) != this.userData.getUserId().intValue() && jsonObject.optInt("is_my_chat", 0) == 1 && (long)jsonObject.optInt("channel_id", -1) != AgentChatActivity.pushChannelId) {
                    conversation.setUnreadCount(conversation.getUnreadCount() + 1);
                    HashMap<Integer, Integer> unreadCount = AgentCommonData.addTotalUnreadCount(conversation.getChannelId().intValue(), conversation.getUnreadCount());
                    this.sendUnreadCount(unreadCount);
                    this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AllChatFragment.this.chatListAdapter.notifyDataSetChanged();
                        }
                    });
                }
                if (this.userData == null) {
                    this.userData = AgentCommonData.getUserData();
                }
                if (jsonObject.optInt("last_sent_by_id", -1) != this.userData.getUserId().intValue()) break;
                conversation.setUnreadCount(0);
                break;
            }
            if (newConversation) {
                HippoLog.v("New chat arrived", "send to unasssigned");
                Conversation conversation = new Conversation();
                conversation.setChannelId(jsonObject.optLong("channel_id"));
                conversation.setChannelName(jsonObject.optString("channel_name", ""));
                conversation.setUserId(jsonObject.optInt("user_id"));
                conversation.setLastUpdatedAt(jsonObject.optString("date_time", ""));
                conversation.setMessage(jsonObject.optString("message", ""));
                conversation.setLabel(jsonObject.optString("label", ""));
                conversation.setStatus(jsonObject.optInt("status", 1));
                conversation.setBotChannelName(jsonObject.optString("bot_channel_name", ""));
                if (jsonObject.optInt("is_my_chat", 0) == 1) {
                    conversation.setUnreadCount(jsonObject.optInt("unread_count", 1));
                } else {
                    conversation.setUnreadCount(jsonObject.optInt("unread_count", 0));
                }
                conversation.setAgentId(jsonObject.optInt("agent_id", 0));
                conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                this.conversationChatList.add(0, conversation);
                this.setLlNoConversation(null);
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AllChatFragment.this.chatListAdapter.notifyItemInserted(0);
                        if (AllChatFragment.this.layoutManager.findFirstVisibleItemPosition() == 0) {
                            AllChatFragment.this.listView.scrollToPosition(0);
                        } else if (AllChatFragment.this.layoutManager.findFirstVisibleItemPosition() > 0) {
                            AllChatFragment.this.newConversationSnackBar();
                        }
                    }
                });
                HashMap<Integer, Integer> unreadCount = AgentCommonData.addTotalUnreadCount(conversation.getChannelId().intValue(), conversation.getUnreadCount());
                this.sendUnreadCount(unreadCount);
            } else if (jsonObject.optInt("notification_type") != NotificationType.ASSIGNMENT.getOrdinal()) {
                ArrayList<Conversation> allChatData = new ArrayList<Conversation>();
                for (Object obj : this.conversationChatList) {
                    if (!(obj instanceof Conversation)) continue;
                    Conversation conversation = (Conversation)obj;
                    allChatData.add(conversation);
                }
                Collections.sort(allChatData, new Comparator<Conversation>(){

                    @Override
                    public int compare(Conversation o1, Conversation o2) {
                        if (o1.getLastUpdatedAt() == null || o2.getLastUpdatedAt() == null) {
                            return 0;
                        }
                        return o2.getLastUpdatedAt().compareTo(o1.getLastUpdatedAt());
                    }
                });
                this.setConversationChatData(allChatData, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void remove(final int position) {
        Conversation conversation = (Conversation)this.conversationChatList.get(position);
        conversation.setOverlay(Overlay.ASSIGNMENT.getOrdinal());
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AllChatFragment.this.chatListAdapter.notifyItemChanged(position);
            }
        });
        this.removeConversation(conversation.getChannelId());
    }

    private void sendUnreadCount(HashMap<Integer, Integer> unreadCount) {
        if (unreadCount == null) {
            unreadCount = AgentCommonData.getTotalUnreadCount();
        }
        int count = 0;
        for (Integer value : unreadCount.values()) {
            count += value.intValue();
        }
        if (HippoConfig.getInstance().getCallbackListener() != null) {
            HippoConfig.getInstance().getCallbackListener().count(count);
        }
    }

    private void addUnreadCount(ArrayList<Conversation> allChatData, boolean isPagination) {
        HashMap<Integer, Integer> hashMap = AgentCommonData.getTotalUnreadCount();
        for (Conversation conversation : allChatData) {
            hashMap.put(conversation.getChannelId().intValue(), conversation.getUnreadCount());
        }
        AgentCommonData.addTotalUnreadCount(hashMap);
        this.sendUnreadCount(null);
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }
}

