/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.graphics.PorterDuff;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import com.hippo.R;
import java.util.ArrayList;
import java.util.List;

public class TabAdapter
extends FragmentStatePagerAdapter {
    private final List<Fragment> mFragmentList = new ArrayList<Fragment>();
    private final List<String> mFragmentTitleList = new ArrayList<String>();
    private final List<Integer> mFragmentIconList = new ArrayList<Integer>();
    private Context context;

    public TabAdapter(FragmentManager fm, Context context) {
        super(fm);
        this.context = context;
    }

    public Fragment getItem(int position) {
        return this.mFragmentList.get(position);
    }

    public void addFragment(Fragment fragment, String title, int tabIcon) {
        this.mFragmentList.add(fragment);
        this.mFragmentTitleList.add(title);
        this.mFragmentIconList.add(tabIcon);
    }

    @Nullable
    public CharSequence getPageTitle(int position) {
        return null;
    }

    public int getCount() {
        return this.mFragmentList.size();
    }

    public View getTabView(int position) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.custom_tab_layout, null);
        TextView tabTextView = (TextView)view.findViewById(R.id.tabTextView);
        tabTextView.setText((CharSequence)this.mFragmentTitleList.get(position));
        ImageView tabImageView = (ImageView)view.findViewById(R.id.tabImageView);
        tabImageView.setImageResource(this.mFragmentIconList.get(position).intValue());
        tabTextView.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.tabUnselectedIconColor));
        tabImageView.setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.tabUnselectedIconColor), PorterDuff.Mode.SRC_ATOP);
        return view;
    }

    public View getSelectedTabView(int position) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.custom_tab_layout, null);
        TextView tabTextView = (TextView)view.findViewById(R.id.tabTextView);
        tabTextView.setText((CharSequence)this.mFragmentTitleList.get(position));
        tabTextView.setTextColor(-16777216);
        ImageView tabImageView = (ImageView)view.findViewById(R.id.tabImageView);
        tabImageView.setImageResource(this.mFragmentIconList.get(position).intValue());
        tabImageView.setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.tabSelectedIconColor), PorterDuff.Mode.SRC_ATOP);
        return view;
    }
}

