/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.showmoretextview;

import android.animation.LayoutTransition;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class ReadMoreOption {
    public static final int TYPE_LINE = 1;
    public static final int TYPE_CHARACTER = 2;
    private static final String TAG = ReadMoreOption.class.getSimpleName();
    private Context context;
    private int textLength;
    private int textLengthType;
    private String moreLabel;
    private String lessLabel;
    private int moreLabelColor;
    private int lessLabelColor;
    private boolean labelUnderLine;
    private boolean expandAnimation;
    private OptionClick optionClick;
    private int position;
    private int status;

    private ReadMoreOption(Builder builder) {
        this.context = builder.context;
        this.textLength = builder.textLength;
        this.textLengthType = builder.textLengthType;
        this.moreLabel = builder.moreLabel;
        this.lessLabel = builder.lessLabel;
        this.moreLabelColor = builder.moreLabelColor;
        this.lessLabelColor = builder.lessLabelColor;
        this.labelUnderLine = builder.labelUnderLine;
        this.expandAnimation = builder.expandAnimation;
        this.optionClick = builder.optionClick;
        this.position = builder.position;
        this.status = builder.status;
    }

    public void addReadLessTo(final TextView textView, final CharSequence text) {
        textView.post(new Runnable(){

            @Override
            public void run() {
                textView.setMaxLines(Integer.MAX_VALUE);
                SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(text).append((CharSequence)"...").append((CharSequence)ReadMoreOption.this.lessLabel);
                SpannableString ss = SpannableString.valueOf((CharSequence)spannableStringBuilder);
                ClickableSpan clickableSpan = new ClickableSpan(){

                    public void onClick(View view) {
                        new Handler().post(new Runnable(){

                            @Override
                            public void run() {
                                ReadMoreOption.this.addReadMoreTo(textView, text);
                                if (ReadMoreOption.this.optionClick != null) {
                                    ReadMoreOption.this.optionClick.onReadLessClickListener(ReadMoreOption.this.position);
                                }
                            }
                        });
                    }

                    public void updateDrawState(TextPaint ds) {
                        super.updateDrawState(ds);
                        ds.setUnderlineText(ReadMoreOption.this.labelUnderLine);
                        ds.setColor(ReadMoreOption.this.lessLabelColor);
                    }
                };
                ss.setSpan((Object)clickableSpan, ss.length() - ReadMoreOption.this.lessLabel.length(), ss.length(), 33);
                textView.setText((CharSequence)ss);
                textView.setMovementMethod(LinkMovementMethod.getInstance());
            }
        });
    }

    public void addReadMoreTo(final TextView textView, final CharSequence text) {
        if (this.textLengthType == 2) {
            if (text.length() <= this.textLength) {
                textView.setText(text);
                return;
            }
        } else {
            textView.setLines(this.textLength);
            textView.setText(text);
        }
        textView.post(new Runnable(){

            @Override
            public void run() {
                int textLengthNew = ReadMoreOption.this.textLength;
                if (ReadMoreOption.this.textLengthType == 1) {
                    int moreLabelLength;
                    if (textView.getLayout().getLineCount() <= ReadMoreOption.this.textLength) {
                        textView.setText(text);
                        return;
                    }
                    ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)textView.getLayoutParams();
                    int startIndex = textView.getLayout().getLineStart(ReadMoreOption.this.textLength - 1);
                    int endIndex = textView.getLayout().getLineEnd(ReadMoreOption.this.textLength - 1);
                    int charCount = endIndex - startIndex;
                    if (charCount >= (moreLabelLength = ReadMoreOption.this.moreLabel.length() + 4 + lp.rightMargin / 6)) {
                        CharSequence subString = text.subSequence(textView.getLayout().getLineStart(0), textView.getLayout().getLineEnd(ReadMoreOption.this.textLength - 1));
                        textLengthNew = subString.length() - (ReadMoreOption.this.moreLabel.length() + 4 + lp.rightMargin / 6);
                    } else {
                        CharSequence subString = text.subSequence(textView.getLayout().getLineStart(0), textView.getLayout().getLineStart(ReadMoreOption.this.textLength - 1));
                        textLengthNew = subString.length();
                    }
                }
                SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(text.subSequence(0, textLengthNew)).append((CharSequence)"...").append((CharSequence)ReadMoreOption.this.moreLabel);
                SpannableString ss = SpannableString.valueOf((CharSequence)spannableStringBuilder);
                ClickableSpan clickableSpan = new ClickableSpan(){

                    public void onClick(View view) {
                        ReadMoreOption.this.addReadLess(textView, text);
                        if (ReadMoreOption.this.optionClick != null) {
                            ReadMoreOption.this.optionClick.onReadMoreClickListener(ReadMoreOption.this.position);
                        }
                    }

                    public void updateDrawState(TextPaint ds) {
                        super.updateDrawState(ds);
                        ds.setUnderlineText(ReadMoreOption.this.labelUnderLine);
                        ds.setColor(ReadMoreOption.this.moreLabelColor);
                    }
                };
                ss.setSpan((Object)clickableSpan, ss.length() - ReadMoreOption.this.moreLabel.length(), ss.length(), 33);
                if (Build.VERSION.SDK_INT >= 16 && ReadMoreOption.this.expandAnimation) {
                    LayoutTransition layoutTransition = new LayoutTransition();
                    layoutTransition.enableTransitionType(4);
                    ((ViewGroup)textView.getParent()).setLayoutTransition(layoutTransition);
                }
                textView.setText((CharSequence)ss);
                textView.setMovementMethod(LinkMovementMethod.getInstance());
            }
        });
    }

    private void addReadLess(final TextView textView, final CharSequence text) {
        textView.setMaxLines(Integer.MAX_VALUE);
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(text).append((CharSequence)"...").append((CharSequence)this.lessLabel);
        SpannableString ss = SpannableString.valueOf((CharSequence)spannableStringBuilder);
        ClickableSpan clickableSpan = new ClickableSpan(){

            public void onClick(View view) {
                new Handler().post(new Runnable(){

                    @Override
                    public void run() {
                        ReadMoreOption.this.addReadMoreTo(textView, text);
                        if (ReadMoreOption.this.optionClick != null) {
                            ReadMoreOption.this.optionClick.onReadLessClickListener(ReadMoreOption.this.position);
                        }
                    }
                });
            }

            public void updateDrawState(TextPaint ds) {
                super.updateDrawState(ds);
                ds.setUnderlineText(ReadMoreOption.this.labelUnderLine);
                ds.setColor(ReadMoreOption.this.lessLabelColor);
            }
        };
        ss.setSpan((Object)clickableSpan, ss.length() - this.lessLabel.length(), ss.length(), 33);
        textView.setText((CharSequence)ss);
        textView.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public static interface OptionClick {
        public void onReadMoreClickListener(int var1);

        public void onReadLessClickListener(int var1);
    }

    public static class Builder {
        private Context context;
        private int textLength = 100;
        private int textLengthType = 2;
        private String moreLabel = "read more";
        private String lessLabel = "read less";
        private int moreLabelColor = Color.parseColor((String)"#ff00ff");
        private int lessLabelColor = Color.parseColor((String)"#ff00ff");
        private boolean labelUnderLine = false;
        private boolean expandAnimation = false;
        private int status;
        private OptionClick optionClick;
        private int position;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder textLength(int length, int textLengthType) {
            this.textLength = length;
            this.textLengthType = textLengthType;
            return this;
        }

        public Builder moreLabel(String moreLabel) {
            this.moreLabel = moreLabel;
            return this;
        }

        public Builder lessLabel(String lessLabel) {
            this.lessLabel = lessLabel;
            return this;
        }

        public Builder moreLabelColor(int moreLabelColor) {
            this.moreLabelColor = moreLabelColor;
            return this;
        }

        public Builder lessLabelColor(int lessLabelColor) {
            this.lessLabelColor = lessLabelColor;
            return this;
        }

        public Builder labelUnderLine(boolean labelUnderLine) {
            this.labelUnderLine = labelUnderLine;
            return this;
        }

        public Builder expandAnimation(boolean expandAnimation) {
            this.expandAnimation = expandAnimation;
            return this;
        }

        public Builder optionClick(OptionClick optionClick) {
            this.optionClick = optionClick;
            return this;
        }

        public Builder position(int position) {
            this.position = position;
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public ReadMoreOption build() {
            return new ReadMoreOption(this);
        }
    }
}

