/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.countrypicker;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.utils.countrypicker.CountriesAdapter;
import com.hippo.utils.countrypicker.Country;
import com.hippo.utils.countrypicker.OnCountryPickerListener;
import com.hippo.utils.countrypicker.OnItemClickListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CountryPickerDialog
extends DialogFragment
implements OnItemClickListener {
    private CountryPickerDialogInteractionListener dialogInteractionListener;
    private EditText searchEditText;
    private RecyclerView countriesRecyclerView;
    private CountriesAdapter adapter;
    private List<Country> searchResults;
    private OnCountryPickerListener listener;

    public static CountryPickerDialog newInstance() {
        return new CountryPickerDialog();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.hippo_country_picker, null);
        this.getDialog().setTitle(R.string.hippo_country_picker_header);
        this.searchEditText = (EditText)view.findViewById(R.id.country_code_picker_search);
        this.countriesRecyclerView = (RecyclerView)view.findViewById(R.id.countries_recycler_view);
        this.setupRecyclerView();
        if (!this.dialogInteractionListener.canSearch()) {
            this.searchEditText.setVisibility(8);
        } else {
            this.searchEditText.setVisibility(0);
        }
        this.searchEditText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable searchQuery) {
                CountryPickerDialog.this.search(searchQuery.toString());
            }
        });
        return view;
    }

    public void onStart() {
        super.onStart();
        WindowManager.LayoutParams params = this.getDialog().getWindow().getAttributes();
        params.width = -1;
        params.height = -1;
        this.getDialog().getWindow().setAttributes(params);
    }

    @Override
    public void onItemClicked(Country country) {
        if (this.listener != null) {
            this.listener.onSelectCountry(country);
        }
        this.dismiss();
    }

    public void setCountryPickerListener(OnCountryPickerListener listener) {
        this.listener = listener;
    }

    public void setDialogInteractionListener(CountryPickerDialogInteractionListener dialogInteractionListener) {
        this.dialogInteractionListener = dialogInteractionListener;
    }

    private void search(String searchQuery) {
        this.searchResults.clear();
        for (Country country : this.dialogInteractionListener.getAllCountries()) {
            if (!country.getName().toLowerCase(Locale.ENGLISH).contains(searchQuery.toLowerCase())) continue;
            this.searchResults.add(country);
        }
        this.dialogInteractionListener.sortCountries(this.searchResults);
        this.adapter.notifyDataSetChanged();
    }

    private void setupRecyclerView() {
        this.searchResults = new ArrayList<Country>();
        this.searchResults.addAll(this.dialogInteractionListener.getAllCountries());
        this.adapter = new CountriesAdapter((Context)this.getActivity(), this.searchResults, this);
        this.countriesRecyclerView.setHasFixedSize(true);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        layoutManager.setOrientation(1);
        this.countriesRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.countriesRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    public static interface CountryPickerDialogInteractionListener {
        public List<Country> getAllCountries();

        public void sortCountries(List<Country> var1);

        public boolean canSearch();
    }
}

