/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.Util.permissionHelper;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.hippo.agent.Util.permissionHelper.Permissions;
import com.hippo.agent.Util.permissionHelper.PermissionsResultAction;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PermissionsManager {
    private static final String TAG = PermissionsManager.class.getSimpleName();
    private final Set<String> mPendingRequests = new HashSet<String>(1);
    private final Set<String> mPermissions = new HashSet<String>(1);
    private final List<WeakReference<PermissionsResultAction>> mPendingActions = new ArrayList<WeakReference<PermissionsResultAction>>(1);
    private static PermissionsManager mInstance = null;

    public static PermissionsManager getInstance() {
        if (mInstance == null) {
            mInstance = new PermissionsManager();
        }
        return mInstance;
    }

    private PermissionsManager() {
        this.initializePermissionsMap();
    }

    private synchronized void initializePermissionsMap() {
        Field[] fields;
        for (Field field : fields = Manifest.permission.class.getFields()) {
            String name = null;
            try {
                name = (String)field.get("");
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"Could not access field", (Throwable)e);
            }
            this.mPermissions.add(name);
        }
    }

    @NonNull
    private synchronized String[] getManifestPermissions(@NonNull Activity activity) {
        String[] permissions;
        PackageInfo packageInfo = null;
        ArrayList<String> list = new ArrayList<String>(1);
        try {
            Log.d((String)TAG, (String)activity.getPackageName());
            packageInfo = activity.getPackageManager().getPackageInfo(activity.getPackageName(), 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"A problem occurred when retrieving permissions", (Throwable)e);
        }
        if (packageInfo != null && (permissions = packageInfo.requestedPermissions) != null) {
            for (String perm : permissions) {
                Log.d((String)TAG, (String)("Manifest contained permission: " + perm));
                list.add(perm);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private synchronized void addPendingAction(@NonNull String[] permissions, @Nullable PermissionsResultAction action) {
        if (action == null) {
            return;
        }
        action.registerPermissions(permissions);
        this.mPendingActions.add(new WeakReference<PermissionsResultAction>(action));
    }

    private synchronized void removePendingAction(@Nullable PermissionsResultAction action) {
        Iterator<WeakReference<PermissionsResultAction>> iterator = this.mPendingActions.iterator();
        while (iterator.hasNext()) {
            WeakReference<PermissionsResultAction> weakRef = iterator.next();
            if (weakRef.get() != action && weakRef.get() != null) continue;
            iterator.remove();
        }
    }

    public synchronized boolean hasPermission(@Nullable Context context, @NonNull String permission2) {
        return context != null && (ActivityCompat.checkSelfPermission((Context)context, (String)permission2) == 0 || !this.mPermissions.contains(permission2));
    }

    public synchronized boolean hasAllPermissions(@Nullable Context context, @NonNull String[] permissions) {
        if (context == null) {
            return false;
        }
        boolean hasAllPermissions = true;
        for (String perm : permissions) {
            hasAllPermissions &= this.hasPermission(context, perm);
        }
        return hasAllPermissions;
    }

    public synchronized void requestAllManifestPermissionsIfNecessary(@Nullable Activity activity, @Nullable PermissionsResultAction action) {
        if (activity == null) {
            return;
        }
        String[] perms = this.getManifestPermissions(activity);
        this.requestPermissionsIfNecessaryForResult(activity, perms, action);
    }

    public synchronized void requestPermissionsIfNecessaryForResult(@Nullable Activity activity, @NonNull String[] permissions, @Nullable PermissionsResultAction action) {
        if (activity == null) {
            return;
        }
        this.addPendingAction(permissions, action);
        if (Build.VERSION.SDK_INT < 23) {
            this.doPermissionWorkBeforeAndroidM(activity, permissions, action);
        } else {
            List<String> permList = this.getPermissionsListToRequest(activity, permissions, action);
            if (permList.isEmpty()) {
                this.removePendingAction(action);
            } else {
                String[] permsToRequest = permList.toArray(new String[permList.size()]);
                this.mPendingRequests.addAll(permList);
                ActivityCompat.requestPermissions((Activity)activity, (String[])permsToRequest, (int)1);
            }
        }
    }

    public synchronized void requestPermissionsIfNecessaryForResult(@NonNull Fragment fragment, @NonNull String[] permissions, @Nullable PermissionsResultAction action) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        this.addPendingAction(permissions, action);
        if (Build.VERSION.SDK_INT < 23) {
            this.doPermissionWorkBeforeAndroidM((Activity)activity, permissions, action);
        } else {
            List<String> permList = this.getPermissionsListToRequest((Activity)activity, permissions, action);
            if (permList.isEmpty()) {
                this.removePendingAction(action);
            } else {
                String[] permsToRequest = permList.toArray(new String[permList.size()]);
                this.mPendingRequests.addAll(permList);
                fragment.requestPermissions(permsToRequest, 1);
            }
        }
    }

    public synchronized void notifyPermissionsChange(@NonNull String[] permissions, @NonNull int[] results) {
        int size = permissions.length;
        if (results.length < size) {
            size = results.length;
        }
        Iterator<WeakReference<PermissionsResultAction>> iterator = this.mPendingActions.iterator();
        block0: while (iterator.hasNext()) {
            PermissionsResultAction action = (PermissionsResultAction)iterator.next().get();
            for (int n = 0; n < size; ++n) {
                if (action != null && !action.onResult(permissions[n], results[n])) continue;
                iterator.remove();
                continue block0;
            }
        }
        for (int n = 0; n < size; ++n) {
            this.mPendingRequests.remove(permissions[n]);
        }
    }

    private void doPermissionWorkBeforeAndroidM(@NonNull Activity activity, @NonNull String[] permissions, @Nullable PermissionsResultAction action) {
        for (String perm : permissions) {
            if (action == null) continue;
            if (!this.mPermissions.contains(perm)) {
                action.onResult(perm, Permissions.NOT_FOUND);
                continue;
            }
            if (ActivityCompat.checkSelfPermission((Context)activity, (String)perm) != 0) {
                action.onResult(perm, Permissions.DENIED);
                continue;
            }
            action.onResult(perm, Permissions.GRANTED);
        }
    }

    @NonNull
    private List<String> getPermissionsListToRequest(@NonNull Activity activity, @NonNull String[] permissions, @Nullable PermissionsResultAction action) {
        ArrayList<String> permList = new ArrayList<String>(permissions.length);
        for (String perm : permissions) {
            if (!this.mPermissions.contains(perm)) {
                if (action == null) continue;
                action.onResult(perm, Permissions.NOT_FOUND);
                continue;
            }
            if (ActivityCompat.checkSelfPermission((Context)activity, (String)perm) != 0) {
                if (this.mPendingRequests.contains(perm)) continue;
                permList.add(perm);
                continue;
            }
            if (action == null) continue;
            action.onResult(perm, Permissions.GRANTED);
        }
        return permList;
    }
}

