package com.hippo.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.hippo.R;
import com.hippo.adapter.PaymentGatewayAdapter;
import com.hippo.callback.OnPaymentItemClickListener;

/**
 * Created by gurmail on 2020-05-06.
 *
 * @author gurmail
 */
public class BottomSheetPopup extends BottomSheetDialogFragment implements OnPaymentItemClickListener {

    private RecyclerView recyclerView;
    private PaymentGatewayAdapter paymentAdapter;

    public static BottomSheetPopup newInstance() {
        BottomSheetPopup frag = new BottomSheetPopup();
        Bundle args = new Bundle();
        frag.setArguments(args);
        return frag;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        new BottomSheetDialog(requireContext(), getTheme());
        return inflater.inflate(R.layout.hippo_payment_bottom_sheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        recyclerView = view.findViewById(R.id.recyclerView);
        paymentAdapter = new PaymentGatewayAdapter(this);
        recyclerView.setAdapter(paymentAdapter);
    }

    @Override
    public int getTheme() {
        return R.style.AppBottomSheetDialogTheme;
    }

    @Override
    public void onItemClickListener() {

    }
}
