package com.hippo.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.hippo.R
import com.hippo.callback.OnPaymentItemClickListener
import kotlinx.android.synthetic.main.hippo_payment_item.view.*

/**
 * Created by gurmail on 2020-05-06.
 * @author gurmail
 */
class PaymentGatewayAdapter(var onItemListener: OnPaymentItemClickListener) : RecyclerView.Adapter<PaymentGatewayAdapter.ViewHolder>() {

    var context: Context? = null
    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(LayoutInflater.from(context).inflate(R.layout.hippo_payment_item, parent, false))
    }

    override fun getItemCount(): Int {
        return 1
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.bind(position, onItemListener)
    }

    class ViewHolder(itemView: View): RecyclerView.ViewHolder(itemView) {
        fun bind(position: Int, onItemListener: OnPaymentItemClickListener) = with(itemView) {
            itemView.item.setOnClickListener {
                onItemListener.onItemClickListener()
            }
        }
    }
}