/*
 * Decompiled with CFR 0.152.
 */
package faye;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippo.HippoConfig;
import com.hippo.constant.FuguAppConstant;
import com.hippo.model.FuguFileDetails;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import faye.ConnectionError;
import faye.FayeAgentListener;
import faye.FayeCallClientListener;
import faye.FayeClientListener;
import faye.FayeServiceListener;
import faye.MetaMessage;
import faye.WebSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.channels.NotYetConnectedException;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FayeClient
implements FuguAppConstant {
    private static final String LOG_TAG = FayeClient.class.getSimpleName();
    private WebSocket mWebSocket = null;
    private CopyOnWriteArrayList<FayeClientListener> fayeClientListenerList;
    private FayeClientListener mListener = null;
    private FayeClientListener mConnectionListener = null;
    private FayeCallClientListener mCallListener = null;
    private FayeServiceListener serviceListener = null;
    private FayeClientListener mNetworkListener = null;
    private FayeAgentListener mAgentListener = null;
    private HashSet<String> mChannels;
    private String mServerUrl = "";
    private boolean mFayeConnected = false;
    private boolean mIsConnectedServer = false;
    private MetaMessage mMetaMessage;
    private Handler mMessageHandler;

    public FayeClient(String url, MetaMessage meta) {
        HandlerThread thread = new HandlerThread("FayeHandler");
        thread.start();
        this.mMessageHandler = new Handler(thread.getLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 1: {
                        HippoLog.i(LOG_TAG, "onOpen() executed");
                        FayeClient.this.mIsConnectedServer = true;
                        FayeClient.this.handShake();
                        break;
                    }
                    case 2: {
                        HippoLog.i(LOG_TAG, "onClosed() executed");
                        FayeClient.this.mIsConnectedServer = false;
                        FayeClient.this.mFayeConnected = false;
                        if (FayeClient.this.mListener != null && FayeClient.this.mListener instanceof FayeClientListener) {
                            FayeClient.this.mListener.onDisconnectedServer(FayeClient.this);
                        } else {
                            FayeClient.this.sendLocalBroadcast(2);
                        }
                        if (FayeClient.this.mCallListener != null) {
                            FayeClient.this.mCallListener.onDisconnectedServer(FayeClient.this);
                        }
                        if (FayeClient.this.mNetworkListener != null) {
                            FayeClient.this.mNetworkListener.onDisconnectedServer(FayeClient.this);
                        }
                        if (FayeClient.this.mAgentListener != null) {
                            FayeClient.this.mAgentListener.onDisconnectedServer(FayeClient.this);
                        }
                        if (FayeClient.this.mConnectionListener == null) break;
                        FayeClient.this.mConnectionListener.onDisconnectedServer(FayeClient.this);
                        break;
                    }
                    case 3: {
                        try {
                            HippoLog.i(LOG_TAG, "onMessage executed");
                            FayeClient.this.handleFayeMessage((String)msg.obj);
                        }
                        catch (NotYetConnectedException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 5: {
                        if (FayeClient.this.getListener() != null) {
                            FayeClient.this.getListener().onPongReceived();
                        } else {
                            FayeClient.this.sendLocalBroadcast(1);
                        }
                        if (FayeClient.this.mNetworkListener != null) {
                            FayeClient.this.mNetworkListener.onPongReceived();
                        }
                        if (FayeClient.this.mAgentListener == null) break;
                        FayeClient.this.mAgentListener.onPongReceived();
                        break;
                    }
                    case 6: {
                        if (FayeClient.this.mListener != null) {
                            FayeClient.this.mListener.onNotConnected();
                        }
                        if (FayeClient.this.mConnectionListener == null) break;
                        FayeClient.this.mConnectionListener.onNotConnected();
                    }
                }
            }
        };
        this.mServerUrl = url;
        HippoLog.e("TAG", "faye url = " + url);
        this.mMetaMessage = meta;
        this.mChannels = new HashSet();
    }

    private void sendLocalBroadcast(int status) {
        block3: {
            try {
                if (HippoConfig.getInstance().getContext() != null) {
                    Intent mIntent = new Intent("fugu_listener_null");
                    mIntent.putExtra("status", status);
                    LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
                }
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }

    public FayeClientListener getListener() {
        return this.mListener;
    }

    public void setListener(FayeClientListener listener) {
        this.mListener = listener;
    }

    public FayeClientListener getmConnectionListener() {
        return this.mConnectionListener;
    }

    public void setmConnectionListener(FayeClientListener mConnectionListener) {
        this.mConnectionListener = mConnectionListener;
    }

    public FayeCallClientListener getmCallListener() {
        return this.mCallListener;
    }

    public void setmCallListener(FayeCallClientListener mCallListener) {
        this.mCallListener = mCallListener;
    }

    public FayeCallClientListener getCallListener() {
        return this.mCallListener;
    }

    public void setCallListener(FayeCallClientListener listener) {
        this.mCallListener = listener;
    }

    public FayeServiceListener getServiceListener() {
        return this.serviceListener;
    }

    public void setServiceListener(FayeServiceListener serviceListener) {
        this.serviceListener = serviceListener;
    }

    public FayeClientListener getmNetworkListener() {
        return this.mNetworkListener;
    }

    public void setNetworkListener(FayeClientListener networkListener) {
        this.mNetworkListener = networkListener;
    }

    public FayeAgentListener getAgentListener() {
        return this.mAgentListener;
    }

    public void setAgentListener(FayeAgentListener listener) {
        this.mAgentListener = listener;
    }

    public void addChannel(String channel) {
        this.mChannels.add(channel);
    }

    public HashSet<String> getmChannels() {
        return this.mChannels;
    }

    public boolean isConnectedServer() {
        return this.mIsConnectedServer;
    }

    public boolean isFayeConnected() {
        return this.mFayeConnected;
    }

    public void connectServer() {
        this.openWebSocketConnection();
    }

    public void disconnectServer() {
        for (String channel : this.mChannels) {
            this.unsubscribe(channel);
        }
        this.mChannels.clear();
        this.disconnect();
    }

    public void subscribeChannel(String channel) {
        this.mChannels.add(channel);
        this.subscribe(channel);
        HippoLog.v("channel------>>>>>>>>>>--------------", channel);
    }

    public void subscribeToChannels(String ... channels) {
        for (String channel : channels) {
            this.mChannels.add(channel);
            this.subscribe(channel);
        }
    }

    public void unsubscribeChannel(String channel) {
        if (this.mChannels.contains(channel)) {
            this.unsubscribe(channel);
            this.mChannels.remove(channel);
        }
    }

    public void unsubscribeChannels(String ... channels) {
        for (String channel : channels) {
            this.unsubscribe(channel);
        }
    }

    public void unsubscribeAll() {
        for (String channel : this.mChannels) {
            this.unsubscribe(channel);
        }
    }

    public void publish(String message, int messageType, String url, String thumbnailUrl, FuguFileDetails fileDetails, int notificationType, String uuid, int position, String channel, Long userId, String userName, Long channelId, int isTyping) {
        JSONObject messageJson = new JSONObject();
        String localDate = DateUtils.getFormattedDate(new Date());
        try {
            if (notificationType == 6) {
                messageJson.put("notification_type", notificationType);
                messageJson.put("channel_id", (Object)channelId);
            } else {
                messageJson.put("full_name", (Object)userName);
                messageJson.put("message", (Object)message);
                messageJson.put("message_type", messageType);
                messageJson.put("date_time", (Object)DateUtils.getInstance().convertToUTC(localDate));
                if (position == 0) {
                    messageJson.put("message_index", position);
                } else {
                    messageJson.put("message_index", position);
                }
                messageJson.put("UUID", (Object)uuid);
                if (messageType == 10 && !url.trim().isEmpty() && !thumbnailUrl.trim().isEmpty()) {
                    messageJson.put("image_url", (Object)url);
                    messageJson.put("thumbnail_url", (Object)thumbnailUrl);
                }
                if (messageType == 11 && !url.trim().isEmpty()) {
                    messageJson.put("url", (Object)url);
                    messageJson.put("file_name", (Object)fileDetails.getFileName());
                    messageJson.put("file_size", (Object)fileDetails.getFileSize());
                }
                if (messageType == 1) {
                    messageJson.put("is_typing", isTyping);
                } else {
                    messageJson.put("is_typing", 0);
                }
                messageJson.put("message_status", 4);
            }
            messageJson.put("user_id", (Object)String.valueOf(userId));
            messageJson.put("user_type", 1);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.publish(channel, messageJson, null, null);
    }

    public void publish(String channel, JSONObject data) {
        this.publish(channel, data, null, null);
    }

    public void publish(String channel, JSONObject data, String ext, String id2) {
        try {
            HippoLog.e("@@@@@@@@", channel + "%%%%%%%%%%%%%%%%%%%%%%% " + data);
            String publish = this.mMetaMessage.publish(channel, data, ext, id2);
            this.mWebSocket.send(publish);
        }
        catch (Exception e) {
            HippoLog.e(LOG_TAG, "Build publish message to JSON error" + e);
            this.connectServer();
        }
    }

    public void publish(String channel, JSONObject data, ConnectionError connectionError) {
        block2: {
            try {
                HippoLog.e("@@@@@@@@", "%%%%%%%%%%%%%%%%%%%%%%% " + data);
                String publish = this.mMetaMessage.publish(channel, data, null, null);
                this.mWebSocket.send(publish);
            }
            catch (Exception e) {
                HippoLog.e(LOG_TAG, "Build publish message to JSON error" + e);
                if (connectionError == null) break block2;
                connectionError.onError(data);
            }
        }
    }

    private Socket getSSLWebSocket() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, null, null);
            SSLSocketFactory factory = sslContext.getSocketFactory();
            return factory.createSocket();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void openWebSocketConnection() {
        WebSocketImpl.DEBUG = false;
        if (this.mWebSocket != null) {
            this.mWebSocket.close();
        }
        try {
            URI uri = new URI(this.mServerUrl);
            this.mWebSocket = new WebSocket(uri, this.mMessageHandler);
            this.mWebSocket.setConnectionLostTimeout(60);
            HippoLog.e("uri.getScheme()", "==" + uri.getScheme());
            if (uri.getScheme().equals("https") || uri.getScheme().equals("wss")) {
                this.mWebSocket.setSocket(this.getSSLWebSocket());
            }
            this.mWebSocket.connect();
        }
        catch (Exception e) {
            HippoLog.e(LOG_TAG, "Server URL error" + e);
        }
    }

    private void closeWebSocketConnection() {
        if (this.mWebSocket != null) {
            this.mWebSocket.close();
        }
        this.mNetworkListener = null;
    }

    private void handShake() {
        block4: {
            try {
                String handshake = this.mMetaMessage.handShake();
                this.mWebSocket.send(handshake);
            }
            catch (Exception e) {
                HippoLog.e(LOG_TAG, "HandShake message error" + e);
                if (this.mListener != null) {
                    this.mListener.onWebSocketError();
                }
                if (this.mConnectionListener != null) {
                    this.mConnectionListener.onWebSocketError();
                }
                if (this.mCallListener == null) break block4;
                this.mCallListener.onWebSocketError();
            }
        }
    }

    private void subscribe(String channel) {
        try {
            String subscribe = this.mMetaMessage.subscribe(channel);
            this.mWebSocket.send(subscribe);
        }
        catch (WebsocketNotConnectedException e) {
            if (this.mListener != null) {
                this.mListener.onWebSocketError();
            }
            if (this.mCallListener != null) {
                this.mCallListener.onWebSocketError();
            }
            if (this.mConnectionListener != null) {
                this.mConnectionListener.onWebSocketError();
            }
            if (this.mAgentListener != null) {
                this.mAgentListener.onWebSocketError();
            }
            this.mFayeConnected = false;
            e.printStackTrace();
            HippoLog.e(LOG_TAG, "Subscribe message error" + (Object)((Object)e));
        }
        catch (Exception e) {
            HippoLog.e(LOG_TAG, "Subscribe message error" + e);
        }
    }

    private void unsubscribe(String channel) {
        try {
            String unsubscribe = this.mMetaMessage.unsubscribe(channel);
            this.mWebSocket.send(unsubscribe);
            HippoLog.i(LOG_TAG, "UnSubscribe:" + channel);
        }
        catch (Exception e) {
            e.printStackTrace();
            HippoLog.e(LOG_TAG, "Unsubscribe message error: " + e);
        }
    }

    private void connect() {
        try {
            String connect = this.mMetaMessage.connect();
            this.mWebSocket.send(connect);
            this.mWebSocket.setConnectionLostTimeout(10);
        }
        catch (Exception e) {
            HippoLog.e(LOG_TAG, "Connect message error" + e);
        }
    }

    private void disconnect() {
        try {
            String disconnect = this.mMetaMessage.disconnect();
            this.mWebSocket.send(disconnect);
        }
        catch (Exception e) {
            HippoLog.e(LOG_TAG, "Disconnect message error" + e);
        }
    }

    public boolean hasSubscribed(String s) {
        return !this.mChannels.contains(s);
    }

    private void handleFayeMessage(String message) {
        HippoLog.v("handleFayeMessage", "handleFayeMessage = " + message);
        JSONArray arr = null;
        try {
            arr = new JSONArray(message);
        }
        catch (Exception e) {
            HippoLog.e(LOG_TAG, "Unknown message type: " + message + e);
        }
        int length = arr.length();
        for (int i = 0; i < length; ++i) {
            JSONObject obj = arr.optJSONObject(i);
            if (obj == null) continue;
            String channel = obj.optString("channel");
            boolean successful = obj.optBoolean("successful");
            if (channel.equals("/meta/handshake")) {
                if (successful) {
                    this.mMetaMessage.setClient(obj.optString("clientId"));
                    if (this.mListener != null && this.mListener instanceof FayeClientListener) {
                        this.mListener.onConnectedServer(this);
                    }
                    if (this.mCallListener != null) {
                        this.mCallListener.onConnectedServer(this);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onConnectedServer(this);
                    }
                    if (this.mNetworkListener != null) {
                        this.mNetworkListener.onConnectedServer(this);
                    }
                    if (this.mAgentListener != null) {
                        this.mAgentListener.onConnectedServer(this);
                    }
                    if (this.mConnectionListener != null) {
                        this.mConnectionListener.onConnectedServer(this);
                    }
                    this.connect();
                } else {
                    HippoLog.e(LOG_TAG, "Handshake Error: " + obj.toString());
                }
                return;
            }
            if (channel.equals("/meta/connect")) {
                if (successful) {
                    this.mFayeConnected = true;
                    this.connect();
                } else {
                    HippoLog.e(LOG_TAG, "Connecting Error: " + obj.toString());
                }
                return;
            }
            if (channel.equals("/meta/disconnect")) {
                if (successful) {
                    if (this.mListener != null && this.mListener instanceof FayeClientListener) {
                        this.mListener.onDisconnectedServer(this);
                    }
                    if (this.mCallListener != null) {
                        this.mCallListener.onDisconnectedServer(this);
                    }
                    if (this.mNetworkListener != null) {
                        this.mNetworkListener.onDisconnectedServer(this);
                    }
                    if (this.mAgentListener != null) {
                        this.mAgentListener.onDisconnectedServer(this);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onDisconnectedServer(this);
                    }
                    if (this.mConnectionListener != null) {
                        this.mConnectionListener.onDisconnectedServer(this);
                    }
                    this.mFayeConnected = false;
                    this.closeWebSocketConnection();
                } else {
                    HippoLog.e(LOG_TAG, "Disconnecting Error: " + obj.toString());
                }
                return;
            }
            if (channel.equals("/meta/subscribe")) {
                String subscription = obj.optString("subscription");
                if (successful) {
                    this.mFayeConnected = true;
                    HippoLog.i(LOG_TAG, "Subscribed channel " + subscription);
                } else {
                    HippoLog.e(LOG_TAG, "Subscribing channel " + subscription + " Error: " + obj.toString());
                }
                return;
            }
            if (channel.equals("/meta/unsubscribe")) {
                String subscription = obj.optString("subscription");
                if (successful) {
                    HippoLog.i(LOG_TAG, "Unsubscribed channel " + subscription);
                } else {
                    HippoLog.e(LOG_TAG, "Unsubscribing channel " + subscription + " Error: " + obj.toString());
                }
                return;
            }
            if (this.mChannels.contains(channel)) {
                String data = obj.optString("data", null);
                HippoLog.e("data", "data in faye = " + data);
                if (data != null) {
                    if (this.mListener != null && this.mListener instanceof FayeClientListener) {
                        this.mListener.onReceivedMessage(this, data, channel);
                    } else if (this.mAgentListener != null) {
                        this.mAgentListener.onReceivedMessage(this, data, channel);
                    }
                    if (this.mCallListener != null) {
                        this.mCallListener.onReceivedMessage(this, data, channel);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onReceivedMessage(this, data, channel);
                    }
                    if (this.mNetworkListener != null) {
                        this.mNetworkListener.onReceivedMessage(this, data, channel);
                    }
                    if (this.mConnectionListener != null) {
                        this.mConnectionListener.onReceivedMessage(this, data, channel);
                    }
                } else {
                    try {
                        if (obj.has("error")) {
                            if (this.mListener != null) {
                                this.mListener.onErrorReceived(this, obj.getString("error"), channel);
                            }
                            if (this.mCallListener != null) {
                                this.mCallListener.onErrorReceived(this, obj.getString("error"), channel);
                            }
                            if (this.serviceListener != null) {
                                this.serviceListener.onErrorReceived(this, obj.getString("error"), channel);
                            }
                            if (this.mConnectionListener != null) {
                                this.mConnectionListener.onErrorReceived(this, obj.getString("error"), channel);
                            }
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                HippoLog.e(LOG_TAG, "Cannot handle this message: " + obj.toString());
                String data = obj.optString("data", null);
                if (data != null) {
                    if (this.mListener != null && this.mListener instanceof FayeClientListener) {
                        this.mListener.onReceivedMessage(this, data, channel);
                    } else if (this.mAgentListener != null) {
                        this.mAgentListener.onReceivedMessage(this, data, channel);
                    }
                    if (this.mCallListener != null) {
                        this.mCallListener.onReceivedMessage(this, data, channel);
                    }
                    if (this.mNetworkListener != null) {
                        this.mNetworkListener.onReceivedMessage(this, data, channel);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onReceivedMessage(this, data, channel);
                    }
                    if (this.mConnectionListener != null) {
                        this.mConnectionListener.onReceivedMessage(this, data, channel);
                    }
                }
                try {
                    if (obj.has("error")) {
                        if (this.mListener != null) {
                            this.mListener.onErrorReceived(this, obj.getString("error"), channel);
                        }
                        if (this.mCallListener != null) {
                            this.mCallListener.onErrorReceived(this, obj.getString("error"), channel);
                        }
                        if (this.serviceListener != null) {
                            this.serviceListener.onErrorReceived(this, obj.getString("error"), channel);
                        }
                        if (this.mConnectionListener != null) {
                            this.mConnectionListener.onErrorReceived(this, obj.getString("error"), channel);
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
    }

    public boolean isOpened() {
        return this.mWebSocket != null && this.mWebSocket.isOpen() && this.mWebSocket.getSocket().isConnected();
    }
}

