/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.model;

import androidx.annotation.NonNull;
import com.hippo.agent.model.ListItem;
import com.hippo.agent.model.Message;
import com.hippo.constant.FuguAppConstant;

public class EventItem
extends ListItem
implements FuguAppConstant {
    @NonNull
    private Message event;

    public EventItem(@NonNull Message event) {
        this.event = event;
    }

    @NonNull
    public Message getEvent() {
        return this.event;
    }

    @Override
    public int getType() {
        int messageType = this.event.getMessageType();
        switch (messageType) {
            case 2: {
                return 3;
            }
            case 1: 
            case 3: 
            case 10: 
            case 19: {
                if (this.event.isSelf()) {
                    return 2;
                }
                return 1;
            }
            case 11: {
                if (this.event.isSelf()) {
                    if (this.event.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.VIDEO.toString())) {
                        return 12;
                    }
                    return 10;
                }
                if (this.event.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.VIDEO.toString())) {
                    return 13;
                }
                return 11;
            }
            case 18: {
                if (this.event.isSelf()) {
                    return 18;
                }
                return 19;
            }
            case 15: {
                return 2;
            }
            case 20: {
                return 20;
            }
        }
        if (this.event.isSelf()) {
            return -2;
        }
        return -1;
    }
}

