/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.os.CancellationSignal;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsProvider;
import android.util.Log;
import android.webkit.MimeTypeMap;
import androidx.annotation.RequiresApi;
import com.hippo.R;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@RequiresApi(api=19)
public class LocalStorageProvider
extends DocumentsProvider {
    public static final String AUTHORITY = "com.hippochat.localstorage.documents";
    private static final String[] DEFAULT_ROOT_PROJECTION = new String[]{"root_id", "flags", "title", "document_id", "icon", "available_bytes"};
    private static final String[] DEFAULT_DOCUMENT_PROJECTION = new String[]{"document_id", "_display_name", "flags", "mime_type", "_size", "last_modified"};

    public Cursor queryRoots(String[] projection) throws FileNotFoundException {
        MatrixCursor result = new MatrixCursor(projection != null ? projection : DEFAULT_ROOT_PROJECTION);
        File homeDir = Environment.getExternalStorageDirectory();
        MatrixCursor.RowBuilder row = result.newRow();
        row.add("root_id", (Object)homeDir.getAbsolutePath());
        row.add("document_id", (Object)homeDir.getAbsolutePath());
        row.add("title", (Object)this.getContext().getString(R.string.hippo_select_string));
        row.add("flags", (Object)3);
        row.add("icon", (Object)R.drawable.hippo_ic_photo_icon);
        row.add("available_bytes", (Object)homeDir.getFreeSpace());
        return result;
    }

    public String createDocument(String parentDocumentId, String mimeType, String displayName) throws FileNotFoundException {
        File newFile = new File(parentDocumentId, displayName);
        try {
            newFile.createNewFile();
            return newFile.getAbsolutePath();
        }
        catch (IOException e) {
            Log.e((String)LocalStorageProvider.class.getSimpleName(), (String)("Error creating new file " + newFile));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetFileDescriptor openDocumentThumbnail(String documentId, Point sizeHint, CancellationSignal signal) throws FileNotFoundException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)documentId, (BitmapFactory.Options)options);
        int targetHeight = 2 * sizeHint.y;
        int targetWidth = 2 * sizeHint.x;
        int height = options.outHeight;
        int width = options.outWidth;
        options.inSampleSize = 1;
        if (height > targetHeight || width > targetWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / options.inSampleSize > targetHeight || halfWidth / options.inSampleSize > targetWidth) {
                options.inSampleSize *= 2;
            }
        }
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)documentId, (BitmapFactory.Options)options);
        File tempFile = null;
        FileOutputStream out = null;
        try {
            tempFile = File.createTempFile("thumbnail", null, this.getContext().getCacheDir());
            out = new FileOutputStream(tempFile);
            bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)out);
        }
        catch (IOException e) {
            Log.e((String)LocalStorageProvider.class.getSimpleName(), (String)"Error writing thumbnail", (Throwable)e);
            AssetFileDescriptor assetFileDescriptor = null;
            return assetFileDescriptor;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    Log.e((String)LocalStorageProvider.class.getSimpleName(), (String)"Error closing thumbnail", (Throwable)e);
                }
            }
        }
        return new AssetFileDescriptor(ParcelFileDescriptor.open((File)tempFile, (int)0x10000000), 0L, -1L);
    }

    public Cursor queryChildDocuments(String parentDocumentId, String[] projection, String sortOrder) throws FileNotFoundException {
        MatrixCursor result = new MatrixCursor(projection != null ? projection : DEFAULT_DOCUMENT_PROJECTION);
        File parent = new File(parentDocumentId);
        for (File file : parent.listFiles()) {
            if (file.getName().startsWith(".")) continue;
            this.includeFile(result, file);
        }
        return result;
    }

    public Cursor queryDocument(String documentId, String[] projection) throws FileNotFoundException {
        MatrixCursor result = new MatrixCursor(projection != null ? projection : DEFAULT_DOCUMENT_PROJECTION);
        this.includeFile(result, new File(documentId));
        return result;
    }

    private void includeFile(MatrixCursor result, File file) throws FileNotFoundException {
        int flags;
        MatrixCursor.RowBuilder row = result.newRow();
        row.add("document_id", (Object)file.getAbsolutePath());
        row.add("_display_name", (Object)file.getName());
        String mimeType = this.getDocumentType(file.getAbsolutePath());
        row.add("mime_type", (Object)mimeType);
        int n = flags = file.canWrite() ? 6 : 0;
        if (mimeType.startsWith("image/")) {
            flags |= 1;
        }
        row.add("flags", (Object)flags);
        row.add("_size", (Object)file.length());
        row.add("last_modified", (Object)file.lastModified());
    }

    public String getDocumentType(String documentId) throws FileNotFoundException {
        File file = new File(documentId);
        if (file.isDirectory()) {
            return "vnd.android.document/directory";
        }
        int lastDot = file.getName().lastIndexOf(46);
        if (lastDot >= 0) {
            String extension = file.getName().substring(lastDot + 1);
            String mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
            if (mime != null) {
                return mime;
            }
        }
        return "application/octet-stream";
    }

    public void deleteDocument(String documentId) throws FileNotFoundException {
        new File(documentId).delete();
    }

    public ParcelFileDescriptor openDocument(String documentId, String mode, CancellationSignal signal) throws FileNotFoundException {
        boolean isWrite;
        File file = new File(documentId);
        boolean bl = isWrite = mode.indexOf(119) != -1;
        if (isWrite) {
            return ParcelFileDescriptor.open((File)file, (int)0x30000000);
        }
        return ParcelFileDescriptor.open((File)file, (int)0x10000000);
    }

    public boolean onCreate() {
        return true;
    }
}

