/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.Util;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatSpinner;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.agent.Util.SpinnerListener;
import com.hippo.agent.Util.WrapContentLinearLayoutManager;
import com.hippo.agent.model.broadcastResponse.Tag;
import com.hippo.agent.model.broadcastResponse.User;
import java.util.List;

public class MultiSpinnerSearch
extends AppCompatSpinner
implements DialogInterface.OnCancelListener {
    private static final String TAG = MultiSpinnerSearch.class.getSimpleName();
    private int LIST_TYPE = 0;
    private List<Tag> items;
    private List<User> userArray;
    private String defaultText = "";
    private String spinnerTitle = "";
    private SpinnerListener listener;
    public static AlertDialog.Builder builder;
    public static AlertDialog ad;
    private ListAdapter teamAdapter;
    private FleetListAdapter fleetListAdapter;

    public MultiSpinnerSearch(Context context) {
        super(context);
    }

    public MultiSpinnerSearch(Context arg0, AttributeSet arg1) {
        super(arg0, arg1);
        TypedArray a = arg0.obtainStyledAttributes(arg1, R.styleable.MultiSpinnerSearch);
        for (int i = 0; i < a.getIndexCount(); ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.MultiSpinnerSearch_hintText) {
                this.defaultText = this.spinnerTitle = a.getString(attr2);
            }
            if (attr2 != R.styleable.MultiSpinnerSearch_listType) continue;
            this.LIST_TYPE = a.getInt(attr2, 0);
            break;
        }
        a.recycle();
    }

    public MultiSpinnerSearch(Context arg0, AttributeSet arg1, int arg2) {
        super(arg0, arg1, arg2);
    }

    public void onCancel(DialogInterface dialog) {
        if (this.LIST_TYPE == 0) {
            this.listener.onItemsSelected(this.items);
        }
    }

    public boolean performClick() {
        builder = new AlertDialog.Builder(this.getContext(), R.style.dialog);
        builder.setTitle((CharSequence)this.spinnerTitle);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.fugu_alert_dialog_listview, null);
        builder.setView(view);
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.alertSearchListView);
        WrapContentLinearLayoutManager linearLayoutManager = new WrapContentLinearLayoutManager(this.getContext(), 1, false);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        recyclerView.setHasFixedSize(false);
        recyclerView.setDescendantFocusability(131072);
        recyclerView.requestFocus();
        if (this.LIST_TYPE == 0) {
            this.teamAdapter = new ListAdapter(this.getContext(), this.items);
            recyclerView.setAdapter((RecyclerView.Adapter)this.teamAdapter);
        } else {
            this.fleetListAdapter = new FleetListAdapter(this.getContext(), this.userArray);
            recyclerView.setAdapter((RecyclerView.Adapter)this.fleetListAdapter);
        }
        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        builder.setOnCancelListener((DialogInterface.OnCancelListener)this);
        ad = builder.show();
        return true;
    }

    public void setItems(List<Tag> items, SpinnerListener listener) {
        this.LIST_TYPE = 0;
        this.items = items;
        this.listener = listener;
    }

    public void setFleetItems(List<User> userArray, SpinnerListener listener) {
        this.LIST_TYPE = 1;
        this.userArray = userArray;
        this.listener = listener;
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView textView;
        CheckBox checkBox;
        RelativeLayout mainLayout;

        public ViewHolder(View itemView) {
            super(itemView);
            this.textView = (TextView)itemView.findViewById(R.id.alertTextView);
            this.checkBox = (CheckBox)itemView.findViewById(R.id.alertCheckbox);
            this.mainLayout = (RelativeLayout)itemView.findViewById(R.id.main_layout);
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = ViewHolder.this.getAdapterPosition();
                    if (MultiSpinnerSearch.this.LIST_TYPE == 0) {
                        if (pos == 0) {
                            for (int i = 0; i < MultiSpinnerSearch.this.items.size(); ++i) {
                                ((Tag)MultiSpinnerSearch.this.items.get(i)).setSelected(!((Tag)MultiSpinnerSearch.this.items.get(i)).isSelected());
                            }
                        } else {
                            ((Tag)MultiSpinnerSearch.this.items.get(pos)).setSelected(!((Tag)MultiSpinnerSearch.this.items.get(pos)).isSelected());
                            if (!((Tag)MultiSpinnerSearch.this.items.get(pos)).isSelected()) {
                                ((Tag)MultiSpinnerSearch.this.items.get(0)).setSelected(false);
                            } else {
                                for (int i = 1; i < MultiSpinnerSearch.this.items.size(); ++i) {
                                    if (!((Tag)MultiSpinnerSearch.this.items.get(i)).isSelected()) {
                                        ((Tag)MultiSpinnerSearch.this.items.get(0)).setSelected(false);
                                        break;
                                    }
                                    ((Tag)MultiSpinnerSearch.this.items.get(0)).setSelected(true);
                                }
                            }
                        }
                        MultiSpinnerSearch.this.teamAdapter.notifyDataSetChanged();
                    }
                }
            });
        }
    }

    public class FleetListAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private List<User> arrayList;
        private LayoutInflater inflater;

        public FleetListAdapter(Context context, List<User> arrayList) {
            this.arrayList = arrayList;
            this.inflater = LayoutInflater.from((Context)context);
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = this.inflater.inflate(R.layout.hippo_textview_for_spinner, parent, false);
            return new ViewHolder(view);
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            User data = this.arrayList.get(position);
            holder.textView.setText((CharSequence)data.getFullName());
            holder.textView.setTypeface(null, 0);
            holder.checkBox.setChecked(data.isSelected());
        }

        public int getItemCount() {
            return this.arrayList == null ? 0 : this.arrayList.size();
        }
    }

    public class ListAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private List<Tag> arrayList;
        private LayoutInflater inflater;

        public ListAdapter(Context context, List<Tag> arrayList) {
            this.arrayList = arrayList;
            this.inflater = LayoutInflater.from((Context)context);
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = this.inflater.inflate(R.layout.hippo_textview_for_spinner, parent, false);
            return new ViewHolder(view);
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            Tag data = this.arrayList.get(position);
            holder.textView.setText((CharSequence)data.getTagName());
            holder.textView.setTypeface(null, 0);
            holder.checkBox.setChecked(data.isSelected());
        }

        public int getItemCount() {
            return this.arrayList == null ? 0 : this.arrayList.size();
        }
    }
}

