/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.model.ContentValue;
import java.util.ArrayList;

public class TagsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    public ArrayList<ContentValue> arrayList = new ArrayList();
    private HippoColorConfig hippoColorConfig;
    private Context mContext;
    private OnTagClicked onTagClicked;

    public TagsAdapter(ArrayList<ContentValue> arrayList, HippoColorConfig hippoColorConfig, OnTagClicked onTagClicked) {
        this.arrayList = arrayList;
        this.hippoColorConfig = hippoColorConfig;
        this.onTagClicked = onTagClicked;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        this.mContext = viewGroup.getContext();
        return new ViewHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_tag_view, viewGroup, false));
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
        viewHolder.tagView.setText((CharSequence)this.arrayList.get(i).getBtnTitle());
        viewHolder.tagView.setTextColor(this.hippoColorConfig.getHippoBotConcentText());
        try {
            Drawable background = viewHolder.tagView.getBackground();
            if (background instanceof ShapeDrawable) {
                ((ShapeDrawable)background).getPaint().setColor(this.hippoColorConfig.getHippoBotConcentBtnBg());
            } else if (background instanceof GradientDrawable) {
                ((GradientDrawable)background).setColor(this.hippoColorConfig.getHippoBotConcentBtnBg());
                ((GradientDrawable)background).setStroke(2, this.hippoColorConfig.getHippoBotConcentText());
            } else if (background instanceof ColorDrawable) {
                ((ColorDrawable)background).setColor(this.hippoColorConfig.getHippoBotConcentBtnBg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.arrayList.size();
    }

    public static interface OnTagClicked {
        public void onClick(int var1, ContentValue var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tagView;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tagView = (TextView)itemView.findViewById(R.id.tagView);
            this.tagView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TagsAdapter.this.onTagClicked != null) {
                        TagsAdapter.this.onTagClicked.onClick(ViewHolder.this.getAdapterPosition(), TagsAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition()));
                    }
                }
            });
        }
    }
}

