package com.hippo.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import com.google.android.material.appbar.AppBarLayout;
import androidx.core.content.ContextCompat;
import androidx.appcompat.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.model.AgentInfoResponse;
import com.hippo.model.CustomField;
import com.hippo.model.HippoUserProfileModel;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.RoundedCornersTransformation;

import java.util.ArrayList;

/**
 * Created by gurmail on 2019-11-13.
 *
 * @author gurmail
 */
public class ProfileFragmentDialog extends DialogFragment implements AppBarLayout.OnOffsetChangedListener {

    private HippoUserProfileModel profileModel;
    private ImageView imageView;
    private LinearLayout contentLayout;

    protected AppBarLayout appBarLayout;
    protected Toolbar toolbar;

    public static ProfileFragmentDialog newInstance(HippoUserProfileModel profileModel) {
        ProfileFragmentDialog fragment = new ProfileFragmentDialog();

        Bundle bundle = new Bundle();
        bundle.putSerializable("profileModel", profileModel);
        bundle.putBoolean("fullScreen", true);

        fragment.setArguments(bundle);

        return fragment;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hippo_profile_fragment, container, false);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
    }


    @Override
    public void onResume() {
        super.onResume();

    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.ivBackBtn) {
        }
    }


    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            if (getArguments() != null) {
                profileModel = (HippoUserProfileModel) getArguments().getSerializable("profileModel");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        setStyle(DialogFragment.STYLE_NORMAL, R.style.FullScreenDialogStyle);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        imageView = view.findViewById(R.id.image);
        contentLayout = view.findViewById(R.id.contentLayout);

        appBarLayout = view.findViewById(R.id.appbar);
        toolbar = view.findViewById(R.id.toolbar);

//        setSupportActionBar(toolbar);
//        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        appBarLayout.addOnOffsetChangedListener(this);

        RequestOptions myOptions = RequestOptions
                .bitmapTransform(new RoundedCornersTransformation(getActivity(), 4, 1))
                .placeholder(ContextCompat.getDrawable(getActivity(), R.drawable.hippo_placeholder))
                .fitCenter()
                .dontAnimate()
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .error(ContextCompat.getDrawable(getActivity(), R.drawable.hippo_placeholder));
        Glide.with(getActivity()).load(profileModel.getImageUrl())
                .apply(myOptions)
                .into(imageView);

        getAgentInfo();

    }

    private void getAgentInfo() {
        CommonParams params = new CommonParams.Builder()
                .add("app_secret_key", HippoConfig.getInstance().getAppKey())
                .add("en_user_id", profileModel.getEnUserId())
                .add("channel_id", profileModel.getChannelID())
                .build();

        RestClient.getApiInterface().getAgentInfo(params.getMap()).enqueue(new ResponseResolver<AgentInfoResponse>(getActivity(), true, true) {
            @Override
            public void success(AgentInfoResponse commonResponse) {

                ArrayList<CustomField> fields = new ArrayList<>();
                for(CustomField field : commonResponse.getData().getCustomFields()) {
                    if(field.getShowToCustomer()) {
                        //fields.add(field);
                        contentLayout.addView(getViews(field.getDisplayName(), field.getValue()));
                    }
                }

            }

            @Override
            public void failure(APIError error) {

            }
        });
    }

    View view;

    private View getViews(String titleStr, String detailStr) {
        LayoutInflater layoutInflater = (LayoutInflater) getActivity().getBaseContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        view = layoutInflater.inflate(R.layout.hippo_content_main, null, false);
        TextView title = view.findViewById(R.id.title);
        TextView detail = view.findViewById(R.id.detail);

        title.setText(titleStr);
        detail.setText(detailStr);

        return view;
    }


    @Override
    public void onOffsetChanged(AppBarLayout appBarLayout, int i) {

    }
}
