/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.hippoHeaderBehavior;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.appbar.AppBarLayout;
import com.hippo.R;
import com.hippo.utils.hippoHeaderBehavior.HippoHeaderView;

public class HippoHeaderBehavior
extends CoordinatorLayout.Behavior<HippoHeaderView> {
    private Context mContext;
    private int mStartMarginLeft;
    private int mEndMarginLeft;
    private int mMarginRight;
    private int mStartMarginBottom;
    private float mTitleStartSize;
    private float mTitleEndSize;
    private boolean isHide;

    public HippoHeaderBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
    }

    public HippoHeaderBehavior(Context context, AttributeSet attrs, Context mContext) {
        super(context, attrs);
        this.mContext = mContext;
    }

    public static int getToolbarHeight(Context context) {
        int result = 0;
        TypedValue tv = new TypedValue();
        if (context.getTheme().resolveAttribute(16843499, tv, true)) {
            result = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
        return result;
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, HippoHeaderView child, View dependency) {
        return dependency instanceof AppBarLayout;
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, HippoHeaderView child, View dependency) {
        this.shouldInitProperties();
        int maxScroll = ((AppBarLayout)dependency).getTotalScrollRange();
        float percentage = Math.abs(dependency.getY()) / (float)maxScroll;
        float childPosition = (float)dependency.getHeight() + dependency.getY() - (float)child.getHeight() - (float)(HippoHeaderBehavior.getToolbarHeight(this.mContext) - child.getHeight()) * percentage / 2.0f;
        childPosition -= (float)this.mStartMarginBottom * (1.0f - percentage);
        CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
        if (Math.abs(dependency.getY()) >= (float)(maxScroll / 2)) {
            float layoutPercentage = (Math.abs(dependency.getY()) - (float)(maxScroll / 2)) / (float)Math.abs(maxScroll / 2);
            lp.leftMargin = (int)(layoutPercentage * (float)this.mEndMarginLeft) + this.mStartMarginLeft;
            child.setTextSize(this.getTranslationOffset(this.mTitleStartSize, this.mTitleEndSize, layoutPercentage));
        } else {
            lp.leftMargin = this.mStartMarginLeft;
        }
        lp.rightMargin = this.mMarginRight;
        child.setLayoutParams((ViewGroup.LayoutParams)lp);
        child.setY(childPosition);
        if (this.isHide && percentage < 1.0f) {
            child.setVisibility(0);
            this.isHide = false;
        } else if (!this.isHide && percentage == 1.0f) {
            child.setVisibility(8);
            this.isHide = true;
        }
        return true;
    }

    protected float getTranslationOffset(float expandedOffset, float collapsedOffset, float ratio) {
        return expandedOffset + ratio * (collapsedOffset - expandedOffset);
    }

    private void shouldInitProperties() {
        if (this.mStartMarginLeft == 0) {
            this.mStartMarginLeft = this.mContext.getResources().getDimensionPixelOffset(R.dimen.header_view_start_margin_left);
        }
        if (this.mEndMarginLeft == 0) {
            this.mEndMarginLeft = this.mContext.getResources().getDimensionPixelOffset(R.dimen.header_view_end_margin_left);
        }
        if (this.mStartMarginBottom == 0) {
            this.mStartMarginBottom = this.mContext.getResources().getDimensionPixelOffset(R.dimen.header_view_start_margin_bottom);
        }
        if (this.mMarginRight == 0) {
            this.mMarginRight = this.mContext.getResources().getDimensionPixelOffset(R.dimen.header_view_end_margin_right);
        }
        if (this.mTitleStartSize == 0.0f) {
            this.mTitleEndSize = this.mContext.getResources().getDimensionPixelSize(R.dimen.header_view_end_text_size);
        }
        if (this.mTitleStartSize == 0.0f) {
            this.mTitleStartSize = this.mContext.getResources().getDimensionPixelSize(R.dimen.header_view_start_text_size);
        }
    }
}

