/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.apis;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.hippo.CaptureUserData;
import com.hippo.GroupingTag;
import com.hippo.HippoConfig;
import com.hippo.HippoConfigAttributes;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.FuguDeviceDetails;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.UserInfoModel;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.ApiInterface;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.CommonResponse;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.hippo.utils.fileUpload.Prefs;
import faye.ConnectionManager;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ApiPutUserDetails
implements FuguAppConstant {
    public Activity activity;
    private Callback callback;
    private CaptureUserData userData;
    private boolean fetchAllList = false;

    public ApiPutUserDetails(Activity activity, Callback callback) {
        this.activity = activity;
        this.callback = callback;
        this.fetchAllList = false;
    }

    public void sendUserDetails(String resellerToken, int referenceId) {
        this.sendUserDetails(resellerToken, referenceId, HippoConfig.progressLoader);
    }

    public void sendUserDetails(String resellerToken, int referenceId, boolean showLoading, boolean fetchAllList) {
        this.fetchAllList = fetchAllList;
        this.sendUserDetails(resellerToken, referenceId, showLoading);
    }

    public void sendUserDetails(String resellerToken, int referenceId, boolean showLoading) {
        String deviceToken;
        HashMap<String, Object> commonParamsMAp;
        block41: {
            HippoLog.v("inside sendUserDetails", "inside sendUserDetails");
            Gson gson = new GsonBuilder().create();
            JsonObject deviceDetailsJson = null;
            try {
                deviceDetailsJson = gson.toJsonTree((Object)new FuguDeviceDetails(this.getAppVersion()).getDeviceDetails()).getAsJsonObject();
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            HippoConfigAttributes attributes = CommonData.getAttributes();
            commonParamsMAp = new HashMap<String, Object>();
            if (attributes.isResellerApi()) {
                if (TextUtils.isEmpty((CharSequence)resellerToken)) {
                    resellerToken = attributes.getResellerToken();
                }
                if (TextUtils.isEmpty((CharSequence)resellerToken)) {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onFailure("Reseller Token can't be empty");
                    }
                    return;
                }
                commonParamsMAp.put("reseller_token", resellerToken);
                commonParamsMAp.put("reference_id", String.valueOf(referenceId));
                try {
                    CommonData.saveResellerData(resellerToken, referenceId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                if (TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getAppKey()) && !TextUtils.isEmpty((CharSequence)attributes.getAppKey())) {
                    HippoConfig.getInstance().appKey = attributes.getAppKey();
                }
                if (TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getAppKey())) {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onFailure("App secret key can't be empty");
                    }
                    return;
                }
                commonParamsMAp.put("app_secret_key", HippoConfig.getInstance().getAppKey());
            }
            commonParamsMAp.put("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this.activity));
            commonParamsMAp.put("app_type", HippoConfig.getInstance().getAppType());
            commonParamsMAp.put("device_type", 1);
            commonParamsMAp.put("app_version", "2.5.1");
            commonParamsMAp.put("app_version_code", 251);
            commonParamsMAp.put("device_details", deviceDetailsJson);
            this.userData = HippoConfig.getInstance().getUserData(false);
            if (this.userData != null) {
                if (!TextUtils.isEmpty((CharSequence)this.userData.getUserUniqueKey())) {
                    commonParamsMAp.put("user_unique_key", this.userData.getUserUniqueKey());
                }
                if (!TextUtils.isEmpty((CharSequence)this.userData.getFullName())) {
                    commonParamsMAp.put("full_name", this.userData.getFullName());
                }
                if (!TextUtils.isEmpty((CharSequence)this.userData.getEmail())) {
                    commonParamsMAp.put("email", this.userData.getEmail());
                }
                if (!TextUtils.isEmpty((CharSequence)this.userData.getPhoneNumber())) {
                    String contact = this.userData.getPhoneNumber();
                    commonParamsMAp.put("phone_number", contact);
                }
                if (!TextUtils.isEmpty((CharSequence)CommonData.getImagePath())) {
                    commonParamsMAp.put("user_image", CommonData.getImagePath());
                }
                JSONObject attJson = new JSONObject();
                JSONObject addressJson = new JSONObject();
                JSONObject userInfo = new JSONObject();
                if (!TextUtils.isEmpty((CharSequence)CommonData.getUserCountryCode())) {
                    try {
                        userInfo.put("country_code", (Object)CommonData.getUserCountryCode());
                        userInfo.put("continent_code", (Object)CommonData.getUserContCode());
                        attJson.put("country_info", (Object)userInfo);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    if (!TextUtils.isEmpty((CharSequence)this.userData.getAddressLine1())) {
                        addressJson.put("address_line1", (Object)this.userData.getAddressLine1());
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.userData.getAddressLine2())) {
                        addressJson.put("address_line2", (Object)this.userData.getAddressLine2());
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.userData.getCity())) {
                        addressJson.put("city", (Object)this.userData.getCity());
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.userData.getRegion())) {
                        addressJson.put("region", (Object)this.userData.getRegion());
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.userData.getCountry())) {
                        addressJson.put("country", (Object)this.userData.getCountry());
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.userData.getZipCode())) {
                        addressJson.put("zip_code", (Object)this.userData.getZipCode());
                    }
                    if (this.userData.getLatitude() != 0.0 && this.userData.getLongitude() != 0.0) {
                        attJson.put("lat_long", (Object)String.valueOf(this.userData.getLatitude() + "," + this.userData.getLongitude()));
                    }
                    attJson.put("ip_address", (Object)CommonData.getLocalIpAddress());
                    attJson.put("address", (Object)addressJson);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                commonParamsMAp.put("attributes", attJson);
                commonParamsMAp.put("custom_attributes", new JSONObject(this.userData.getCustom_attributes()));
                if (!this.userData.getTags().isEmpty()) {
                    ArrayList<GroupingTag> groupingTags = new ArrayList<GroupingTag>();
                    for (GroupingTag tag : this.userData.getTags()) {
                        GroupingTag groupingTag = new GroupingTag();
                        if (!TextUtils.isEmpty((CharSequence)tag.getTagName())) {
                            groupingTag.setTagName(tag.getTagName());
                        }
                        if (tag.getTeamId() != null) {
                            groupingTag.setTeamId(tag.getTeamId());
                        }
                        if (TextUtils.isEmpty((CharSequence)tag.getTagName()) && tag.getTeamId() == null) continue;
                        groupingTags.add(groupingTag);
                    }
                    commonParamsMAp.put("grouping_tags", new Gson().toJson(groupingTags));
                } else {
                    commonParamsMAp.put("grouping_tags", "[]");
                }
            }
            deviceToken = null;
            try {
                deviceToken = CommonData.getDeviceToken();
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block41;
                e.printStackTrace();
            }
        }
        if (!TextUtils.isEmpty((CharSequence)deviceToken)) {
            commonParamsMAp.put("device_token", deviceToken);
        }
        if (!this.fetchAllList) {
            commonParamsMAp.put("neglect_conversations", true);
        }
        HippoLog.e("Fugu Config sendUserDetails maps", "==" + commonParamsMAp.toString());
        CommonData.savePutUserParams(commonParamsMAp);
        if (!TextUtils.isEmpty((CharSequence)resellerToken)) {
            this.apiPutUserDetailReseller(commonParamsMAp);
        } else {
            this.apiPutUserDetail(commonParamsMAp, showLoading);
        }
    }

    public void updateUserData(HashMap<String, Object> commonParamsMap) {
        if (commonParamsMap.containsKey("reseller_token")) {
            this.apiPutUserDetailReseller(commonParamsMap, HippoConfig.progressLoader, true);
        } else {
            this.apiPutUserDetail(commonParamsMap, HippoConfig.progressLoader, true);
        }
    }

    private void apiPutUserDetail(HashMap<String, Object> commonParams, boolean showLoading) {
        this.apiPutUserDetail(commonParams, showLoading, false);
    }

    private void apiPutUserDetail(HashMap<String, Object> commonParams, boolean showLoading, boolean showError) {
        try {
            if (HippoConfig.getInstance().getOnApiCallback() != null) {
                HippoConfig.getInstance().getOnApiCallback().onProcessing();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonParams params = new CommonParams.Builder().putMap(commonParams).build();
        RestClient.getApiInterface().putUserDetails(params.getMap()).enqueue((retrofit2.Callback)new ResponseResolver<FuguPutUserDetailsResponse>(this.activity, Boolean.valueOf(showLoading), Boolean.valueOf(showError)){

            @Override
            public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
                CommonData.setUserDetails(fuguPutUserDetailsResponse);
                try {
                    CommonData.setConversationList(fuguPutUserDetailsResponse.getData().getFuguConversations());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HippoConfig.getInstance().getUserData().setUserId(fuguPutUserDetailsResponse.getData().getUserId());
                HippoConfig.getInstance().getUserData().setEnUserId(fuguPutUserDetailsResponse.getData().getEn_user_id());
                CommonData.saveUserData(HippoConfig.getInstance().getUserData());
                HippoLog.e("en_user_id", fuguPutUserDetailsResponse.getData().getEn_user_id());
                if (ApiPutUserDetails.this.activity != null) {
                    Prefs.with((Context)ApiPutUserDetails.this.activity).save("en_user_id", fuguPutUserDetailsResponse.getData().getEn_user_id());
                    Prefs.with((Context)ApiPutUserDetails.this.activity).save("user_id", fuguPutUserDetailsResponse.getData().getUserId());
                    Prefs.with((Context)ApiPutUserDetails.this.activity).save("full_name", fuguPutUserDetailsResponse.getData().getFullName());
                    Prefs.with((Context)ApiPutUserDetails.this.activity).save("email", fuguPutUserDetailsResponse.getData().getEmail());
                }
                try {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onSucess();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ApiPutUserDetails.this.callback.onSuccess();
                ConnectionManager.INSTANCE.initFayeConnection();
                ConnectionManager.INSTANCE.subScribeChannel("/" + fuguPutUserDetailsResponse.getData().getUserChannel());
            }

            @Override
            public void failure(APIError error) {
                try {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onFailure(error.getMessage());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ApiPutUserDetails.this.callback.onFailure();
            }
        });
    }

    private void apiPutUserDetailReseller(HashMap<String, Object> commonParams) {
        this.apiPutUserDetailReseller(commonParams, false, false);
    }

    private void apiPutUserDetailReseller(HashMap<String, Object> commonParams, boolean showLoading, boolean showError) {
        try {
            if (HippoConfig.getInstance().getOnApiCallback() != null) {
                HippoConfig.getInstance().getOnApiCallback().onProcessing();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonParams params = new CommonParams.Builder().putMap(commonParams).build();
        RestClient.getApiInterface().putUserDetailsReseller(params.getMap()).enqueue((retrofit2.Callback)new ResponseResolver<FuguPutUserDetailsResponse>(this.activity, Boolean.valueOf(false), Boolean.valueOf(false)){

            @Override
            public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
                CommonData.setUserDetails(fuguPutUserDetailsResponse);
                try {
                    CommonData.setConversationList(fuguPutUserDetailsResponse.getData().getFuguConversations());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HippoConfig.getInstance().getUserData().setUserId(fuguPutUserDetailsResponse.getData().getUserId());
                HippoConfig.getInstance().getUserData().setEnUserId(fuguPutUserDetailsResponse.getData().getEn_user_id());
                CommonData.saveUserData(HippoConfig.getInstance().getUserData());
                HippoLog.e("en_user_id", fuguPutUserDetailsResponse.getData().getEn_user_id());
                if (fuguPutUserDetailsResponse.getData().getAppSecretKey() != null && !TextUtils.isEmpty((CharSequence)fuguPutUserDetailsResponse.getData().getAppSecretKey())) {
                    HippoConfig.getInstance().appKey = fuguPutUserDetailsResponse.getData().getAppSecretKey();
                    CommonData.setAppSecretKey(fuguPutUserDetailsResponse.getData().getAppSecretKey());
                }
                if (ApiPutUserDetails.this.activity != null) {
                    Prefs.with((Context)ApiPutUserDetails.this.activity).save("en_user_id", fuguPutUserDetailsResponse.getData().getEn_user_id());
                    Prefs.with((Context)ApiPutUserDetails.this.activity).save("user_id", fuguPutUserDetailsResponse.getData().getUserId());
                    Prefs.with((Context)ApiPutUserDetails.this.activity).save("full_name", fuguPutUserDetailsResponse.getData().getFullName());
                    Prefs.with((Context)ApiPutUserDetails.this.activity).save("email", fuguPutUserDetailsResponse.getData().getEmail());
                }
                try {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onSucess();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ApiPutUserDetails.this.callback.onSuccess();
                ConnectionManager.INSTANCE.initFayeConnection();
                ConnectionManager.INSTANCE.subScribeChannel("/" + fuguPutUserDetailsResponse.getData().getUserChannel());
            }

            @Override
            public void failure(APIError error) {
                try {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onFailure(error.getMessage());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ApiPutUserDetails.this.callback.onFailure();
            }
        });
    }

    private int getAppVersion() {
        try {
            return this.activity.getPackageManager().getPackageInfo((String)this.activity.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void getUserContryInfo(final HippoConfigAttributes attributes, final UserCallback callback) {
        block2: {
            try {
                Gson gson = new GsonBuilder().setLenient().create();
                Retrofit retrofit = new Retrofit.Builder().baseUrl("https://ip.tookanapp.com:8000").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
                ApiInterface gerritAPI = (ApiInterface)retrofit.create(ApiInterface.class);
                Call<UserInfoModel> call = gerritAPI.getUserInfo();
                call.enqueue((retrofit2.Callback)new ResponseResolver<UserInfoModel>(){

                    @Override
                    public void success(UserInfoModel userInfoModel) {
                        try {
                            CommonData.setUserContCode(userInfoModel.getData().getContinentCode());
                            CommonData.setUserCountryCode(userInfoModel.getData().getCountryCode());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (callback != null) {
                            callback.onSuccess(userInfoModel, attributes);
                        }
                    }

                    @Override
                    public void failure(APIError error) {
                        if (callback != null) {
                            callback.onSuccess(null, attributes);
                        }
                    }
                });
            }
            catch (Exception e) {
                if (callback == null) break block2;
                callback.onSuccess(null, attributes);
            }
        }
    }

    public void stopRideStatus() {
        CommonParams params = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_user_id", HippoConfig.getInstance().getUserData().getEnUserId()).build();
        RestClient.getApiInterface().stopRideStatus(params.getMap()).enqueue((retrofit2.Callback)new ResponseResolver<CommonResponse>(){

            @Override
            public void success(CommonResponse commonResponse) {
                if (ApiPutUserDetails.this.callback != null) {
                    ApiPutUserDetails.this.callback.onSuccess();
                }
            }

            @Override
            public void failure(APIError error) {
                if (ApiPutUserDetails.this.callback != null) {
                    ApiPutUserDetails.this.callback.onFailure();
                }
            }
        });
    }

    public static interface UserCallback {
        public void onSuccess(UserInfoModel var1, HippoConfigAttributes var2);
    }

    public static interface Callback {
        public void onSuccess();

        public void onFailure();
    }
}

