/*
 * Decompiled with CFR 0.152.
 */
package com.hippo;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippo.AgentUnreadCountListener;
import com.hippo.HippoConfig;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.listeners.UnreadListener;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.UnreadCountData;
import com.hippo.agent.model.unreadResponse.UnreadCountResponse;
import com.hippo.agent.model.unreadResponse.UserUnreadCount;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Callback;

public class UnreadCountHelper
implements UnreadListener {
    private static final String TAG = UnreadCountHelper.class.getSimpleName();
    private static UnreadCountHelper instance;
    private static Type listType;

    private UnreadCountHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static UnreadCountHelper getInstance() {
        if (instance == null) {
            Class<UnreadCountHelper> clazz = UnreadCountHelper.class;
            // MONITORENTER : com.hippo.UnreadCountHelper.class
            if (instance == null) {
                instance = new UnreadCountHelper();
                instance.setHelperListener();
            }
            // MONITOREXIT : clazz
        }
        instance.checkHelperListener();
        return instance;
    }

    private void setHelperListener() {
        HippoConfig.getInstance().addUIListener(UnreadListener.class, this);
    }

    private void checkHelperListener() {
        HippoConfig.getInstance().addOrUpdateUIListener(UnreadListener.class, this);
    }

    @Override
    public void pushUpdateCount(String userUniqueKey, boolean isArrayStr) {
        if (TextUtils.isEmpty((CharSequence)userUniqueKey)) {
            return;
        }
        if (isArrayStr) {
            ArrayList userUniqueKeyArr = (ArrayList)new Gson().fromJson(userUniqueKey, listType);
            for (Object string2 : userUniqueKeyArr) {
                UnreadCountData unreadCountData = AgentCommonData.getUnreadCount((String)string2);
                if (unreadCountData == null || TextUtils.isEmpty((CharSequence)unreadCountData.getUserUniqueKey())) continue;
                int count = unreadCountData.getCount();
                unreadCountData.setCount(++count);
                AgentCommonData.addUnreadCount((String)string2, unreadCountData);
            }
        } else {
            UnreadCountData countData = AgentCommonData.getUnreadCount(userUniqueKey);
            if (countData == null || TextUtils.isEmpty((CharSequence)countData.getUserUniqueKey())) {
                return;
            }
            int count = countData.getCount();
            countData.setCount(++count);
            AgentCommonData.addUnreadCount(userUniqueKey, countData);
        }
        HashMap<String, UnreadCountData> dataHashMap = AgentCommonData.getUnreadCount();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Map.Entry entry : dataHashMap.entrySet()) {
            UnreadCountData data = (UnreadCountData)entry.getValue();
            hashMap.put((String)entry.getKey(), data.getCount());
        }
        String jsonData = new Gson().toJson(hashMap);
        if (HippoConfig.getInstance().getAgentCountListener() != null) {
            HippoConfig.getInstance().getAgentCountListener().unreadCount(jsonData);
        }
    }

    @Override
    public void updateOpenChannelCount(ArrayList<String> userUniqueKeyArr, int value) {
        for (String userUniqueKey : userUniqueKeyArr) {
            UnreadCountData countData = AgentCommonData.getUnreadCount(userUniqueKey);
            if (countData == null || TextUtils.isEmpty((CharSequence)countData.getUserUniqueKey())) continue;
            int n = countData.getCount();
            if ((n -= value) < 0) {
                n = 0;
            }
            countData.setCount(n);
            AgentCommonData.addUnreadCount(userUniqueKey, countData);
        }
        HashMap<String, UnreadCountData> dataHashMap = AgentCommonData.getUnreadCount();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Map.Entry entry : dataHashMap.entrySet()) {
            UnreadCountData data = (UnreadCountData)entry.getValue();
            hashMap.put((String)entry.getKey(), data.getCount());
        }
        String jsonData = new Gson().toJson(hashMap);
        if (HippoConfig.getInstance().getAgentCountListener() != null) {
            HippoConfig.getInstance().getAgentCountListener().unreadCount(jsonData);
        }
    }

    @Override
    public void getUnreadCount() {
        HashMap<String, UnreadCountData> countHashMap = AgentCommonData.getUnreadCount();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Map.Entry<String, UnreadCountData> map : countHashMap.entrySet()) {
            UnreadCountData data = map.getValue();
            hashMap.put(map.getKey(), data.getCount());
        }
        String jsonData = new Gson().toJson(hashMap);
        if (HippoConfig.getInstance().getAgentCountListener() != null) {
            HippoConfig.getInstance().getAgentCountListener().unreadCount(jsonData);
        }
    }

    @Override
    public void getUpdatedUnreadCount(ArrayList<String> strings) {
        if (strings == null) {
            strings = AgentCommonData.getAgentUniqueKey();
        }
        if (HippoConfig.getInstance().getAgentCountListener() != null) {
            this.getUpdatedUnreadCount(strings, HippoConfig.getInstance().getAgentCountListener());
        }
    }

    @Override
    public void getUpdatedUnreadCount(ArrayList<String> strings, AgentUnreadCountListener countListener) {
        UserData userData = AgentCommonData.getUserData();
        if (strings == null) {
            strings = AgentCommonData.getAgentUniqueKey();
        }
        if (userData == null || strings == null) {
            return;
        }
        CommonParams commonParams = new CommonParams.Builder().add("access_token", userData.getAccessToken()).add("user_unique_key", new Gson().toJson(strings)).add("response_type", 1).build(2);
        RestClient.getAgentApiInterface().getUnreadCount(commonParams.getMap()).enqueue((Callback)new ResponseResolver<UnreadCountResponse>(){

            @Override
            public void success(UnreadCountResponse unreadCountResponse) {
                try {
                    AgentCommonData.clearUnreadCount();
                    HashMap<String, UnreadCountData> countHashMap = new HashMap<String, UnreadCountData>();
                    for (UserUnreadCount userUnreadCount : unreadCountResponse.getData().getUserUnreadCount()) {
                        UnreadCountData unreadCountData = new UnreadCountData();
                        unreadCountData.setUserUniqueKey(userUnreadCount.getUserUniqueKey());
                        unreadCountData.setHippoUserId(userUnreadCount.getUserId());
                        unreadCountData.setCount(userUnreadCount.getUnreadCount());
                        countHashMap.put(userUnreadCount.getUserUniqueKey(), unreadCountData);
                    }
                    AgentCommonData.addAllUnreadCount(countHashMap);
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    for (Map.Entry<String, UnreadCountData> entry : countHashMap.entrySet()) {
                        UnreadCountData data = entry.getValue();
                        hashMap.put(entry.getKey(), data.getCount());
                    }
                    String string2 = new Gson().toJson(hashMap);
                    if (HippoConfig.getInstance().getAgentCountListener() != null) {
                        HippoConfig.getInstance().getAgentCountListener().unreadCount(string2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void failure(APIError error) {
            }
        });
    }

    @Override
    public void addTotalPushUnread(Integer channelId) {
        try {
            Integer count = AgentCommonData.getTotalUnreadCount(channelId);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            HashMap<Integer, Integer> totalUnreadCount = AgentCommonData.addTotalUnreadCount(channelId, count);
            int totalCount = 0;
            for (Integer value : totalUnreadCount.values()) {
                totalCount += value.intValue();
            }
            if (HippoConfig.getInstance().getCallbackListener() != null) {
                HippoConfig.getInstance().getCallbackListener().count(totalCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendTotalUnreadCount() {
        HashMap<Integer, Integer> totalUnreadCount = AgentCommonData.getTotalUnreadCount();
        HippoLog.i(TAG, "totalUnreadCount: " + new Gson().toJson(totalUnreadCount));
        int totalCount = 0;
        for (Integer value : totalUnreadCount.values()) {
            totalCount += value.intValue();
        }
        if (HippoConfig.getInstance().getCallbackListener() != null) {
            HippoConfig.getInstance().getCallbackListener().count(totalCount);
        }
    }

    static {
        listType = new TypeToken<ArrayList<String>>(){}.getType();
    }
}

