package com.hippo.agent.helper;

import com.hippo.agent.listeners.BroadcastListener;
import com.hippo.agent.model.broadcastResponse.BroadcastModel;
import com.hippo.agent.model.broadcastStatus.BroadcastResponseModel;
import com.hippo.agent.model.createConversation.CreateConversation;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;

import java.util.HashMap;

/**
 * Created by gurmail on 20/07/18.
 *
 * @author gurmail
 */

public class BroadcastListenerHelper implements BroadcastListener {

    @Override
    public void getGroupingList(HashMap<String, Object> hashMap, final BroadcastResponse broadcastResponse) {
        CommonParams commonParams = new CommonParams.Builder()
                .addAll(hashMap)
                .build(2);
        RestClient.getAgentApiInterface().getGroupingTag(commonParams.getMap()).enqueue(new ResponseResolver<BroadcastModel>() {
            @Override
            public void success(BroadcastModel broadcastModel) {
                broadcastResponse.groupingResponse(broadcastModel);
            }

            @Override
            public void failure(APIError error) {
                broadcastResponse.onFailure(1, error.getMessage());
            }
        });
    }

    @Override
    public void sendBroadcastMessage(HashMap<String, Object> hashMap, final BroadcastResponse broadcastResponse) {
        CommonParams commonParams = new CommonParams.Builder()
                .addAll(hashMap)
                .build(2);
        RestClient.getAgentApiInterface().sendBroadcastMessage(commonParams.getMap()).enqueue(new ResponseResolver<BroadcastResponseModel>() {
            @Override
            public void success(BroadcastResponseModel responseModel) {
                broadcastResponse.sendBroadcastResponse(responseModel);
            }

            @Override
            public void failure(APIError error) {
                broadcastResponse.onFailure(2, error.getMessage());
            }
        });
    }

    @Override
    public void getBroadcastList(HashMap<String, Object> hashMap, final BroadcastResponse broadcastResponse) {
        CommonParams commonParams = new CommonParams.Builder()
                .addAll(hashMap)
                .build(2);
        RestClient.getAgentApiInterface().getBroadcastList(commonParams.getMap()).enqueue(new ResponseResolver<BroadcastResponseModel>() {
            @Override
            public void success(BroadcastResponseModel broadcastResponseModel) {
                broadcastResponse.broadcastListResponse(broadcastResponseModel);
            }

            @Override
            public void failure(APIError error) {
                broadcastResponse.onFailure(3, error.getMessage());
            }
        });
    }

    @Override
    public void getBroadcastStatus(HashMap<String, Object> hashMap, final BroadcastResponse broadcastResponse) {
        CommonParams commonParams = new CommonParams.Builder()
                .addAll(hashMap)
                .build(2);
        RestClient.getAgentApiInterface().broadcastStatus(commonParams.getMap()).enqueue(new ResponseResolver<BroadcastResponseModel>() {
            @Override
            public void success(BroadcastResponseModel broadcastResponseModel) {
                broadcastResponse.broadcastStatusResponse(broadcastResponseModel);
            }

            @Override
            public void failure(APIError error) {
                broadcastResponse.onFailure(4, error.getMessage());
            }
        });
    }
}
