package com.hippo.fragment;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.gson.Gson;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.HippoConfigAttributes;
import com.hippo.R;
import com.hippo.activity.BaseFragment;
import com.hippo.activity.FuguChannelsActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.adapter.FuguChannelsAdapter;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.datastructure.ChannelStatus;
import com.hippo.eventbus.BusProvider;
import com.hippo.eventbus.ConversationEvent;
import com.hippo.eventbus.OnViewUpdate;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.squareup.otto.Subscribe;

import java.util.ArrayList;

/**
 * Created by gurmail on 2020-01-26.
 *
 * @author gurmail
 */
public class OpenChannelFragment extends BaseFragment implements FuguAppConstant, SwipeRefreshLayout.OnRefreshListener {

    private View rootView;
    private RelativeLayout rlRoot;
    private SwipeRefreshLayout swipeRefresh;
    private RecyclerView rvChannels;
    private TextView tvNoInternet, tvNewConversation;
    private HippoColorConfig hippoColorConfig;
    private TextView tvPoweredBy;
    @SuppressLint("StaticFieldLeak")
    private static LinearLayout llInternet;
    @SuppressLint("StaticFieldLeak")
    private static TextView tvStatus;
    private final int IS_HIT_REQUIRED = 200;
    private final String TAG = FuguChannelsActivity.class.getSimpleName();
    private FuguChannelsAdapter fuguChannelsAdapter;

    private ArrayList<FuguConversation> openConversationList = new ArrayList<>();
    private ArrayList<FuguConversation> closeConversationList = new ArrayList<>();

    private ImageView llNoConversation;
    private TextView noConversationTextView;
    private Button createBtn;

    private String label = "";
    private Long userId = -1L;
    private String enUserId = "";
    private String userName = "Anonymous";
    private String businessName = "Anonymous";
    private int appVersion = 0;

    private boolean isClosedChannel = false;
    private boolean hasCreateNowBtn = false;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if(getArguments() != null && getArguments().containsKey("isClosedChannel"))
            isClosedChannel = getArguments().getBoolean("isClosedChannel", false);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        rootView = inflater.inflate(R.layout.fugu_activity_channel, container, false);
        return rootView;

    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
    }

    @Override
    public void onStart() {
        super.onStart();
        BusProvider.getInstance().register(this);
    }

    @Override
    public void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister(this);
    }

    /**
     * Initialize Views
     */
    private void initViews(View view) {

        hippoColorConfig = CommonData.getColorConfig();

        rlRoot = (RelativeLayout) view.findViewById(R.id.rlRoot);
        swipeRefresh = (SwipeRefreshLayout) view.findViewById(R.id.swipeRefresh);
        swipeRefresh.setOnRefreshListener(this);
        rvChannels = (RecyclerView) view.findViewById(R.id.rvChannels);
        createBtn = view.findViewById(R.id.createBtn);
        tvNoInternet = (TextView) view.findViewById(R.id.tvNoInternet);
        tvNewConversation = (TextView) view.findViewById(R.id.tvNewConversation);
        tvStatus = (TextView) view.findViewById(R.id.tvStatus);
        llInternet = (LinearLayout) view.findViewById(R.id.llInternet);
        llNoConversation = view.findViewById(R.id.llNoConversation);
        noConversationTextView = view.findViewById(R.id.noConversationTextView);
        tvPoweredBy = (TextView) view.findViewById(R.id.tvPoweredBy);
        tvPoweredBy.setVisibility(View.GONE);
        tvNoInternet.setVisibility(View.GONE);
        swipeRefresh.setVisibility(View.VISIBLE);

        createBtn.setText("Create conversation");
        if(getAttributes() != null && getAttributes().getAdditionalInfo() != null) {
            if(!TextUtils.isEmpty(getAttributes().getAdditionalInfo().getEmptyChannelList())) {
                noConversationTextView.setText(getAttributes().getAdditionalInfo().getEmptyChannelList());
            }

            if(getAttributes().getAdditionalInfo().isHasCreateNewChat()) {
                createBtn.setVisibility(View.VISIBLE);
                hasCreateNowBtn = true;
            }

            if(!TextUtils.isEmpty(getAttributes().getAdditionalInfo().getCreateChatBtnText()))
                createBtn.setText(getAttributes().getAdditionalInfo().getCreateChatBtnText());

        }

        configColors();
        if (!isNetworkAvailable()) {
            llInternet.setVisibility(View.VISIBLE);
            llInternet.setBackgroundColor(Color.parseColor("#FF0000"));
            tvStatus.setText(R.string.fugu_not_connected_to_internet);
        }

        rvChannels.addOnScrollListener(new RecyclerView.OnScrollListener() {

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                if ((dy > 0 || dy < 0) && createBtn.getVisibility() == View.VISIBLE) {
                    createBtn.setVisibility(View.GONE);
                }
            }

            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == RecyclerView.SCROLL_STATE_IDLE && !isClosedChannel && hasCreateNowBtn) {
                    createBtn.setVisibility(View.VISIBLE);
                }
                super.onScrollStateChanged(recyclerView, newState);
            }
        });

        createBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                BusProvider.getInstance().post(new ConversationEvent(2));
            }
        });

        if(isClosedChannel) {
            createBtn.setVisibility(View.GONE);
        }

        //createBtn.setVisibility(View.GONE);



        setRecyclerViewData();
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                FuguPutUserDetailsResponse.Data userData = CommonData.getUserDetails().getData();
                try {
                    if (CommonData.getConversationList().size() > 0) {
                        notifyData((ArrayList<FuguConversation>) CommonData.getConversationList());
                    }
                } catch (Exception e) {
                    if(HippoConfig.DEBUG)
                        e.printStackTrace();
                }
            }
        }, 100);

    }

    /**
     * Config Colors of App
     */
    private void configColors() {
        rlRoot.setBackgroundColor(hippoColorConfig.getHippoChannelBg());
        tvNewConversation.setTextColor(hippoColorConfig.getHippoActionBarText());
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            tvNewConversation.setBackground(HippoColorConfig.makeRoundedSelector(hippoColorConfig.getHippoActionBarBg()));
        } else {
            tvNewConversation.setBackgroundDrawable(HippoColorConfig.makeRoundedSelector(hippoColorConfig.getHippoActionBarBg()));
        }
        tvNewConversation.setTextColor(hippoColorConfig.getHippoActionBarText());
        swipeRefresh.setColorSchemeColors(hippoColorConfig.getHippoThemeColorPrimary());
        tvNoInternet.setTextColor(hippoColorConfig.getHippoThemeColorSecondary());

    }

    /**
     * Set Recycler Data
     */
    private void setRecyclerViewData() {
        FuguPutUserDetailsResponse.Data userData = CommonData.getUserDetails().getData();
        label = userData.getBusinessName();
        businessName = userData.getBusinessName();
        userId = userData.getUserId();
        enUserId = userData.getEn_user_id();
        if(!TextUtils.isEmpty(userData.getFullName()))
            userName = userData.getFullName();

        if(isClosedChannel) {
            fuguChannelsAdapter = new FuguChannelsAdapter(getActivity(), closeConversationList, userName, userId, businessName
                    , new FuguChannelsAdapter.Callback() {
                @Override
                public void onClick(FuguConversation conversation) {
                    Intent chatIntent = new Intent(getActivity(), FuguChatActivity.class);
                    chatIntent.putExtra("is_from_history", false);
                    chatIntent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, FuguConversation.class));
                    startActivityForResult(chatIntent, IS_HIT_REQUIRED);
                }
            }, enUserId);
        } else {
            fuguChannelsAdapter = new FuguChannelsAdapter(getActivity(), openConversationList, userName, userId, businessName
                    , new FuguChannelsAdapter.Callback() {
                @Override
                public void onClick(FuguConversation conversation) {
                    Intent chatIntent = new Intent(getActivity(), FuguChatActivity.class);
                    chatIntent.putExtra("is_from_history", false);
                    chatIntent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, FuguConversation.class));
                    startActivityForResult(chatIntent, IS_HIT_REQUIRED);
                }
            }, enUserId);
        }


        LinearLayoutManager layoutManager = new LinearLayoutManager(getContext());
        rvChannels.setLayoutManager(layoutManager);
        rvChannels.setAdapter(fuguChannelsAdapter);
    }


    @Override
    public void onRefresh() {
        BusProvider.getInstance().post(new ConversationEvent(1));
    }

    @Subscribe
    public void onViewUpdate(OnViewUpdate update) {
        switch (update.type) {
            case 1:
                tvNoInternet.setVisibility(View.VISIBLE);
                swipeRefresh.setVisibility(View.GONE);
                tvNewConversation.setVisibility(View.GONE);
                break;
            case 2:
                //fuguChannelsAdapter.notifyDataSetChanged();
                notifyData(update.fuguConversationList);
                swipeRefresh.setRefreshing(false);
                break;
            case 3:
                swipeRefresh.setRefreshing(false);
                break;
            case 4:
                setRecyclerViewData();
                break;
            default:

                break;
        }
    }

    HippoConfigAttributes attributes;

    private HippoConfigAttributes getAttributes() {
        if(attributes == null)
            attributes = CommonData.getAttributes();
        return attributes;
    }

    private void notifyData(ArrayList<FuguConversation> conversationList) {

        openConversationList.clear();
        closeConversationList.clear();
        if(getAttributes() != null && getAttributes().getAdditionalInfo() != null && getAttributes().getAdditionalInfo().isHasChannelPager()) {
            for(FuguConversation conversation : conversationList) {
                if(isClosedChannel && conversation.getChannelStatus() == ChannelStatus.CLOSED.getOrdinal()) {
                    closeConversationList.add(conversation);
                } else if(!isClosedChannel && conversation.getChannelStatus() != ChannelStatus.CLOSED.getOrdinal()) {
                    openConversationList.add(conversation);
                }
            }
        } else {
            openConversationList.addAll(conversationList);
        }


        fuguChannelsAdapter.notifyDataSetChanged();

        if(isClosedChannel) {
            if(closeConversationList == null || closeConversationList.size() == 0) {
                noConversationTextView.setVisibility(View.VISIBLE);
            } else {
                noConversationTextView.setVisibility(View.GONE);
            }
        } else {
            if(openConversationList == null || openConversationList.size() == 0) {
                noConversationTextView.setVisibility(View.VISIBLE);
            } else {
                noConversationTextView.setVisibility(View.GONE);
            }
        }
    }
}
