package com.hippo;

import android.app.Application;
import android.content.Context;
import android.content.Intent;

import uk.co.chrisjenx.calligraphy.CalligraphyConfig;

/**
 * Created by gurmail on 2019-10-18.
 *
 * @author gurmail
 */
abstract public class LibApp extends Application {
    /** Instance of the current application. */
    private static LibApp instance;

    /**
     * Constructor.
     */
    public LibApp() {
        instance = this;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        CalligraphyConfig.initDefault(new CalligraphyConfig.Builder()
                .setDefaultFontPath("fonts/montserrat_regular.otf")
                .setFontAttrId(R.attr.fontPath)
                .build());
    }

    /**
     * Gets the application context.
     *
     * @return the application context
     */
    public static Context getContext() {
        return instance;
    }

    public static synchronized LibApp getInstance() {
        return instance;
    }

    abstract public void openMainScreen();

    abstract public void onCallBtnClick(Context context, int callType, Long channelId, Long userId, boolean isAgentFlow,
                                     boolean isAllowCall, String fullname, String image);
}
