/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.zoomview;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.view.ScaleGestureDetectorCompat;
import com.hippo.R;
import com.hippo.utils.zoomview.AutoResetMode;

public class ZoomageView
extends AppCompatImageView
implements ScaleGestureDetector.OnScaleGestureListener {
    private static final float MIN_SCALE = 0.6f;
    private static final float MAX_SCALE = 8.0f;
    private final int RESET_DURATION = 200;
    private ImageView.ScaleType startScaleType;
    private Matrix matrix = new Matrix();
    private Matrix startMatrix = new Matrix();
    private float[] matrixValues = new float[9];
    private float[] startValues = null;
    private float minScale = 0.6f;
    private float maxScale = 8.0f;
    private float calculatedMinScale = 0.6f;
    private float calculatedMaxScale = 8.0f;
    private final RectF bounds = new RectF();
    private boolean translatable;
    private boolean zoomable;
    private boolean doubleTapToZoom;
    private boolean restrictBounds;
    private boolean animateOnReset;
    private boolean autoCenter;
    private float doubleTapToZoomScaleFactor;
    private int autoResetMode;
    private PointF last = new PointF(0.0f, 0.0f);
    private float startScale = 1.0f;
    private float scaleBy = 1.0f;
    private float currentScaleFactor = 1.0f;
    private int previousPointerCount = 1;
    private ScaleGestureDetector scaleDetector;
    private GestureDetector gestureDetector;
    private boolean doubleTapDetected = false;
    private boolean singleTapDetected = false;
    private final GestureDetector.OnGestureListener gestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDoubleTapEvent(MotionEvent motionEvent) {
            if (motionEvent.getAction() == 1) {
                ZoomageView.this.doubleTapDetected = true;
            }
            return false;
        }

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            ZoomageView.this.singleTapDetected = true;
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            ZoomageView.this.singleTapDetected = false;
            return false;
        }

        public boolean onDown(MotionEvent motionEvent) {
            return true;
        }
    };

    public ZoomageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ZoomageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet);
    }

    public ZoomageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context, attributeSet);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.scaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        this.gestureDetector = new GestureDetector(context, this.gestureListener);
        ScaleGestureDetectorCompat.setQuickScaleEnabled((ScaleGestureDetector)this.scaleDetector, (boolean)false);
        this.startScaleType = this.getScaleType();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.HippoZoomageView);
        this.zoomable = typedArray.getBoolean(R.styleable.HippoZoomageView_zoomage_zoomable, true);
        this.translatable = typedArray.getBoolean(R.styleable.HippoZoomageView_zoomage_translatable, true);
        this.animateOnReset = typedArray.getBoolean(R.styleable.HippoZoomageView_zoomage_animateOnReset, true);
        this.autoCenter = typedArray.getBoolean(R.styleable.HippoZoomageView_zoomage_autoCenter, true);
        this.restrictBounds = typedArray.getBoolean(R.styleable.HippoZoomageView_zoomage_restrictBounds, false);
        this.doubleTapToZoom = typedArray.getBoolean(R.styleable.HippoZoomageView_zoomage_doubleTapToZoom, true);
        this.minScale = typedArray.getFloat(R.styleable.HippoZoomageView_zoomage_minScale, 0.6f);
        this.maxScale = typedArray.getFloat(R.styleable.HippoZoomageView_zoomage_maxScale, 8.0f);
        this.doubleTapToZoomScaleFactor = typedArray.getFloat(R.styleable.HippoZoomageView_zoomage_doubleTapToZoomScaleFactor, 3.0f);
        this.autoResetMode = AutoResetMode.Parser.fromInt(typedArray.getInt(R.styleable.HippoZoomageView_zoomage_autoResetMode, 0));
        this.verifyScaleRange();
        typedArray.recycle();
    }

    private void verifyScaleRange() {
        if (this.minScale >= this.maxScale) {
            throw new IllegalStateException("minScale must be less than maxScale");
        }
        if (this.minScale < 0.0f) {
            throw new IllegalStateException("minScale must be greater than 0");
        }
        if (this.maxScale < 0.0f) {
            throw new IllegalStateException("maxScale must be greater than 0");
        }
        if (this.doubleTapToZoomScaleFactor > this.maxScale) {
            this.doubleTapToZoomScaleFactor = this.maxScale;
        }
        if (this.doubleTapToZoomScaleFactor < this.minScale) {
            this.doubleTapToZoomScaleFactor = this.minScale;
        }
    }

    public void setScaleRange(float f2, float f3) {
        this.minScale = f2;
        this.maxScale = f3;
        this.startValues = null;
        this.verifyScaleRange();
    }

    public boolean isTranslatable() {
        return this.translatable;
    }

    public void setTranslatable(boolean bl) {
        this.translatable = bl;
    }

    public boolean isZoomable() {
        return this.zoomable;
    }

    public void setZoomable(boolean bl) {
        this.zoomable = bl;
    }

    public boolean getRestrictBounds() {
        return this.restrictBounds;
    }

    public void setRestrictBounds(boolean bl) {
        this.restrictBounds = bl;
    }

    public boolean getAnimateOnReset() {
        return this.animateOnReset;
    }

    public void setAnimateOnReset(boolean bl) {
        this.animateOnReset = bl;
    }

    public int getAutoResetMode() {
        return this.autoResetMode;
    }

    public void setAutoResetMode(int n) {
        this.autoResetMode = n;
    }

    public boolean getAutoCenter() {
        return this.autoCenter;
    }

    public void setAutoCenter(boolean bl) {
        this.autoCenter = bl;
    }

    public boolean getDoubleTapToZoom() {
        return this.doubleTapToZoom;
    }

    public void setDoubleTapToZoom(boolean bl) {
        this.doubleTapToZoom = bl;
    }

    public float getDoubleTapToZoomScaleFactor() {
        return this.doubleTapToZoomScaleFactor;
    }

    public void setDoubleTapToZoomScaleFactor(float f2) {
        this.doubleTapToZoomScaleFactor = f2;
        this.verifyScaleRange();
    }

    public float getCurrentScaleFactor() {
        return this.currentScaleFactor;
    }

    public void setScaleType(@Nullable ImageView.ScaleType scaleType) {
        if (scaleType != null) {
            super.setScaleType(scaleType);
            this.startScaleType = scaleType;
            this.startValues = null;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.setScaleType(this.startScaleType);
        }
    }

    public void setImageResource(int n) {
        super.setImageResource(n);
        this.setScaleType(this.startScaleType);
    }

    public void setImageDrawable(@Nullable Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.setScaleType(this.startScaleType);
    }

    public void setImageBitmap(Bitmap bitmap) {
        super.setImageBitmap(bitmap);
        this.setScaleType(this.startScaleType);
    }

    public void setImageURI(@Nullable Uri uri) {
        super.setImageURI(uri);
        this.setScaleType(this.startScaleType);
    }

    private void updateBounds(float[] fArray) {
        if (this.getDrawable() != null) {
            this.bounds.set(fArray[2], fArray[5], (float)this.getDrawable().getIntrinsicWidth() * fArray[0] + fArray[2], (float)this.getDrawable().getIntrinsicHeight() * fArray[4] + fArray[5]);
        }
    }

    private float getCurrentDisplayedWidth() {
        if (this.getDrawable() != null) {
            return (float)this.getDrawable().getIntrinsicWidth() * this.matrixValues[0];
        }
        return 0.0f;
    }

    private float getCurrentDisplayedHeight() {
        if (this.getDrawable() != null) {
            return (float)this.getDrawable().getIntrinsicHeight() * this.matrixValues[4];
        }
        return 0.0f;
    }

    private void setStartValues() {
        this.startValues = new float[9];
        this.startMatrix = new Matrix(this.getImageMatrix());
        this.startMatrix.getValues(this.startValues);
        this.calculatedMinScale = this.minScale * this.startValues[0];
        this.calculatedMaxScale = this.maxScale * this.startValues[0];
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.isClickable() && this.isEnabled() && (this.zoomable || this.translatable)) {
            if (this.getScaleType() != ImageView.ScaleType.MATRIX) {
                super.setScaleType(ImageView.ScaleType.MATRIX);
            }
            if (this.startValues == null) {
                this.setStartValues();
            }
            this.matrix.set(this.getImageMatrix());
            this.matrix.getValues(this.matrixValues);
            this.updateBounds(this.matrixValues);
            this.scaleDetector.onTouchEvent(motionEvent);
            this.gestureDetector.onTouchEvent(motionEvent);
            if (this.doubleTapToZoom && this.doubleTapDetected) {
                this.doubleTapDetected = false;
                this.singleTapDetected = false;
                if (this.matrixValues[0] != this.startValues[0]) {
                    this.reset();
                } else {
                    Matrix matrix = new Matrix(this.matrix);
                    matrix.postScale(this.doubleTapToZoomScaleFactor, this.doubleTapToZoomScaleFactor, this.scaleDetector.getFocusX(), this.scaleDetector.getFocusY());
                    this.animateScaleAndTranslationToMatrix(matrix, 200);
                }
                return true;
            }
            if (!this.singleTapDetected) {
                if (motionEvent.getActionMasked() == 0 || motionEvent.getPointerCount() != this.previousPointerCount) {
                    this.last.set(this.scaleDetector.getFocusX(), this.scaleDetector.getFocusY());
                } else if (motionEvent.getActionMasked() == 2) {
                    float f2 = this.scaleDetector.getFocusX();
                    float f3 = this.scaleDetector.getFocusY();
                    if (this.translatable) {
                        float f4 = this.getXDistance(f2, this.last.x);
                        float f5 = this.getYDistance(f3, this.last.y);
                        this.matrix.postTranslate(f4, f5);
                    }
                    if (this.zoomable) {
                        this.matrix.postScale(this.scaleBy, this.scaleBy, f2, f3);
                        this.currentScaleFactor = this.matrixValues[0] / this.startValues[0];
                    }
                    this.setImageMatrix(this.matrix);
                    this.last.set(f2, f3);
                }
                if (motionEvent.getActionMasked() == 1) {
                    this.scaleBy = 1.0f;
                    this.resetImage();
                }
            }
            this.previousPointerCount = motionEvent.getPointerCount();
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    private void resetImage() {
        switch (this.autoResetMode) {
            case 0: {
                if (this.matrixValues[0] <= this.startValues[0]) {
                    this.reset();
                    break;
                }
                this.center();
                break;
            }
            case 1: {
                if (this.matrixValues[0] >= this.startValues[0]) {
                    this.reset();
                    break;
                }
                this.center();
                break;
            }
            case 2: {
                this.reset();
                break;
            }
            case 3: {
                this.center();
            }
        }
    }

    private void center() {
        if (this.autoCenter) {
            this.animateTranslationX();
            this.animateTranslationY();
        }
    }

    public void reset() {
        this.reset(this.animateOnReset);
    }

    public void reset(boolean bl) {
        if (bl) {
            this.animateToStartMatrix();
        } else {
            this.setImageMatrix(this.startMatrix);
        }
    }

    private void animateToStartMatrix() {
        this.animateScaleAndTranslationToMatrix(this.startMatrix, 200);
    }

    private void animateScaleAndTranslationToMatrix(final Matrix matrix, int n) {
        float[] fArray = new float[9];
        matrix.getValues(fArray);
        final Matrix matrix2 = new Matrix(this.getImageMatrix());
        matrix2.getValues(this.matrixValues);
        final float f2 = fArray[0] - this.matrixValues[0];
        final float f3 = fArray[4] - this.matrixValues[4];
        final float f4 = fArray[2] - this.matrixValues[2];
        final float f5 = fArray[5] - this.matrixValues[5];
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            final Matrix activeMatrix;
            final float[] values;
            {
                this.activeMatrix = new Matrix(ZoomageView.this.getImageMatrix());
                this.values = new float[9];
            }

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f22 = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                this.activeMatrix.set(matrix2);
                this.activeMatrix.getValues(this.values);
                this.values[2] = this.values[2] + f4 * f22;
                this.values[5] = this.values[5] + f5 * f22;
                this.values[0] = this.values[0] + f2 * f22;
                this.values[4] = this.values[4] + f3 * f22;
                this.activeMatrix.setValues(this.values);
                ZoomageView.this.setImageMatrix(this.activeMatrix);
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                ZoomageView.this.setImageMatrix(matrix);
            }
        });
        valueAnimator.setDuration((long)n);
        valueAnimator.start();
    }

    private void animateTranslationX() {
        if (this.getCurrentDisplayedWidth() > (float)this.getWidth()) {
            if (this.bounds.left > 0.0f) {
                this.animateMatrixIndex(2, 0.0f);
            } else if (this.bounds.right < (float)this.getWidth()) {
                this.animateMatrixIndex(2, this.bounds.left + (float)this.getWidth() - this.bounds.right);
            }
        } else if (this.bounds.left < 0.0f) {
            this.animateMatrixIndex(2, 0.0f);
        } else if (this.bounds.right > (float)this.getWidth()) {
            this.animateMatrixIndex(2, this.bounds.left + (float)this.getWidth() - this.bounds.right);
        }
    }

    private void animateTranslationY() {
        if (this.getCurrentDisplayedHeight() > (float)this.getHeight()) {
            if (this.bounds.top > 0.0f) {
                this.animateMatrixIndex(5, 0.0f);
            } else if (this.bounds.bottom < (float)this.getHeight()) {
                this.animateMatrixIndex(5, this.bounds.top + (float)this.getHeight() - this.bounds.bottom);
            }
        } else if (this.bounds.top < 0.0f) {
            this.animateMatrixIndex(5, 0.0f);
        } else if (this.bounds.bottom > (float)this.getHeight()) {
            this.animateMatrixIndex(5, this.bounds.top + (float)this.getHeight() - this.bounds.bottom);
        }
    }

    private void animateMatrixIndex(final int n, float f2) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.matrixValues[n], f2});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            final float[] values = new float[9];
            Matrix current = new Matrix();

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                this.current.set(ZoomageView.this.getImageMatrix());
                this.current.getValues(this.values);
                this.values[n] = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                this.current.setValues(this.values);
                ZoomageView.this.setImageMatrix(this.current);
            }
        });
        valueAnimator.setDuration(200L);
        valueAnimator.start();
    }

    private float getXDistance(float f2, float f3) {
        float f4 = f2 - f3;
        if (this.restrictBounds) {
            f4 = this.getRestrictedXDistance(f4);
        }
        if (this.bounds.right + f4 < 0.0f) {
            f4 = -this.bounds.right;
        } else if (this.bounds.left + f4 > (float)this.getWidth()) {
            f4 = (float)this.getWidth() - this.bounds.left;
        }
        return f4;
    }

    private float getRestrictedXDistance(float f2) {
        float f3 = f2;
        if (this.getCurrentDisplayedWidth() >= (float)this.getWidth()) {
            if (this.bounds.left <= 0.0f && this.bounds.left + f2 > 0.0f && !this.scaleDetector.isInProgress()) {
                f3 = -this.bounds.left;
            } else if (this.bounds.right >= (float)this.getWidth() && this.bounds.right + f2 < (float)this.getWidth() && !this.scaleDetector.isInProgress()) {
                f3 = (float)this.getWidth() - this.bounds.right;
            }
        } else if (!this.scaleDetector.isInProgress()) {
            if (this.bounds.left >= 0.0f && this.bounds.left + f2 < 0.0f) {
                f3 = -this.bounds.left;
            } else if (this.bounds.right <= (float)this.getWidth() && this.bounds.right + f2 > (float)this.getWidth()) {
                f3 = (float)this.getWidth() - this.bounds.right;
            }
        }
        return f3;
    }

    private float getYDistance(float f2, float f3) {
        float f4 = f2 - f3;
        if (this.restrictBounds) {
            f4 = this.getRestrictedYDistance(f4);
        }
        if (this.bounds.bottom + f4 < 0.0f) {
            f4 = -this.bounds.bottom;
        } else if (this.bounds.top + f4 > (float)this.getHeight()) {
            f4 = (float)this.getHeight() - this.bounds.top;
        }
        return f4;
    }

    private float getRestrictedYDistance(float f2) {
        float f3 = f2;
        if (this.getCurrentDisplayedHeight() >= (float)this.getHeight()) {
            if (this.bounds.top <= 0.0f && this.bounds.top + f2 > 0.0f && !this.scaleDetector.isInProgress()) {
                f3 = -this.bounds.top;
            } else if (this.bounds.bottom >= (float)this.getHeight() && this.bounds.bottom + f2 < (float)this.getHeight() && !this.scaleDetector.isInProgress()) {
                f3 = (float)this.getHeight() - this.bounds.bottom;
            }
        } else if (!this.scaleDetector.isInProgress()) {
            if (this.bounds.top >= 0.0f && this.bounds.top + f2 < 0.0f) {
                f3 = -this.bounds.top;
            } else if (this.bounds.bottom <= (float)this.getHeight() && this.bounds.bottom + f2 > (float)this.getHeight()) {
                f3 = (float)this.getHeight() - this.bounds.bottom;
            }
        }
        return f3;
    }

    public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
        this.scaleBy = this.startScale * scaleGestureDetector.getScaleFactor() / this.matrixValues[0];
        float f2 = this.scaleBy * this.matrixValues[0];
        if (f2 < this.calculatedMinScale) {
            this.scaleBy = this.calculatedMinScale / this.matrixValues[0];
        } else if (f2 > this.calculatedMaxScale) {
            this.scaleBy = this.calculatedMaxScale / this.matrixValues[0];
        }
        return false;
    }

    public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
        this.startScale = this.matrixValues[0];
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
        this.scaleBy = 1.0f;
    }

    private class SimpleAnimatorListener
    implements Animator.AnimatorListener {
        private SimpleAnimatorListener() {
        }

        public void onAnimationStart(Animator animator) {
        }

        public void onAnimationEnd(Animator animator) {
        }

        public void onAnimationCancel(Animator animator) {
        }

        public void onAnimationRepeat(Animator animator) {
        }
    }
}

