/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.swipeLayout.frame;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.hippo.R;
import com.hippo.utils.swipeLayout.SwipeGestureManager;
import com.hippo.utils.swipeLayout.listener.LayoutShiftListener;
import com.hippo.utils.swipeLayout.listener.OnLayoutPercentageChangeListener;
import com.hippo.utils.swipeLayout.listener.OnLayoutSwipedListener;
import java.util.HashSet;
import java.util.Set;

public class SwipeableLayout
extends FrameLayout {
    private float swipeSpeed;
    private SwipeGestureManager swipeManager;
    private int swipeOrientationMode;
    private boolean scrollAndClickable;
    private boolean isSwipeable = true;
    private final Set<Integer> blocks = new HashSet<Integer>();
    private OnLayoutSwipedListener onLayoutSwipedListener;
    private OnLayoutPercentageChangeListener onLayoutPercentageChangeListener;
    private LayoutShiftListener layoutShiftListener;

    public SwipeableLayout(Context context) {
        super(context);
        this.inflateAttributes(context, null);
    }

    public SwipeableLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.inflateAttributes(context, attributeSet);
    }

    public SwipeableLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.inflateAttributes(context, attributeSet);
    }

    @TargetApi(value=21)
    public SwipeableLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.inflateAttributes(context, attributeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inflateAttributes(Context context, @Nullable AttributeSet attributeSet) {
        this.swipeSpeed = 0.7f;
        this.swipeOrientationMode = 1;
        if (attributeSet != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SwipeableLayout);
            try {
                this.swipeSpeed = typedArray.getFloat(R.styleable.SwipeableLayout_swipeSpeed, this.swipeSpeed);
                this.swipeOrientationMode = typedArray.getInt(R.styleable.SwipeableLayout_swipeOrientation, this.swipeOrientationMode);
                this.scrollAndClickable = typedArray.getBoolean(R.styleable.SwipeableLayout_scrollAndClickable, this.scrollAndClickable);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.scrollAndClickable) {
            super.dispatchTouchEvent(motionEvent);
        }
        return this.swipeManager.onTouch((View)this, motionEvent);
    }

    public void initSwipeManager() {
        SwipeGestureManager.Builder builder = new SwipeGestureManager.Builder(this.getContext());
        builder.setSwipeSpeed(this.swipeSpeed);
        builder.setOrientationMode(this.swipeOrientationMode);
        builder.setStartCoordinates(this.getX(), this.getY());
        this.swipeManager = builder.create();
        this.swipeManager.setOnLayoutPercentageChangeListener(this.onLayoutPercentageChangeListener);
        this.swipeManager.setOnSwipedListener(this.onLayoutSwipedListener);
        this.swipeManager.setBlockSet(this.blocks);
        this.swipeManager.setLayoutShiftListener(this.layoutShiftListener);
        this.setOnTouchListener(this.swipeManager);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.initSwipeManager();
    }

    public void addBlock(int n) {
        if (this.swipeManager != null) {
            this.swipeManager.addBlock(n);
        } else {
            this.blocks.add(n);
        }
    }

    public void isSwipeable(boolean bl) {
        if (this.swipeManager != null) {
            this.swipeManager.isSwipeable(bl);
        } else {
            this.isSwipeable = bl;
        }
    }

    public void removeBlock(int n) {
        if (this.swipeManager != null) {
            this.swipeManager.removeBlock(n);
        } else {
            this.blocks.remove(n);
        }
    }

    public void setSwipeSpeed(int n) {
        if (this.swipeManager != null) {
            this.swipeManager.setSwipeSpeed(n);
        } else {
            this.swipeSpeed = n;
        }
    }

    public void setSwipeOrientationMode(int n) {
        if (this.swipeManager != null) {
            this.swipeManager.setOrientationMode(n);
        } else {
            this.swipeOrientationMode = n;
        }
    }

    public void setOnSwipedListener(OnLayoutSwipedListener onLayoutSwipedListener) {
        this.onLayoutSwipedListener = onLayoutSwipedListener;
    }

    public void setOnLayoutPercentageChangeListener(OnLayoutPercentageChangeListener onLayoutPercentageChangeListener) {
        this.onLayoutPercentageChangeListener = onLayoutPercentageChangeListener;
    }

    public void setLayoutShiftListener(LayoutShiftListener layoutShiftListener) {
        this.layoutShiftListener = layoutShiftListener;
    }
}

