/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.showmoretextview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hippo.R;

public class ExpandableTextView
extends LinearLayout
implements View.OnClickListener {
    private static final String TAG = ExpandableTextView.class.getSimpleName();
    private static final int EXPAND_INDICATOR_IMAGE_BUTTON = 0;
    private static final int EXPAND_INDICATOR_TEXT_VIEW = 1;
    private static final int DEFAULT_TOGGLE_TYPE = 0;
    private static final int MAX_COLLAPSED_LINES = 8;
    private static final int DEFAULT_ANIM_DURATION = 300;
    private static final float DEFAULT_ANIM_ALPHA_START = 0.7f;
    protected TextView mTv;
    protected View mToggleView;
    private boolean mRelayout;
    private boolean mCollapsed = true;
    private int mCollapsedHeight;
    private int mTextHeightWithMaxLines;
    private int mMaxCollapsedLines;
    private int mMarginBetweenTxtAndBottom;
    private ExpandIndicatorController mExpandIndicatorController;
    private int mAnimationDuration;
    private float mAnimAlphaStart;
    private boolean mAnimating;
    @IdRes
    private int mExpandableTextId = R.id.expandable_text;
    @IdRes
    private int mExpandCollapseToggleId = R.id.expand_collapse;
    private boolean mExpandToggleOnTextClick;
    private OnExpandStateChangeListener mListener;
    private SparseBooleanArray mCollapsedStatus;
    private int mPosition;

    public ExpandableTextView(Context context) {
        this(context, null);
    }

    public ExpandableTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(attributeSet);
    }

    @TargetApi(value=11)
    public ExpandableTextView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(attributeSet);
    }

    public void setOrientation(int n) {
        if (0 == n) {
            throw new IllegalArgumentException("ExpandableTextView only supports Vertical Orientation.");
        }
        super.setOrientation(n);
    }

    public void onClick(View view) {
        if (this.mToggleView.getVisibility() != 0) {
            return;
        }
        this.mCollapsed = !this.mCollapsed;
        this.mExpandIndicatorController.changeState(this.mCollapsed);
        if (this.mCollapsedStatus != null) {
            this.mCollapsedStatus.put(this.mPosition, this.mCollapsed);
        }
        this.mAnimating = true;
        ExpandCollapseAnimation expandCollapseAnimation = this.mCollapsed ? new ExpandCollapseAnimation((View)this, this.getHeight(), this.mCollapsedHeight) : new ExpandCollapseAnimation((View)this, this.getHeight(), this.getHeight() + this.mTextHeightWithMaxLines - this.mTv.getHeight());
        expandCollapseAnimation.setFillAfter(true);
        expandCollapseAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                ExpandableTextView.applyAlphaAnimation((View)ExpandableTextView.this.mTv, ExpandableTextView.this.mAnimAlphaStart);
            }

            public void onAnimationEnd(Animation animation) {
                ExpandableTextView.this.clearAnimation();
                ExpandableTextView.this.mAnimating = false;
                if (ExpandableTextView.this.mListener != null) {
                    ExpandableTextView.this.mListener.onExpandStateChanged(ExpandableTextView.this.mTv, !ExpandableTextView.this.mCollapsed);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.clearAnimation();
        this.startAnimation(expandCollapseAnimation);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return this.mAnimating;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.findViews();
    }

    protected void onMeasure(int n, int n2) {
        if (this.getVisibility() == 8) {
            super.onMeasure(n, n2);
            return;
        }
        this.mRelayout = false;
        this.mToggleView.setVisibility(8);
        this.mTv.setMaxLines(Integer.MAX_VALUE);
        super.onMeasure(n, n2);
        if (this.mTv.getLineCount() <= this.mMaxCollapsedLines) {
            return;
        }
        this.mTextHeightWithMaxLines = ExpandableTextView.getRealTextViewHeight(this.mTv);
        if (this.mCollapsed) {
            this.mTv.setMaxLines(this.mMaxCollapsedLines);
        }
        this.mToggleView.setVisibility(0);
        super.onMeasure(n, n2);
        if (this.mCollapsed) {
            this.mTv.post(new Runnable(){

                @Override
                public void run() {
                    ExpandableTextView.this.mMarginBetweenTxtAndBottom = ExpandableTextView.this.getHeight() - ExpandableTextView.this.mTv.getHeight();
                }
            });
            this.mCollapsedHeight = this.getMeasuredHeight();
        }
    }

    public void setOnExpandStateChangeListener(@Nullable OnExpandStateChangeListener onExpandStateChangeListener) {
        this.mListener = onExpandStateChangeListener;
    }

    public void setText(@Nullable CharSequence charSequence) {
        this.mRelayout = true;
        this.mTv.setText(charSequence);
        this.setVisibility(TextUtils.isEmpty((CharSequence)charSequence) ? 8 : 0);
        this.clearAnimation();
        this.getLayoutParams().height = -2;
        this.requestLayout();
    }

    public void setText(@Nullable CharSequence charSequence, @NonNull SparseBooleanArray sparseBooleanArray, int n) {
        this.mCollapsedStatus = sparseBooleanArray;
        this.mPosition = n;
        boolean bl = sparseBooleanArray.get(n, true);
        this.clearAnimation();
        this.mCollapsed = bl;
        this.mExpandIndicatorController.changeState(this.mCollapsed);
        this.setText(charSequence);
    }

    @Nullable
    public CharSequence getText() {
        if (this.mTv == null) {
            return "";
        }
        return this.mTv.getText();
    }

    private void init(AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ExpandableTextView);
        this.mMaxCollapsedLines = typedArray.getInt(R.styleable.ExpandableTextView_maxCollapsedLines, 8);
        this.mAnimationDuration = typedArray.getInt(R.styleable.ExpandableTextView_animDuration, 300);
        this.mAnimAlphaStart = typedArray.getFloat(R.styleable.ExpandableTextView_animAlphaStart, 0.7f);
        this.mExpandableTextId = typedArray.getResourceId(R.styleable.ExpandableTextView_expandableTextId, R.id.expandable_text);
        this.mExpandCollapseToggleId = typedArray.getResourceId(R.styleable.ExpandableTextView_expandCollapseToggleId, R.id.expand_collapse);
        this.mExpandToggleOnTextClick = typedArray.getBoolean(R.styleable.ExpandableTextView_expandToggleOnTextClick, true);
        this.mExpandIndicatorController = ExpandableTextView.setupExpandToggleController(this.getContext(), typedArray);
        typedArray.recycle();
        this.setOrientation(1);
        this.setVisibility(8);
    }

    private void findViews() {
        this.mTv = (TextView)this.findViewById(this.mExpandableTextId);
        if (this.mExpandToggleOnTextClick) {
            this.mTv.setOnClickListener((View.OnClickListener)this);
        } else {
            this.mTv.setOnClickListener(null);
        }
        this.mToggleView = this.findViewById(this.mExpandCollapseToggleId);
        this.mExpandIndicatorController.setView(this.mToggleView);
        this.mExpandIndicatorController.changeState(this.mCollapsed);
        this.mToggleView.setOnClickListener((View.OnClickListener)this);
    }

    private static boolean isPostHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    private static boolean isPostLolipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @TargetApi(value=11)
    private static void applyAlphaAnimation(View view, float f2) {
        if (ExpandableTextView.isPostHoneycomb()) {
            view.setAlpha(f2);
        } else {
            AlphaAnimation alphaAnimation = new AlphaAnimation(f2, f2);
            alphaAnimation.setDuration(0L);
            alphaAnimation.setFillAfter(true);
            view.startAnimation((Animation)alphaAnimation);
        }
    }

    @TargetApi(value=21)
    private static Drawable getDrawable(@NonNull Context context, @DrawableRes int n) {
        Resources resources = context.getResources();
        if (ExpandableTextView.isPostLolipop()) {
            return resources.getDrawable(n, context.getTheme());
        }
        return resources.getDrawable(n);
    }

    private static int getRealTextViewHeight(@NonNull TextView textView) {
        int n = textView.getLayout().getLineTop(textView.getLineCount());
        int n2 = textView.getCompoundPaddingTop() + textView.getCompoundPaddingBottom();
        return n + n2;
    }

    private static ExpandIndicatorController setupExpandToggleController(@NonNull Context context, TypedArray typedArray) {
        ExpandIndicatorController expandIndicatorController;
        int n = typedArray.getInt(R.styleable.ExpandableTextView_expandToggleType, 0);
        switch (n) {
            case 0: {
                Drawable drawable2 = typedArray.getDrawable(R.styleable.ExpandableTextView_expandIndicator);
                Drawable drawable3 = typedArray.getDrawable(R.styleable.ExpandableTextView_collapseIndicator);
                if (drawable2 == null) {
                    drawable2 = ExpandableTextView.getDrawable(context, R.drawable.ic_expand_more_black_12dp);
                }
                if (drawable3 == null) {
                    drawable3 = ExpandableTextView.getDrawable(context, R.drawable.ic_expand_less_black_12dp);
                }
                expandIndicatorController = new ImageButtonExpandController(drawable2, drawable3);
                break;
            }
            case 1: {
                String string2 = typedArray.getString(R.styleable.ExpandableTextView_expandIndicator);
                String string3 = typedArray.getString(R.styleable.ExpandableTextView_collapseIndicator);
                expandIndicatorController = new TextViewExpandController(string2, string3);
                break;
            }
            default: {
                throw new IllegalStateException("Must be of enum: ExpandableTextView_expandToggleType, one of EXPAND_INDICATOR_IMAGE_BUTTON or EXPAND_INDICATOR_TEXT_VIEW.");
            }
        }
        return expandIndicatorController;
    }

    static class TextViewExpandController
    implements ExpandIndicatorController {
        private final String mExpandText;
        private final String mCollapseText;
        private TextView mTextView;

        public TextViewExpandController(String string2, String string3) {
            this.mExpandText = string2;
            this.mCollapseText = string3;
        }

        @Override
        public void changeState(boolean bl) {
            this.mTextView.setText((CharSequence)(bl ? this.mExpandText : this.mCollapseText));
        }

        @Override
        public void setView(View view) {
            this.mTextView = (TextView)view;
        }
    }

    static class ImageButtonExpandController
    implements ExpandIndicatorController {
        private final Drawable mExpandDrawable;
        private final Drawable mCollapseDrawable;
        private ImageButton mImageButton;

        public ImageButtonExpandController(Drawable drawable2, Drawable drawable3) {
            this.mExpandDrawable = drawable2;
            this.mCollapseDrawable = drawable3;
        }

        @Override
        public void changeState(boolean bl) {
            this.mImageButton.setImageDrawable(bl ? this.mExpandDrawable : this.mCollapseDrawable);
        }

        @Override
        public void setView(View view) {
            this.mImageButton = (ImageButton)view;
        }
    }

    static interface ExpandIndicatorController {
        public void changeState(boolean var1);

        public void setView(View var1);
    }

    public static interface OnExpandStateChangeListener {
        public void onExpandStateChanged(TextView var1, boolean var2);
    }

    class ExpandCollapseAnimation
    extends Animation {
        private final View mTargetView;
        private final int mStartHeight;
        private final int mEndHeight;

        public ExpandCollapseAnimation(View view, int n, int n2) {
            this.mTargetView = view;
            this.mStartHeight = n;
            this.mEndHeight = n2;
            this.setDuration(ExpandableTextView.this.mAnimationDuration);
        }

        protected void applyTransformation(float f2, Transformation transformation) {
            int n = (int)((float)(this.mEndHeight - this.mStartHeight) * f2 + (float)this.mStartHeight);
            ExpandableTextView.this.mTv.setMaxHeight(n - ExpandableTextView.this.mMarginBetweenTxtAndBottom);
            if (Float.compare(ExpandableTextView.this.mAnimAlphaStart, 1.0f) != 0) {
                ExpandableTextView.applyAlphaAnimation((View)ExpandableTextView.this.mTv, ExpandableTextView.this.mAnimAlphaStart + f2 * (1.0f - ExpandableTextView.this.mAnimAlphaStart));
            }
            this.mTargetView.getLayoutParams().height = n;
            this.mTargetView.requestLayout();
        }

        public void initialize(int n, int n2, int n3, int n4) {
            super.initialize(n, n2, n3, n4);
        }

        public boolean willChangeBounds() {
            return true;
        }
    }
}

