/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.photoview;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import androidx.core.view.MotionEventCompat;
import com.hippo.utils.photoview.Compat;
import com.hippo.utils.photoview.CustomGestureDetector;
import com.hippo.utils.photoview.OnDoubleTap;
import com.hippo.utils.photoview.OnGestureListener;
import com.hippo.utils.photoview.OnMatrixChangedListener;
import com.hippo.utils.photoview.OnOutsidePhotoTapListener;
import com.hippo.utils.photoview.OnPhotoTapListener;
import com.hippo.utils.photoview.OnScaleChangedListener;
import com.hippo.utils.photoview.OnSingleFlingListener;
import com.hippo.utils.photoview.OnViewDragListener;
import com.hippo.utils.photoview.OnViewTapListener;
import com.hippo.utils.photoview.Util;

public class PhotoViewAttacher
implements View.OnLayoutChangeListener,
View.OnTouchListener {
    private static float DEFAULT_MAX_SCALE = 3.0f;
    private static float DEFAULT_MID_SCALE = 1.75f;
    private static float DEFAULT_MIN_SCALE = 1.0f;
    private static int DEFAULT_ZOOM_DURATION = 200;
    private static final int EDGE_NONE = -1;
    private static final int EDGE_LEFT = 0;
    private static final int EDGE_RIGHT = 1;
    private static final int EDGE_BOTH = 2;
    private static int SINGLE_TOUCH = 1;
    private Interpolator mInterpolator = new AccelerateDecelerateInterpolator();
    private int mZoomDuration = DEFAULT_ZOOM_DURATION;
    private float mMinScale = DEFAULT_MIN_SCALE;
    private float mMidScale = DEFAULT_MID_SCALE;
    private float mMaxScale = DEFAULT_MAX_SCALE;
    private boolean mAllowParentInterceptOnEdge = true;
    private boolean mBlockParentIntercept = false;
    private ImageView mImageView;
    private GestureDetector mGestureDetector;
    private CustomGestureDetector mScaleDragDetector;
    private final Matrix mBaseMatrix = new Matrix();
    private final Matrix mDrawMatrix = new Matrix();
    private final Matrix mSuppMatrix = new Matrix();
    private final RectF mDisplayRect = new RectF();
    private final float[] mMatrixValues = new float[9];
    private OnMatrixChangedListener mMatrixChangeListener;
    private OnPhotoTapListener mPhotoTapListener;
    private OnOutsidePhotoTapListener mOutsidePhotoTapListener;
    private OnViewTapListener mViewTapListener;
    private View.OnClickListener mOnClickListener;
    private View.OnLongClickListener mLongClickListener;
    private OnScaleChangedListener mScaleChangeListener;
    private OnSingleFlingListener mSingleFlingListener;
    private OnDoubleTap mDoubleTap;
    private OnViewDragListener mOnViewDragListener;
    private FlingRunnable mCurrentFlingRunnable;
    private int mScrollEdge = 2;
    private float mBaseRotation;
    private boolean mZoomEnabled = true;
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;
    private OnGestureListener onGestureListener = new OnGestureListener(){

        @Override
        public void onDrag(float f2, float f3) {
            if (PhotoViewAttacher.this.mScaleDragDetector.isScaling()) {
                return;
            }
            if (PhotoViewAttacher.this.mOnViewDragListener != null) {
                PhotoViewAttacher.this.mOnViewDragListener.onDrag(f2, f3);
            }
            PhotoViewAttacher.this.mSuppMatrix.postTranslate(f2, f3);
            PhotoViewAttacher.this.checkAndDisplayMatrix();
            ViewParent viewParent = PhotoViewAttacher.this.mImageView.getParent();
            if (PhotoViewAttacher.this.mAllowParentInterceptOnEdge && !PhotoViewAttacher.this.mScaleDragDetector.isScaling() && !PhotoViewAttacher.this.mBlockParentIntercept) {
                if ((PhotoViewAttacher.this.mScrollEdge == 2 || PhotoViewAttacher.this.mScrollEdge == 0 && f2 >= 1.0f || PhotoViewAttacher.this.mScrollEdge == 1 && f2 <= -1.0f) && viewParent != null) {
                    viewParent.requestDisallowInterceptTouchEvent(false);
                }
            } else if (viewParent != null) {
                viewParent.requestDisallowInterceptTouchEvent(true);
            }
        }

        @Override
        public void onFling(float f2, float f3, float f4, float f5) {
            PhotoViewAttacher.this.mCurrentFlingRunnable = new FlingRunnable(PhotoViewAttacher.this.mImageView.getContext());
            PhotoViewAttacher.this.mCurrentFlingRunnable.fling(PhotoViewAttacher.this.getImageViewWidth(PhotoViewAttacher.this.mImageView), PhotoViewAttacher.this.getImageViewHeight(PhotoViewAttacher.this.mImageView), (int)f4, (int)f5);
            PhotoViewAttacher.this.mImageView.post((Runnable)PhotoViewAttacher.this.mCurrentFlingRunnable);
        }

        @Override
        public void onScale(float f2, float f3, float f4) {
            if ((PhotoViewAttacher.this.getScale() < PhotoViewAttacher.this.mMaxScale || f2 < 1.0f) && (PhotoViewAttacher.this.getScale() > PhotoViewAttacher.this.mMinScale || f2 > 1.0f)) {
                if (PhotoViewAttacher.this.mScaleChangeListener != null) {
                    PhotoViewAttacher.this.mScaleChangeListener.onScaleChange(f2, f3, f4);
                }
                PhotoViewAttacher.this.mSuppMatrix.postScale(f2, f2, f3, f4);
                PhotoViewAttacher.this.checkAndDisplayMatrix();
            }
        }
    };

    public PhotoViewAttacher(ImageView imageView) {
        this.mImageView = imageView;
        imageView.setOnTouchListener((View.OnTouchListener)this);
        imageView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        if (imageView.isInEditMode()) {
            return;
        }
        this.mBaseRotation = 0.0f;
        this.mScaleDragDetector = new CustomGestureDetector(imageView.getContext(), this.onGestureListener, this.mDoubleTap);
        this.mGestureDetector = new GestureDetector(imageView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent motionEvent) {
                if (PhotoViewAttacher.this.mLongClickListener != null) {
                    PhotoViewAttacher.this.mLongClickListener.onLongClick((View)PhotoViewAttacher.this.mImageView);
                }
            }

            public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
                if (PhotoViewAttacher.this.mSingleFlingListener != null) {
                    if (PhotoViewAttacher.this.getScale() > DEFAULT_MIN_SCALE) {
                        return false;
                    }
                    if (MotionEventCompat.getPointerCount((MotionEvent)motionEvent) > SINGLE_TOUCH || MotionEventCompat.getPointerCount((MotionEvent)motionEvent2) > SINGLE_TOUCH) {
                        return false;
                    }
                    return PhotoViewAttacher.this.mSingleFlingListener.onFling(motionEvent, motionEvent2, f2, f3);
                }
                return false;
            }
        });
        this.mGestureDetector.setOnDoubleTapListener(new GestureDetector.OnDoubleTapListener(){

            public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
                if (PhotoViewAttacher.this.mOnClickListener != null) {
                    PhotoViewAttacher.this.mOnClickListener.onClick((View)PhotoViewAttacher.this.mImageView);
                }
                RectF rectF = PhotoViewAttacher.this.getDisplayRect();
                float f2 = motionEvent.getX();
                float f3 = motionEvent.getY();
                if (PhotoViewAttacher.this.mViewTapListener != null) {
                    PhotoViewAttacher.this.mViewTapListener.onViewTap((View)PhotoViewAttacher.this.mImageView, f2, f3);
                }
                if (rectF != null) {
                    if (rectF.contains(f2, f3)) {
                        float f4 = (f2 - rectF.left) / rectF.width();
                        float f5 = (f3 - rectF.top) / rectF.height();
                        if (PhotoViewAttacher.this.mPhotoTapListener != null) {
                            PhotoViewAttacher.this.mPhotoTapListener.onPhotoTap(PhotoViewAttacher.this.mImageView, f4, f5);
                        }
                        return true;
                    }
                    if (PhotoViewAttacher.this.mOutsidePhotoTapListener != null) {
                        PhotoViewAttacher.this.mOutsidePhotoTapListener.onOutsidePhotoTap(PhotoViewAttacher.this.mImageView);
                    }
                }
                return false;
            }

            public boolean onDoubleTap(MotionEvent motionEvent) {
                try {
                    float f2 = PhotoViewAttacher.this.getScale();
                    float f3 = motionEvent.getX();
                    float f4 = motionEvent.getY();
                    if (f2 < PhotoViewAttacher.this.getMediumScale()) {
                        PhotoViewAttacher.this.setScale(PhotoViewAttacher.this.getMediumScale(), f3, f4, true);
                        if (PhotoViewAttacher.this.mDoubleTap != null) {
                            PhotoViewAttacher.this.mDoubleTap.onDoubleTap(PhotoViewAttacher.this.getMediumScale());
                        }
                        PhotoViewAttacher.this.mScaleDragDetector.setOnDoubleTapValue(PhotoViewAttacher.this.getMediumScale());
                    } else if (f2 >= PhotoViewAttacher.this.getMediumScale() && f2 < PhotoViewAttacher.this.getMaximumScale()) {
                        PhotoViewAttacher.this.setScale(PhotoViewAttacher.this.getMaximumScale(), f3, f4, true);
                        if (PhotoViewAttacher.this.mDoubleTap != null) {
                            PhotoViewAttacher.this.mDoubleTap.onDoubleTap(PhotoViewAttacher.this.getMaximumScale());
                        }
                        PhotoViewAttacher.this.mScaleDragDetector.setOnDoubleTapValue(PhotoViewAttacher.this.getMaximumScale());
                    } else {
                        PhotoViewAttacher.this.setScale(PhotoViewAttacher.this.getMinimumScale(), f3, f4, true);
                        if (PhotoViewAttacher.this.mDoubleTap != null) {
                            PhotoViewAttacher.this.mDoubleTap.onDoubleTap(PhotoViewAttacher.this.getMinimumScale());
                        }
                        PhotoViewAttacher.this.mScaleDragDetector.setOnDoubleTapValue(PhotoViewAttacher.this.getMinimumScale());
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                return true;
            }

            public boolean onDoubleTapEvent(MotionEvent motionEvent) {
                return false;
            }
        });
    }

    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        this.mGestureDetector.setOnDoubleTapListener(onDoubleTapListener);
    }

    public void setOnScaleChangeListener(OnScaleChangedListener onScaleChangedListener) {
        this.mScaleChangeListener = onScaleChangedListener;
    }

    public void setOnSingleFlingListener(OnSingleFlingListener onSingleFlingListener) {
        this.mSingleFlingListener = onSingleFlingListener;
    }

    public void setOnDoubleTap(OnDoubleTap onDoubleTap) {
        this.mDoubleTap = onDoubleTap;
        if (this.mImageView != null) {
            this.mScaleDragDetector = new CustomGestureDetector(this.mImageView.getContext(), this.onGestureListener, this.mDoubleTap);
        }
    }

    @Deprecated
    public boolean isZoomEnabled() {
        return this.mZoomEnabled;
    }

    public RectF getDisplayRect() {
        this.checkMatrixBounds();
        return this.getDisplayRect(this.getDrawMatrix());
    }

    public boolean setDisplayMatrix(Matrix matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix cannot be null");
        }
        if (this.mImageView.getDrawable() == null) {
            return false;
        }
        this.mSuppMatrix.set(matrix);
        this.checkAndDisplayMatrix();
        return true;
    }

    public void setBaseRotation(float f2) {
        this.mBaseRotation = f2 % 360.0f;
        this.update();
        this.setRotationBy(this.mBaseRotation);
        this.checkAndDisplayMatrix();
    }

    public void setRotationTo(float f2) {
        this.mSuppMatrix.setRotate(f2 % 360.0f);
        this.checkAndDisplayMatrix();
    }

    public void setRotationBy(float f2) {
        this.mSuppMatrix.postRotate(f2 % 360.0f);
        this.checkAndDisplayMatrix();
    }

    public float getMinimumScale() {
        return this.mMinScale;
    }

    public float getMediumScale() {
        return this.mMidScale;
    }

    public float getMaximumScale() {
        return this.mMaxScale;
    }

    public float getScale() {
        return (float)Math.sqrt((float)Math.pow(this.getValue(this.mSuppMatrix, 0), 2.0) + (float)Math.pow(this.getValue(this.mSuppMatrix, 3), 2.0));
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n != n5 || n2 != n6 || n3 != n7 || n4 != n8) {
            this.updateBaseMatrix(this.mImageView.getDrawable());
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        boolean bl = false;
        if (this.mZoomEnabled && Util.hasDrawable((ImageView)view)) {
            switch (motionEvent.getAction()) {
                case 0: {
                    ViewParent viewParent = view.getParent();
                    if (viewParent != null) {
                        viewParent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.cancelFling();
                    break;
                }
                case 1: 
                case 3: {
                    RectF rectF;
                    if (this.getScale() <= this.mMinScale) {
                        if (this.mDoubleTap != null) {
                            this.mDoubleTap.onDoubleTap(this.mMinScale);
                        }
                        if ((rectF = this.getDisplayRect()) == null) break;
                        view.post((Runnable)new AnimatedZoomRunnable(this.getScale(), this.mMinScale, rectF.centerX(), rectF.centerY()));
                        bl = true;
                        break;
                    }
                    if (!(this.getScale() >= this.mMaxScale) || (rectF = this.getDisplayRect()) == null) break;
                    view.post((Runnable)new AnimatedZoomRunnable(this.getScale(), this.mMaxScale, rectF.centerX(), rectF.centerY()));
                    bl = true;
                }
            }
            if (this.mScaleDragDetector != null) {
                boolean bl2 = this.mScaleDragDetector.isScaling();
                boolean bl3 = this.mScaleDragDetector.isDragging();
                bl = this.mScaleDragDetector.onTouchEvent(motionEvent);
                boolean bl4 = !bl2 && !this.mScaleDragDetector.isScaling();
                boolean bl5 = !bl3 && !this.mScaleDragDetector.isDragging();
                boolean bl6 = this.mBlockParentIntercept = bl4 && bl5;
            }
            if (this.mGestureDetector != null && this.mGestureDetector.onTouchEvent(motionEvent)) {
                bl = true;
            }
        }
        return bl;
    }

    public void setAllowParentInterceptOnEdge(boolean bl) {
        this.mAllowParentInterceptOnEdge = bl;
    }

    public void setMinimumScale(float f2) {
        Util.checkZoomLevels(f2, this.mMidScale, this.mMaxScale);
        this.mMinScale = f2;
    }

    public void setMediumScale(float f2) {
        Util.checkZoomLevels(this.mMinScale, f2, this.mMaxScale);
        this.mMidScale = f2;
    }

    public void setMaximumScale(float f2) {
        Util.checkZoomLevels(this.mMinScale, this.mMidScale, f2);
        this.mMaxScale = f2;
    }

    public void setScaleLevels(float f2, float f3, float f4) {
        Util.checkZoomLevels(f2, f3, f4);
        this.mMinScale = f2;
        this.mMidScale = f3;
        this.mMaxScale = f4;
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.mLongClickListener = onLongClickListener;
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }

    public void setOnMatrixChangeListener(OnMatrixChangedListener onMatrixChangedListener) {
        this.mMatrixChangeListener = onMatrixChangedListener;
    }

    public void setOnPhotoTapListener(OnPhotoTapListener onPhotoTapListener) {
        this.mPhotoTapListener = onPhotoTapListener;
    }

    public void setOnOutsidePhotoTapListener(OnOutsidePhotoTapListener onOutsidePhotoTapListener) {
        this.mOutsidePhotoTapListener = onOutsidePhotoTapListener;
    }

    public void setOnViewTapListener(OnViewTapListener onViewTapListener) {
        this.mViewTapListener = onViewTapListener;
    }

    public void setOnViewDragListener(OnViewDragListener onViewDragListener) {
        this.mOnViewDragListener = onViewDragListener;
    }

    public void setScale(float f2) {
        this.setScale(f2, false);
    }

    public void setScale(float f2, boolean bl) {
        this.setScale(f2, this.mImageView.getRight() / 2, this.mImageView.getBottom() / 2, bl);
    }

    public void setScale(float f2, float f3, float f4, boolean bl) {
        if (f2 < this.mMinScale || f2 > this.mMaxScale) {
            throw new IllegalArgumentException("Scale must be within the range of minScale and maxScale");
        }
        if (bl) {
            this.mImageView.post((Runnable)new AnimatedZoomRunnable(this.getScale(), f2, f3, f4));
        } else {
            this.mSuppMatrix.setScale(f2, f2, f3, f4);
            this.checkAndDisplayMatrix();
        }
    }

    public void setZoomInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (Util.isSupportedScaleType(scaleType) && scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.update();
        }
    }

    public boolean isZoomable() {
        return this.mZoomEnabled;
    }

    public void setZoomable(boolean bl) {
        this.mZoomEnabled = bl;
        this.update();
    }

    public void update() {
        if (this.mZoomEnabled) {
            this.updateBaseMatrix(this.mImageView.getDrawable());
        } else {
            this.resetMatrix();
        }
    }

    public void getDisplayMatrix(Matrix matrix) {
        matrix.set(this.getDrawMatrix());
    }

    public void getSuppMatrix(Matrix matrix) {
        matrix.set(this.mSuppMatrix);
    }

    private Matrix getDrawMatrix() {
        this.mDrawMatrix.set(this.mBaseMatrix);
        this.mDrawMatrix.postConcat(this.mSuppMatrix);
        return this.mDrawMatrix;
    }

    public Matrix getImageMatrix() {
        return this.mDrawMatrix;
    }

    public void setZoomTransitionDuration(int n) {
        this.mZoomDuration = n;
    }

    private float getValue(Matrix matrix, int n) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[n];
    }

    private void resetMatrix() {
        this.mSuppMatrix.reset();
        this.setRotationBy(this.mBaseRotation);
        this.setImageViewMatrix(this.getDrawMatrix());
        this.checkMatrixBounds();
    }

    private void setImageViewMatrix(Matrix matrix) {
        RectF rectF;
        this.mImageView.setImageMatrix(matrix);
        if (this.mMatrixChangeListener != null && (rectF = this.getDisplayRect(matrix)) != null) {
            this.mMatrixChangeListener.onMatrixChanged(rectF);
        }
    }

    private void checkAndDisplayMatrix() {
        if (this.checkMatrixBounds()) {
            this.setImageViewMatrix(this.getDrawMatrix());
        }
    }

    private RectF getDisplayRect(Matrix matrix) {
        Drawable drawable2 = this.mImageView.getDrawable();
        if (drawable2 != null) {
            this.mDisplayRect.set(0.0f, 0.0f, (float)drawable2.getIntrinsicWidth(), (float)drawable2.getIntrinsicHeight());
            matrix.mapRect(this.mDisplayRect);
            return this.mDisplayRect;
        }
        return null;
    }

    private void updateBaseMatrix(Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        float f2 = this.getImageViewWidth(this.mImageView);
        float f3 = this.getImageViewHeight(this.mImageView);
        int n = drawable2.getIntrinsicWidth();
        int n2 = drawable2.getIntrinsicHeight();
        this.mBaseMatrix.reset();
        float f4 = f2 / (float)n;
        float f5 = f3 / (float)n2;
        if (this.mScaleType == ImageView.ScaleType.CENTER) {
            this.mBaseMatrix.postTranslate((f2 - (float)n) / 2.0f, (f3 - (float)n2) / 2.0f);
        } else if (this.mScaleType == ImageView.ScaleType.CENTER_CROP) {
            float f6 = Math.max(f4, f5);
            this.mBaseMatrix.postScale(f6, f6);
            this.mBaseMatrix.postTranslate((f2 - (float)n * f6) / 2.0f, (f3 - (float)n2 * f6) / 2.0f);
        } else if (this.mScaleType == ImageView.ScaleType.CENTER_INSIDE) {
            float f7 = Math.min(1.0f, Math.min(f4, f5));
            this.mBaseMatrix.postScale(f7, f7);
            this.mBaseMatrix.postTranslate((f2 - (float)n * f7) / 2.0f, (f3 - (float)n2 * f7) / 2.0f);
        } else {
            RectF rectF = new RectF(0.0f, 0.0f, (float)n, (float)n2);
            RectF rectF2 = new RectF(0.0f, 0.0f, f2, f3);
            if ((int)this.mBaseRotation % 180 != 0) {
                rectF = new RectF(0.0f, 0.0f, (float)n2, (float)n);
            }
            switch (this.mScaleType) {
                case FIT_CENTER: {
                    this.mBaseMatrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.CENTER);
                    break;
                }
                case FIT_START: {
                    this.mBaseMatrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.START);
                    break;
                }
                case FIT_END: {
                    this.mBaseMatrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.END);
                    break;
                }
                case FIT_XY: {
                    this.mBaseMatrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.FILL);
                    break;
                }
            }
        }
        this.resetMatrix();
    }

    private boolean checkMatrixBounds() {
        RectF rectF = this.getDisplayRect(this.getDrawMatrix());
        if (rectF == null) {
            return false;
        }
        float f2 = rectF.height();
        float f3 = rectF.width();
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n = this.getImageViewHeight(this.mImageView);
        if (f2 <= (float)n) {
            switch (this.mScaleType) {
                case FIT_START: {
                    f5 = -rectF.top;
                    break;
                }
                case FIT_END: {
                    f5 = (float)n - f2 - rectF.top;
                    break;
                }
                default: {
                    f5 = ((float)n - f2) / 2.0f - rectF.top;
                    break;
                }
            }
        } else if (rectF.top > 0.0f) {
            f5 = -rectF.top;
        } else if (rectF.bottom < (float)n) {
            f5 = (float)n - rectF.bottom;
        }
        int n2 = this.getImageViewWidth(this.mImageView);
        if (f3 <= (float)n2) {
            switch (this.mScaleType) {
                case FIT_START: {
                    f4 = -rectF.left;
                    break;
                }
                case FIT_END: {
                    f4 = (float)n2 - f3 - rectF.left;
                    break;
                }
                default: {
                    f4 = ((float)n2 - f3) / 2.0f - rectF.left;
                }
            }
            this.mScrollEdge = 2;
        } else if (rectF.left > 0.0f) {
            this.mScrollEdge = 0;
            f4 = -rectF.left;
        } else if (rectF.right < (float)n2) {
            f4 = (float)n2 - rectF.right;
            this.mScrollEdge = 1;
        } else {
            this.mScrollEdge = -1;
        }
        this.mSuppMatrix.postTranslate(f4, f5);
        return true;
    }

    private int getImageViewWidth(ImageView imageView) {
        return imageView.getWidth() - imageView.getPaddingLeft() - imageView.getPaddingRight();
    }

    private int getImageViewHeight(ImageView imageView) {
        return imageView.getHeight() - imageView.getPaddingTop() - imageView.getPaddingBottom();
    }

    private void cancelFling() {
        if (this.mCurrentFlingRunnable != null) {
            this.mCurrentFlingRunnable.cancelFling();
            this.mCurrentFlingRunnable = null;
        }
    }

    private class FlingRunnable
    implements Runnable {
        private final OverScroller mScroller;
        private int mCurrentX;
        private int mCurrentY;

        public FlingRunnable(Context context) {
            this.mScroller = new OverScroller(context);
        }

        public void cancelFling() {
            this.mScroller.forceFinished(true);
        }

        public void fling(int n, int n2, int n3, int n4) {
            int n5;
            int n6;
            int n7;
            int n8;
            RectF rectF = PhotoViewAttacher.this.getDisplayRect();
            if (rectF == null) {
                return;
            }
            int n9 = Math.round(-rectF.left);
            if ((float)n < rectF.width()) {
                n8 = 0;
                n7 = Math.round(rectF.width() - (float)n);
            } else {
                n8 = n7 = n9;
            }
            int n10 = Math.round(-rectF.top);
            if ((float)n2 < rectF.height()) {
                n6 = 0;
                n5 = Math.round(rectF.height() - (float)n2);
            } else {
                n6 = n5 = n10;
            }
            this.mCurrentX = n9;
            this.mCurrentY = n10;
            if (n9 != n7 || n10 != n5) {
                this.mScroller.fling(n9, n10, n3, n4, n8, n7, n6, n5, 0, 0);
            }
        }

        @Override
        public void run() {
            if (this.mScroller.isFinished()) {
                return;
            }
            if (this.mScroller.computeScrollOffset()) {
                int n = this.mScroller.getCurrX();
                int n2 = this.mScroller.getCurrY();
                PhotoViewAttacher.this.mSuppMatrix.postTranslate((float)(this.mCurrentX - n), (float)(this.mCurrentY - n2));
                PhotoViewAttacher.this.checkAndDisplayMatrix();
                this.mCurrentX = n;
                this.mCurrentY = n2;
                Compat.postOnAnimation((View)PhotoViewAttacher.this.mImageView, this);
            }
        }
    }

    private class AnimatedZoomRunnable
    implements Runnable {
        private final float mFocalX;
        private final float mFocalY;
        private final long mStartTime;
        private final float mZoomStart;
        private final float mZoomEnd;

        public AnimatedZoomRunnable(float f2, float f3, float f4, float f5) {
            this.mFocalX = f4;
            this.mFocalY = f5;
            this.mStartTime = System.currentTimeMillis();
            this.mZoomStart = f2;
            this.mZoomEnd = f3;
        }

        @Override
        public void run() {
            float f2 = this.interpolate();
            float f3 = this.mZoomStart + f2 * (this.mZoomEnd - this.mZoomStart);
            float f4 = f3 / PhotoViewAttacher.this.getScale();
            Log.e((String)"Scaling", (String)(f3 + ""));
            PhotoViewAttacher.this.onGestureListener.onScale(f4, this.mFocalX, this.mFocalY);
            if (f2 < 1.0f) {
                Compat.postOnAnimation((View)PhotoViewAttacher.this.mImageView, this);
            }
        }

        private float interpolate() {
            float f2 = 1.0f * (float)(System.currentTimeMillis() - this.mStartTime) / (float)PhotoViewAttacher.this.mZoomDuration;
            f2 = Math.min(1.0f, f2);
            f2 = PhotoViewAttacher.this.mInterpolator.getInterpolation(f2);
            return f2;
        }
    }
}

