/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.photoview;

import android.content.Context;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import com.hippo.utils.photoview.OnDoubleTap;
import com.hippo.utils.photoview.OnGestureListener;
import com.hippo.utils.photoview.Util;

class CustomGestureDetector {
    private static final int INVALID_POINTER_ID = -1;
    private int mActivePointerId = -1;
    private int mActivePointerIndex = 0;
    private final ScaleGestureDetector mDetector;
    private VelocityTracker mVelocityTracker;
    private boolean mIsDragging;
    private float mLastTouchX;
    private float mLastTouchY;
    private final float mTouchSlop;
    private final float mMinimumVelocity;
    private OnGestureListener mListener;
    private OnDoubleTap onDoubleTapGlobal;
    private float scaleFactorGlobal = 1.0f;

    CustomGestureDetector(Context context, OnGestureListener onGestureListener, OnDoubleTap onDoubleTap) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.onDoubleTapGlobal = onDoubleTap;
        this.mListener = onGestureListener;
        ScaleGestureDetector.OnScaleGestureListener onScaleGestureListener = new ScaleGestureDetector.OnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
                float f2 = scaleGestureDetector.getScaleFactor();
                CustomGestureDetector.this.scaleFactorGlobal = f2;
                Log.e((String)"Scale factor", (String)(f2 + ""));
                if (Float.isNaN(f2) || Float.isInfinite(f2)) {
                    return false;
                }
                CustomGestureDetector.this.mListener.onScale(f2, scaleGestureDetector.getFocusX(), scaleGestureDetector.getFocusY());
                return true;
            }

            public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
                return true;
            }

            public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
            }
        };
        this.mDetector = new ScaleGestureDetector(context, onScaleGestureListener);
    }

    private float getActiveX(MotionEvent motionEvent) {
        try {
            return motionEvent.getX(this.mActivePointerIndex);
        }
        catch (Exception exception) {
            return motionEvent.getX();
        }
    }

    public void setOnDoubleTapValue(float f2) {
        this.scaleFactorGlobal = f2;
    }

    private float getActiveY(MotionEvent motionEvent) {
        try {
            return motionEvent.getY(this.mActivePointerIndex);
        }
        catch (Exception exception) {
            return motionEvent.getY();
        }
    }

    public boolean isScaling() {
        return this.mDetector.isInProgress();
    }

    public boolean isDragging() {
        return this.mIsDragging;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        try {
            this.mDetector.onTouchEvent(motionEvent);
            return this.processTouchEvent(motionEvent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
    }

    private boolean processTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (this.onDoubleTapGlobal != null && motionEvent.getPointerCount() > 1 && (n == 0 || n == 2)) {
            this.onDoubleTapGlobal.onDoubleTap(2.0f);
        }
        switch (n & 0xFF) {
            case 0: {
                this.mActivePointerId = motionEvent.getPointerId(0);
                this.mVelocityTracker = VelocityTracker.obtain();
                if (null != this.mVelocityTracker) {
                    this.mVelocityTracker.addMovement(motionEvent);
                }
                this.mLastTouchX = this.getActiveX(motionEvent);
                this.mLastTouchY = this.getActiveY(motionEvent);
                this.mIsDragging = false;
                break;
            }
            case 2: {
                float f2 = this.getActiveX(motionEvent);
                float f3 = this.getActiveY(motionEvent);
                float f4 = f2 - this.mLastTouchX;
                float f5 = f3 - this.mLastTouchY;
                if (!this.mIsDragging) {
                    boolean bl = this.mIsDragging = Math.sqrt(f4 * f4 + f5 * f5) >= (double)this.mTouchSlop;
                }
                if (!this.mIsDragging) break;
                this.mListener.onDrag(f4, f5);
                this.mLastTouchX = f2;
                this.mLastTouchY = f3;
                if (null == this.mVelocityTracker) break;
                this.mVelocityTracker.addMovement(motionEvent);
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                if (null == this.mVelocityTracker) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 1: {
                this.mActivePointerId = -1;
                if (this.mIsDragging && null != this.mVelocityTracker) {
                    this.mLastTouchX = this.getActiveX(motionEvent);
                    this.mLastTouchY = this.getActiveY(motionEvent);
                    this.mVelocityTracker.addMovement(motionEvent);
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    float f6 = this.mVelocityTracker.getXVelocity();
                    float f7 = this.mVelocityTracker.getYVelocity();
                    if (Math.max(Math.abs(f6), Math.abs(f7)) >= this.mMinimumVelocity) {
                        this.mListener.onFling(this.mLastTouchX, this.mLastTouchY, -f6, -f7);
                    }
                }
                if (null == this.mVelocityTracker) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 6: {
                int n2 = Util.getPointerIndex(motionEvent.getAction());
                int n3 = motionEvent.getPointerId(n2);
                if (n3 != this.mActivePointerId) break;
                int n4 = n2 == 0 ? 1 : 0;
                this.mActivePointerId = motionEvent.getPointerId(n4);
                this.mLastTouchX = motionEvent.getX(n4);
                this.mLastTouchY = motionEvent.getY(n4);
            }
        }
        this.mActivePointerIndex = motionEvent.findPointerIndex(this.mActivePointerId != -1 ? this.mActivePointerId : 0);
        return true;
    }
}

