/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.linkPreview;

import android.os.AsyncTask;
import com.hippo.utils.linkPreview.LinkPreviewCallback;
import com.hippo.utils.linkPreview.Regex;
import com.hippo.utils.linkPreview.SearchUrls;
import com.hippo.utils.linkPreview.SourceContent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class TextCrawler {
    public static final int ALL = -1;
    public static final int NONE = -2;
    private final String HTTP_PROTOCOL = "http://";
    private final String HTTPS_PROTOCOL = "https://";
    private LinkPreviewCallback callback;
    private AsyncTask getCodeTask;

    public void makePreview(LinkPreviewCallback linkPreviewCallback, String string2) {
        this.makePreview(linkPreviewCallback, string2, -1);
    }

    public void makePreview(LinkPreviewCallback linkPreviewCallback, String string2, int n) {
        this.callback = linkPreviewCallback;
        this.cancel();
        this.getCodeTask = new GetCode(n).execute(new String[]{string2});
    }

    public void cancel() {
        if (this.getCodeTask != null) {
            this.getCodeTask.cancel(true);
        }
    }

    private String getTagContent(String string2, String string3) {
        String string4 = "<" + string2 + "(.*?)>(.*?)</" + string2 + ">";
        String string5 = "";
        String string6 = "";
        List<String> list = Regex.pregMatchAll(string3, string4, 2);
        int n = list.size();
        for (int j = 0; j < n && !this.getCodeTask.isCancelled(); ++j) {
            string6 = this.stripTags(list.get(j));
            if (string6.length() < 120) continue;
            string5 = TextCrawler.extendedTrim(string6);
            break;
        }
        if (string5.equals("")) {
            String string7 = Regex.pregMatch(string3, string4, 2);
            string5 = TextCrawler.extendedTrim(string7);
        }
        string5 = string5.replaceAll("&nbsp;", "");
        return this.htmlDecode(string5);
    }

    public List<String> getImages(Document document, int n) {
        List<String> list = new ArrayList<String>();
        Elements elements = document.select("[src]");
        for (Element element : elements) {
            if (this.getCodeTask.isCancelled()) break;
            if (!element.tagName().equals("img")) continue;
            list.add(element.attr("abs:src"));
        }
        if (n != -1) {
            list = list.subList(0, n);
        }
        return list;
    }

    private String htmlDecode(String string2) {
        return Jsoup.parse((String)string2).text();
    }

    private String crawlCode(String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        string4 = this.getTagContent("span", string2);
        string5 = this.getTagContent("p", string2);
        string6 = this.getTagContent("div", string2);
        string3 = string4;
        string3 = string5.length() > string4.length() && string5.length() >= string6.length() ? string5 : (string5.length() > string4.length() && string5.length() < string6.length() ? string6 : string5);
        return this.htmlDecode(string3);
    }

    private String cannonicalPage(String string2) {
        String string3 = "";
        if (string2.startsWith("http://")) {
            string2 = string2.substring("http://".length());
        } else if (string2.startsWith("https://")) {
            string2 = string2.substring("https://".length());
        }
        int n = string2.length();
        for (int j = 0; j < n && !this.getCodeTask.isCancelled() && string2.charAt(j) != '/'; ++j) {
            string3 = string3 + string2.charAt(j);
        }
        return string3;
    }

    private String stripTags(String string2) {
        return Jsoup.parse((String)string2).text();
    }

    private boolean isImage(String string2) {
        return string2.matches("(.+?)\\.(jpg|png|gif|bmp)$");
    }

    private HashMap<String, String> getMetaTags(String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("url", "");
        hashMap.put("title", "");
        hashMap.put("description", "");
        hashMap.put("image", "");
        List<String> list = Regex.pregMatchAll(string2, "<meta(.*?)>", 1);
        for (String string3 : list) {
            if (this.getCodeTask.isCancelled()) break;
            String string4 = string3.toLowerCase();
            if (string4.contains("property=\"og:url\"") || string4.contains("property='og:url'") || string4.contains("name=\"url\"") || string4.contains("name='url'")) {
                this.updateMetaTag(hashMap, "url", this.separeMetaTagsContent(string3));
                continue;
            }
            if (string4.contains("property=\"og:title\"") || string4.contains("property='og:title'") || string4.contains("name=\"title\"") || string4.contains("name='title'")) {
                this.updateMetaTag(hashMap, "title", this.separeMetaTagsContent(string3));
                continue;
            }
            if (string4.contains("property=\"og:description\"") || string4.contains("property='og:description'") || string4.contains("name=\"description\"") || string4.contains("name='description'")) {
                this.updateMetaTag(hashMap, "description", this.separeMetaTagsContent(string3));
                continue;
            }
            if (!string4.contains("property=\"og:image\"") && !string4.contains("property='og:image'") && !string4.contains("name=\"image\"") && !string4.contains("name='image'")) continue;
            this.updateMetaTag(hashMap, "image", this.separeMetaTagsContent(string3));
        }
        return hashMap;
    }

    private void updateMetaTag(HashMap<String, String> hashMap, String string2, String string3) {
        if (string3 != null && string3.length() > 0) {
            hashMap.put(string2, string3);
        }
    }

    private String separeMetaTagsContent(String string2) {
        String string3 = Regex.pregMatch(string2, "content=\"(.*?)\"", 1);
        return this.htmlDecode(string3);
    }

    private String unshortenUrl(String string2) {
        if (!string2.startsWith("http://") && !string2.startsWith("https://")) {
            return "";
        }
        URLConnection uRLConnection = this.connectURL(string2);
        uRLConnection.getHeaderFields();
        String string3 = uRLConnection.getURL().toString();
        uRLConnection = this.connectURL(string3);
        uRLConnection.getHeaderFields();
        string2 = uRLConnection.getURL().toString();
        while (!string2.equals(string3)) {
            string3 = this.unshortenUrl(string3);
        }
        return string3;
    }

    private URLConnection connectURL(String string2) {
        URLConnection uRLConnection = null;
        try {
            URL uRL = new URL(string2);
            uRLConnection = uRL.openConnection();
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Please input a valid URL");
        }
        catch (IOException iOException) {
            System.out.println("Can not connect to the URL");
        }
        return uRLConnection;
    }

    public static String extendedTrim(String string2) {
        return string2.replaceAll("\\s+", " ").replace("\n", " ").replace("\r", " ").trim();
    }

    public class GetCode
    extends AsyncTask<String, Void, Void> {
        private SourceContent sourceContent = new SourceContent();
        private int imageQuantity;
        private ArrayList<String> urls;

        public GetCode(int n) {
            this.imageQuantity = n;
        }

        protected void onPreExecute() {
            if (TextCrawler.this.callback != null) {
                TextCrawler.this.callback.onPre();
            }
            super.onPreExecute();
        }

        protected void onPostExecute(Void void_) {
            if (TextCrawler.this.callback != null) {
                TextCrawler.this.callback.onPos(this.sourceContent, this.isNull());
            }
            super.onPostExecute((Object)void_);
        }

        protected void onCancelled() {
            super.onCancelled();
        }

        protected Void doInBackground(String ... stringArray) {
            Document document;
            this.urls = SearchUrls.matches(stringArray[0]);
            if (this.urls.size() > 0) {
                this.sourceContent.setFinalUrl(TextCrawler.this.unshortenUrl(TextCrawler.extendedTrim(this.urls.get(0))));
            } else {
                this.sourceContent.setFinalUrl("");
            }
            if (!this.sourceContent.getFinalUrl().equals("")) {
                if (TextCrawler.this.isImage(this.sourceContent.getFinalUrl()) && !this.sourceContent.getFinalUrl().contains("dropbox")) {
                    this.sourceContent.setSuccess(true);
                    this.sourceContent.getImages().add(this.sourceContent.getFinalUrl());
                    this.sourceContent.setTitle("");
                    this.sourceContent.setDescription("");
                } else {
                    try {
                        String string2;
                        document = Jsoup.connect((String)this.sourceContent.getFinalUrl()).userAgent("Mozilla").get();
                        this.sourceContent.setHtmlCode(TextCrawler.extendedTrim(document.toString()));
                        HashMap hashMap = TextCrawler.this.getMetaTags(this.sourceContent.getHtmlCode());
                        this.sourceContent.setMetaTags(hashMap);
                        this.sourceContent.setTitle((String)hashMap.get("title"));
                        this.sourceContent.setDescription((String)hashMap.get("description"));
                        if (this.sourceContent.getTitle().equals("") && !(string2 = Regex.pregMatch(this.sourceContent.getHtmlCode(), "<title(.*?)>(.*?)</title>", 2)).equals("")) {
                            this.sourceContent.setTitle(TextCrawler.this.htmlDecode(string2));
                        }
                        if (this.sourceContent.getDescription().equals("")) {
                            this.sourceContent.setDescription(TextCrawler.this.crawlCode(this.sourceContent.getHtmlCode()));
                        }
                        this.sourceContent.setDescription(this.sourceContent.getDescription().replaceAll("<script(.*?)>(.*?)</script>", ""));
                        if (this.imageQuantity != -2) {
                            if (!((String)hashMap.get("image")).equals("")) {
                                this.sourceContent.getImages().add((String)hashMap.get("image"));
                            } else {
                                this.sourceContent.setImages(TextCrawler.this.getImages(document, this.imageQuantity));
                            }
                        }
                        this.sourceContent.setSuccess(true);
                    }
                    catch (Exception exception) {
                        this.sourceContent.setSuccess(false);
                    }
                }
            }
            document = this.sourceContent.getFinalUrl().split("&");
            this.sourceContent.setUrl(document[0]);
            this.sourceContent.setCannonicalUrl(TextCrawler.this.cannonicalPage(this.sourceContent.getFinalUrl()));
            this.sourceContent.setDescription(TextCrawler.this.stripTags(this.sourceContent.getDescription()));
            return null;
        }

        public boolean isNull() {
            return !this.sourceContent.isSuccess() && TextCrawler.extendedTrim(this.sourceContent.getHtmlCode()).equals("") && !TextCrawler.this.isImage(this.sourceContent.getFinalUrl());
        }
    }
}

