/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.hippoHeaderBehavior;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.appbar.AppBarLayout;
import com.hippo.R;
import com.hippo.utils.hippoHeaderBehavior.HippoHeaderView;

public class HippoHeaderBehavior
extends CoordinatorLayout.Behavior<HippoHeaderView> {
    private Context mContext;
    private int mStartMarginLeft;
    private int mEndMarginLeft;
    private int mMarginRight;
    private int mStartMarginBottom;
    private float mTitleStartSize;
    private float mTitleEndSize;
    private boolean isHide;

    public HippoHeaderBehavior(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
    }

    public HippoHeaderBehavior(Context context, AttributeSet attributeSet, Context context2) {
        super(context, attributeSet);
        this.mContext = context2;
    }

    public static int getToolbarHeight(Context context) {
        int n = 0;
        TypedValue typedValue = new TypedValue();
        if (context.getTheme().resolveAttribute(16843499, typedValue, true)) {
            n = TypedValue.complexToDimensionPixelSize((int)typedValue.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
        return n;
    }

    public boolean layoutDependsOn(CoordinatorLayout coordinatorLayout, HippoHeaderView hippoHeaderView, View view) {
        return view instanceof AppBarLayout;
    }

    public boolean onDependentViewChanged(CoordinatorLayout coordinatorLayout, HippoHeaderView hippoHeaderView, View view) {
        this.shouldInitProperties();
        int n = ((AppBarLayout)view).getTotalScrollRange();
        float f2 = Math.abs(view.getY()) / (float)n;
        float f3 = (float)view.getHeight() + view.getY() - (float)hippoHeaderView.getHeight() - (float)(HippoHeaderBehavior.getToolbarHeight(this.mContext) - hippoHeaderView.getHeight()) * f2 / 2.0f;
        f3 -= (float)this.mStartMarginBottom * (1.0f - f2);
        CoordinatorLayout.LayoutParams layoutParams = (CoordinatorLayout.LayoutParams)hippoHeaderView.getLayoutParams();
        if (Math.abs(view.getY()) >= (float)(n / 2)) {
            float f4 = (Math.abs(view.getY()) - (float)(n / 2)) / (float)Math.abs(n / 2);
            layoutParams.leftMargin = (int)(f4 * (float)this.mEndMarginLeft) + this.mStartMarginLeft;
            hippoHeaderView.setTextSize(this.getTranslationOffset(this.mTitleStartSize, this.mTitleEndSize, f4));
        } else {
            layoutParams.leftMargin = this.mStartMarginLeft;
        }
        layoutParams.rightMargin = this.mMarginRight;
        hippoHeaderView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        hippoHeaderView.setY(f3);
        if (this.isHide && f2 < 1.0f) {
            hippoHeaderView.setVisibility(0);
            this.isHide = false;
        } else if (!this.isHide && f2 == 1.0f) {
            hippoHeaderView.setVisibility(8);
            this.isHide = true;
        }
        return true;
    }

    protected float getTranslationOffset(float f2, float f3, float f4) {
        return f2 + f4 * (f3 - f2);
    }

    private void shouldInitProperties() {
        if (this.mStartMarginLeft == 0) {
            this.mStartMarginLeft = this.mContext.getResources().getDimensionPixelOffset(R.dimen.header_view_start_margin_left);
        }
        if (this.mEndMarginLeft == 0) {
            this.mEndMarginLeft = this.mContext.getResources().getDimensionPixelOffset(R.dimen.header_view_end_margin_left);
        }
        if (this.mStartMarginBottom == 0) {
            this.mStartMarginBottom = this.mContext.getResources().getDimensionPixelOffset(R.dimen.header_view_start_margin_bottom);
        }
        if (this.mMarginRight == 0) {
            this.mMarginRight = this.mContext.getResources().getDimensionPixelOffset(R.dimen.header_view_end_margin_right);
        }
        if (this.mTitleStartSize == 0.0f) {
            this.mTitleEndSize = this.mContext.getResources().getDimensionPixelSize(R.dimen.header_view_end_text_size);
        }
        if (this.mTitleStartSize == 0.0f) {
            this.mTitleStartSize = this.mContext.getResources().getDimensionPixelSize(R.dimen.header_view_start_text_size);
        }
    }
}

