/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.adapter.BaseAdapter;
import com.hippo.utils.filepicker.filter.entity.NormalFile;
import java.util.ArrayList;

public class NormalFilePickAdapter
extends BaseAdapter<NormalFile, NormalFilePickViewHolder> {
    protected Context mContext;

    public NormalFilePickAdapter(Context context, int n) {
        this(context, new ArrayList<NormalFile>(), n);
    }

    public NormalFilePickAdapter(Context context, ArrayList<NormalFile> arrayList, int n) {
        super(context, arrayList);
        this.mContext = context;
    }

    public NormalFilePickViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.vw_layout_item_normal_file_pick, viewGroup, false);
        return new NormalFilePickViewHolder(view);
    }

    public void onBindViewHolder(final NormalFilePickViewHolder normalFilePickViewHolder, int n) {
        normalFilePickViewHolder.mCbx.setVisibility(8);
        if (n == 0) {
            normalFilePickViewHolder.mTvTitle.setText(R.string.hippo_browse_other_doc);
            normalFilePickViewHolder.mIvIcon.setImageResource(R.drawable.hippo_ic_storage);
            normalFilePickViewHolder.mTvTitle.setLines(1);
        } else {
            NormalFile normalFile = (NormalFile)this.mList.get(n - 1);
            normalFilePickViewHolder.mTvTitle.setText((CharSequence)Util.extractFileNameWithSuffix(normalFile.getPath()));
            normalFilePickViewHolder.mTvTitle.measure(0, 0);
            if (normalFilePickViewHolder.mTvTitle.getMeasuredWidth() > Util.getScreenWidth(this.mContext) - Util.dip2px(this.mContext, 120.0f)) {
                normalFilePickViewHolder.mTvTitle.setLines(2);
            } else {
                normalFilePickViewHolder.mTvTitle.setLines(1);
            }
            if (normalFile.getPath().toLowerCase().endsWith("xls") || normalFile.getPath().toLowerCase().endsWith("xlsx")) {
                normalFilePickViewHolder.mIvIcon.setImageResource(R.drawable.vw_ic_excel);
            } else if (normalFile.getPath().toLowerCase().endsWith("doc") || normalFile.getPath().toLowerCase().endsWith("docx")) {
                normalFilePickViewHolder.mIvIcon.setImageResource(R.drawable.vw_ic_word);
            } else if (normalFile.getPath().toLowerCase().endsWith("ppt") || normalFile.getPath().endsWith("pptx")) {
                normalFilePickViewHolder.mIvIcon.setImageResource(R.drawable.vw_ic_ppt);
            } else if (normalFile.getPath().toLowerCase().endsWith("pdf")) {
                normalFilePickViewHolder.mIvIcon.setImageResource(R.drawable.vw_ic_pdf);
            } else if (normalFile.getPath().toLowerCase().endsWith("txt")) {
                normalFilePickViewHolder.mIvIcon.setImageResource(R.drawable.vw_ic_txt);
            } else {
                normalFilePickViewHolder.mIvIcon.setImageResource(R.drawable.vw_ic_file);
            }
        }
        normalFilePickViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int n = normalFilePickViewHolder.getAdapterPosition();
                if (n == 0) {
                    if (NormalFilePickAdapter.this.mListener != null) {
                        NormalFilePickAdapter.this.mListener.OnSelectStateChanged(true, null);
                    }
                } else {
                    ((NormalFile)NormalFilePickAdapter.this.mList.get(normalFilePickViewHolder.getAdapterPosition())).setSelected(normalFilePickViewHolder.mCbx.isSelected());
                    if (NormalFilePickAdapter.this.mListener != null) {
                        NormalFilePickAdapter.this.mListener.OnSelectStateChanged(normalFilePickViewHolder.mCbx.isSelected(), NormalFilePickAdapter.this.mList.get(normalFilePickViewHolder.getAdapterPosition() - 1));
                    }
                }
            }
        });
    }

    public int getItemCount() {
        return this.mList.size() + 1;
    }

    public Bitmap writeOnDrawable(int n, String string2) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)n).copy(Bitmap.Config.ARGB_8888, true);
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(-16777216);
        paint.setTextSize(20.0f);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawText(string2, 0.0f, (float)(bitmap.getHeight() / 2), paint);
        return bitmap;
    }

    class NormalFilePickViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mIvIcon;
        private TextView mTvTitle;
        private ImageView mCbx;

        public NormalFilePickViewHolder(View view) {
            super(view);
            this.mIvIcon = (ImageView)view.findViewById(R.id.ic_file);
            this.mTvTitle = (TextView)view.findViewById(R.id.tv_file_title);
            this.mCbx = (ImageView)view.findViewById(R.id.cbx);
        }
    }
}

