/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.activity;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.utils.filepicker.DividerGridItemDecoration;
import com.hippo.utils.filepicker.activity.BaseActivity;
import com.hippo.utils.filepicker.adapter.ImageDirectoryAdapter;
import com.hippo.utils.filepicker.adapter.ImagePickAdapter;
import com.hippo.utils.filepicker.adapter.OnSelectStateListener;
import com.hippo.utils.filepicker.filter.FileFilter;
import com.hippo.utils.filepicker.filter.callback.FilterResultCallback;
import com.hippo.utils.filepicker.filter.entity.Directory;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImagePickActivity
extends BaseActivity {
    public static final String IS_NEED_CAMERA = "IsNeedCamera";
    public static final String IS_NEED_IMAGE_PAGER = "IsNeedImagePager";
    public static final String IS_TAKEN_AUTO_SELECTED = "IsTakenAutoSelected";
    public static final int DEFAULT_MAX_NUMBER = 1;
    private int mMaxNumber;
    private int mCurrentNumber = 0;
    private RecyclerView mRecyclerView;
    private ImagePickAdapter mAdapter;
    private ImageDirectoryAdapter directoryAdapter;
    private boolean isNeedCamera;
    private boolean isNeedImagePager;
    private boolean isTakenAutoSelected;
    public ArrayList<ImageFile> mSelectedList = new ArrayList();
    private GridLayoutManager layoutManager;
    private boolean isDirectory;
    private Toolbar myToolbar;

    @Override
    public void permissionGranted() {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                ImagePickActivity.this.loadData();
            }
        });
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.vw_activity_image_pick);
        this.mMaxNumber = this.getIntent().getIntExtra("MaxNumber", 1);
        this.isNeedCamera = this.getIntent().getBooleanExtra(IS_NEED_CAMERA, false);
        this.isNeedImagePager = this.getIntent().getBooleanExtra(IS_NEED_IMAGE_PAGER, true);
        this.isTakenAutoSelected = this.getIntent().getBooleanExtra(IS_TAKEN_AUTO_SELECTED, true);
        this.initView();
    }

    private void initView() {
        this.myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.myToolbar);
        this.setToolbar(this.myToolbar, "Image Picker");
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_image_pick);
        this.layoutManager = new GridLayoutManager((Context)this, 2);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerGridItemDecoration((Context)this));
        this.mAdapter = new ImagePickAdapter((Context)this, this.isNeedCamera, this.isNeedImagePager, this.mMaxNumber);
        this.directoryAdapter = new ImageDirectoryAdapter((Context)this);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.directoryAdapter);
        this.directoryAdapter.setOnSelectStateListener(new OnSelectStateListener<Directory>(){

            @Override
            public void OnSelectStateChanged(boolean bl, Directory directory) {
                ImagePickActivity.this.isDirectory = true;
                ImagePickActivity.this.layoutManager.setSpanCount(3);
                ImagePickActivity.this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)ImagePickActivity.this.layoutManager);
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(directory.getFiles());
                ImagePickActivity.this.mAdapter.refresh(arrayList);
                ImagePickActivity.this.mRecyclerView.setAdapter((RecyclerView.Adapter)ImagePickActivity.this.mAdapter);
                ImagePickActivity.this.runLayoutAnimation(ImagePickActivity.this.mRecyclerView);
            }
        });
        this.mAdapter.setOnSelectStateListener(new OnSelectStateListener<ImageFile>(){

            @Override
            public void OnSelectStateChanged(boolean bl, ImageFile imageFile) {
                ImagePickActivity.this.mSelectedList.add(imageFile);
                ImagePickActivity.this.mCurrentNumber++;
                Intent intent = new Intent();
                intent.putParcelableArrayListExtra("ResultPickImage", ImagePickActivity.this.mSelectedList);
                ImagePickActivity.this.setResult(-1, intent);
                ImagePickActivity.this.finish();
            }
        });
    }

    @Override
    protected void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        switch (n) {
            case 257: {
                if (n2 == -1) {
                    Intent intent2 = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
                    File file = new File(this.mAdapter.mImagePath);
                    Uri uri = Uri.fromFile((File)file);
                    intent2.setData(uri);
                    this.sendBroadcast(intent2);
                    this.loadData();
                    break;
                }
                this.getApplicationContext().getContentResolver().delete(this.mAdapter.mImageUri, null, null);
                break;
            }
            case 258: {
                if (n2 != -1) break;
                ArrayList arrayList = intent.getParcelableArrayListExtra("ResultBrowserImage");
                this.mCurrentNumber = arrayList.size();
                this.mAdapter.setCurrentNumber(this.mCurrentNumber);
                this.mSelectedList.clear();
                this.mSelectedList.addAll(arrayList);
                for (ImageFile imageFile : this.mAdapter.getDataSet()) {
                    if (this.mSelectedList.contains(imageFile)) {
                        imageFile.setSelected(true);
                        continue;
                    }
                    imageFile.setSelected(false);
                }
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    private void loadData() {
        FileFilter.getImages((FragmentActivity)this, new FilterResultCallback<ImageFile>(){

            @Override
            public void onResult(List<Directory<ImageFile>> list) {
                if (ImagePickActivity.this.isNeedFolderList) {
                    ArrayList<Directory> arrayList = new ArrayList<Directory>();
                    Directory directory = new Directory();
                    directory.setName(ImagePickActivity.this.getResources().getString(R.string.vw_all));
                    arrayList.add(directory);
                    arrayList.addAll(list);
                    ImagePickActivity.this.mFolderHelper.fillData(arrayList);
                }
                ImagePickActivity.this.refreshData(list);
            }
        });
    }

    public void onBackPressed() {
        if (this.isDirectory) {
            this.isDirectory = false;
            this.layoutManager.setSpanCount(2);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.directoryAdapter);
        } else {
            super.onBackPressed();
        }
    }

    private void refreshData(List<Directory<ImageFile>> list) {
        ArrayList<Directory<ImageFile>> arrayList = new ArrayList<Directory<ImageFile>>();
        arrayList.addAll(list);
        this.directoryAdapter.refresh(arrayList);
    }

    private void runLayoutAnimation(RecyclerView recyclerView) {
        Context context = recyclerView.getContext();
        LayoutAnimationController layoutAnimationController = AnimationUtils.loadLayoutAnimation((Context)context, (int)R.anim.hippo_layout_animation_from_bottom);
        recyclerView.setLayoutAnimation(layoutAnimationController);
        recyclerView.getAdapter().notifyDataSetChanged();
        recyclerView.scheduleLayoutAnimation();
    }
}

