/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.MenuItem;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.utils.easypermissions.AfterPermissionGranted;
import com.hippo.utils.easypermissions.AppSettingsDialog;
import com.hippo.utils.easypermissions.EasyPermissions;
import com.hippo.utils.filepicker.FolderListHelper;
import java.util.List;

public abstract class BaseActivity
extends AppCompatActivity
implements FuguAppConstant,
EasyPermissions.PermissionCallbacks {
    private static final String TAG = BaseActivity.class.getName();
    protected FolderListHelper mFolderHelper;
    protected boolean isNeedFolderList;
    public static final String IS_NEED_FOLDER_LIST = "isNeedFolderList";

    protected abstract void permissionGranted();

    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.isNeedFolderList = this.getIntent().getBooleanExtra(IS_NEED_FOLDER_LIST, false);
        if (this.isNeedFolderList) {
            this.mFolderHelper = new FolderListHelper();
            this.mFolderHelper.initFolderListView((Context)this);
        }
    }

    protected void onPostCreate(@Nullable Bundle bundle) {
        super.onPostCreate(bundle);
        this.readExternalStorage();
    }

    public void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        super.onRequestPermissionsResult(n, stringArray, nArray);
        EasyPermissions.onRequestPermissionsResult(n, stringArray, nArray, this);
    }

    @AfterPermissionGranted(value=123)
    private void readExternalStorage() {
        boolean bl = EasyPermissions.hasPermissions((Context)this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        if (bl) {
            this.permissionGranted();
        } else {
            EasyPermissions.requestPermissions((Activity)this, this.getString(R.string.vw_rationale_storage), 123, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        }
    }

    @Override
    public void onPermissionsGranted(int n, List<String> list) {
        Log.d((String)TAG, (String)("onPermissionsGranted:" + n + ":" + list.size()));
        this.permissionGranted();
    }

    @Override
    public void onPermissionsDenied(int n, List<String> list) {
        Log.d((String)TAG, (String)("onPermissionsDenied:" + n + ":" + list.size()));
        if (EasyPermissions.somePermissionPermanentlyDenied((Activity)this, list)) {
            new AppSettingsDialog.Builder((Activity)this).build().show();
        } else {
            this.finish();
        }
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (n == 16061) {
            if (EasyPermissions.hasPermissions((Context)this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
                this.permissionGranted();
            } else {
                this.finish();
            }
        }
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public ActionBar setToolbar(Toolbar toolbar, String string2) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setBackgroundDrawable((Drawable)new ColorDrawable(CommonData.getColorConfig().getHippoActionBarBg()));
            actionBar.setHomeAsUpIndicator(R.drawable.hippo_ic_arrow_back);
            actionBar.setTitle((CharSequence)"");
            toolbar.setTitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setText((CharSequence)string2);
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        }
        return this.getSupportActionBar();
    }
}

