/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.hippo.constant.FuguAppConstant;
import java.io.File;
import java.util.List;

public class Util
implements FuguAppConstant.MimeTypeConstants {
    private static final String AppName = "Hippo";
    private static final int NOT_FOUND = -1;
    public static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    public static boolean detectIntent(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    public static String getDurationString(long l) {
        String string2;
        long l2 = l % 86400000L / 3600000L;
        long l3 = l % 3600000L / 60000L;
        long l4 = l % 60000L / 1000L;
        String string3 = l2 < 10L ? "0" + l2 : l2 + "";
        String string4 = l3 < 10L ? "0" + l3 : l3 + "";
        String string5 = string2 = l4 < 10L ? "0" + l4 : l4 + "";
        if (l2 != 0L) {
            return string3 + ":" + string4 + ":" + string2;
        }
        return string4 + ":" + string2;
    }

    public static int getScreenWidth(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    public static int dip2px(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().density;
        return (int)(f2 * f3 + 0.5f);
    }

    public static int px2dip(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().density;
        return (int)(f2 / f3 + 0.5f);
    }

    public static String extractFileNameWithSuffix(String string2) {
        return string2.substring(string2.lastIndexOf("/") + 1);
    }

    public static String extractFileNameWithoutSuffix(String string2) {
        try {
            return string2.substring(string2.lastIndexOf("/") + 1, string2.lastIndexOf("."));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            try {
                return string2.substring(string2.lastIndexOf("/") + 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                stringIndexOutOfBoundsException.printStackTrace();
                return "";
            }
        }
    }

    public static String getMuid(String string2) {
        try {
            return string2.substring(string2.lastIndexOf("_") + 1, string2.lastIndexOf("."));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            stringIndexOutOfBoundsException.printStackTrace();
            return "";
        }
    }

    public static String extractPathWithSeparator(String string2) {
        return string2.substring(0, string2.lastIndexOf("/") + 1);
    }

    public static String extractPathWithoutSeparator(String string2) {
        return string2.substring(0, string2.lastIndexOf("/"));
    }

    public static String extractFileSuffix(String string2) {
        if (string2.contains(".")) {
            return string2.substring(string2.lastIndexOf(".") + 1);
        }
        return "";
    }

    public static String getFilePath(Context context, Uri uri) {
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                File file = new File(uri.getPath());
                String[] stringArray = file.getPath().split(":");
                return Util.getPath(context, uri);
            }
            catch (Exception exception) {
                return Util.getPath(context, uri);
            }
        }
        return Util.getPath(context, uri);
    }

    /*
     * Exception decompiling
     */
    public static String getPath(Context var0, Uri var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isGoogleDriveDocument(Uri uri) {
        return "com.google.android.apps.docs.storage".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String string2, String[] stringArray) {
        Cursor cursor = null;
        String string3 = "_data";
        String[] stringArray2 = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, stringArray2, string2, stringArray, null);
            if (cursor != null && cursor.moveToFirst()) {
                int n = cursor.getColumnIndexOrThrow("_data");
                String string4 = cursor.getString(n);
                return string4;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static File getDirectory(FileType fileType) {
        try {
            String string2 = Environment.getExternalStorageDirectory() + File.separator + AppName + File.separator + fileType.directory;
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getExtension(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = Util.indexOfExtension(string2);
        if (n == -1) {
            return "";
        }
        return string2.substring(n + 1);
    }

    public static int indexOfExtension(String string2) {
        if (string2 == null) {
            return -1;
        }
        int n = string2.lastIndexOf(46);
        int n2 = Util.indexOfLastSeparator(string2);
        return n2 > n ? -1 : n;
    }

    public static int indexOfLastSeparator(String string2) {
        if (string2 == null) {
            return -1;
        }
        int n = string2.lastIndexOf(47);
        int n2 = string2.lastIndexOf(92);
        return Math.max(n, n2);
    }

    public static String humanReadableByteCount(long l, boolean bl) {
        int n;
        int n2 = n = bl ? 1024 : 1024;
        if (l < (long)n) {
            return l + " B";
        }
        int n3 = (int)(Math.log(l) / Math.log(n));
        String string2 = (bl ? "kMGTPE" : "KMGTPE").charAt(n3 - 1) + (bl ? "" : "i");
        return String.format("%.2f %sB", (double)l / Math.pow(n, n3), string2);
    }

    public static String humanReadableSize(long l, boolean bl) {
        int n;
        int n2 = n = bl ? 1024 : 1024;
        if (l < (long)n) {
            return l + " B";
        }
        int n3 = (int)(Math.log(l) / Math.log(n));
        String string2 = (bl ? "kMGTPE" : "KMGTPE").charAt(n3 - 1) + (bl ? "" : "i");
        return String.format("%.0f %sB", (double)l / Math.pow(n, n3), string2);
    }

    public static String getDirectoryPath(String string2) {
        return Environment.getExternalStorageDirectory() + File.separator + AppName + File.separator + string2;
    }

    public static String getOrCreateDirectoryPath(String string2) {
        String string3 = Environment.getExternalStorageDirectory() + File.separator + AppName + File.separator + string2;
        File file = new File(string3);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string3;
    }

    public static String setImageFullPath(String string2) {
        String string3 = Util.getOrCreateDirectoryPath(FuguAppConstant.FOLDER_TYPE.get("image"));
        return string3 + File.separator + string2;
    }

    public static String getFileName(String string2, String string3) {
        if (!string2.contains(string3)) {
            String string4 = Util.getExtension(string2);
            String string5 = Util.extractFileNameWithoutSuffix(string2);
            string2 = string5 + "_" + string3 + "." + string4;
        }
        return string2;
    }

    static enum FileType {
        LOG_FILE("logs", ".log"),
        IMAGE_FILE("snapshots", ""),
        GENERAL_FILE("public", ".txt"),
        PRIVATE_FILE("system", ".sys");

        public final String extension;
        public final String directory;

        private FileType(String string3, String string4) {
            this.extension = string4;
            this.directory = string3;
        }
    }
}

