/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;
import android.webkit.MimeTypeMap;
import androidx.core.app.NotificationCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.model.EventItem;
import com.hippo.agent.model.HeaderItem;
import com.hippo.agent.model.ListItem;
import com.hippo.agent.model.Message;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.FuguUploadImageResponse;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.MultipartParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.fileUpload.Prefs;
import com.hippo.utils.fileUpload.ProgressRequestBody;
import faye.ConnectionManager;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

public class MyForeGroundService
extends Service
implements FuguAppConstant,
ProgressRequestBody.UploadCallbacks {
    private static final String TAG = MyForeGroundService.class.getSimpleName();
    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";
    private Handler h;
    private Runnable r;
    int counter = 0;
    private Type fileuploadType = new TypeToken<List<FileuploadModel>>(){}.getType();
    NotificationManager manager;
    NotificationCompat.Builder builder;
    FileuploadModel fileuploadModel;
    ArrayList<FileuploadModel> fileuploadModels = new ArrayList();
    boolean apiInProgress;
    boolean isFirstTime;

    public IBinder onBind(Intent intent) {
        return null;
    }

    private Notification updateNotification() {
        ++this.counter;
        Context context = this.getApplicationContext();
        this.manager = (NotificationManager)this.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            String string2 = "hippo_file_uploading";
            NotificationChannel notificationChannel = new NotificationChannel(string2, (CharSequence)this.getString(R.string.app_name), 3);
            notificationChannel.setDescription("File uploading");
            this.manager.createNotificationChannel(notificationChannel);
            this.builder = new NotificationCompat.Builder((Context)this, string2);
        } else {
            this.builder = new NotificationCompat.Builder(context);
        }
        this.builder.setProgress(100, this.counter, false);
        return this.builder.setContentTitle((CharSequence)this.getString(R.string.uploading)).setTicker((CharSequence)"").setOnlyAlertOnce(true).setContentText((CharSequence)this.getString(R.string.uploading_in_progress)).setSmallIcon(R.drawable.hippo_default_notif_icon).setOngoing(true).build();
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        if (intent.getAction().contains("start")) {
            this.startForeground(101, this.updateNotification());
            this.uploadFileServerCall();
        } else {
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        }
        return 1;
    }

    public void stopFayeClient() {
    }

    public void updateProgress(int n, int n2) {
        if (this.builder != null && this.manager != null) {
            this.builder.setProgress(n2, n, false);
            this.manager.notify(101, this.builder.build());
        } else {
            this.startForeground(101, this.updateNotification());
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (connectivityManager != null) {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    private void uploadFileServerCall() {
        try {
            if (this.apiInProgress) {
                HippoLog.e(TAG, "***************ApiInProgress*************");
                return;
            }
            if (this.isNetworkAvailable()) {
                String string2 = Prefs.with((Context)this).getString("pref_upload_data", "");
                HippoLog.v(TAG, "uploadFileServerCall 1: " + string2);
                this.fileuploadModels = (ArrayList)new Gson().fromJson(string2, this.fileuploadType);
                if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
                    Prefs.with((Context)this).remove("pref_upload_data");
                    this.stopFayeClient();
                    this.stopForeground(true);
                    this.stopSelf();
                    return;
                }
                this.fileuploadModel = this.fileuploadModels.get(0);
                this.isFirstTime = true;
                ProgressRequestBody progressRequestBody = new ProgressRequestBody(new File(this.fileuploadModel.getFilePath()), this, this.getMimeType(this.fileuploadModel.getFilePath()), this.fileuploadModel.getFilePath(), this.fileuploadModel.getMessageIndex(), this.fileuploadModel.getMuid());
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)"file", (String)this.fileuploadModel.getFileName(), (RequestBody)progressRequestBody);
                MultipartParams.Builder builder = new MultipartParams.Builder();
                MultipartParams multipartParams = builder.add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("app_version", "2.5.1").add("device_type", 1).add("allow_all_mime_type", true).add("file_name", this.fileuploadModel.getFileName()).build();
                this.apiInProgress = true;
                HippoLog.v("map = ", multipartParams.getMap().toString());
                HippoLog.v("app_secret_key", "---> " + HippoConfig.getInstance().getAppKey());
                RestClient.getApiInterface().uploadFile(HippoConfig.getInstance().getAppKey(), 1, 251, part, multipartParams.getMap()).enqueue((Callback)new ResponseResolver<FuguUploadImageResponse>(){

                    @Override
                    public void success(FuguUploadImageResponse fuguUploadImageResponse) {
                        JSONObject jSONObject;
                        String string2;
                        String string3;
                        String string4;
                        block8: {
                            string4 = fuguUploadImageResponse.getData().getUrl();
                            string3 = fuguUploadImageResponse.getData().getThumbnailUrl();
                            string2 = Prefs.with((Context)MyForeGroundService.this).getString("pref_upload_data", "");
                            HippoLog.v(TAG, "In response: " + string2);
                            MyForeGroundService.this.fileuploadModels = (ArrayList)new Gson().fromJson(string2, MyForeGroundService.this.fileuploadType);
                            jSONObject = MyForeGroundService.this.fileuploadModels.get(0).getMessageObject();
                            try {
                                jSONObject.put("image_url", (Object)string4);
                                jSONObject.put("thumbnail_url", (Object)string3);
                                jSONObject.put("url", (Object)string4);
                                jSONObject.remove("local_url");
                            }
                            catch (JSONException jSONException) {
                                if (!HippoConfig.DEBUG) break block8;
                                jSONException.printStackTrace();
                            }
                        }
                        MyForeGroundService.this.fileuploadModels.get(0).setFileUploaded(true);
                        MyForeGroundService.this.fileuploadModels.get(0).setMessageObject(jSONObject);
                        if (MyForeGroundService.this.fileuploadModels.get(0).getChannelId().intValue() < 1) {
                            Intent intent = new Intent("HIPPO_FILE_UPLOAD");
                            intent.putExtra("broadcast_status", 4);
                            intent.putExtra("fileuploadModel", new Gson().toJson((Object)MyForeGroundService.this.fileuploadModels.get(0)));
                            LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(intent);
                            MyForeGroundService.this.updatePref();
                        } else {
                            string2 = new Gson().toJson(MyForeGroundService.this.fileuploadModels, MyForeGroundService.this.fileuploadType);
                            HippoLog.e(TAG, "In response else case " + string2);
                            Prefs.with((Context)MyForeGroundService.this).save("pref_upload_data", string2);
                            MyForeGroundService.this.fileuploadModel = MyForeGroundService.this.fileuploadModels.get(0);
                            if (MyForeGroundService.this.isOpenedChatActivityMsg(MyForeGroundService.this.fileuploadModel.getChannelId())) {
                                Intent intent = new Intent("HIPPO_FILE_UPLOAD");
                                intent.putExtra("broadcast_status", 0);
                                intent.putExtra("channelId", (Serializable)MyForeGroundService.this.fileuploadModel.getChannelId());
                                intent.putExtra("muid", MyForeGroundService.this.fileuploadModel.getMuid());
                                intent.putExtra("messageIndex", MyForeGroundService.this.fileuploadModel.getMessageIndex());
                                intent.putExtra("image_url", string4);
                                intent.putExtra("thumbnail_url", string3);
                                intent.putExtra("fileuploadModel", new Gson().toJson((Object)MyForeGroundService.this.fileuploadModel));
                                LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(intent);
                                MyForeGroundService.this.updatePref();
                            } else if (AgentCommonData.isAgentFlow()) {
                                MyForeGroundService.this.updateLocalAgentMessageObj(MyForeGroundService.this.fileuploadModel.getChannelId(), false, string4, string3, jSONObject, new UpdateLocalMsgListener(){

                                    @Override
                                    public void onUpdation(JSONObject jSONObject) {
                                        MyForeGroundService.this.apiInProgress = false;
                                        MyForeGroundService.this.getClient(MyForeGroundService.this.fileuploadModel.getChannelId(), jSONObject);
                                    }
                                });
                            } else {
                                MyForeGroundService.this.updateLocalMessageObj(MyForeGroundService.this.fileuploadModel.getChannelId(), false, string4, string3, jSONObject, new UpdateLocalMsgListener(){

                                    @Override
                                    public void onUpdation(JSONObject jSONObject) {
                                        MyForeGroundService.this.apiInProgress = false;
                                        MyForeGroundService.this.getClient(MyForeGroundService.this.fileuploadModel.getChannelId(), jSONObject);
                                    }
                                });
                            }
                        }
                    }

                    @Override
                    public void failure(APIError aPIError) {
                        HippoLog.e(TAG, "In uploading failure");
                        MyForeGroundService.this.handleException();
                    }
                });
            } else {
                HippoLog.e(TAG, "In uploading else");
                this.handleException();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HippoLog.e(TAG, "In uploading else 2");
            this.handleException();
        }
    }

    private void handleException() {
        Log.e((String)TAG, (String)"In handleException failure");
        try {
            String string2 = Prefs.with((Context)this).getString("pref_upload_data", "");
            Log.e((String)TAG, (String)("In response else case " + string2));
            this.fileuploadModels = (ArrayList)new Gson().fromJson(string2, this.fileuploadType);
            if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
                Prefs.with((Context)this).remove("pref_upload_data");
                this.stopFayeClient();
                this.stopForeground(true);
                this.stopSelf();
                return;
            }
            this.fileuploadModel = this.fileuploadModels.get(0);
            this.apiInProgress = false;
            if (this.isOpenedChatActivityMsg(this.fileuploadModel.getChannelId())) {
                this.setMessageExpired();
                Intent intent = new Intent("HIPPO_FILE_UPLOAD");
                intent.putExtra("channelId", (Serializable)this.fileuploadModel.getChannelId());
                intent.putExtra("muid", this.fileuploadModel.getMuid());
                intent.putExtra("messageIndex", this.fileuploadModel.getMessageIndex());
                intent.putExtra("fileuploadModel", new Gson().toJson((Object)this.fileuploadModel));
                intent.putExtra("broadcast_status", 1);
                LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(intent);
            } else {
                this.uploadingFailed(this.fileuploadModel.getChannelId());
                this.setMessageExpired();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        }
    }

    public String getMimeType(String string2) {
        String string3 = null;
        String string4 = MimeTypeMap.getFileExtensionFromUrl((String)string2);
        if (string4 != null) {
            string3 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string4);
        }
        return string3;
    }

    private void updatePref() {
        HippoLog.e(TAG, "updatePref: " + Prefs.with((Context)this).getString("pref_upload_data", ""));
        this.fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
        if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        } else {
            this.fileuploadModels.remove(0);
            String string2 = new Gson().toJson(this.fileuploadModels, this.fileuploadType);
            Prefs.with((Context)this).save("pref_upload_data", string2);
            HippoLog.e(TAG, "int updatePref set data : " + string2);
            if (this.fileuploadModels.size() == 0) {
                Prefs.with((Context)this).remove("pref_upload_data");
                this.stopFayeClient();
                this.stopForeground(true);
                this.stopSelf();
            } else {
                this.apiInProgress = false;
                this.uploadFileServerCall();
            }
        }
    }

    @Override
    public void onProgressUpdate(int n, int n2, String string2) {
        if (this.isFirstTime && n == 10) {
            this.isFirstTime = false;
            return;
        }
        if (!this.isFirstTime && n == 10) {
            this.isFirstTime = true;
        }
        if (this.isFirstTime) {
            this.updateProgress(n, 100);
        }
    }

    @Override
    public void onError(int n, int n2, String string2) {
        HippoLog.e(TAG, "In onError else 2");
    }

    @Override
    public void onFinish(int n, int n2, String string2) {
        HippoLog.e(TAG, "In onFinish else 2");
    }

    private void getClient(Long l, JSONObject jSONObject) {
        ConnectionManager.INSTANCE.initFayeConnection();
        ArrayList arrayList = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
        for (FileuploadModel fileuploadModel : arrayList) {
            if (!fileuploadModel.isFileUploaded()) continue;
            ConnectionManager.INSTANCE.subScribeChannel("/" + String.valueOf(fileuploadModel.getChannelId()));
            ConnectionManager.INSTANCE.publish("/" + String.valueOf(fileuploadModel.getChannelId()), fileuploadModel.getMessageObject());
            break;
        }
        this.afterSetUpFayeConnection(l, jSONObject);
    }

    private void afterSetUpFayeConnection(Long l, JSONObject jSONObject) {
        if (this.isNetworkAvailable() && ConnectionManager.INSTANCE.isConnected()) {
            HippoLog.e(TAG, "************publish*********");
            ConnectionManager.INSTANCE.publish("/" + String.valueOf(l), jSONObject);
            this.updatePref();
        } else if (!this.isNetworkAvailable()) {
            Intent intent = new Intent("HIPPO_FILE_UPLOAD");
            intent.putExtra("broadcast_status", 0);
            LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(intent);
            this.updatePref();
        }
    }

    public void onDisconnectedServer() {
    }

    public void onReceivedMessage(String string2, String string3) {
        try {
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.optInt("message_type", 0) == 10 || jSONObject.optInt("message_type", 0) == 11) {
                String string4 = string3.replace("/", "");
                if (!this.isOpenedChatActivityMsg(Long.parseLong(string4))) {
                    this.updateLocalMessageObj(Long.parseLong(string4), true, "", "", null, null);
                }
                this.updatePref();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onWebSocketError() {
    }

    public void onErrorReceived() {
    }

    private boolean isOpenedChatActivityMsg(Long l) {
        ActivityManager activityManager = (ActivityManager)this.getSystemService("activity");
        List list = activityManager.getRunningTasks(10);
        return ((ActivityManager.RunningTaskInfo)list.get((int)0)).topActivity.getClassName().equals("com.hippo.activity.FuguChatActivity") && FuguChatActivity.currentChannelId.compareTo(l) == 0;
    }

    private void uploadingFailed(long l) {
        String string2 = Prefs.with((Context)this).getString("pref_upload_data", "empty");
        if (string2.equals("empty")) {
            this.apiInProgress = false;
            Log.v((String)TAG, (String)("data = " + string2));
            return;
        }
        ArrayList arrayList = (ArrayList)new Gson().fromJson(string2, this.fileuploadType);
        int n = arrayList.indexOf(new FileuploadModel(l));
        if (n == -1) {
            return;
        }
        FileuploadModel fileuploadModel = (FileuploadModel)arrayList.get(n);
        LinkedHashMap<String, com.hippo.model.Message> linkedHashMap = CommonData.getUnsentMessageByChannel(l);
        LinkedHashMap<String, JSONObject> linkedHashMap2 = CommonData.getUnsentMessageMapByChannel(l);
        com.hippo.model.Message message = linkedHashMap.get(fileuploadModel.getMuid());
        if (message == null) {
            return;
        }
        message.setUploadStatus(0);
        message.setIsMessageExpired(1);
        linkedHashMap.put(fileuploadModel.getMuid(), message);
        CommonData.setUnsentMessageByChannel(l, linkedHashMap);
    }

    private void setAllMessageExpired() {
        this.fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
        if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        } else {
            for (FileuploadModel fileuploadModel : this.fileuploadModels) {
                if (this.isOpenedChatActivityMsg(fileuploadModel.getChannelId())) {
                    this.sendLocalBroadcast(fileuploadModel);
                    continue;
                }
                if (AgentCommonData.isAgentFlow()) {
                    this.updateAgentLocalMessage(this.fileuploadModels.get(0));
                    continue;
                }
                this.updateLocalMessages(this.fileuploadModels.get(0));
            }
            this.fileuploadModels.clear();
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        }
    }

    private void setMessageExpired() {
        String string2 = Prefs.with((Context)this).getString("pref_upload_data", "");
        HippoLog.e(TAG, "In setMessageExpired: " + string2);
        this.fileuploadModels = (ArrayList)new Gson().fromJson(string2, this.fileuploadType);
        if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        } else {
            if (this.isOpenedChatActivityMsg(this.fileuploadModels.get(0).getChannelId())) {
                this.sendLocalBroadcast(this.fileuploadModels.get(0));
            } else if (AgentCommonData.isAgentFlow()) {
                this.updateAgentLocalMessage(this.fileuploadModels.get(0));
            } else {
                this.updateLocalMessages(this.fileuploadModels.get(0));
            }
            this.fileuploadModels.remove(0);
            string2 = new Gson().toJson(this.fileuploadModels, this.fileuploadType);
            HippoLog.e(TAG, "In setMessageExpired after update: " + string2);
            Prefs.with((Context)this).save("pref_upload_data", string2);
            this.uploadFileServerCall();
        }
    }

    private void sendLocalBroadcast(FileuploadModel fileuploadModel) {
        Intent intent = new Intent("HIPPO_FILE_UPLOAD");
        intent.putExtra("muid", fileuploadModel.getMuid());
        intent.putExtra("messageIndex", fileuploadModel.getMessageIndex());
        intent.putExtra("broadcast_status", 3);
        LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(intent);
    }

    private void updateLocalMessageObj(Long l, boolean bl, String string2, String string3, JSONObject jSONObject, UpdateLocalMsgListener updateLocalMsgListener) {
        String string4 = Prefs.with((Context)this).getString("pref_upload_data", "empty");
        if (string4.equals("empty")) {
            this.apiInProgress = false;
            HippoLog.v(TAG, "data = " + string4);
            return;
        }
        ArrayList arrayList = (ArrayList)new Gson().fromJson(string4, this.fileuploadType);
        int n = arrayList.indexOf(new FileuploadModel(l));
        if (n == -1) {
            return;
        }
        FileuploadModel fileuploadModel = (FileuploadModel)arrayList.get(n);
        LinkedHashMap<String, com.hippo.model.Message> linkedHashMap = CommonData.getSentMessageByChannel(l);
        LinkedHashMap<String, com.hippo.model.Message> linkedHashMap2 = CommonData.getUnsentMessageByChannel(l);
        LinkedHashMap<String, JSONObject> linkedHashMap3 = CommonData.getUnsentMessageMapByChannel(l);
        com.hippo.model.Message message = linkedHashMap2.get(fileuploadModel.getMuid());
        if (message == null) {
            return;
        }
        if (bl) {
            String string52;
            message.setMessageStatus(1);
            ArrayList<String> arrayList2 = new ArrayList<String>(linkedHashMap.keySet());
            Collections.reverse(arrayList2);
            String string6 = "";
            for (String string52 : arrayList2) {
                if (!linkedHashMap.get(string52).isDateView()) continue;
                string6 = string52;
                break;
            }
            String string7 = message.getSentAtUtc();
            string52 = DateUtils.getInstance().convertToLocal(string7, this.inputFormat, this.outputFormat);
            if (!string6.equalsIgnoreCase(string52)) {
                linkedHashMap.put(string52, new com.hippo.model.Message(string52, true));
            }
            linkedHashMap.put(fileuploadModel.getMuid(), message);
            linkedHashMap2.remove(fileuploadModel.getMuid());
            linkedHashMap3.remove(fileuploadModel.getMuid());
            CommonData.setSentMessageByChannel(l, linkedHashMap);
        } else {
            com.hippo.model.Message message2 = message;
            message2.setFileUrl(string2);
            message2.setUrl(string2);
            message2.setThumbnailUrl(string3);
            message2.setUploadStatus(3);
            linkedHashMap2.put(fileuploadModel.getMuid(), message2);
            JSONObject jSONObject2 = null;
            try {
                jSONObject2 = linkedHashMap3.get(fileuploadModel.getMuid());
                jSONObject2.put("image_url", (Object)string2);
                jSONObject2.put("thumbnail_url", (Object)string3);
                jSONObject2.put("url", (Object)string2);
                linkedHashMap3.put(fileuploadModel.getMuid(), jSONObject2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        CommonData.setUnsentMessageByChannel(l, linkedHashMap2);
        CommonData.setUnsentMessageMapByChannel(l, linkedHashMap3);
        if (updateLocalMsgListener != null) {
            updateLocalMsgListener.onUpdation(jSONObject);
        }
    }

    private void updateLocalAgentMessageObj(Long l, boolean bl, String string2, String string3, JSONObject jSONObject, UpdateLocalMsgListener updateLocalMsgListener) {
        String string4 = Prefs.with((Context)this).getString("pref_upload_data", "empty");
        if (string4.equals("empty")) {
            this.apiInProgress = false;
            HippoLog.v(TAG, "data = " + string4);
            return;
        }
        ArrayList arrayList = (ArrayList)new Gson().fromJson(string4, this.fileuploadType);
        int n = arrayList.indexOf(new FileuploadModel(l));
        if (n == -1) {
            return;
        }
        FileuploadModel fileuploadModel = (FileuploadModel)arrayList.get(n);
        LinkedHashMap<String, ListItem> linkedHashMap = AgentCommonData.getSentMessageByChannel(l);
        LinkedHashMap<String, ListItem> linkedHashMap2 = AgentCommonData.getUnsentMessageByChannel(l);
        LinkedHashMap<String, JSONObject> linkedHashMap3 = AgentCommonData.getUnsentMessageMapByChannel(l);
        ListItem listItem = linkedHashMap2.get(fileuploadModel.getMuid());
        if (listItem == null) {
            return;
        }
        if (bl) {
            String string52;
            ((EventItem)listItem).getEvent().setMessageStatus(1);
            ArrayList<String> arrayList2 = new ArrayList<String>(linkedHashMap.keySet());
            Collections.reverse(arrayList2);
            String string6 = "";
            for (String string52 : arrayList2) {
                if (!(linkedHashMap.get(string52) instanceof HeaderItem)) continue;
                string6 = string52;
                break;
            }
            String string7 = ((EventItem)listItem).getEvent().getSentAtUtc();
            string52 = DateUtils.getInstance().convertToLocal(string7, this.inputFormat, this.outputFormat);
            if (!string6.equalsIgnoreCase(string52)) {
                linkedHashMap.put(string52, new HeaderItem(string52));
            }
            linkedHashMap.put(fileuploadModel.getMuid(), listItem);
            linkedHashMap2.remove(fileuploadModel.getMuid());
            linkedHashMap3.remove(fileuploadModel.getMuid());
            AgentCommonData.setSentMessageByChannel(l, linkedHashMap);
        } else {
            Message message = ((EventItem)listItem).getEvent();
            message.setFileUrl(string2);
            message.setImageUrl(string2);
            message.setThumbnailUrl(string3);
            message.setUploadStatus(3);
            linkedHashMap2.put(fileuploadModel.getMuid(), new EventItem(message));
            JSONObject jSONObject2 = null;
            try {
                jSONObject2 = linkedHashMap3.get(fileuploadModel.getMuid());
                jSONObject2.put("image_url", (Object)string2);
                jSONObject2.put("thumbnail_url", (Object)string3);
                jSONObject2.put("url", (Object)string2);
                linkedHashMap3.put(fileuploadModel.getMuid(), jSONObject2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        AgentCommonData.setUnsentMessageByChannel(l, linkedHashMap2);
        AgentCommonData.setUnsentMessageMapByChannel(l, linkedHashMap3);
        if (updateLocalMsgListener != null) {
            updateLocalMsgListener.onUpdation(jSONObject);
        }
    }

    private void updateLocalMessages(FileuploadModel fileuploadModel) {
        String string2 = fileuploadModel.getMuid();
        LinkedHashMap<String, com.hippo.model.Message> linkedHashMap = CommonData.getUnsentMessageByChannel(fileuploadModel.getChannelId());
        LinkedHashMap<String, JSONObject> linkedHashMap2 = CommonData.getUnsentMessageMapByChannel(fileuploadModel.getChannelId());
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap();
        }
        linkedHashMap.get(string2).setIsMessageExpired(1);
        try {
            JSONObject jSONObject = linkedHashMap2.get(string2);
            jSONObject.put("is_message_expired", 1);
            linkedHashMap2.put(string2, jSONObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CommonData.setUnsentMessageByChannel(fileuploadModel.getChannelId(), linkedHashMap);
        CommonData.setUnsentMessageMapByChannel(fileuploadModel.getChannelId(), linkedHashMap2);
    }

    private void updateAgentLocalMessage(FileuploadModel fileuploadModel) {
        String string2 = fileuploadModel.getMuid();
        LinkedHashMap<String, ListItem> linkedHashMap = AgentCommonData.getUnsentMessageByChannel(fileuploadModel.getChannelId());
        LinkedHashMap<String, JSONObject> linkedHashMap2 = AgentCommonData.getUnsentMessageMapByChannel(fileuploadModel.getChannelId());
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap();
        }
        ListItem listItem = linkedHashMap.get(string2);
        ((EventItem)listItem).getEvent().setIsMessageExpired(1);
        try {
            JSONObject jSONObject = linkedHashMap2.get(string2);
            jSONObject.put("is_message_expired", 1);
            linkedHashMap2.put(string2, jSONObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AgentCommonData.setUnsentMessageByChannel(fileuploadModel.getChannelId(), linkedHashMap);
        AgentCommonData.setUnsentMessageMapByChannel(fileuploadModel.getChannelId(), linkedHashMap2);
    }

    public static interface UpdateLocalMsgListener {
        public void onUpdation(JSONObject var1);
    }
}

