/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.hippo.R;

public class MaxHeightLayout
extends FrameLayout {
    private static final float DEFAULT_MAX_RATIO = 0.6f;
    private static final float DEFAULT_MAX_HEIGHT = 0.0f;
    private float mMaxRatio = 0.6f;
    private float mMaxHeight = 0.0f;

    public MaxHeightLayout(Context context) {
        super(context);
        this.init();
    }

    public MaxHeightLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initAttrs(context, attributeSet);
        this.init();
    }

    public MaxHeightLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initAttrs(context, attributeSet);
        this.init();
    }

    private void initAttrs(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.MaxHeightLayout);
        int n = typedArray.getIndexCount();
        for (int j = 0; j < n; ++j) {
            int n2 = typedArray.getIndex(j);
            if (n2 == R.styleable.MaxHeightLayout_mhl_HeightRatio) {
                this.mMaxRatio = typedArray.getFloat(n2, 0.6f);
                continue;
            }
            if (n2 != R.styleable.MaxHeightLayout_mhl_HeightDimen) continue;
            this.mMaxHeight = typedArray.getDimension(n2, 0.0f);
        }
        typedArray.recycle();
    }

    private void init() {
        this.mMaxHeight = this.mMaxHeight <= 0.0f ? this.mMaxRatio * (float)this.getScreenHeight(this.getContext()) : Math.min(this.mMaxHeight, this.mMaxRatio * (float)this.getScreenHeight(this.getContext()));
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getMode((int)n2);
        int n4 = View.MeasureSpec.getSize((int)n2);
        if (n3 == 0x40000000) {
            int n5 = n4 = (float)n4 <= this.mMaxHeight ? n4 : (int)this.mMaxHeight;
        }
        if (n3 == 0) {
            int n6 = n4 = (float)n4 <= this.mMaxHeight ? n4 : (int)this.mMaxHeight;
        }
        if (n3 == Integer.MIN_VALUE) {
            n4 = (float)n4 <= this.mMaxHeight ? n4 : (int)this.mMaxHeight;
        }
        int n7 = View.MeasureSpec.makeMeasureSpec((int)n4, (int)n3);
        super.onMeasure(n, n7);
    }

    private int getScreenHeight(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return windowManager.getDefaultDisplay().getHeight();
    }
}

