/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.media.ExifInterface;
import com.hippo.utils.filepicker.CompressorListener;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

class ImageUtil {
    private ImageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void compressImage(File file, ImageFile imageFile, float f2, float f3, Bitmap.CompressFormat compressFormat, int n, String string2, CompressorListener compressorListener) throws IOException {
        Object object;
        OutputStream outputStream = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(1280);
        arrayList.add(800);
        File file2 = new File(string2).getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        try {
            object = ImageUtil.decodeSampledBitmapFromFile(file, f2, f3);
            outputStream = new FileOutputStream(string2);
            object.compress(compressFormat, n, outputStream);
            if (object.getHeight() > 0) {
                arrayList.add(0, object.getHeight());
            }
            if (object.getWidth() > 0) {
                arrayList.add(1, object.getWidth());
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                ((FileOutputStream)outputStream).close();
            }
        }
        if (compressorListener != null) {
            object = new File(string2);
            imageFile.setSize(((File)object).length());
            imageFile.setPath(string2);
            compressorListener.onImageCompressed((File)object, string2, imageFile, arrayList);
        }
    }

    static Bitmap decodeSampledBitmapFromFile(File file, float f2, float f3) throws IOException {
        Bitmap bitmap = null;
        Bitmap bitmap2 = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        bitmap2 = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        int n = options.outHeight;
        int n2 = options.outWidth;
        float f4 = (float)n2 / (float)n;
        float f5 = f2 / f3;
        if ((float)n > f3 || (float)n2 > f2) {
            if (f4 < f5) {
                f4 = f3 / (float)n;
                n2 = (int)(f4 * (float)n2);
                n = (int)f3;
            } else if (f4 > f5) {
                f4 = f2 / (float)n2;
                n = (int)(f4 * (float)n);
                n2 = (int)f2;
            } else {
                n = (int)f3;
                n2 = (int)f2;
            }
        }
        options.inSampleSize = ImageUtil.calculateInSampleSize(options, n2, n);
        options.inJustDecodeBounds = false;
        options.inDither = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inTempStorage = new byte[16384];
        try {
            bitmap2 = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
        try {
            bitmap = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
        float f6 = (float)n2 / (float)options.outWidth;
        float f7 = (float)n / (float)options.outHeight;
        float f8 = (float)n2 / 2.0f;
        float f9 = (float)n / 2.0f;
        Matrix matrix = new Matrix();
        matrix.setScale(f6, f7, f8, f9);
        Canvas canvas = new Canvas(bitmap);
        canvas.setMatrix(matrix);
        canvas.drawBitmap(bitmap2, f8 - (float)(bitmap2.getWidth() / 2), f9 - (float)(bitmap2.getHeight() / 2), new Paint(2));
        bitmap2.recycle();
        try {
            ExifInterface exifInterface = new ExifInterface(file.getAbsolutePath());
            int n3 = exifInterface.getAttributeInt("Orientation", 0);
            Matrix matrix2 = new Matrix();
            if (n3 == 6) {
                matrix2.postRotate(90.0f);
            } else if (n3 == 3) {
                matrix2.postRotate(180.0f);
            } else if (n3 == 8) {
                matrix2.postRotate(270.0f);
            }
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix2, (boolean)true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bitmap;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3 = options.outHeight;
        int n4 = options.outWidth;
        int n5 = 1;
        if (n3 > n2 || n4 > n) {
            n5 *= 2;
            int n6 = n3 / 2;
            int n7 = n4 / 2;
            while (n6 / n5 >= n2 && n7 / n5 >= n) {
                n5 *= 2;
            }
        }
        return n5;
    }
}

