/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.utils.filepicker.adapter.FolderListAdapter;
import com.hippo.utils.filepicker.filter.entity.Directory;
import java.util.ArrayList;
import java.util.List;

public class FolderListHelper {
    private PopupWindow mPopupWindow;
    private View mContentView;
    private RecyclerView rv_folder;
    private FolderListAdapter mAdapter;

    public void initFolderListView(Context context) {
        if (this.mPopupWindow == null) {
            this.mContentView = LayoutInflater.from((Context)context).inflate(R.layout.vw_layout_folder_list, null);
            this.rv_folder = (RecyclerView)this.mContentView.findViewById(R.id.rv_folder);
            this.mAdapter = new FolderListAdapter(context, new ArrayList<Directory>());
            this.rv_folder.setAdapter((RecyclerView.Adapter)this.mAdapter);
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context);
            linearLayoutManager.setOrientation(1);
            this.rv_folder.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
            this.mContentView.setFocusable(true);
            this.mContentView.setFocusableInTouchMode(true);
            this.mPopupWindow = new PopupWindow(this.mContentView);
            this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.mPopupWindow.setFocusable(true);
            this.mPopupWindow.setOutsideTouchable(true);
            this.mPopupWindow.setTouchable(true);
        }
    }

    public void setFolderListListener(FolderListAdapter.FolderListListener folderListListener) {
        this.mAdapter.setListener(folderListListener);
    }

    public void fillData(List<Directory> list) {
        this.mAdapter.refresh(list);
    }

    public void toggle(View view) {
        if (this.mPopupWindow.isShowing()) {
            this.mPopupWindow.dismiss();
        } else {
            this.mContentView.measure(0, 0);
            this.mPopupWindow.showAsDropDown(view, (view.getMeasuredWidth() - this.mContentView.getMeasuredWidth()) / 2, 0);
            int n = view.getMeasuredWidth();
            if (n > this.mContentView.getMeasuredHeight()) {
                n = this.mContentView.getMeasuredHeight();
            }
            this.mPopupWindow.update(view, this.mContentView.getMeasuredWidth(), n);
        }
    }
}

