/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.hippo.HippoConfig;
import java.io.File;
import java.io.FileFilter;
import java.text.DecimalFormat;
import java.util.Comparator;

public class FileUtils {
    static final String TAG = "FileUtils";
    public static final String MIME_TYPE_AUDIO = "audio/*";
    public static final String MIME_TYPE_TEXT = "text/*";
    public static final String MIME_TYPE_IMAGE = "image/*";
    public static final String MIME_TYPE_VIDEO = "video/*";
    public static final String MIME_TYPE_APP = "application/*";
    public static final String HIDDEN_PREFIX = ".";
    public static Comparator<File> sComparator = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            return file.getName().toLowerCase().compareTo(file2.getName().toLowerCase());
        }
    };
    public static FileFilter sFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string2 = file.getName();
            return file.isFile() && !string2.startsWith(FileUtils.HIDDEN_PREFIX);
        }
    };
    public static FileFilter sDirFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string2 = file.getName();
            return file.isDirectory() && !string2.startsWith(FileUtils.HIDDEN_PREFIX);
        }
    };

    private FileUtils() {
    }

    public static String getExtension(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.lastIndexOf(HIDDEN_PREFIX);
        if (n >= 0) {
            return string2.substring(n);
        }
        return "";
    }

    public static boolean isLocal(String string2) {
        return string2 != null && !string2.startsWith("http://") && !string2.startsWith("https://");
    }

    public static boolean isMediaUri(Uri uri) {
        return "media".equalsIgnoreCase(uri.getAuthority());
    }

    public static Uri getUri(File file) {
        if (file != null) {
            return Uri.fromFile((File)file);
        }
        return null;
    }

    public static File getPathWithoutFilename(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return file;
            }
            String string2 = file.getName();
            String string3 = file.getAbsolutePath();
            String string4 = string3.substring(0, string3.length() - string2.length());
            if (string4.endsWith("/")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            return new File(string4);
        }
        return null;
    }

    public static String getMimeType(File file) {
        String string2 = FileUtils.getExtension(file.getName());
        if (string2.length() > 0) {
            return MimeTypeMap.getSingleton().getMimeTypeFromExtension(string2.substring(1));
        }
        return "application/octet-stream";
    }

    public static String getMimeType(Context context, Uri uri) {
        File file = new File(FileUtils.getPath(context, uri));
        return FileUtils.getMimeType(file);
    }

    public static boolean isLocalStorageDocument(Uri uri) {
        return "com.hippochat.localstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String string2, String[] stringArray) {
        Cursor cursor = null;
        String string3 = "_data";
        String[] stringArray2 = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, stringArray2, string2, stringArray, null);
            if (cursor != null && cursor.moveToFirst()) {
                if (HippoConfig.DEBUG) {
                    DatabaseUtils.dumpCursor((Cursor)cursor);
                }
                int n = cursor.getColumnIndexOrThrow("_data");
                String string4 = cursor.getString(n);
                return string4;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static String getPath(Context context, Uri uri) {
        boolean bl;
        if (HippoConfig.DEBUG) {
            Log.d((String)"FileUtils File -", (String)("Authority: " + uri.getAuthority() + ", Fragment: " + uri.getFragment() + ", Port: " + uri.getPort() + ", Query: " + uri.getQuery() + ", Scheme: " + uri.getScheme() + ", Host: " + uri.getHost() + ", Segments: " + uri.getPathSegments().toString()));
        }
        boolean bl2 = bl = Build.VERSION.SDK_INT >= 19;
        if (bl && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtils.isLocalStorageDocument(uri)) {
                return DocumentsContract.getDocumentId((Uri)uri);
            }
            if (FileUtils.isExternalStorageDocument(uri)) {
                String string2 = DocumentsContract.getDocumentId((Uri)uri);
                String[] stringArray = string2.split(":");
                String string3 = stringArray[0];
                if ("primary".equalsIgnoreCase(string3)) {
                    return Environment.getExternalStorageDirectory() + "/" + stringArray[1];
                }
            } else {
                if (FileUtils.isDownloadsDocument(uri)) {
                    String string4 = DocumentsContract.getDocumentId((Uri)uri);
                    if (!TextUtils.isEmpty((CharSequence)string4) && string4.startsWith("raw:")) {
                        return string4.replaceFirst("raw:", "");
                    }
                    Uri uri2 = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(string4));
                    return FileUtils.getDataColumn(context, uri2, null, null);
                }
                if (FileUtils.isMediaDocument(uri)) {
                    String string5 = DocumentsContract.getDocumentId((Uri)uri);
                    String[] stringArray = string5.split(":");
                    String string6 = stringArray[0];
                    Uri uri3 = null;
                    if ("image".equals(string6)) {
                        uri3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(string6)) {
                        uri3 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(string6)) {
                        uri3 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String string7 = "_id=?";
                    String[] stringArray2 = new String[]{stringArray[1]};
                    return FileUtils.getDataColumn(context, uri3, "_id=?", stringArray2);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (FileUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return FileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    public static File getFile(Context context, Uri uri) {
        String string2;
        if (uri != null && (string2 = FileUtils.getPath(context, uri)) != null && FileUtils.isLocal(string2)) {
            return new File(string2);
        }
        return null;
    }

    public static String getReadableFileSize(int n) {
        int n2 = 1024;
        DecimalFormat decimalFormat = new DecimalFormat("###.#");
        String string2 = " KB";
        String string3 = " MB";
        String string4 = " GB";
        float f2 = 0.0f;
        String string5 = " KB";
        if (n > 1024 && (f2 = (float)(n / 1024)) > 1024.0f) {
            if ((f2 /= 1024.0f) > 1024.0f) {
                f2 /= 1024.0f;
                string5 = " GB";
            } else {
                string5 = " MB";
            }
        }
        return String.valueOf(decimalFormat.format(f2) + string5);
    }

    public static Bitmap getThumbnail(Context context, File file) {
        return FileUtils.getThumbnail(context, FileUtils.getUri(file), FileUtils.getMimeType(file));
    }

    public static Bitmap getThumbnail(Context context, Uri uri) {
        return FileUtils.getThumbnail(context, uri, FileUtils.getMimeType(context, uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getThumbnail(Context context, Uri uri, String string2) {
        if (HippoConfig.DEBUG) {
            Log.d((String)TAG, (String)"Attempting to get thumbnail");
        }
        if (!FileUtils.isMediaUri(uri)) {
            Log.e((String)TAG, (String)"You can only retrieve thumbnails for images and videos.");
            return null;
        }
        Bitmap bitmap = null;
        if (uri != null) {
            ContentResolver contentResolver = context.getContentResolver();
            try (Cursor cursor = null;){
                cursor = contentResolver.query(uri, null, null, null, null);
                if (cursor.moveToFirst()) {
                    int n = cursor.getInt(0);
                    if (HippoConfig.DEBUG) {
                        Log.d((String)TAG, (String)("Got thumb ID: " + n));
                    }
                    if (string2.contains("video")) {
                        bitmap = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)n, (int)1, null);
                    } else if (string2.contains(MIME_TYPE_IMAGE)) {
                        bitmap = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)n, (int)1, null);
                    }
                }
            }
        }
        return bitmap;
    }

    public static Intent createGetContentIntent() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        intent.addCategory("android.intent.category.OPENABLE");
        return intent;
    }
}

