/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.fileUpload;

import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class ProgressRequestBody
extends RequestBody {
    private File mFile;
    private String mPath;
    private UploadCallbacks mListener;
    private String mMimeType;
    private String mfileUrl;
    private int mMessageIndex;
    private String muid;
    private static final int DEFAULT_BUFFER_SIZE = 2048;

    public ProgressRequestBody(File file, UploadCallbacks uploadCallbacks, String string2, String string3, int n, String string4) {
        this.mFile = file;
        this.mListener = uploadCallbacks;
        this.mMimeType = string2;
        this.mfileUrl = string3;
        this.mMessageIndex = n;
        this.muid = string4;
    }

    public MediaType contentType() {
        try {
            return MediaType.parse((String)this.mMimeType);
        }
        catch (Exception exception) {
            return MediaType.parse((String)"jpg");
        }
    }

    public long contentLength() throws IOException {
        return this.mFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink bufferedSink) throws IOException {
        long l = this.mFile.length();
        byte[] byArray = new byte[2048];
        FileInputStream fileInputStream = new FileInputStream(this.mFile);
        long l2 = 0L;
        Handler handler = new Handler(Looper.getMainLooper());
        if (l > 0L) {
            try {
                int n;
                while ((n = fileInputStream.read(byArray)) != -1) {
                    if ((int)(100L * l2 / l) > 0 && (int)(100L * l2 / l) % 10 == 0) {
                        this.mListener.onProgressUpdate((int)(100L * l2 / l), this.mMessageIndex, this.muid);
                    }
                    l2 += (long)n;
                    bufferedSink.write(byArray, 0, n);
                }
                this.mListener.onFinish((int)l2, this.mMessageIndex, this.muid);
            }
            catch (Exception exception) {
                handler.post((Runnable)new ProgressUpdaterFailure(l2, this.mMessageIndex, this.muid));
            }
            finally {
                fileInputStream.close();
            }
        }
    }

    private class ProgressUpdaterFailure
    implements Runnable {
        private int messageIndex;
        private String muid;
        private long percentage;

        public ProgressUpdaterFailure(long l, int n, String string2) {
            this.messageIndex = n;
            this.muid = string2;
            this.percentage = l;
        }

        @Override
        public void run() {
            ProgressRequestBody.this.mListener.onError((int)this.percentage, this.messageIndex, this.muid);
        }
    }

    private class ProgressUpdater
    implements Runnable {
        private long mUploaded = 0L;
        private long mTotal = 0L;
        private int messageIndex;
        private String muid;
        int currentProgress = -1;

        public ProgressUpdater(long l, long l2, int n, String string2) {
            this.mUploaded = l;
            this.mTotal = l2;
            this.messageIndex = n;
            this.muid = string2;
        }

        @Override
        public void run() {
            if ((int)(100L * this.mUploaded / this.mTotal) == 100) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ProgressRequestBody.this.mListener.onFinish((int)ProgressUpdater.this.mUploaded, ProgressRequestBody.this.mMessageIndex, ProgressUpdater.this.muid);
                    }
                }, 2000L);
            }
            if ((int)(100L * this.mUploaded / this.mTotal) > 0 && (int)(100L * this.mUploaded / this.mTotal) % 10 == 0) {
                ProgressRequestBody.this.mListener.onProgressUpdate((int)(100L * this.mUploaded / this.mTotal), ProgressRequestBody.this.mMessageIndex, this.muid);
            }
        }
    }

    public static interface UploadCallbacks {
        public void onProgressUpdate(int var1, int var2, String var3);

        public void onError(int var1, int var2, String var3);

        public void onFinish(int var1, int var2, String var3);
    }
}

