/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.fileUpload;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;

public class AndroidMultiPartEntity
extends MultipartEntity {
    private final ProgressListener listener;

    public AndroidMultiPartEntity(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    public AndroidMultiPartEntity(HttpMultipartMode httpMultipartMode, ProgressListener progressListener) {
        super(httpMultipartMode);
        this.listener = progressListener;
    }

    public AndroidMultiPartEntity(HttpMultipartMode httpMultipartMode, String string2, Charset charset, ProgressListener progressListener) {
        super(httpMultipartMode, string2, charset);
        this.listener = progressListener;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        super.writeTo((OutputStream)new CountingOutputStream(outputStream, this.listener));
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private final ProgressListener listener;
        private long transferred;

        public CountingOutputStream(OutputStream outputStream, ProgressListener progressListener) {
            super(outputStream);
            this.listener = progressListener;
            this.transferred = 0L;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.transferred += (long)n2;
            this.listener.transferred(this.transferred);
        }

        @Override
        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.transferred;
            this.listener.transferred(this.transferred);
        }
    }

    public static interface ProgressListener {
        public void transferred(long var1);
    }
}

