/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.easypermissions.helper;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.hippo.utils.easypermissions.helper.ActivityPermissionHelper;
import com.hippo.utils.easypermissions.helper.FragmentActivityPermissionHelper;
import com.hippo.utils.easypermissions.helper.LowApiPermissionsHelper;
import com.hippo.utils.easypermissions.helper.SupportFragmentPermissionHelper;
import java.util.List;

public abstract class PermissionHelper<T> {
    private T mHost;

    @NonNull
    public static PermissionHelper<? extends Activity> newInstance(Activity activity) {
        if (Build.VERSION.SDK_INT < 23) {
            return new LowApiPermissionsHelper<Activity>(activity);
        }
        if (activity instanceof FragmentActivity) {
            return new FragmentActivityPermissionHelper((FragmentActivity)activity);
        }
        return new ActivityPermissionHelper(activity);
    }

    @NonNull
    public static PermissionHelper<Fragment> newInstance(Fragment fragment) {
        if (Build.VERSION.SDK_INT < 23) {
            return new LowApiPermissionsHelper<Fragment>(fragment);
        }
        return new SupportFragmentPermissionHelper(fragment);
    }

    public PermissionHelper(@NonNull T t) {
        this.mHost = t;
    }

    private boolean shouldShowRationale(String ... stringArray) {
        for (String string2 : stringArray) {
            if (!this.shouldShowRequestPermissionRationale(string2)) continue;
            return true;
        }
        return false;
    }

    public void requestPermissions(@NonNull String string2, @NonNull String string3, @NonNull String string4, @StyleRes int n, int n2, String ... stringArray) {
        if (this.shouldShowRationale(stringArray)) {
            this.showRequestPermissionRationale(string2, string3, string4, n, n2, stringArray);
        } else {
            this.directRequestPermissions(n2, stringArray);
        }
    }

    public boolean somePermissionPermanentlyDenied(@NonNull List<String> list) {
        for (String string2 : list) {
            if (!this.permissionPermanentlyDenied(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean permissionPermanentlyDenied(@NonNull String string2) {
        return !this.shouldShowRequestPermissionRationale(string2);
    }

    public boolean somePermissionDenied(String ... stringArray) {
        return this.shouldShowRationale(stringArray);
    }

    @NonNull
    public T getHost() {
        return this.mHost;
    }

    public abstract void directRequestPermissions(int var1, String ... var2);

    public abstract boolean shouldShowRequestPermissionRationale(@NonNull String var1);

    public abstract void showRequestPermissionRationale(@NonNull String var1, @NonNull String var2, @NonNull String var3, @StyleRes int var4, int var5, String ... var6);

    public abstract Context getContext();
}

